/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir;

import java.util.List;
import oracle.pgql.lang.ir.CommonPathExpression;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.Projection;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public abstract class GraphQuery
implements PgqlStatement {
    private List<CommonPathExpression> commonPathExpressions;
    private SchemaQualifiedName graphName;
    private GraphPattern graphPattern;
    private GroupBy groupBy;
    private QueryExpression having;
    private OrderBy orderBy;
    private QueryExpression limit;
    private QueryExpression offset;

    protected GraphQuery(List<CommonPathExpression> commonPathExpressions, SchemaQualifiedName graphName, GraphPattern graphPattern, GroupBy groupBy, QueryExpression having, OrderBy orderBy, QueryExpression limit, QueryExpression offset) {
        this.commonPathExpressions = commonPathExpressions;
        this.graphName = graphName;
        this.graphPattern = graphPattern;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
    }

    public abstract QueryType getQueryType();

    public List<CommonPathExpression> getCommonPathExpressions() {
        return this.commonPathExpressions;
    }

    public void setCommonPathExpressions(List<CommonPathExpression> commonPathExpressions) {
        this.commonPathExpressions = commonPathExpressions;
    }

    @Deprecated
    public abstract Projection getProjection();

    @Deprecated
    public abstract void setProjection(Projection var1);

    @Deprecated
    public String getInputGraphName() {
        return this.graphName == null ? null : this.graphName.getName();
    }

    @Deprecated
    public void setInputGraphName(String inputGraphName) {
        if (this.graphName == null) {
            this.graphName = new SchemaQualifiedName(null, inputGraphName);
        } else {
            this.graphName.setName(inputGraphName);
        }
    }

    public SchemaQualifiedName getGraphName() {
        return this.graphName;
    }

    public void setGraphName(SchemaQualifiedName graphName) {
        this.graphName = graphName;
    }

    public GraphPattern getGraphPattern() {
        return this.graphPattern;
    }

    public void setGraphPattern(GraphPattern graphPattern) {
        this.graphPattern = graphPattern;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public QueryExpression getHaving() {
        return this.having;
    }

    public void setHaving(QueryExpression having) {
        this.having = having;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public QueryExpression getLimit() {
        return this.limit;
    }

    public void setLimit(QueryExpression limit) {
        this.limit = limit;
    }

    public QueryExpression getOffset() {
        return this.offset;
    }

    public void setOffset(QueryExpression offset) {
        this.offset = offset;
    }

    public String toString() {
        return PgqlUtils.printPgqlString(this);
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphQuery other = (GraphQuery)obj;
        if (this.commonPathExpressions == null ? other.commonPathExpressions != null : !this.commonPathExpressions.equals(other.commonPathExpressions)) {
            return false;
        }
        if (this.graphPattern == null ? other.graphPattern != null : !this.graphPattern.equals(other.graphPattern)) {
            return false;
        }
        if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
            return false;
        }
        if (this.having == null ? other.having != null : !this.having.equals(other.having)) {
            return false;
        }
        if (this.graphName == null ? other.graphName != null : !this.graphName.equals(other.graphName)) {
            return false;
        }
        if (this.limit == null ? other.limit != null : !this.limit.equals(other.limit)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy));
    }

    public abstract void accept(QueryExpressionVisitor var1);
}

