/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SelectQuery;

public interface QueryExpression {
    public ExpressionType getExpType();

    public void accept(QueryExpressionVisitor var1);

    public static class ScalarSubquery
    extends Subquery {
        public ScalarSubquery(SelectQuery query) {
            super(query);
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.SCALAR_SUBQUERY;
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }
    }

    public static abstract class Subquery
    implements QueryExpression {
        private SelectQuery query;

        public Subquery(SelectQuery query) {
            this.query = query;
        }

        public SelectQuery getQuery() {
            return this.query;
        }

        public void setQuery(SelectQuery query) {
            this.query = query;
        }

        public String toString() {
            return "( " + this.query + " )";
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subquery other = (Subquery)obj;
            return !(this.query == null ? other.query != null : !this.query.equals(other.query));
        }
    }

    public static class AllProperties
    implements QueryExpression {
        private VarRef varRef;

        public AllProperties(VarRef varRef) {
            this.varRef = varRef;
        }

        public VarRef getVarRef() {
            return this.varRef;
        }

        public void setVarRef(VarRef varRef) {
            this.varRef = varRef;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.ALL_PROPERTIES;
        }

        public String toString() {
            return this.varRef + ".*";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AllProperties other = (AllProperties)obj;
            return !(this.varRef == null ? other.varRef != null : !this.varRef.equals(other.varRef));
        }
    }

    public static class Star
    implements QueryExpression {
        @Override
        public ExpressionType getExpType() {
            return ExpressionType.STAR;
        }

        public String toString() {
            return "*";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 31;
        }
    }

    public static interface Aggregation
    extends QueryExpression {

        public static class AggrListagg
        extends AbstractAggregation {
            private String separator;

            public AggrListagg(boolean distinct, QueryExpression exp, String separator) {
                super(distinct, exp);
                this.separator = separator;
            }

            public String getSeparator() {
                return this.separator;
            }

            public void setSeparator(String separator) {
                this.separator = separator;
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AGGR_LISTAGG;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class AggrArrayAgg
        extends AbstractAggregation {
            public AggrArrayAgg(boolean distinct, QueryExpression exp) {
                super(distinct, exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AGGR_ARRAY_AGG;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class AggrAvg
        extends AbstractAggregation {
            public AggrAvg(boolean distinct, QueryExpression exp) {
                super(distinct, exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AGGR_AVG;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class AggrSum
        extends AbstractAggregation {
            public AggrSum(boolean distinct, QueryExpression exp) {
                super(distinct, exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AGGR_SUM;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class AggrMax
        extends AbstractAggregation {
            public AggrMax(boolean distinct, QueryExpression exp) {
                super(distinct, exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AGGR_MAX;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class AggrMin
        extends AbstractAggregation {
            public AggrMin(boolean distinct, QueryExpression exp) {
                super(distinct, exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AGGR_MIN;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class AggrCount
        extends AbstractAggregation {
            public AggrCount(boolean distinct, QueryExpression exp) {
                super(distinct, exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AGGR_COUNT;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static abstract class AbstractAggregation
        extends UnaryExpression
        implements Aggregation {
            private boolean distinct;

            public AbstractAggregation(boolean distinct, QueryExpression exp) {
                super(exp);
                this.distinct = distinct;
            }

            @Deprecated
            public boolean hasDistinct() {
                return this.distinct;
            }

            public boolean isDistinct() {
                return this.distinct;
            }

            public void setDistinct(boolean distinct) {
                this.distinct = distinct;
            }

            public String toString() {
                String result;
                String separator = "";
                switch (this.getExpType()) {
                    case AGGR_COUNT: {
                        result = "COUNT";
                        break;
                    }
                    case AGGR_MIN: {
                        result = "MIN";
                        break;
                    }
                    case AGGR_MAX: {
                        result = "MAX";
                        break;
                    }
                    case AGGR_AVG: {
                        result = "AVG";
                        break;
                    }
                    case AGGR_SUM: {
                        result = "SUM";
                        break;
                    }
                    case AGGR_ARRAY_AGG: {
                        result = "ARRAY_AGG";
                        break;
                    }
                    case AGGR_LISTAGG: {
                        result = "LISTAGG";
                        separator = ((AggrListagg)this).getSeparator();
                        if (separator.length() <= 0) break;
                        separator = ", " + PgqlUtils.printLiteral(separator);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected expression type: " + (Object)((Object)this.getExpType()));
                    }
                }
                result = result + "(" + (this.distinct ? "DISTINCT " : "") + this.getExp() + separator + ")";
                return result;
            }

            @Override
            public int hashCode() {
                return 31;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AbstractAggregation other = (AbstractAggregation)obj;
                return this.distinct == other.distinct;
            }
        }
    }

    public static class BetweenPredicate
    extends TernaryExpression {
        public BetweenPredicate(QueryExpression exp1, QueryExpression exp2, QueryExpression exp3) {
            super(exp1, exp2, exp3);
        }

        public String toString() {
            return this.getExp1() + " BETWEEN " + this.getExp2() + " AND " + this.getExp3();
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.BETWEEN_PREDICATE;
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }
    }

    public static class SubstringExpression
    implements QueryExpression {
        private QueryExpression exp;
        private QueryExpression startPosition;
        private QueryExpression stringLength;

        public SubstringExpression(QueryExpression exp, QueryExpression startPosition, QueryExpression stringLength) {
            this.exp = exp;
            this.startPosition = startPosition;
            this.stringLength = stringLength;
        }

        public QueryExpression getExp() {
            return this.exp;
        }

        public void setExp(QueryExpression exp) {
            this.exp = exp;
        }

        public QueryExpression getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(QueryExpression startPosition) {
            this.startPosition = startPosition;
        }

        public QueryExpression getStringLength() {
            return this.stringLength;
        }

        public void setStringLength(QueryExpression stringLength) {
            this.stringLength = stringLength;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.SUBSTRING;
        }

        public String toString() {
            String result = "SUBSTRING(" + this.exp + " FROM " + this.startPosition;
            if (this.stringLength != null) {
                result = result + " FOR " + this.stringLength;
            }
            result = result + ")";
            return result;
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SubstringExpression other = (SubstringExpression)obj;
            if (this.exp == null ? other.exp != null : !this.exp.equals(other.exp)) {
                return false;
            }
            if (this.startPosition == null ? other.startPosition != null : !this.startPosition.equals(other.startPosition)) {
                return false;
            }
            return !(this.stringLength == null ? other.stringLength != null : !this.stringLength.equals(other.stringLength));
        }
    }

    public static class WhenThenExpression {
        QueryExpression when;
        QueryExpression then;

        public WhenThenExpression(QueryExpression when, QueryExpression then) {
            this.when = when;
            this.then = then;
        }

        public QueryExpression getWhen() {
            return this.when;
        }

        public void setWhen(QueryExpression when) {
            this.when = when;
        }

        public QueryExpression getThen() {
            return this.then;
        }

        public void setThen(QueryExpression then) {
            this.then = then;
        }

        public String toString() {
            return "WHEN " + this.when + " THEN " + this.then;
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WhenThenExpression other = (WhenThenExpression)obj;
            if (this.then == null ? other.then != null : !this.then.equals(other.then)) {
                return false;
            }
            return !(this.when == null ? other.when != null : !this.when.equals(other.when));
        }
    }

    public static class SimpleCase
    implements QueryExpression {
        QueryExpression caseOperand;
        List<WhenThenExpression> whenThenExps;
        QueryExpression elseExp;
        IfElse ifElseRepresentation;

        public SimpleCase(QueryExpression caseOperand, List<WhenThenExpression> whenThenExps, QueryExpression elseExp, IfElse ifElseRepresentation) {
            this.caseOperand = caseOperand;
            this.whenThenExps = whenThenExps;
            this.elseExp = elseExp;
            this.ifElseRepresentation = ifElseRepresentation;
        }

        public QueryExpression getCaseOperand() {
            return this.caseOperand;
        }

        public void setCaseOperand(QueryExpression caseOperand) {
            this.caseOperand = caseOperand;
        }

        public List<WhenThenExpression> getWhenThenExps() {
            return this.whenThenExps;
        }

        public void setWhenThenExps(List<WhenThenExpression> whenThenExps) {
            this.whenThenExps = whenThenExps;
        }

        public QueryExpression getElseExp() {
            return this.elseExp;
        }

        public void setElseExp(QueryExpression elseExp) {
            this.elseExp = elseExp;
        }

        public IfElse getIfElseRepresentation() {
            return this.ifElseRepresentation;
        }

        public void setIfElseRepresentation(IfElse ifElseRepresentation) {
            this.ifElseRepresentation = ifElseRepresentation;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.SIMPLE_CASE;
        }

        public String toString() {
            String result = "CASE " + this.caseOperand + " ";
            result = result + this.whenThenExps.stream().map(x -> x.toString()).collect(Collectors.joining(" "));
            if (this.elseExp != null) {
                result = result + " ELSE " + this.elseExp;
            }
            result = result + " END";
            return result;
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleCase other = (SimpleCase)obj;
            if (this.caseOperand == null ? other.caseOperand != null : !this.caseOperand.equals(other.caseOperand)) {
                return false;
            }
            if (this.elseExp == null ? other.elseExp != null : !this.elseExp.equals(other.elseExp)) {
                return false;
            }
            if (this.ifElseRepresentation == null ? other.ifElseRepresentation != null : !this.ifElseRepresentation.equals(other.ifElseRepresentation)) {
                return false;
            }
            return !(this.whenThenExps == null ? other.whenThenExps != null : !this.whenThenExps.equals(other.whenThenExps));
        }
    }

    public static class IfElse
    implements QueryExpression {
        QueryExpression exp1;
        QueryExpression exp2;
        QueryExpression exp3;

        public IfElse(QueryExpression exp1, QueryExpression exp2, QueryExpression exp3) {
            this.exp1 = exp1;
            this.exp2 = exp2;
            this.exp3 = exp3;
        }

        public QueryExpression getExp1() {
            return this.exp1;
        }

        public void setExp1(QueryExpression exp1) {
            this.exp1 = exp1;
        }

        public QueryExpression getExp2() {
            return this.exp2;
        }

        public void setExp2(QueryExpression exp2) {
            this.exp2 = exp2;
        }

        public QueryExpression getExp3() {
            return this.exp3;
        }

        public void setExp3(QueryExpression exp3) {
            this.exp3 = exp3;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.IF_ELSE;
        }

        public String toString() {
            String elseClause = "";
            if (this.exp3 != null) {
                elseClause = elseClause + " ELSE " + this.exp3;
            }
            return "CASE WHEN " + this.exp1 + " THEN " + this.exp2 + elseClause + " END";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IfElse other = (IfElse)obj;
            if (this.exp1 == null ? other.exp1 != null : !this.exp1.equals(other.exp1)) {
                return false;
            }
            if (this.exp2 == null ? other.exp2 != null : !this.exp2.equals(other.exp2)) {
                return false;
            }
            return !(this.exp3 == null ? other.exp3 != null : !this.exp3.equals(other.exp3));
        }
    }

    public static class IsNull
    implements QueryExpression {
        QueryExpression exp;

        public IsNull(QueryExpression exp) {
            this.exp = exp;
        }

        public QueryExpression getExp() {
            return this.exp;
        }

        public void setExp(QueryExpression exp) {
            this.exp = exp;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.IS_NULL;
        }

        public String toString() {
            return this.exp + " IS NULL";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IsNull other = (IsNull)obj;
            return !(this.exp == null ? other.exp != null : !this.exp.equals(other.exp));
        }
    }

    public static class InPredicate
    implements QueryExpression {
        QueryExpression exp;
        QueryExpression inValueList;

        public InPredicate(QueryExpression exp, QueryExpression inValueList) {
            this.exp = exp;
            this.inValueList = inValueList;
        }

        public QueryExpression getExp() {
            return this.exp;
        }

        public void setExp(QueryExpression exp) {
            this.exp = exp;
        }

        public void setInValueList(QueryExpression inValueList) {
            this.inValueList = inValueList;
        }

        public QueryExpression getInValueList() {
            return this.inValueList;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.IN_EXPRESSION;
        }

        public String toString() {
            return this.exp + " IN " + this.inValueList;
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InPredicate other = (InPredicate)obj;
            if (this.exp == null ? other.exp != null : !this.exp.equals(other.exp)) {
                return false;
            }
            return !(this.inValueList == null ? other.inValueList != null : !this.inValueList.equals(other.inValueList));
        }

        public static class InValueList
        implements QueryExpression {
            ExpressionType arrayElementType;
            long[] integerValues;
            double[] decimalValues;
            boolean[] booleanValues;
            String[] stringValues;
            LocalDate[] dateValues;
            LocalTime[] timeValues;
            LocalDateTime[] timestampValues;

            public InValueList(long[] integerValues) {
                this.integerValues = integerValues;
                this.arrayElementType = ExpressionType.INTEGER;
            }

            public InValueList(double[] decimalValues) {
                this.decimalValues = decimalValues;
                this.arrayElementType = ExpressionType.DECIMAL;
            }

            public InValueList(boolean[] booleanValues) {
                this.booleanValues = booleanValues;
                this.arrayElementType = ExpressionType.BOOLEAN;
            }

            public InValueList(String[] stringValues) {
                this.stringValues = stringValues;
                this.arrayElementType = ExpressionType.STRING;
            }

            public InValueList(LocalDate[] dateValues) {
                this.dateValues = dateValues;
                this.arrayElementType = ExpressionType.DATE;
            }

            public InValueList(LocalTime[] timeValues) {
                this.timeValues = timeValues;
                this.arrayElementType = ExpressionType.TIME;
            }

            public InValueList(LocalDateTime[] timestampValues) {
                this.timestampValues = timestampValues;
                this.arrayElementType = ExpressionType.TIMESTAMP;
            }

            public ExpressionType getArrayElementType() {
                return this.arrayElementType;
            }

            public void setArrayElementType(ExpressionType arrayElementType) {
                this.arrayElementType = arrayElementType;
            }

            public long[] getIntegerValues() {
                return this.integerValues;
            }

            public void setIntegerValues(long[] integerValues) {
                this.integerValues = integerValues;
            }

            public double[] getDecimalValues() {
                return this.decimalValues;
            }

            public void setDecimalValues(double[] decimalValues) {
                this.decimalValues = decimalValues;
            }

            public boolean[] getBooleanValues() {
                return this.booleanValues;
            }

            public void setBooleanValues(boolean[] booleanValues) {
                this.booleanValues = booleanValues;
            }

            public String[] getStringValues() {
                return this.stringValues;
            }

            public void setStringValues(String[] stringValues) {
                this.stringValues = stringValues;
            }

            public LocalDate[] getDateValues() {
                return this.dateValues;
            }

            public void setDateValues(LocalDate[] dateValues) {
                this.dateValues = dateValues;
            }

            public LocalTime[] getTimeValues() {
                return this.timeValues;
            }

            public void setTimeValues(LocalTime[] timeValues) {
                this.timeValues = timeValues;
            }

            public LocalDateTime[] getTimestampValues() {
                return this.timestampValues;
            }

            public void setTimestampValues(LocalDateTime[] timestampValues) {
                this.timestampValues = timestampValues;
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.IN_VALUE_LIST;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }

            public String toString() {
                String values;
                switch (this.arrayElementType) {
                    case INTEGER: {
                        values = Arrays.stream(this.integerValues).mapToObj(Long::toString).collect(Collectors.joining(", "));
                        break;
                    }
                    case DECIMAL: {
                        values = Arrays.stream(this.decimalValues).mapToObj(v -> PgqlUtils.printLiteral(v)).collect(Collectors.joining(", "));
                        break;
                    }
                    case BOOLEAN: {
                        values = IntStream.range(0, this.booleanValues.length).mapToObj(i -> Boolean.valueOf(this.booleanValues[i]).toString()).collect(Collectors.joining(", "));
                        break;
                    }
                    case STRING: {
                        values = Arrays.stream(this.stringValues).map(v -> PgqlUtils.printLiteral(v)).collect(Collectors.joining(", "));
                        break;
                    }
                    case DATE: {
                        values = Arrays.stream(this.dateValues).map(v -> PgqlUtils.printLiteral(v)).collect(Collectors.joining(", "));
                        break;
                    }
                    case TIME: {
                        values = Arrays.stream(this.timeValues).map(v -> PgqlUtils.printLiteral(v)).collect(Collectors.joining(", "));
                        break;
                    }
                    case TIMESTAMP: {
                        values = Arrays.stream(this.timestampValues).map(v -> PgqlUtils.printLiteral(v)).collect(Collectors.joining(", "));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(this.arrayElementType.toString());
                    }
                }
                return "(" + values + ")";
            }

            public int hashCode() {
                return 31;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                InValueList other = (InValueList)obj;
                if (this.arrayElementType != other.arrayElementType) {
                    return false;
                }
                if (!Arrays.equals(this.booleanValues, other.booleanValues)) {
                    return false;
                }
                if (!Arrays.equals(this.dateValues, other.dateValues)) {
                    return false;
                }
                if (!Arrays.equals(this.decimalValues, other.decimalValues)) {
                    return false;
                }
                if (!Arrays.equals(this.integerValues, other.integerValues)) {
                    return false;
                }
                if (!Arrays.equals(this.stringValues, other.stringValues)) {
                    return false;
                }
                if (!Arrays.equals(this.timeValues, other.timeValues)) {
                    return false;
                }
                return Arrays.equals(this.timestampValues, other.timestampValues);
            }
        }
    }

    public static class ExtractExpression
    implements QueryExpression {
        ExtractField field;
        QueryExpression exp;

        public ExtractExpression(ExtractField field, QueryExpression exp) {
            this.field = field;
            this.exp = exp;
        }

        public ExtractField getField() {
            return this.field;
        }

        public void setExtractField(ExtractField field) {
            this.field = field;
        }

        public QueryExpression getExp() {
            return this.exp;
        }

        public void setExp(QueryExpression exp) {
            this.exp = exp;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.EXTRACT_EXPRESSION;
        }

        public String toString() {
            return "EXTRACT(" + (Object)((Object)this.getField()) + " FROM " + this.getExp() + ")";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtractExpression other = (ExtractExpression)obj;
            if (this.exp == null ? other.exp != null : !this.exp.equals(other.exp)) {
                return false;
            }
            return this.field == other.field;
        }

        public static enum ExtractField {
            YEAR,
            MONTH,
            DAY,
            HOUR,
            MINUTE,
            SECOND,
            TIMEZONE_HOUR,
            TIMEZONE_MINUTE;

        }
    }

    public static class FunctionCall
    implements QueryExpression {
        private String schemaName;
        private String packageName;
        private String functionName;
        private List<QueryExpression> args;

        public FunctionCall(String functionName, List<QueryExpression> exps) {
            this(null, functionName, exps);
        }

        public FunctionCall(String packageName, String functionName, List<QueryExpression> exps) {
            this(null, packageName, functionName, exps);
        }

        public FunctionCall(String schemaName, String packageName, String functionName, List<QueryExpression> exps) {
            this.schemaName = schemaName;
            this.packageName = packageName;
            this.functionName = functionName;
            this.args = exps;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public List<QueryExpression> getArgs() {
            return this.args;
        }

        public void setArgs(List<QueryExpression> args) {
            this.args = args;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.FUNCTION_CALL;
        }

        public String toString() {
            String schemaNamePart = this.schemaName == null ? "" : PgqlUtils.printIdentifier(this.schemaName, false) + ".";
            String packageNamePart = this.packageName == null ? "" : PgqlUtils.printIdentifier(this.packageName, false) + ".";
            String expressions = this.args.stream().map(Object::toString).collect(Collectors.joining(", "));
            return schemaNamePart + packageNamePart + PgqlUtils.printIdentifier(this.functionName, false) + "(" + expressions + ")";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionCall other = (FunctionCall)obj;
            if (this.args == null ? other.args != null : !this.args.equals(other.args)) {
                return false;
            }
            if (this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName)) {
                return false;
            }
            if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
                return false;
            }
            return !(this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName));
        }
    }

    public static interface Function
    extends QueryExpression {

        public static class Exists
        extends Subquery
        implements Function {
            public Exists(SelectQuery query) {
                super(query);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.EXISTS;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }

            @Override
            public String toString() {
                return "EXISTS" + super.toString();
            }
        }

        public static class Cast
        implements Function {
            private QueryExpression exp;
            private String targetTypeName;

            public Cast(QueryExpression exp, String targetTypeName) {
                this.exp = exp;
                this.targetTypeName = targetTypeName;
            }

            public QueryExpression getExp() {
                return this.exp;
            }

            public void setExp(QueryExpression exp) {
                this.exp = exp;
            }

            public String getTargetTypeName() {
                return this.targetTypeName;
            }

            public void setTargetTypeName(String targetTypeName) {
                this.targetTypeName = targetTypeName;
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.CAST;
            }

            public String toString() {
                String normalizedType = this.targetTypeName.replace("TIMEZONE", "TIME ZONE");
                return "CAST(" + this.exp + " AS " + normalizedType + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }

            public int hashCode() {
                return 31;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Cast other = (Cast)obj;
                if (this.exp == null ? other.exp != null : !this.exp.equals(other.exp)) {
                    return false;
                }
                return !(this.targetTypeName == null ? other.targetTypeName != null : !this.targetTypeName.equals(other.targetTypeName));
            }
        }
    }

    public static class PropertyAccess
    implements QueryExpression {
        private QueryVariable variable;
        private String propertyName;

        public PropertyAccess(QueryVariable variable, String propertyName) {
            this.variable = variable;
            this.propertyName = propertyName;
        }

        public QueryVariable getVariable() {
            return this.variable;
        }

        public void setVariable(QueryVariable variable) {
            this.variable = variable;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.PROP_ACCESS;
        }

        public String toString() {
            return PgqlUtils.printPgqlString(this.variable) + "." + PgqlUtils.printIdentifier(this.propertyName, false);
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyAccess that = (PropertyAccess)o;
            if (!this.variable.equals(that.variable)) {
                return false;
            }
            return this.propertyName.equals(that.propertyName);
        }

        public int hashCode() {
            return 31;
        }
    }

    public static class BindVariable
    implements QueryExpression {
        private int parameterIndex;

        public BindVariable(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public void setParameterIndex(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.BIND_VARIABLE;
        }

        public String toString() {
            return "?";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BindVariable other = (BindVariable)obj;
            return this.parameterIndex == other.parameterIndex;
        }

        public int hashCode() {
            return 31;
        }
    }

    public static class VarRef
    implements QueryExpression {
        private QueryVariable variable;

        public VarRef(QueryVariable variable) {
            this.variable = variable;
        }

        public QueryVariable getVariable() {
            return this.variable;
        }

        public void setVariable(QueryVariable variable) {
            this.variable = variable;
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.VARREF;
        }

        public String toString() {
            return PgqlUtils.printPgqlString(this.variable);
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarRef varRef = (VarRef)o;
            return this.variable.equals(varRef.variable);
        }

        public int hashCode() {
            return 31;
        }
    }

    public static abstract class Constant<T>
    implements QueryExpression {
        protected T value;

        public Constant(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constant constant = (Constant)o;
            return this.value.equals(constant.value);
        }

        public int hashCode() {
            return 31;
        }

        public static class ConstTimestampWithTimezone
        extends Constant<OffsetDateTime> {
            public ConstTimestampWithTimezone(OffsetDateTime val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.TIMESTAMP_WITH_TIMEZONE;
            }

            @Override
            public String toString() {
                return PgqlUtils.printLiteral((OffsetDateTime)this.value);
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstTimeWithTimezone
        extends Constant<OffsetTime> {
            public ConstTimeWithTimezone(OffsetTime val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.TIME_WITH_TIMEZONE;
            }

            @Override
            public String toString() {
                return PgqlUtils.printLiteral((OffsetTime)this.value);
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstTimestamp
        extends Constant<LocalDateTime> {
            public ConstTimestamp(LocalDateTime val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.TIMESTAMP;
            }

            @Override
            public String toString() {
                return PgqlUtils.printLiteral((LocalDateTime)this.value);
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstTime
        extends Constant<LocalTime> {
            public ConstTime(LocalTime val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.TIME;
            }

            @Override
            public String toString() {
                return PgqlUtils.printLiteral((LocalTime)this.value);
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstDate
        extends Constant<LocalDate> {
            public ConstDate(LocalDate val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.DATE;
            }

            @Override
            public String toString() {
                return PgqlUtils.printLiteral((LocalDate)this.value);
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstBoolean
        extends Constant<Boolean> {
            public ConstBoolean(boolean val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.BOOLEAN;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstString
        extends Constant<String> {
            public ConstString(String val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.STRING;
            }

            @Override
            public String toString() {
                return PgqlUtils.printLiteral((String)this.value);
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstDecimal
        extends Constant<Double> {
            public ConstDecimal(double val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.DECIMAL;
            }

            @Override
            public String toString() {
                return PgqlUtils.printLiteral((Double)this.value);
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class ConstInteger
        extends Constant<Long> {
            public ConstInteger(long val) {
                super(val);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.INTEGER;
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }
    }

    public static class ConcatExpression
    extends BinaryExpression {
        public ConcatExpression(QueryExpression exp1, QueryExpression exp2) {
            super(exp1, exp2);
        }

        @Override
        public ExpressionType getExpType() {
            return ExpressionType.CONCAT;
        }

        public String toString() {
            return "(" + this.getExp1() + " || " + this.getExp2() + ")";
        }

        @Override
        public void accept(QueryExpressionVisitor v) {
            v.visit(this);
        }
    }

    public static interface RelationalExpression
    extends QueryExpression {

        public static class LessEqual
        extends BinaryExpression
        implements RelationalExpression {
            public LessEqual(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.LESS_EQUAL;
            }

            public String toString() {
                return "(" + this.getExp1() + " <= " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Less
        extends BinaryExpression
        implements RelationalExpression {
            public Less(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.LESS;
            }

            public String toString() {
                return "(" + this.getExp1() + " < " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class GreaterEqual
        extends BinaryExpression
        implements RelationalExpression {
            public GreaterEqual(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.GREATER_EQUAL;
            }

            public String toString() {
                return "(" + this.getExp1() + " >= " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Greater
        extends BinaryExpression
        implements RelationalExpression {
            public Greater(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.GREATER;
            }

            public String toString() {
                return "(" + this.getExp1() + " > " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class NotEqual
        extends BinaryExpression
        implements RelationalExpression {
            public NotEqual(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.NOT_EQUAL;
            }

            public String toString() {
                return "(" + this.getExp1() + " <> " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Equal
        extends BinaryExpression
        implements RelationalExpression {
            public Equal(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.EQUAL;
            }

            public String toString() {
                return "(" + this.getExp1() + " = " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }
    }

    public static interface LogicalExpression
    extends QueryExpression {

        public static class Not
        extends UnaryExpression
        implements LogicalExpression {
            public Not(QueryExpression exp) {
                super(exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.NOT;
            }

            public String toString() {
                return "(NOT " + this.getExp() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Or
        extends BinaryExpression
        implements LogicalExpression {
            public Or(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.OR;
            }

            public String toString() {
                return "(" + this.getExp1() + " OR " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class And
        extends BinaryExpression
        implements LogicalExpression {
            public And(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.AND;
            }

            public String toString() {
                return "(" + this.getExp1() + " AND " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }
    }

    public static interface ArithmeticExpression
    extends QueryExpression {

        public static class UMin
        extends UnaryExpression
        implements ArithmeticExpression {
            public UMin(QueryExpression exp) {
                super(exp);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.UMIN;
            }

            public String toString() {
                return "-(" + this.getExp() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Mod
        extends BinaryExpression
        implements ArithmeticExpression {
            public Mod(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.MOD;
            }

            public String toString() {
                return "(" + this.getExp1() + " % " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Div
        extends BinaryExpression
        implements ArithmeticExpression {
            public Div(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.DIV;
            }

            public String toString() {
                return "(" + this.getExp1() + " / " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Mul
        extends BinaryExpression
        implements ArithmeticExpression {
            public Mul(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.MUL;
            }

            public String toString() {
                return "(" + this.getExp1() + " * " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Add
        extends BinaryExpression
        implements ArithmeticExpression {
            public Add(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.ADD;
            }

            public String toString() {
                return "(" + this.getExp1() + " + " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }

        public static class Sub
        extends BinaryExpression
        implements ArithmeticExpression {
            public Sub(QueryExpression exp1, QueryExpression exp2) {
                super(exp1, exp2);
            }

            @Override
            public ExpressionType getExpType() {
                return ExpressionType.SUB;
            }

            public String toString() {
                return "(" + this.getExp1() + " - " + this.getExp2() + ")";
            }

            @Override
            public void accept(QueryExpressionVisitor v) {
                v.visit(this);
            }
        }
    }

    public static abstract class TernaryExpression
    implements QueryExpression {
        private QueryExpression exp1;
        private QueryExpression exp2;
        private QueryExpression exp3;

        public TernaryExpression(QueryExpression exp1, QueryExpression exp2, QueryExpression exp3) {
            this.exp1 = exp1;
            this.exp2 = exp2;
            this.exp3 = exp3;
        }

        public QueryExpression getExp1() {
            return this.exp1;
        }

        public void setExp1(QueryExpression exp1) {
            this.exp1 = exp1;
        }

        public QueryExpression getExp2() {
            return this.exp2;
        }

        public void setExp2(QueryExpression exp2) {
            this.exp2 = exp2;
        }

        public QueryExpression getExp3() {
            return this.exp3;
        }

        public void setExp3(QueryExpression exp3) {
            this.exp3 = exp3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TernaryExpression that = (TernaryExpression)o;
            if (!this.exp1.equals(that.exp1)) {
                return false;
            }
            if (!this.exp2.equals(that.exp2)) {
                return false;
            }
            return this.exp3.equals(that.exp3);
        }

        public int hashCode() {
            return 31;
        }
    }

    public static abstract class BinaryExpression
    implements QueryExpression {
        private QueryExpression exp1;
        private QueryExpression exp2;

        public BinaryExpression(QueryExpression exp1, QueryExpression exp2) {
            this.exp1 = exp1;
            this.exp2 = exp2;
        }

        public QueryExpression getExp1() {
            return this.exp1;
        }

        public void setExp1(QueryExpression exp1) {
            this.exp1 = exp1;
        }

        public QueryExpression getExp2() {
            return this.exp2;
        }

        public void setExp2(QueryExpression exp2) {
            this.exp2 = exp2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinaryExpression that = (BinaryExpression)o;
            if (!this.exp1.equals(that.exp1)) {
                return false;
            }
            return this.exp2.equals(that.exp2);
        }

        public int hashCode() {
            return 31;
        }
    }

    public static abstract class UnaryExpression
    implements QueryExpression {
        private QueryExpression exp;

        public UnaryExpression(QueryExpression exp) {
            this.exp = exp;
        }

        public QueryExpression getExp() {
            return this.exp;
        }

        public void setExp(QueryExpression exp) {
            this.exp = exp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnaryExpression that = (UnaryExpression)o;
            return this.exp.equals(that.exp);
        }

        public int hashCode() {
            return 31;
        }
    }

    public static enum ExpressionType {
        INTEGER,
        DECIMAL,
        STRING,
        BOOLEAN,
        DATE,
        TIME,
        TIMESTAMP,
        TIME_WITH_TIMEZONE,
        TIMESTAMP_WITH_TIMEZONE,
        SUB,
        ADD,
        MUL,
        DIV,
        MOD,
        UMIN,
        AND,
        OR,
        NOT,
        EQUAL,
        NOT_EQUAL,
        GREATER,
        GREATER_EQUAL,
        LESS,
        LESS_EQUAL,
        CONCAT,
        AGGR_COUNT,
        AGGR_MIN,
        AGGR_MAX,
        AGGR_SUM,
        AGGR_AVG,
        AGGR_ARRAY_AGG,
        AGGR_LISTAGG,
        VARREF,
        BIND_VARIABLE,
        STAR,
        ALL_PROPERTIES,
        SCALAR_SUBQUERY,
        PROP_ACCESS,
        CAST,
        EXISTS,
        FUNCTION_CALL,
        EXTRACT_EXPRESSION,
        IN_EXPRESSION,
        IN_VALUE_LIST,
        IS_NULL,
        IF_ELSE,
        SIMPLE_CASE,
        SUBSTRING,
        BETWEEN_PREDICATE;

    }
}

