/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.util;

import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.Projection;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.modify.DeleteClause;
import oracle.pgql.lang.ir.modify.EdgeInsertion;
import oracle.pgql.lang.ir.modify.InsertClause;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.ir.modify.SetPropertyExpression;
import oracle.pgql.lang.ir.modify.Update;
import oracle.pgql.lang.ir.modify.UpdateClause;
import oracle.pgql.lang.ir.modify.VertexInsertion;
import oracle.pgql.lang.ir.unnest.OneRowPerEdge;
import oracle.pgql.lang.ir.unnest.OneRowPerVertex;
import oracle.pgql.lang.ir.unnest.RowsPerMatch;

public abstract class AbstractQueryExpressionVisitor
implements QueryExpressionVisitor {
    @Override
    public void visit(QueryExpression.VarRef varRef) {
    }

    @Override
    public void visit(QueryExpression.BindVariable bindVariable) {
    }

    @Override
    public void visit(QueryExpression.PropertyAccess propAccess) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstInteger constInteger) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstDecimal constDecimal) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstString constString) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstBoolean constBoolean) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstDate constDate) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTime constTime) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTimestamp constTimestamp) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTimeWithTimezone constTimeWithTimezone) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTimestampWithTimezone constTimestampWithTimezone) {
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Sub sub) {
        sub.getExp1().accept(this);
        sub.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Add add) {
        add.getExp1().accept(this);
        add.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Mul mul) {
        mul.getExp1().accept(this);
        mul.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Div div) {
        div.getExp1().accept(this);
        div.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Mod mod) {
        mod.getExp1().accept(this);
        mod.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.UMin uMin) {
        uMin.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.LogicalExpression.And and) {
        and.getExp1().accept(this);
        and.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.LogicalExpression.Or or) {
        or.getExp1().accept(this);
        or.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.LogicalExpression.Not not) {
        not.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.Equal equal) {
        equal.getExp1().accept(this);
        equal.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.NotEqual notEqual) {
        notEqual.getExp1().accept(this);
        notEqual.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.Greater greater) {
        greater.getExp1().accept(this);
        greater.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.GreaterEqual greaterEqual) {
        greaterEqual.getExp1().accept(this);
        greaterEqual.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.Less less) {
        less.getExp1().accept(this);
        less.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.LessEqual lessEqual) {
        lessEqual.getExp1().accept(this);
        lessEqual.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.ConcatExpression concat) {
        concat.getExp1().accept(this);
        concat.getExp2().accept(this);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
        aggrCount.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
        aggrListagg.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
        aggrMin.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
        aggrMax.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
        aggrSum.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
        aggrAvg.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayAgg) {
        aggrArrayAgg.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.Star star) {
    }

    @Override
    public void visit(QueryExpression.AllProperties allProperties) {
        allProperties.getVarRef().accept(this);
    }

    @Override
    public void visit(QueryExpression.Function.Cast cast) {
        cast.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.FunctionCall functionCall) {
        functionCall.getArgs().stream().forEach(e -> e.accept(this));
    }

    @Override
    public void visit(QueryExpression.ExtractExpression extractExpression) {
        extractExpression.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.InPredicate inPredicate) {
        inPredicate.getExp().accept(this);
        inPredicate.getInValueList().accept(this);
    }

    @Override
    public void visit(QueryExpression.InPredicate.InValueList inValueList) {
    }

    @Override
    public void visit(QueryExpression.IsNull isNull) {
        isNull.getExp().accept(this);
    }

    @Override
    public void visit(QueryExpression.IfElse ifElse) {
        ifElse.getExp1().accept(this);
        ifElse.getExp2().accept(this);
        if (ifElse.getExp3() != null) {
            ifElse.getExp3().accept(this);
        }
    }

    @Override
    public void visit(QueryExpression.SimpleCase simpleCase) {
        simpleCase.getCaseOperand().accept(this);
        simpleCase.getWhenThenExps().forEach(whenThen -> {
            whenThen.getWhen().accept(this);
            whenThen.getThen().accept(this);
        });
        if (simpleCase.getElseExp() != null) {
            simpleCase.getElseExp().accept(this);
        }
    }

    @Override
    public void visit(QueryExpression.SubstringExpression substringExpression) {
        substringExpression.getExp().accept(this);
        substringExpression.getStartPosition().accept(this);
        if (substringExpression.getStringLength() != null) {
            substringExpression.getStringLength().accept(this);
        }
    }

    @Override
    public void visit(QueryExpression.BetweenPredicate betweenPredicate) {
        betweenPredicate.getExp1().accept(this);
        betweenPredicate.getExp2().accept(this);
        betweenPredicate.getExp3().accept(this);
    }

    @Override
    public void visit(QueryExpression.Function.Exists exists) {
        exists.getQuery().accept(this);
    }

    @Override
    public void visit(QueryExpression.ScalarSubquery scalarSubquery) {
        scalarSubquery.getQuery().accept(this);
    }

    @Override
    public void visit(SelectQuery selectQuery) {
        selectQuery.getProjection().accept(this);
        this.visitQuery(selectQuery);
    }

    private void visitQuery(GraphQuery query) {
        if (query.getGraphPattern() != null) {
            query.getGraphPattern().accept(this);
        }
        if (query.getGroupBy() != null) {
            query.getGroupBy().accept(this);
        }
        if (query.getHaving() != null) {
            query.getHaving().accept(this);
        }
        query.getOrderBy().accept(this);
        if (query.getLimit() != null) {
            query.getLimit().accept(this);
        }
        if (query.getOffset() != null) {
            query.getOffset().accept(this);
        }
    }

    @Override
    public void visit(GraphPattern graphPattern) {
        graphPattern.getVertices().stream().forEach(e -> e.accept(this));
        graphPattern.getConnections().stream().forEach(e -> e.accept(this));
        graphPattern.getConstraints().stream().forEach(e -> e.accept(this));
    }

    @Override
    public void visit(Projection projection) {
        projection.getElements().stream().forEach(e -> e.accept(this));
    }

    @Override
    public void visit(ExpAsVar expAsVar) {
        expAsVar.getExp().accept(this);
    }

    @Override
    public void visit(QueryVertex queryVertex) {
    }

    @Override
    public void visit(QueryEdge queryEdge) {
    }

    @Override
    public void visit(QueryPath queryPath) {
        queryPath.getConnections().stream().forEach(e -> e.accept(this));
        queryPath.getConstraints().stream().forEach(e -> e.accept(this));
        RowsPerMatch rowsPerMatch = queryPath.getRowsPerMatch();
        switch (queryPath.getRowsPerMatch().getRowsPerMatchType()) {
            case ONE_ROW_PER_VERTEX: {
                ((OneRowPerVertex)rowsPerMatch).getVertex().accept(this);
                break;
            }
            case ONE_ROW_PER_EDGE: {
                ((OneRowPerEdge)rowsPerMatch).getEdge().accept(this);
                break;
            }
            case ONE_ROW_PER_MATCH: {
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)rowsPerMatch.getRowsPerMatchType()) + " not supported");
            }
        }
    }

    @Override
    public void visit(GroupBy groupBy) {
        groupBy.getElements().stream().forEach(e -> e.accept(this));
    }

    @Override
    public void visit(OrderBy orderBy) {
        orderBy.getElements().stream().forEach(e -> e.accept(this));
    }

    @Override
    public void visit(OrderByElem orderByElem) {
        orderByElem.getExp().accept(this);
    }

    @Override
    public void visit(ModifyQuery modifyQuery) {
        modifyQuery.getModifications().stream().forEach(modification -> modification.accept(this));
        this.visitQuery(modifyQuery);
    }

    @Override
    public void visit(InsertClause insertClause) {
        insertClause.getInsertions().stream().forEach(element -> element.accept(this));
    }

    @Override
    public void visit(UpdateClause updateClause) {
        updateClause.getUpdates().stream().forEach(element -> element.accept(this));
    }

    @Override
    public void visit(DeleteClause deleteClause) {
        deleteClause.getDeletions().stream().forEach(element -> element.accept(this));
    }

    @Override
    public void visit(VertexInsertion vertexInsertion) {
        vertexInsertion.getVertex().accept(this);
        vertexInsertion.getLabels().stream().forEach(label -> label.accept(this));
        vertexInsertion.getProperties().stream().forEach(setProperty -> setProperty.accept(this));
    }

    @Override
    public void visit(EdgeInsertion edgeInsertion) {
        edgeInsertion.getEdge().accept(this);
        edgeInsertion.getLabels().stream().forEach(label -> label.accept(this));
        edgeInsertion.getProperties().stream().forEach(setProperty -> setProperty.accept(this));
    }

    @Override
    public void visit(Update update) {
        update.getElement().accept(this);
        update.getSetPropertyExpressions().stream().forEach(setPropertyExpression -> setPropertyExpression.accept(this));
    }

    @Override
    public void visit(SetPropertyExpression setPropertyExpression) {
        setPropertyExpression.getPropertyAccess().accept(this);
        setPropertyExpression.getValueExpression().accept(this);
    }
}

