/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import oracle.jdevimpl.javacompiler.AnnotationProcessorClassLoader;
import oracle.jdevimpl.javacompiler.FileJavaFileObject;
import oracle.jdevimpl.javacompiler.FileListener;
import oracle.jdevimpl.javacompiler.JDevJavaCompiler;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.JavaCompilerOptions;
import oracle.jdevimpl.javacompiler.ResourceUtils;
import oracle.jdevimpl.javacompiler.StorageJavaFileObject;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class JDevJavaFileManager
implements StandardJavaFileManager {
    private static final String STORAGE_APPEND_SLASH = "StorageAppendSlash";
    private Storage outputPath;
    private List<? extends Storage> sourcePath;
    private List<? extends Storage> bootClassPath;
    private List<? extends Storage> appendBootClassPath;
    private List<? extends Storage> prependBootClassPath;
    private List<? extends Storage> classPath;
    private List<? extends Storage> extDirsPath;
    private List<? extends Storage> endorsedDirsPath;
    private List<? extends Storage> annotationProcessorPath;
    private Map<JavaFileManager.Location, Iterable<? extends Storage>> locationStorages;
    private String encoding = null;
    private String fileSeparator;
    private char fileSeparatorChar;
    private Map<String, Integer> supportedOptions;
    private List<FileListener> fileListeners;
    private boolean checkUnusedJars = System.getProperty("CHECK_UNUSED_JARS") != null;
    private boolean interrupted;
    private int interruptCounter;
    private JavaCompilerLog<JavaFileObject> log;
    private boolean verbose;
    private AnnotationProcessorClassLoader annotationProcessorClassLoader;
    private ClassLoader javacClassLoader;
    private JavaFileManager standardJavaFileManager;
    private List<String> profileJdkClassPath;
    private Iterable<? extends File> platformClassPathOverride;
    private Iterable<? extends File> outputPathOverride;
    private String modulePath;

    public JDevJavaFileManager() {
        this.fileSeparator = System.getProperty("file.separator");
        if (this.fileSeparator == null) {
            this.fileSeparator = "/";
        }
        this.fileSeparatorChar = this.fileSeparator.charAt(0);
        this.locationStorages = new HashMap<JavaFileManager.Location, Iterable<? extends Storage>>();
        this.supportedOptions = new HashMap<String, Integer>(9);
        this.supportedOptions.put("-d", 1);
        this.supportedOptions.put("-sourcepath", 1);
        this.supportedOptions.put("-classpath", 1);
        this.supportedOptions.put("-cp", 1);
        this.supportedOptions.put("-bootclasspath", 1);
        this.supportedOptions.put("-Xbootclasspath/a:", 0);
        this.supportedOptions.put("-Xbootclasspath/p:", 0);
        this.supportedOptions.put("-Xbootclasspath:", 0);
        this.supportedOptions.put("-encoding", 1);
        this.supportedOptions.put("-endorseddirs", 1);
        this.supportedOptions.put("-extdirs", 1);
        if (JDevJavaCompiler.allowAnnotationProcessing()) {
            this.supportedOptions.put("-processor", 1);
            this.supportedOptions.put("-processorpath", 1);
        }
        this.fileListeners = new ArrayList<FileListener>();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (JDevJavaCompiler.allowAnnotationProcessing() && location == StandardLocation.ANNOTATION_PROCESSOR_PATH) {
            if (this.annotationProcessorClassLoader == null) {
                this.annotationProcessorClassLoader = new AnnotationProcessorClassLoader(this, (StandardLocation)location, this.log);
            }
            return this.annotationProcessorClassLoader;
        }
        return this.getClass().getClassLoader();
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<? extends Storage> locationStorages;
        if (this.interrupted) {
            return Collections.emptyList();
        }
        if (++this.interruptCounter > 20) {
            this.checkInterrupt();
        }
        if (this.profileJdkClassPath != null && location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            try {
                Iterable<JavaFileObject> result = this.standardJavaFileManager.list(location, packageName, kinds, recurse);
                if (result != null && result.iterator().hasNext()) {
                    return result;
                }
            }
            catch (IOException result) {
                // empty catch block
            }
        }
        if ((locationStorages = this.getLocationStorages(location)).iterator().hasNext()) {
            List<Storage> storages = this.getPackageStorages(locationStorages, packageName, false);
            ArrayList<JavaFileObject> fileList = new ArrayList<JavaFileObject>();
            for (Storage storage : storages) {
                if (!storage.isDirectory()) continue;
                this.list(packageName, storage, kinds, fileList, recurse);
            }
            return fileList;
        }
        return this.standardJavaFileManager.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof StorageJavaFileObject) {
            String binaryName = ((StorageJavaFileObject)file).getBinaryName();
            if (binaryName == null) {
                String path = ((StorageJavaFileObject)file).getPath();
                path = path.replace('\\', '/');
                Iterable<? extends Storage> storageIter = this.getLocationStorages(location);
                for (Storage storage : storageIter) {
                    String storagePath = storage.getPath().replace('\\', '/');
                    if (!storagePath.endsWith("/")) {
                        storagePath = storagePath + "/";
                    }
                    if (!path.startsWith(storagePath)) continue;
                    binaryName = path.substring(storagePath.length());
                    int index = binaryName.lastIndexOf(46);
                    if (index > 0) {
                        binaryName = binaryName.substring(0, index);
                    }
                    ((StorageJavaFileObject)file).setBinaryName(binaryName);
                    break;
                }
            }
            return binaryName;
        }
        return this.standardJavaFileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        boolean isOurObjectA = a instanceof StorageJavaFileObject;
        boolean isOurObjectB = b instanceof StorageJavaFileObject;
        if (isOurObjectA && isOurObjectB) {
            StorageJavaFileObject one = (StorageJavaFileObject)a;
            StorageJavaFileObject two = (StorageJavaFileObject)b;
            return one.getPath() != null && two.getPath() != null && one.getPath().equals(two.getPath());
        }
        if (!isOurObjectA && !isOurObjectB) {
            return this.standardJavaFileManager.isSameFile(a, b);
        }
        return a.toUri().equals(b.toUri());
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        int prefixLength;
        boolean missingArgument = false;
        if (current.equals("-d")) {
            if (remaining.hasNext()) {
                String path = remaining.next();
                if (!path.endsWith(this.fileSeparator)) {
                    path = path + this.fileSeparator;
                }
                this.outputPath = this.getOutputPathStorage(path);
                if (this.outputPath == null) {
                    String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", path);
                    throw new IllegalArgumentException(msg);
                }
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-sourcepath")) {
            if (remaining.hasNext()) {
                this.closeStorages(this.sourcePath, null);
                this.sourcePath = JDevJavaFileManager.parsePath(current, remaining.next(), false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-classpath") || current.equals("-cp")) {
            if (remaining.hasNext()) {
                String argument = remaining.next();
                if (this.classPath == null) {
                    this.classPath = JDevJavaFileManager.parsePath(current, argument, this.checkUnusedJars, this.verbose, this.log);
                }
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-bootclasspath")) {
            if (remaining.hasNext()) {
                this.closeStorages(this.bootClassPath, null);
                this.bootClassPath = JDevJavaFileManager.parsePath(current, remaining.next(), false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.startsWith("-Xbootclasspath:")) {
            prefixLength = "-Xbootclasspath:".length();
            if (current.length() > prefixLength) {
                this.closeStorages(this.bootClassPath, null);
                this.bootClassPath = JDevJavaFileManager.parsePath(current.substring(0, prefixLength), current.substring(prefixLength), false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.startsWith("-Xbootclasspath/a:")) {
            prefixLength = "-Xbootclasspath/a:".length();
            if (current.length() > prefixLength) {
                this.closeStorages(this.appendBootClassPath, null);
                this.appendBootClassPath = JDevJavaFileManager.parsePath(current.substring(0, prefixLength), current.substring(prefixLength), false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.startsWith("-Xbootclasspath/p:")) {
            prefixLength = "-Xbootclasspath/p:".length();
            if (current.length() > prefixLength) {
                this.closeStorages(this.prependBootClassPath, null);
                this.prependBootClassPath = JDevJavaFileManager.parsePath(current.substring(0, prefixLength), current.substring(prefixLength), false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-endorseddirs")) {
            if (remaining.hasNext()) {
                String endorsedDirsAsPathString = this.dirsOptionToPath(current, remaining.next());
                this.closeStorages(this.endorsedDirsPath, null);
                this.endorsedDirsPath = JDevJavaFileManager.parsePath(current, endorsedDirsAsPathString, false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-extdirs")) {
            if (remaining.hasNext()) {
                String extDirsAsPathString = this.dirsOptionToPath(current, remaining.next());
                this.closeStorages(this.extDirsPath, null);
                this.extDirsPath = JDevJavaFileManager.parsePath(current, extDirsAsPathString, false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-encoding")) {
            if (remaining.hasNext()) {
                this.encoding = JDevJavaFileManager.getEncoding(remaining.next());
                return true;
            }
            missingArgument = true;
        } else if (JDevJavaCompiler.allowAnnotationProcessing() && current.equals("-processorpath")) {
            if (remaining.hasNext()) {
                String argument = remaining.next();
                this.closeStorages(this.annotationProcessorPath, null);
                this.annotationProcessorPath = JDevJavaFileManager.parsePath(current, argument, false, this.verbose, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("--module-path")) {
            if (remaining.hasNext()) {
                remaining.next();
                return true;
            }
            missingArgument = true;
        }
        if (missingArgument) {
            String msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", current);
            throw new IllegalArgumentException(msg);
        }
        return false;
    }

    void setStandardJavaFileManager(JavaFileManager standardJavaFileManager) {
        this.standardJavaFileManager = standardJavaFileManager;
        if (this.profileJdkClassPath != null && !this.profileJdkClassPath.isEmpty()) {
            standardJavaFileManager.handleOption("-classpath", this.profileJdkClassPath.iterator());
        }
        if (this.modulePath != null) {
            ArrayList<String> modulePathList = new ArrayList<String>(1);
            modulePathList.add(this.modulePath);
            standardJavaFileManager.handleOption("--module-path", modulePathList.iterator());
        }
    }

    void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public void setProfileJdkClassPath(String classPath) {
        this.profileJdkClassPath = new ArrayList<String>(1);
        if (classPath != null && !classPath.trim().isEmpty()) {
            this.profileJdkClassPath.add(classPath);
        }
    }

    protected Storage getOutputPathStorage(String outputPath) {
        File pathFile = new File(outputPath);
        if (pathFile.exists() ? !pathFile.isDirectory() : !pathFile.mkdirs()) {
            return null;
        }
        return new DirectoryStorage(pathFile);
    }

    private String dirsOptionToPath(String option, String argument) {
        if (argument == null || argument.trim().length() == 0) {
            return "";
        }
        String[] pieces = argument.split(File.pathSeparator);
        StringBuilder buf = new StringBuilder();
        for (String piece : pieces) {
            if ((piece = piece.trim()).length() == 0) continue;
            File file = new File(piece);
            boolean notDirectory = false;
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception ex) {
                notDirectory = true;
            }
            if (!notDirectory && !file.isDirectory()) {
                notDirectory = true;
            }
            if (notDirectory) {
                String msg = ResourceUtils.format("OPTION_TAKES_DIRECTORIES_OF_JARS_AND_ZIPS", "Argument {0} of option {1} is not a directory with jar and zip files", piece, option);
                this.log.warning(null, 0L, 0L, 0, msg);
                continue;
            }
            File[] children = file.listFiles();
            if (children == null) continue;
            for (File child : children) {
                String lowerCaseName;
                if (!child.isFile() || !(lowerCaseName = child.getName().toLowerCase()).endsWith(".jar") && !lowerCaseName.endsWith(".zip")) continue;
                buf.append(child.getPath());
                buf.append(File.pathSeparatorChar);
            }
        }
        return buf.toString();
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        Iterable<? extends Storage> storages;
        if (location instanceof StandardLocation) {
            switch ((StandardLocation)location) {
                case PLATFORM_CLASS_PATH: {
                    return this.platformClassPathOverride != null;
                }
                case CLASS_OUTPUT: 
                case SOURCE_OUTPUT: {
                    return this.outputPathOverride != null;
                }
            }
        }
        return (storages = this.getLocationStorages(location)).iterator().hasNext() || this.standardJavaFileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.CLASS && kind != JavaFileObject.Kind.SOURCE) {
            throw new IllegalArgumentException("Illegal JavaFileObject.Kind: " + kind.name());
        }
        Iterable<? extends Storage> locationStorages = this.getLocationStorages(location);
        if (locationStorages.iterator().hasNext()) {
            if (this.profileJdkClassPath != null && kind == JavaFileObject.Kind.CLASS && location == StandardLocation.CLASS_PATH) {
                try {
                    JavaFileObject result = this.standardJavaFileManager.getJavaFileForInput(location, className, kind);
                    if (result != null) {
                        return result;
                    }
                }
                catch (IOException result) {
                    // empty catch block
                }
            }
            int index = className.lastIndexOf(46);
            String packageName = "";
            String shortClassName = className;
            if (index > 0) {
                packageName = className.substring(0, index);
                shortClassName = className.substring(index + 1);
            }
            shortClassName = shortClassName + kind.extension;
            return (JavaFileObject)this.getFileForInput(location, packageName, shortClassName);
        }
        try {
            JavaFileObject result = this.standardJavaFileManager.getJavaFileForInput(location, className, kind);
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        int index = className.lastIndexOf(46);
        String packageName = index > 0 ? className.substring(0, index) : null;
        String fileName = index > 0 ? className.substring(index + 1) : className;
        fileName = fileName + kind.extension;
        return (JavaFileObject)this.getFileForOutput(location, packageName, fileName, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) {
        Storage fileStorage;
        Storage packageStorage;
        if (this.interrupted) {
            return null;
        }
        if (++this.interruptCounter > 20) {
            this.checkInterrupt();
        }
        if ((packageStorage = this.getPackageStorage(location, packageName)) != null && packageStorage.isDirectory() && (fileStorage = packageStorage.open(relativeName)) != null) {
            StorageJavaFileObject file = new StorageJavaFileObject(packageName, fileStorage, this.encoding);
            file.setJDevJavaFileManager(this);
            return file;
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        File parent;
        URI uri;
        if (this.interrupted) {
            return null;
        }
        if (++this.interruptCounter > 20) {
            this.checkInterrupt();
        }
        Iterable<? extends Storage> storages = this.getLocationStorages(location);
        Storage outputStorage = null;
        Iterator<? extends Storage> iterator = storages.iterator();
        if (iterator.hasNext()) {
            Storage s;
            outputStorage = s = iterator.next();
        }
        if (outputStorage == null && sibling != null && (uri = sibling.toUri()) != null && (parent = new File(uri).getParentFile()) != null) {
            outputStorage = new FileStorage(parent);
        }
        if (outputStorage != null) {
            this.checkDirectory(outputStorage);
            if (packageName != null) {
                String[] packageNamePieces;
                String[] stringArray = packageNamePieces = (packageName = packageName.trim()).length() == 0 ? new String[]{} : packageName.split("\\.");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Storage originalOutputStorage = outputStorage;
                    String packageNamePiece = stringArray[i];
                    if ((outputStorage = originalOutputStorage.createDir(packageNamePiece)) != null && outputStorage.isDirectory()) continue;
                    String outputPath = originalOutputStorage.getPath() + this.fileSeparatorChar + packageNamePiece;
                    String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", outputPath);
                    throw new IllegalArgumentException(msg);
                }
            }
            outputStorage = outputStorage.create(relativeName);
            this.reportFileOutput(outputStorage.getPath());
            return new StorageJavaFileObject(packageName, outputStorage, this.encoding);
        }
        String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", packageName + this.fileSeparatorChar + relativeName);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public void flush() throws IOException {
        if (this.standardJavaFileManager != null) {
            this.standardJavaFileManager.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.annotationProcessorClassLoader = null;
        this.javacClassLoader = null;
        PrintWriter writer = null;
        try {
            String unusedZipFileName = System.getProperty("javac.unused.zip.file");
            if (unusedZipFileName != null && unusedZipFileName.trim().length() > 0) {
                File file = new File(unusedZipFileName);
                boolean cannotWrite = false;
                File parentDirectory = file.getParentFile();
                if (parentDirectory.exists() || parentDirectory.mkdirs()) {
                    try {
                        writer = new PrintWriter(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        cannotWrite = true;
                    }
                } else {
                    cannotWrite = true;
                }
                if (cannotWrite && this.log != null) {
                    String string = ResourceUtils.format("CANNOT_WRITE_UNUSED_JAR_ZIP_FILE", "Cannot write unused jar/zip file", new Object[0]);
                    this.log.warning(null, 0L, 0L, 0, string);
                }
            }
            for (Iterable<? extends Storage> storageIter : this.locationStorages.values()) {
                for (Storage storage : storageIter) {
                    if (this.verbose || this.checkUnusedJars) {
                        this.closeStorageWithUnusedJarCheck(storage, writer);
                        continue;
                    }
                    storage.close();
                }
            }
            this.locationStorages.clear();
            this.closeStorages(this.sourcePath, writer);
            this.closeStorages(this.bootClassPath, writer);
            this.closeStorages(this.appendBootClassPath, writer);
            this.closeStorages(this.prependBootClassPath, writer);
            this.closeStorages(this.classPath, writer);
            this.closeStorages(this.extDirsPath, writer);
            this.closeStorages(this.endorsedDirsPath, writer);
            this.closeStorages(this.annotationProcessorPath, writer);
        }
        finally {
            this.locationStorages = null;
            this.sourcePath = null;
            this.bootClassPath = null;
            this.appendBootClassPath = null;
            this.prependBootClassPath = null;
            this.classPath = null;
            this.extDirsPath = null;
            this.endorsedDirsPath = null;
            this.annotationProcessorPath = null;
            if (writer != null) {
                writer.close();
            }
        }
        if (this.outputPath != null) {
            this.outputPath.close();
            this.outputPath = null;
        }
        this.supportedOptions.clear();
        this.fileListeners.clear();
        if (this.standardJavaFileManager != null) {
            this.standardJavaFileManager.close();
        }
    }

    private void closeStorages(List<? extends Storage> list, PrintWriter writer) {
        if (list != null) {
            for (Storage storage : list) {
                if (this.verbose || this.checkUnusedJars) {
                    this.closeStorageWithUnusedJarCheck(storage, writer);
                    continue;
                }
                storage.close();
            }
            list.clear();
        }
    }

    private void closeStorageWithUnusedJarCheck(Storage storage, PrintWriter writer) {
        Object enclosingJar = storage.getProperty("javacompiler.enclosing.jar");
        if (enclosingJar == storage && storage.getProperty("javacompiler.enclosing.jar.used") == Boolean.FALSE) {
            this.log.warning(null, 0L, 0L, 0, storage.getPath() + " not used.");
            if (writer != null) {
                writer.println(storage.getPath());
            }
        }
        storage.setProperty("javacompiler.enclosing.jar", null);
        storage.close();
    }

    @Override
    public int isSupportedOption(String option) {
        if (this.profileJdkClassPath != null && "-classpath".equals(option)) {
            return this.standardJavaFileManager.isSupportedOption(option);
        }
        if ("--module-path".equals(option)) {
            return this.standardJavaFileManager.isSupportedOption(option);
        }
        for (Map.Entry<String, Integer> entry : this.supportedOptions.entrySet()) {
            String key = entry.getKey();
            if (key.equals(option)) {
                return entry.getValue();
            }
            if (!key.endsWith(":") && !key.endsWith("=") || !option.startsWith(key)) continue;
            return entry.getValue();
        }
        return -1;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<FileJavaFileObject> javaFileObjects = new ArrayList<FileJavaFileObject>();
        for (File file : files) {
            javaFileObjects.add(new FileJavaFileObject(file));
        }
        return javaFileObjects;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        ArrayList<FileJavaFileObject> javaFileObjects = new ArrayList<FileJavaFileObject>();
        for (File file : files) {
            javaFileObjects.add(new FileJavaFileObject(file));
        }
        return javaFileObjects;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        ArrayList<FileJavaFileObject> javaFileObjects = new ArrayList<FileJavaFileObject>();
        for (String name : names) {
            javaFileObjects.add(new FileJavaFileObject(new File(name)));
        }
        return javaFileObjects;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ArrayList<FileJavaFileObject> javaFileObjects = new ArrayList<FileJavaFileObject>();
        for (String name : names) {
            javaFileObjects.add(new FileJavaFileObject(new File(name)));
        }
        return javaFileObjects;
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        if (location instanceof StandardLocation) {
            switch ((StandardLocation)location) {
                case PLATFORM_CLASS_PATH: {
                    this.platformClassPathOverride = path;
                    break;
                }
                case CLASS_OUTPUT: 
                case SOURCE_OUTPUT: {
                    this.outputPathOverride = path;
                }
            }
        }
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        if (location instanceof StandardLocation) {
            switch ((StandardLocation)location) {
                case PLATFORM_CLASS_PATH: {
                    if (this.platformClassPathOverride == null) break;
                    return this.platformClassPathOverride;
                }
                case CLASS_OUTPUT: 
                case SOURCE_OUTPUT: {
                    if (this.outputPathOverride == null) break;
                    return this.outputPathOverride;
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        try {
            Method method = JavaFileManager.class.getMethod("getLocationForModule", JavaFileManager.Location.class, String.class);
            return (JavaFileManager.Location)method.invoke((Object)this.standardJavaFileManager, location, moduleName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo, String pkgName) throws IOException {
        try {
            Method method = JavaFileManager.class.getMethod("getLocationForModule", JavaFileManager.Location.class, JavaFileObject.class, String.class);
            return (JavaFileManager.Location)method.invoke((Object)this.standardJavaFileManager, location, fo, pkgName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        try {
            Method method = JavaFileManager.class.getMethod("getLocationForModule", JavaFileManager.Location.class, JavaFileObject.class);
            return (JavaFileManager.Location)method.invoke((Object)this.standardJavaFileManager, location, fo);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        try {
            Method method = JavaFileManager.class.getMethod("getServiceLoader", JavaFileManager.Location.class, Class.class);
            return (ServiceLoader)method.invoke((Object)this.standardJavaFileManager, location, service);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        try {
            Method method = JavaFileManager.class.getMethod("inferModuleName", JavaFileManager.Location.class);
            return (String)method.invoke((Object)this.standardJavaFileManager, location);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        try {
            Method method = JavaFileManager.class.getMethod("listLocationsForModules", JavaFileManager.Location.class);
            return (Iterable)method.invoke((Object)this.standardJavaFileManager, location);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        if (location instanceof StandardLocation) {
            String path = ((StorageJavaFileObject)fo).getPath();
            path = path.replace('\\', '/');
            Iterable<? extends Storage> storageIter = this.getLocationStorages(location);
            for (Storage storage : storageIter) {
                String storagePath = storage.getPath().replace('\\', '/');
                if (!storagePath.endsWith("/")) {
                    storagePath = storagePath + "/";
                }
                if (!path.startsWith(storagePath)) continue;
                return true;
            }
        }
        return false;
    }

    private Iterable<? extends Storage> getLocationStorages(JavaFileManager.Location location) {
        Iterable<? extends Storage> storages = this.locationStorages.get(location);
        if (storages == null) {
            ArrayList<? extends Storage> storageList = new ArrayList<Storage>();
            if (location instanceof StandardLocation) {
                StandardLocation standardLocation = (StandardLocation)location;
                switch (standardLocation) {
                    case CLASS_OUTPUT: 
                    case SOURCE_OUTPUT: {
                        if (this.outputPath == null) break;
                        storageList.add((Storage)this.outputPath);
                        break;
                    }
                    case CLASS_PATH: {
                        if (this.classPath == null) break;
                        for (Storage storage : this.classPath) {
                            storageList.add((Storage)storage);
                        }
                        break;
                    }
                    case PLATFORM_CLASS_PATH: {
                        ArrayList<List<? extends Storage>> bootPaths = new ArrayList<List<? extends Storage>>();
                        bootPaths.add(this.prependBootClassPath);
                        bootPaths.add(this.endorsedDirsPath);
                        bootPaths.add(this.bootClassPath);
                        bootPaths.add(this.appendBootClassPath);
                        bootPaths.add(this.extDirsPath);
                        for (List list : bootPaths) {
                            if (list == null) continue;
                            for (Storage storage : list) {
                                storageList.add((Storage)storage);
                            }
                        }
                        break;
                    }
                    case SOURCE_PATH: {
                        if (this.sourcePath == null) break;
                        for (Storage storage : this.sourcePath) {
                            storageList.add((Storage)storage);
                        }
                        break;
                    }
                    case ANNOTATION_PROCESSOR_PATH: {
                        if (!JDevJavaCompiler.allowAnnotationProcessing()) break;
                        if (this.annotationProcessorPath != null) {
                            for (Storage storage : this.annotationProcessorPath) {
                                storageList.add((Storage)storage);
                            }
                        } else {
                            if (this.classPath == null) break;
                            for (Storage storage : this.classPath) {
                                storageList.add((Storage)storage);
                            }
                        }
                        break;
                    }
                }
            }
            this.locationStorages.put(location, storageList);
            storages = storageList;
        }
        return storages;
    }

    private void list(String packageName, Storage dir, Set<JavaFileObject.Kind> kinds, List<JavaFileObject> fileList, boolean recurse) {
        String[] children = dir.list();
        if (children != null) {
            Object enclosingJar = this.verbose || this.checkUnusedJars ? dir.getProperty("javacompiler.enclosing.jar") : null;
            for (String childName : children) {
                boolean acceptedFile = this.acceptFile(childName, kinds);
                if (!acceptedFile && !recurse) continue;
                Storage childStorage = dir.open(childName);
                if (this.verbose || this.checkUnusedJars) {
                    childStorage.setProperty("javacompiler.enclosing.jar", enclosingJar);
                }
                boolean isDirectory = childStorage.isDirectory();
                if (acceptedFile && !isDirectory) {
                    StorageJavaFileObject file = new StorageJavaFileObject(packageName, childStorage, this.encoding);
                    file.setJDevJavaFileManager(this);
                    fileList.add(file);
                    continue;
                }
                if (!recurse || !isDirectory) continue;
                String childPackageName = packageName + "." + childName;
                this.list(childPackageName, childStorage, kinds, fileList, recurse);
            }
        }
    }

    private boolean acceptFile(String childName, Set<JavaFileObject.Kind> kinds) {
        for (JavaFileObject.Kind kind : kinds) {
            if (kind == JavaFileObject.Kind.OTHER) {
                for (JavaFileObject.Kind otherKind : JavaFileObject.Kind.values()) {
                    if (otherKind == JavaFileObject.Kind.OTHER || !childName.endsWith(otherKind.extension)) continue;
                    return false;
                }
                return true;
            }
            if (!childName.endsWith(kind.extension)) continue;
            return true;
        }
        return false;
    }

    private Storage getPackageStorage(JavaFileManager.Location location, String packageName) {
        List<Storage> storages = this.getPackageStorages(this.getLocationStorages(location), packageName, true);
        return storages.size() > 0 ? storages.get(0) : null;
    }

    private List<Storage> getPackageStorages(Iterable<? extends Storage> storageLocationIter, String packageName, boolean stopAfterFirstOne) {
        ArrayList<Storage> storages = new ArrayList<Storage>();
        String[] packageNamePieces = (packageName = packageName.trim()).length() == 0 ? new String[]{} : packageName.split("\\.");
        Iterator<? extends Storage> iterator = storageLocationIter.iterator();
        block0: while (iterator.hasNext()) {
            Storage storageLocation;
            Storage packageStorage = storageLocation = iterator.next();
            Object enclosingJar = this.verbose || this.checkUnusedJars ? packageStorage.getProperty("javacompiler.enclosing.jar") : null;
            boolean appendSlash = packageStorage.getProperty(STORAGE_APPEND_SLASH) != null;
            for (String packageNamePiece : packageNamePieces) {
                if (appendSlash) {
                    packageNamePiece = packageNamePiece + "/";
                }
                if ((packageStorage = packageStorage.open(packageNamePiece)) == null || !packageStorage.isDirectory()) continue block0;
                if (!this.verbose && !this.checkUnusedJars) continue;
                packageStorage.setProperty("javacompiler.enclosing.jar", enclosingJar);
            }
            storages.add(packageStorage);
            if (!stopAfterFirstOne) continue;
            return storages;
        }
        return storages;
    }

    public void setClassPath(Storage[] storages) {
        if (storages != null && storages.length > 0) {
            String pathKind = "classpath";
            String msg = ResourceUtils.format("PARSING_PATH", "Parsing path: {0}", pathKind);
            msg = "--------------  " + msg + "  --------------";
            this.logMessage(msg);
            ArrayList<? extends Storage> storageList = new ArrayList<Storage>(storages.length);
            for (Storage storage : storages) {
                String name = storage.getClass().getName();
                if (name.endsWith(".JarStorage") && name.equals("oracle.jdeveloper.compiler.JarStorage")) {
                    storage.setProperty(STORAGE_APPEND_SLASH, (Object)Boolean.TRUE);
                }
                storageList.add((Storage)storage);
                this.logMessage("   " + storage.getPath());
            }
            this.classPath = storageList;
            msg = ResourceUtils.format("DONE_PARSING_PATH", "Done parsing path: {0}", pathKind);
            this.logMessage(msg);
        }
    }

    private void checkDirectory(Storage storage) throws IllegalArgumentException {
        if (storage.modDate() > 0L) {
            return;
        }
        File file = new File(storage.getPath());
        if (!file.exists() && !file.mkdirs()) {
            String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", storage.getPath());
            throw new IllegalArgumentException(msg);
        }
    }

    static List<? extends Storage> parsePath(String option, String pathString, boolean checkUnusedJars, boolean verbose, JavaCompilerLog log) throws IllegalArgumentException {
        try {
            JavaCompilerOptions options = new JavaCompilerOptions(checkUnusedJars, verbose, log);
            return options.makePath(pathString, option);
        }
        catch (IllegalArgumentException iae) {
            String msg = ResourceUtils.format("INCORRECT_PATH_FOR_OPTION", "Incorrect path for option {0}: {1}", option, iae.getMessage());
            throw new IllegalArgumentException(msg);
        }
    }

    private synchronized void reportFileOutput(String filePath) {
        if (this.verbose) {
            this.logMessage("Writing " + filePath);
        }
        for (FileListener listener : this.fileListeners) {
            listener.outputFile(filePath);
        }
    }

    private synchronized void reportFileInput(String filePath) {
        if (this.verbose) {
            String message = "Reading " + filePath;
            this.logMessage(message);
        }
        for (FileListener listener : this.fileListeners) {
            listener.inputFile(filePath);
        }
    }

    public synchronized void registerFileListener(FileListener listener) {
        this.fileListeners.add(listener);
    }

    public synchronized void unRegisterFileListener(FileListener listener) {
        this.fileListeners.remove(listener);
    }

    private static String getEncoding(String newEncoding) {
        if (newEncoding == null || newEncoding.equals("null")) {
            return null;
        }
        if (newEncoding.equalsIgnoreCase("default")) {
            String encoding = System.getProperty("file.encoding", "8859_1");
            if (encoding != null && encoding.equals("ISO8859_1")) {
                return null;
            }
            return encoding;
        }
        return newEncoding;
    }

    void checkUnusedJars(boolean checkUnusedJars) {
        this.checkUnusedJars = checkUnusedJars;
    }

    boolean getCheckUnusedJars() {
        return this.checkUnusedJars;
    }

    public void setLog(JavaCompilerLog<JavaFileObject> log) {
        this.log = log;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    boolean getVerbose() {
        return this.verbose;
    }

    void storageJavaFileObjectRead(StorageJavaFileObject object) {
        this.reportFileInput(object.getPath());
    }

    private void checkInterrupt() {
        this.interruptCounter = 0;
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
        }
    }

    private void logMessage(String message) {
        if (this.verbose) {
            if (this.log != null) {
                this.log.println(message);
            } else {
                System.out.println(message);
            }
        }
    }

    void setJavacClassLoader(ClassLoader javacClassLoader) {
        this.javacClassLoader = javacClassLoader;
    }

    ClassLoader getJavacClassLoader() {
        return this.javacClassLoader;
    }
}

