/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.inspector.ContextActionPanel;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.docking.controls.Handlebar;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.border.ShadowBorder;

public class ContextActionPanelHost
extends JDialog {
    private static final int BUTTON_POS_CLOSE = 0;
    private static final Color BORDER_COLOR = new Color(49, 106, 196);
    private static final String BORDER_PANEL_CARD = "titledPanel";
    private static final String CAPTURE_PANEL_CARD = "capturePanel";
    private SmallSquareButton closeButton;
    private Handlebar handlebar;
    private ContextActionPanel content;
    private JPanel border;
    private Window owner;
    private Dimension mySize;

    boolean isSameOwner(Window w) {
        return this.owner == w;
    }

    public ContextActionPanelHost(Window owner) {
        super(owner);
        this.owner = owner;
        this.setUndecorated(true);
        this.setResizable(true);
        this.getRootPane().putClientProperty("DONT_HIDE_COMPONENT_ON_FOCUS_CHANGE", Boolean.TRUE);
        this.setLayout(new BorderLayout());
        this.handlebar = new Handlebar();
        this.handlebar.setActive(true);
        this.handlebar.setTruncateTitle(true);
        this.addCloseButton();
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent evt) {
                ContextActionPanelHost.this.setVisible(false);
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 206) {
                    ContextActionPanelHost.this.setVisible(false);
                }
            }
        });
        this.border = new JPanel(new BorderLayout());
        this.border.setOpaque(false);
        Border line = BorderFactory.createLineBorder(BORDER_COLOR, 1);
        Border empty = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        ShadowBorder shadow = new ShadowBorder(10, 3, 3, 10, 0.5);
        CompoundBorder d = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(empty, (Border)shadow), line);
        this.border.setBorder(line);
        this.border.add((Component)this.handlebar, "North");
        this.add((Component)this.border, "Center");
        this.configureCloseOnEscape();
        new Mover(this);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (this.content != null && !this.content.isHelpAreaExpanded() && this.mySize != null) {
                Dimension c = this.getSize();
                this.setSize(this.mySize.width, c.height);
            }
            super.setVisible(b);
            return;
        }
        if (this.content != null && this.isShowing()) {
            if (!this.content.isHelpAreaExpanded()) {
                this.mySize = this.getSize();
            }
            this.content.storeHelpAreaSize();
            this.content.applyHelpAreaSize();
        }
        super.setVisible(b);
    }

    private void configureCloseOnEscape() {
        JRootPane rootPane = this.getRootPane();
        EscapeAction escape = new EscapeAction();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", escape);
    }

    private void addCloseButton() {
        String tooltip = IdeArb.getString((int)468);
        this.closeButton = new SmallSquareButton(OracleIcons.getIcon((String)"extras/small_close.gif"), tooltip);
        this.closeButton.setOpaque(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContextActionPanelHost.this.setVisible(false);
                ContextActionPanelHost.this.dispose();
            }
        });
        this.handlebar.addButton(this.closeButton, 0);
    }

    public void giveFocus() {
        if (this.content != null) {
            this.content.giveFocus();
        }
    }

    public void content(ContextActionPanel content) {
        if (this.content == content) {
            return;
        }
        if (this.content != null) {
            this.border.remove(this.content);
        }
        this.content = content;
        this.border.add((Component)content, "Center");
    }

    public void title(String title) {
        this.handlebar.setTitle(title);
    }

    @Override
    public Dimension getSize() {
        return this.mySize != null ? this.mySize : super.getSize();
    }

    private static class Mover
    extends ComponentAdapter
    implements MouseMotionListener {
        private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
        private final ContextActionPanelHost host;
        private Point anchorPoint;
        private Point hostLoc;

        public Mover(ContextActionPanelHost host) {
            this.host = host;
            this.hostLoc = host.getLocation();
            this.host.addComponentListener(this);
            this.host.handlebar.addMouseMotionListener((MouseMotionListener)this);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Rectangle moved = this.diff(this.anchorPoint, e.getPoint());
            this.hostLoc.translate(moved.width, moved.height);
            this.host.setLocation(this.hostLoc);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.anchorPoint = e.getPoint();
            this.host.handlebar.setCursor(HAND_CURSOR);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.hostLoc = e.getComponent().getLocation();
        }

        private Rectangle diff(Point p1, Point p2) {
            return new Rectangle(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y);
        }
    }

    private class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContextActionPanelHost.this.setVisible(false);
        }
    }
}

