/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.CustomComponentInfo;
import oracle.ide.inspector.layout.CustomGUIComponent;

final class CustomComponentHandler {
    private final Map<String, CustomComponentInfo> customComponentsByCategory = new HashMap<String, CustomComponentInfo>();
    private final List<CustomGUIComponent> customComponents = new ArrayList<CustomGUIComponent>();
    private String currentCategory;

    CustomComponentHandler() {
    }

    CustomComponentHandler(String currentCategory) {
        this.currentCategory(currentCategory);
    }

    boolean hasCustomComponents() {
        return !this.customComponentsByCategory.isEmpty();
    }

    void addCustomComponent(Container customComponentContainer, Component customComponent, Container labelContainer) {
        this.addCustomComponent(new CustomComponentInfo(customComponentContainer, customComponent, labelContainer));
    }

    void addCustomComponent(CustomComponentInfo customComponentInfo) {
        this.customComponentsByCategory.put(this.currentCategory, customComponentInfo);
    }

    void ensureCustomComponentIsShown() {
        if (!this.customComponentsByCategory.containsKey(this.currentCategory)) {
            return;
        }
        this.customComponentsByCategory.get(this.currentCategory).addCustomComponentToContainer();
    }

    void addCustomGuiComponent(CustomGUIComponent c) {
        if (c != null) {
            this.customComponents.add(c);
        }
    }

    void triggerUpdateOnCustomComponents(PropertyModel model) {
        for (CustomGUIComponent c : this.customComponents) {
            c.onUpdate(model);
        }
    }

    void clear() {
        this.customComponentsByCategory.clear();
        this.customComponents.clear();
    }

    void currentCategory(String newValue) {
        this.currentCategory = newValue;
    }
}

