/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.Context;
import oracle.ide.inspector.IdeMultiObjectModel;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectorContext;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.inspector.LayoutOnlyInspectable;
import oracle.ide.inspector.PropertyModelFactory;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;

public final class MultiInspectable {
    private static final PropertyModel EMPTY_MODEL = new IdeMultiObjectModel();
    private static InspectorFactory inspectorFactory = InspectorFactory.getInstance();
    private PropertyModel propertyModel;
    private final List<Inspectable> inspectables = new ArrayList<Inspectable>();
    private final List<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
    private boolean includePropertiesNotSpecifiedInLayout = true;

    public boolean includePropertiesNotSpecifiedInLayout() {
        return this.includePropertiesNotSpecifiedInLayout;
    }

    MultiInspectable(Context context, List<PropertyModelFactory> propertyModelFactories) {
        InspectableFinder finder = new InspectableFinder(context);
        this.inspectables.addAll(finder.inspectables);
        Object target = null;
        for (Inspectable inspectable : this.inspectables) {
            if (target == null) {
                target = inspectable.getTarget();
            }
            if (inspectable instanceof LayoutOnlyInspectable) {
                this.includePropertiesNotSpecifiedInLayout = this.includePropertiesNotSpecifiedInLayout && ((LayoutOnlyInspectable)((Object)inspectable)).includePropertiesNotSpecifiedInLayout();
            }
            this.addPropertyModel(inspectable.getPropertyModel());
        }
        CopyOnWriteArrayList<PropertyModel> l = new CopyOnWriteArrayList<PropertyModel>(this.propertyModels);
        this.propertyModel = this.newModel(propertyModelFactories, l, finder.offsets(), target, new Context(context));
    }

    private void addPropertyModel(PropertyModel model) {
        if (model != null) {
            this.propertyModels.add(model);
        }
    }

    private PropertyModel newModel(List<PropertyModelFactory> propertyModelFactories, List<PropertyModel> models, Integer[] offsets, Object target, Context context) {
        InspectorContext.setInspectableOffsets(context, offsets);
        try {
            for (PropertyModelFactory factory : propertyModelFactories) {
                PropertyModel newModel = factory.createPropertyModel(models, target, context);
                if (newModel == null) continue;
                return newModel;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            this.inspectables.clear();
        }
        return EMPTY_MODEL;
    }

    public PropertyModel getPropertyModel() {
        return this.propertyModel;
    }

    public int getSize() {
        return this.inspectables.size();
    }

    public Inspectable getInspectable(int index) {
        return this.inspectables.get(index);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiInspectable)) {
            return false;
        }
        MultiInspectable other = (MultiInspectable)object;
        if (!this.equalInspectables(new ArrayList<Inspectable>(other.inspectables))) {
            return false;
        }
        return this.equalPropertyModels(new ArrayList<PropertyModel>(other.propertyModels));
    }

    private boolean equalInspectables(List<Inspectable> other) {
        if (this.inspectables == other) {
            return true;
        }
        if (this.inspectables.size() != other.size()) {
            return false;
        }
        for (Inspectable i : this.inspectables) {
            if (other.remove(i)) continue;
            return false;
        }
        return other.isEmpty();
    }

    private boolean equalPropertyModels(List<PropertyModel> other) {
        if (this.propertyModels == other) {
            return true;
        }
        if (this.propertyModels.size() != other.size()) {
            return false;
        }
        for (PropertyModel m : this.propertyModels) {
            if (other.remove(m)) continue;
            return false;
        }
        return other.isEmpty();
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + ModelUtil.hashCodeFor((Object)this.propertyModel);
        result = 37 * result + ModelUtil.hashCodeFor(this.inspectables);
        return result;
    }

    private static class InspectableFinder {
        final List<Inspectable> inspectables = new ArrayList<Inspectable>();
        final List<Integer> offsets = new ArrayList<Integer>();

        InspectableFinder(Context context) {
            if (inspectorFactory == null) {
                return;
            }
            for (Inspectable inspectable : inspectorFactory.getInspectables(context)) {
                if (inspectable == null) continue;
                this.inspectables.add(inspectable);
            }
            if (!this.inspectables.isEmpty()) {
                return;
            }
            Element[] selection = context.getSelection();
            if (selection == null) {
                return;
            }
            for (int i = 0; i < selection.length; ++i) {
                Inspectable inspectable = inspectorFactory.getInspectable(context, selection[i]);
                if (inspectable != null) {
                    this.inspectables.add(inspectable);
                }
                this.offsets.add(i);
            }
        }

        Integer[] offsets() {
            return this.offsets.toArray(new Integer[this.offsets.size()]);
        }
    }
}

