/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.inspector.InspectableViewRegistry;

public class PISupportersHook
extends ExtensionHook {
    public static final ElementName SUPPORTER_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "supporter");
    public static final ElementName DETRACTOR_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "detractor");
    private static final String CLASS_ATTR = "class";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(SUPPORTER_ELEMENT, (ElementVisitor)new PISupportersVisitor());
        context.registerChildVisitor(DETRACTOR_ELEMENT, (ElementVisitor)new PIDetractorsVisitor());
    }

    private class PIDetractorsVisitor
    extends ElementVisitor {
        private PIDetractorsVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue(PISupportersHook.CLASS_ATTR);
            ClassLoader loader = ElementVisitor.getClassLoader((ElementContext)context);
            if (className != null && className.length() > 0 && loader != null) {
                InspectableViewRegistry.instance().registerDetractor(new MetaClass(loader, className));
            }
        }
    }

    private class PISupportersVisitor
    extends ElementVisitor {
        private PISupportersVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue(PISupportersHook.CLASS_ATTR);
            ClassLoader loader = ElementVisitor.getClassLoader((ElementContext)context);
            if (className != null && className.length() > 0 && loader != null) {
                InspectableViewRegistry.instance().registerSupporter(new MetaClass(loader, className));
            }
        }
    }
}

