/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectCSVExportDialog
extends CustomDialog {
    private JDialog dialog;
    private Design design;
    private JPanel generalPanel;
    private boolean cancelled = false;
    private List expObjects = new ArrayList();
    private JTable expTable;

    public SelectCSVExportDialog(ApplicationView appView) {
        super(appView);
        this.design = appView.getCurrentDesign();
        this.generalPanel = new JPanel(new BorderLayout());
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void init() {
        this.buildExpLists();
        this.expTable = new JTable(new ExportModel());
        this.expTable.setDefaultRenderer(Object.class, new ExportRenderer());
        TableColumn tc = this.expTable.getColumnModel().getColumn(0);
        tc.setPreferredWidth(50);
        tc.setMaxWidth(60);
        tc.setMinWidth(50);
        tc = this.expTable.getColumnModel().getColumn(1);
        tc.setPreferredWidth(90);
        tc.setMaxWidth(100);
        tc.setMinWidth(50);
        JScrollPane scrollpane = new JScrollPane(this.expTable);
        scrollpane.setPreferredSize(new Dimension(400, 210));
        this.generalPanel.add(scrollpane);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectCSVExportDialog.ExportDesignToCSV"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton(Messages.getString("SelectCSVExportDialog.OK"));
        ok.setMnemonic(79);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCSVExportDialog.this.cancelled = false;
                SelectCSVExportDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("SelectCSVExportDialog.Cancel"));
        cancel.setMnemonic(67);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCSVExportDialog.this.cancelled = true;
                SelectCSVExportDialog.this.close();
            }
        });
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    private void buildExpLists() {
        this.expObjects.clear();
        ExpObject eo = new ExpObject(this.design.getLogicalDesign());
        this.expObjects.add(eo);
        for (RelationalDesign pd : this.design.getRelationalDesigns()) {
            eo = new ExpObject(pd);
            this.expObjects.add(eo);
        }
    }

    public List getDesignPartObjects() {
        return this.expObjects;
    }

    public class ExportRenderer
    extends DefaultTableCellRenderer {
        Color color = new Color(204, 255, 255);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fc;
            Color bc;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 2) {
                bc = Color.LIGHT_GRAY;
                fc = Color.WHITE;
            } else {
                bc = Color.WHITE;
                fc = Color.BLACK;
            }
            comp.setBackground(bc);
            comp.setForeground(fc);
            return comp;
        }
    }

    public class ExpObject {
        private boolean selected = false;
        private ModelIDObject object;

        ExpObject(ModelIDObject object) {
            this.object = object;
        }

        String getDesignPartType(ModelIDObject obj) {
            if (obj instanceof LogicalDesign) {
                return Messages.getString("SelectCSVExportDialog.Logical");
            }
            if (obj instanceof RelationalDesign) {
                return Messages.getString("SelectCSVExportDialog.Relational");
            }
            if (obj instanceof DataTypesDesign) {
                return Messages.getString("SelectCSVExportDialog.DataTypes");
            }
            return " ";
        }

        String getType() {
            return this.getDesignPartType(this.object);
        }

        public String toString() {
            return this.object.getName();
        }

        public ModelIDObject getObject() {
            return this.object;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public void setObject(ModelIDObject object) {
            this.object = object;
        }
    }

    private class ExportModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SelectCSVExportDialog.Selected"), Messages.getString("SelectCSVExportDialog.ModelType"), Messages.getString("SelectCSVExportDialog.ModelName")};

        private ExportModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return SelectCSVExportDialog.this.expObjects.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex <= 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                ExpObject so = (ExpObject)SelectCSVExportDialog.this.expObjects.get(row);
                if (value instanceof Boolean) {
                    so.setSelected((Boolean)value);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            ExpObject so = (ExpObject)SelectCSVExportDialog.this.expObjects.get(row);
            if (col == 0) {
                return so.isSelected();
            }
            if (col == 1) {
                return so.getType();
            }
            if (col == 2) {
                return so.getObject().getName();
            }
            return new Integer(row * col);
        }
    }
}

