/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.ViewColumnDTParser;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SQLAnalyzer {
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_PACKAGE = "package";
    public static final String TYPE_COLUMN = "column";
    private static Logger logger = null;
    private static final String t_ref = "table_reference";
    private static final String u_funct = "user_defined_function";
    private static final String dml_table = "aliased_dml_table_expression_clause";
    private static final String function_call = "function_call";
    private static final String prm_spec_type = "prm_spec_unconstrained_type";
    private static final String prm_spec = "prm_spec";
    private static final String unconstrained_type = "unconstrained_type";
    private static final String func_return_prm_spec_unconstrained_type = "func_return_prm_spec_unconstrained_type";
    private static String column = "column";
    private static final String q_block = "query_block";
    private static final String select_list = "select_list";
    private static final String select_clause = "select_clause";
    private static final String aliased_expr = "\"aliased_expr\"";
    private static final String from_clause = "from_clause";
    private static final String column_def = "column_definition";
    private static final String out_of_line_constraint = "out_of_line_constraint";
    private static final String out_of_line_ref_constraint = "out_of_line_ref_constraint";
    private static final String inline_constraint = "inline_constraint";
    private static final String subquery_factoring = "with_clause";

    private static boolean hasString(String[] split, String str) {
        for (int i = 1; i < split.length; ++i) {
            if (!str.equals(split[i].trim())) continue;
            return true;
        }
        return false;
    }

    private static String getContent(ParseNode pn, List<LexerToken> src) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                sb.append(src.get((int)i).content);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static String getSource(ParseNode pn, List<LexerToken> src, String statement) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int end = 1;
        start = src.get((int)pn.from).begin;
        end = src.get((int)(pn.to - 1)).end;
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                sb.append(src.get((int)i).content);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
        return statement.substring(start, end);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseContentForTable(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            int i = pn.from;
            while (i < pn.to) {
                LexerToken t = src.get(i);
                String temp = t.content;
                if (p == 0) {
                    if (temp.startsWith("(")) {
                        return;
                    }
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.valid = true;
                    pd.nameStart = t.begin;
                    pd.nameEnd = t.end;
                } else if (p == 1) {
                    if (!".".equals(temp)) {
                        pd.alias = temp;
                        return;
                    }
                    pd.schema = pd.name;
                    pd.name = null;
                    pd.schemaStart = pd.nameStart;
                    pd.schemaEnd = pd.nameEnd;
                } else if (p == 2) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.nameStart = t.begin;
                    pd.nameEnd = t.end;
                } else if (p == 3) {
                    pd.alias = temp;
                    return;
                }
                ++p;
                ++i;
            }
            return;
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForColumn(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (p == 0) {
                    if (temp.startsWith("(")) break;
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.valid = true;
                } else if (p == 1) {
                    if (!".".equals(temp)) break;
                    pd.schema = pd.name;
                    pd.name = null;
                } else if (p == 2) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForColumnAndAlias(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                LexerToken t = src.get(i);
                String temp = t.content;
                if (p == 0) {
                    if (!temp.startsWith("(")) {
                        pd.name = Token.getValBetweenDoubleQuotes(temp);
                        pd.valid = true;
                        pd.nameStart = t.begin;
                        pd.nameEnd = t.end;
                        ++p;
                        continue;
                    }
                    break;
                }
                if (p == 1) {
                    if (".".equals(temp)) {
                        pd.table = pd.name;
                        pd.name = null;
                        pd.tableStart = pd.nameStart;
                        pd.tableEnd = pd.nameEnd;
                        continue;
                    }
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.nameStart = t.begin;
                    pd.nameEnd = t.end;
                    ++p;
                    continue;
                }
                if (p == 2) {
                    if (".".equals(temp)) {
                        pd.schema = pd.table;
                        pd.table = pd.name;
                        pd.name = null;
                        pd.schemaStart = pd.tableStart;
                        pd.schemaEnd = pd.tableEnd;
                        pd.tableStart = pd.nameStart;
                        pd.tableEnd = pd.nameEnd;
                        continue;
                    }
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.nameStart = t.begin;
                    pd.nameEnd = t.end;
                    ++p;
                    continue;
                }
                if (p != 3 || "AS".equalsIgnoreCase(temp) && i < pn.to - 1) continue;
                pd.alias = Token.getValBetweenDoubleQuotes(temp);
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    static boolean setContains(Set<ParseNode> set, String id) {
        if (set != null) {
            for (ParseNode n : set) {
                if (!n.contains(id)) continue;
                return true;
            }
        }
        return false;
    }

    private static void parseContentForParameterSpec(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            boolean percentFound = false;
            String colName = null;
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (percentFound) {
                    if (temp.equalsIgnoreCase("TYPE")) {
                        if (pd.name != null) {
                            pd.valid = true;
                        }
                    } else if (temp.equalsIgnoreCase("ROWTYPE")) {
                        pd.schema = pd.name;
                        pd.name = colName;
                        pd.valid = true;
                    }
                    break;
                }
                if (p == 0) {
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if (p == 2) {
                    pd.name = colName;
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if (p == 4) {
                    pd.schema = pd.name;
                    pd.name = colName;
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if ("%".equals(temp)) {
                    percentFound = true;
                } else if (!".".equals(temp)) break;
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForFunction(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        int p = 0;
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (temp.startsWith("(")) {
                    pd.valid = p > 0;
                    return;
                }
                if (p == 0) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                } else if (".".equals(temp)) {
                    if (p == 1) {
                        pd.schema = pd.name;
                        pd.name = null;
                    } else if (p == 3) {
                        pd.pack = pd.name;
                        pd.name = null;
                    }
                } else if (p == 2 || p == 4) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    if (p == 4) break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    public static List<PDescriptor> getTablesAndFunctions(String sql) {
        HashMap<String, PDescriptor> tmap = null;
        HashMap<String, PDescriptor> fmap = null;
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        int table_ref = earley.getSymbol(t_ref);
        int dml_tab = earley.getSymbol(dml_table);
        int udf = earley.getSymbol(u_funct);
        int f_cal = earley.getSymbol(function_call);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        int func_return_prm_spec_unconstr_type = earley.getSymbol(func_return_prm_spec_unconstrained_type);
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap<String, PDescriptor>();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (n.contains(udf) || n.contains(f_cal)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_FUNCTION;
                        SQLAnalyzer.parseContentForFunction(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (fmap == null) {
                            fmap = new HashMap<String, PDescriptor>();
                        }
                        if (fmap.get(name) != null) continue;
                        list.add(pd);
                        fmap.put(name, pd);
                        continue;
                    }
                    if (parent != null && parent.contains(param_spec) && n.contains(unconstr_type)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (parent != null && n.contains(func_return_prm_spec_unconstrained_type)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (!n.contains(unconstr_type) && !n.contains("constrained_type") || !SQLAnalyzer.setContains(n.children(), "attribute_designator")) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        return list;
    }

    public static List<PDescriptor> getTables(String sql) {
        HashMap<String, PDescriptor> tmap = null;
        Object fmap = null;
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        int table_ref = earley.getSymbol(t_ref);
        int dml_tab = earley.getSymbol(dml_table);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap<String, PDescriptor>();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        return list;
    }

    private static Map<String, List<ContainedObject>> getColumnsForAsterisk(List<PDescriptor> tables, List<PDescriptor> columns, FKContainer container) {
        PDescriptor p;
        HashMap<String, List<ContainedObject>> map = new HashMap<String, List<ContainedObject>>();
        HashMap<String, PDescriptor> mapd = new HashMap<String, PDescriptor>();
        HashMap mapLongName = new HashMap();
        for (PDescriptor pDescriptor : columns) {
            String string;
            if (!"*".equals(pDescriptor.name)) continue;
            if (container instanceof TableView) {
                ((TableView)container).setGenerateHeaderInDDL(false);
            }
            if (((string = pDescriptor.getColumnPrefix()) == null || string.isEmpty()) && columns.size() == 1) {
                for (PDescriptor p2 : tables) {
                    map.put(p2.getTableIdentifier(), new ArrayList());
                    mapd.put(p2.getTableIdentifier(), p2);
                }
                break;
            }
            p = SQLAnalyzer.getTableForPrefix(tables, string);
            if (p == null || map.containsKey(p.getTableIdentifier())) continue;
            map.put(p.getTableIdentifier(), new ArrayList());
            mapd.put(p.getTableIdentifier(), p);
        }
        if (mapd.size() > 0) {
            RelationalDesign rd = container.getRelationalModel();
            try {
                for (Map.Entry entry : mapd.entrySet()) {
                    p = (PDescriptor)entry.getValue();
                    String lname = p.getTableLongName();
                    List l = (List)mapLongName.get(lname);
                    if (l != null && l.size() > 0) {
                        ArrayList cols = new ArrayList(l);
                        map.put(p.getTableIdentifier(), cols);
                        continue;
                    }
                    String owner = container.getSchema();
                    if (p.schema != null) {
                        owner = p.schema.toUpperCase();
                    }
                    String name = p.name.toUpperCase();
                    ContainerObject cont = null;
                    if (owner != null && !owner.isEmpty()) {
                        cont = rd.getTableSet().getBySchemaAndName(owner, name);
                        if (cont == null) {
                            cont = (ContainerObject)rd.getTableViewSet().getBySchemaAndName(owner, name);
                        }
                    } else {
                        cont = (ContainerObject)rd.getTableSet().getByName(name);
                        if (cont == null) {
                            cont = (ContainerObject)rd.getTableViewSet().getByName(name);
                        }
                    }
                    if (cont == null) continue;
                    ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
                    for (ContainedObject co : cont.getElementsCollection()) {
                        list.add(co);
                    }
                    map.put(p.getTableIdentifier(), list);
                    mapLongName.put(lname, list);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return map;
    }

    private static List<PDescriptor> getColumns(List<PDescriptor> list) {
        ArrayList<PDescriptor> columns = new ArrayList<PDescriptor>();
        for (PDescriptor pd : list) {
            if (!TYPE_COLUMN.equals(pd.type)) continue;
            columns.add(pd);
        }
        return columns;
    }

    private static List<PDescriptor> getTables(List<PDescriptor> list) {
        ArrayList<PDescriptor> tables = new ArrayList<PDescriptor>();
        for (PDescriptor pd : list) {
            if (!TYPE_TABLE.equals(pd.type)) continue;
            tables.add(pd);
        }
        return tables;
    }

    private static PDescriptor getTableForPrefix(List<PDescriptor> tables, String prefix) {
        if (prefix != null) {
            for (PDescriptor pd : tables) {
                if (!TYPE_TABLE.equals(pd.type) || !prefix.equalsIgnoreCase(pd.getTableIdentifier())) continue;
                return pd;
            }
        }
        return null;
    }

    private static String getValidName(Map<String, String> usedNames, String name) {
        if (!usedNames.containsKey(name)) {
            usedNames.put(name, name);
            return name;
        }
        Object temp = name;
        for (int i = 1; i < 1000; ++i) {
            temp = name + "_" + i;
            if (usedNames.containsKey(temp)) continue;
            usedNames.put((String)temp, (String)temp);
            return temp;
        }
        return name;
    }

    private static PDescriptor createDescriptor(ContainedObject co) {
        PDescriptor pd = new PDescriptor();
        pd.name = co.getName();
        pd.table = co.getContainer().getName();
        pd.refColumn = co;
        pd.container = (FKContainer)co.getContainer();
        return pd;
    }

    private static void getColumnNames(Map<String, List<ContainedObject>> map, String prefix, PDescriptor table, Map<String, String> usedNames, List<PDescriptor> headerColumns) {
        List<ContainedObject> list = map.get(table.getTableIdentifier());
        for (ContainedObject co : list) {
            String name = SQLAnalyzer.getValidName(usedNames, co.getName());
            PDescriptor pd = SQLAnalyzer.createDescriptor(co);
            pd.headerName = name;
            headerColumns.add(pd);
        }
    }

    private static void getColumnNames(Map<String, List<ContainedObject>> map, String prefix, List<PDescriptor> tables, Map<String, String> usedNames, List<PDescriptor> headerColumns) {
        for (PDescriptor t : tables) {
            SQLAnalyzer.getColumnNames(map, prefix, t, usedNames, headerColumns);
        }
    }

    public static void validateSQL(String sql, FKContainer container) {
        SQLAnalyzer.validateSQL(sql, container, null);
    }

    public static void validateSQL(String sql, FKContainer container, Map<String, ContainerObject> containers) {
        HashMap<String, SQLNameHelper> sqlNamesIDMap = new HashMap<String, SQLNameHelper>();
        HashMap<String, SQLNameHelper> namesMap = new HashMap<String, SQLNameHelper>();
        ArrayList<PDescriptor> allColumnsAndTables = new ArrayList<PDescriptor>();
        StorageDesign sd = ((RelationalDesign)container.getDesignPart()).getStorageDesign();
        if (!(sd instanceof StorageDesignOracle)) {
            sd = ((RelationalDesign)container.getDesignPart()).getStorageDesign(StorageDesignOraclev12c.RDBMS_SITE);
        }
        if (containers == null || containers.isEmpty()) {
            containers = container.getRelationalModel().getContainersMap();
        }
        for (SQLNameHelper helper : container.getSQLNames()) {
            if (sqlNamesIDMap.get(helper.getID()) == null) {
                sqlNamesIDMap.put(helper.getID(), helper);
            }
            if (helper.desObj == null) {
                helper.desObj = container.getDesign().getDesignObject(helper.getID());
            }
            if (!helper.isContainer() || helper.desObj == null) continue;
            namesMap.put(helper.getLongName().toUpperCase(), helper);
        }
        for (SQLNameHelper helper : container.getSQLNames()) {
            SQLNameHelper h;
            if (helper.isContainer() || helper.desObj == null || (h = (SQLNameHelper)namesMap.get(helper.getContainerLongName().toUpperCase())) == null) continue;
            h.addColumnHelper(helper);
        }
        SQLAnalyzer.parseAndResolveColumns(sql, allColumnsAndTables, container, containers, namesMap);
        allColumnsAndTables.sort(Comparator.comparing(PDescriptor::getStartPosition, (pos1, pos2) -> {
            if (pos1 < pos2) {
                return -1;
            }
            if (pos1 > pos2) {
                return 1;
            }
            return 0;
        }).reversed());
        String temp = sql;
        for (PDescriptor pd : allColumnsAndTables) {
            SQLNameHelper nh = (SQLNameHelper)sqlNamesIDMap.get(pd.getID());
            temp = SQLAnalyzer.replaceNames(pd, nh, temp, sd);
        }
        container.setValidSQL(true);
        container.setUserDefinedSQL(temp);
        for (SQLNameHelper nh : sqlNamesIDMap.values()) {
            nh.applyChanges();
        }
    }

    public static String replaceNames(PDescriptor pd, SQLNameHelper nh, String sql, StorageDesign sd) {
        Object res = sql;
        if (nh != null && nh.isNameChanged()) {
            if (TYPE_COLUMN.equalsIgnoreCase(pd.type)) {
                ContainedObject co = pd.refColumn;
                if (co == null) {
                    co = (ContainedObject)nh.desObj;
                }
                if (co != null) {
                    String t1;
                    String name;
                    if (!co.getName().equalsIgnoreCase(nh.getColumnName())) {
                        name = co.getName();
                        t1 = ((String)res).substring(0, pd.nameStart) + sd.getFormatedName(co) + ((String)res).substring(pd.nameEnd);
                        res = t1;
                        nh.newColumn = name;
                    }
                    if (nh.isObjectContainerChanged() && pd.tableStart > -1 && pd.table != null && !pd.table.isEmpty() && (pd.realTable == null || pd.table.equalsIgnoreCase(pd.realTable))) {
                        name = co.getContainer().getName();
                        t1 = ((String)res).substring(0, pd.tableStart) + sd.getFormatedName(co.getContainer()) + ((String)res).substring(pd.tableEnd);
                        res = t1;
                        nh.newTable = name;
                    }
                    if (nh.isObjectSchemaChanged() && pd.schemaStart > -1 && pd.schema != null && !pd.schema.isEmpty()) {
                        int start = pd.schemaStart;
                        int end = pd.schemaEnd;
                        String schema = co.getContainer().getSchema();
                        SchemaObject so = co.getContainer().getSchemaObject();
                        String formatted = schema;
                        if (co != null) {
                            formatted = sd.getFormatedName(so);
                        }
                        if (schema.isEmpty()) {
                            ++end;
                        }
                        String t12 = ((String)res).substring(0, start) + formatted + ((String)res).substring(end);
                        res = t12;
                        nh.newSchema = schema;
                    }
                }
            } else {
                ContainerObject co = pd.container;
                if (co == null) {
                    co = (ContainerObject)nh.desObj;
                }
                if (co != null && !co.getName().equalsIgnoreCase(nh.getTableName())) {
                    String name = co.getName();
                    String fname = sd.getFormatedName(co);
                    String t1 = ((String)res).substring(0, pd.nameStart) + fname + ((String)res).substring(pd.nameEnd);
                    res = t1;
                    nh.newTable = name;
                    pd.nameEnd = pd.nameStart + fname.length();
                }
                if (nh.isObjectSchemaChanged()) {
                    if (pd.schemaStart > -1 && pd.schema != null && !pd.schema.isEmpty()) {
                        int start = pd.schemaStart;
                        int end = pd.schemaEnd;
                        String schema = co.getSchema();
                        SchemaObject so = co.getSchemaObject();
                        String formatted = schema;
                        if (co != null && so != null) {
                            formatted = sd.getFormatedName(so);
                        }
                        if (schema.isEmpty()) {
                            ++end;
                        }
                        String t1 = ((String)res).substring(0, start) + formatted + ((String)res).substring(end);
                        res = t1;
                        nh.newSchema = schema;
                    } else if (pd.schemaStart == -1 && (pd.schema == null || pd.schema.isEmpty())) {
                        String fname = sd.getFormatedLongNameDDL(co);
                        String t1 = ((String)res).substring(0, pd.nameStart) + fname + ((String)res).substring(pd.nameEnd);
                        res = t1;
                        nh.newSchema = co.getSchema();
                    }
                }
            }
        }
        return res;
    }

    public static void parseAndResolveColumns(String sql, List<PDescriptor> usedColumnsAndTables, FKContainer container, Map<String, ContainerObject> containers, Map<String, SQLNameHelper> namesMap) {
        try {
            List<PDescriptor> list = null;
            boolean parseError = false;
            String schema = container.getSchema();
            if (schema != null && schema.isEmpty()) {
                schema = null;
            }
            if (containers == null || containers.isEmpty()) {
                containers = container.getRelationalModel().getContainersMap();
            }
            try {
                list = SQLAnalyzer.getTablesAndColumns(sql, container, containers);
            }
            catch (Exception e) {
                list = new ArrayList<PDescriptor>();
                parseError = true;
            }
            List<PDescriptor> tables = SQLAnalyzer.getTables(list);
            List<PDescriptor> columns = SQLAnalyzer.getColumns(list);
            for (PDescriptor td : tables) {
                SQLNameHelper nh;
                ContainerObject co;
                Object name = td.name;
                if ("DUAL".equalsIgnoreCase((String)name)) continue;
                boolean hasSchema = false;
                if (td.schema != null && !td.schema.isEmpty()) {
                    name = td.schema + "." + (String)name;
                    hasSchema = true;
                }
                if ((co = containers.get(name = ((String)name).toUpperCase())) == null && (nh = namesMap.get(name)) != null) {
                    co = (ContainerObject)nh.desObj;
                }
                if (co == null && !hasSchema && schema != null && !schema.isEmpty()) {
                    name = schema + "." + (String)name;
                    co = containers.get(name = ((String)name).toUpperCase());
                    if (co == null && (nh = namesMap.get(name)) != null) {
                        co = (ContainerObject)nh.desObj;
                    }
                }
                if (co != null) {
                    td.container = (FKContainer)co;
                } else {
                    nh = namesMap.get(name);
                    if (nh != null) {
                        td.container = (FKContainer)nh.desObj;
                    }
                }
                if (td.container == null) continue;
                usedColumnsAndTables.add(td);
            }
            for (PDescriptor pd : columns) {
                if (pd.refColumn == null) {
                    SQLAnalyzer.resolveColumn(pd, schema, tables, namesMap);
                }
                if (pd.refColumn == null) continue;
                usedColumnsAndTables.add(pd);
            }
        }
        catch (Exception e) {
            SQLAnalyzer.getLogger().error(" parseColumns() - parsing of query", e);
        }
    }

    public static void addToSQLNames(FKContainer container, List<PDescriptor> objects) {
    }

    public static void parseColumns(String sql, List<PDescriptor> headerColumns, List<PDescriptor> usedColumnsAndTables, FKContainer container) {
        SQLAnalyzer.parseColumns(sql, headerColumns, usedColumnsAndTables, container, null);
    }

    public static void parseColumns(String sql, List<PDescriptor> headerColumns, List<PDescriptor> usedColumnsAndTables, FKContainer container, Map<String, ContainerObject> containers) {
        try {
            ContainedObject co;
            ContainerObject co2;
            Object name;
            HashMap<String, DesignObject> sqlNames = new HashMap<String, DesignObject>();
            HashMap<String, String> usedNames = new HashMap<String, String>();
            List<PDescriptor> list = null;
            boolean parseError = false;
            try {
                list = SQLAnalyzer.getFirstColumnNamesAndTables(sql);
            }
            catch (Exception e) {
                list = new ArrayList<PDescriptor>();
                parseError = true;
            }
            List<PDescriptor> tables = SQLAnalyzer.getTables(list);
            List<PDescriptor> columns = SQLAnalyzer.getColumns(list);
            Map<String, List<ContainedObject>> map = SQLAnalyzer.getColumnsForAsterisk(tables, columns, container);
            String schema = container.getSchema();
            if (schema != null && schema.isEmpty()) {
                schema = null;
            }
            String parsedSchema = container.getParsedSchema();
            container.getSQLNames().clear();
            if (containers == null || containers.isEmpty()) {
                containers = container.getRelationalModel().getContainersMap();
            }
            for (PDescriptor td : tables) {
                name = td.name;
                boolean hasSchema = false;
                if (td.schema != null && !td.schema.isEmpty()) {
                    name = td.schema + "." + td.name;
                    hasSchema = true;
                }
                if ((co2 = containers.get(((String)name).toUpperCase())) == null && !hasSchema && schema != null && !schema.isEmpty() && (co2 = containers.get(((String)(name = schema + "." + td.name)).toUpperCase())) != null) {
                    container.setParsedSchema(schema);
                }
                if (co2 == null && parsedSchema != null && !parsedSchema.isEmpty() && (co2 = containers.get(((String)(name = parsedSchema + "." + td.name)).toUpperCase())) != null) {
                    container.setParsedSchema(parsedSchema);
                }
                if (co2 == null) continue;
                td.container = (FKContainer)co2;
                if (sqlNames.get(co2.getObjectID()) != null) continue;
                container.AddToSQLNames(co2);
                sqlNames.put(co2.getObjectID(), co2);
            }
            for (PDescriptor pd : columns) {
                if (!TYPE_COLUMN.equals(pd.type)) continue;
                if ("*".equals(pd.name)) {
                    String pref = pd.getColumnPrefix();
                    if (pref != null && !pref.isEmpty()) {
                        PDescriptor pt = SQLAnalyzer.getTableForPrefix(tables, pref);
                        if (pt == null) continue;
                        SQLAnalyzer.getColumnNames(map, pref, pt, usedNames, headerColumns);
                        continue;
                    }
                    SQLAnalyzer.getColumnNames(map, pref, tables, usedNames, headerColumns);
                    continue;
                }
                name = pd.alias;
                if (name == null) {
                    name = pd.name;
                }
                pd.headerName = name = SQLAnalyzer.getValidName(usedNames, (String)name);
                SQLAnalyzer.resolveContainer(pd, schema, tables, containers);
                headerColumns.add(pd);
            }
            for (PDescriptor pd : headerColumns) {
                co = pd.refColumn;
                if (co == null || sqlNames.get(co.getObjectID()) != null) continue;
                container.AddToSQLNames(co);
                sqlNames.put(co.getObjectID(), co);
            }
            try {
                list = SQLAnalyzer.getTablesAndColumns(sql, container, containers);
            }
            catch (Exception e) {
                list = new ArrayList<PDescriptor>();
                parseError = true;
            }
            tables = SQLAnalyzer.getTables(list);
            columns = SQLAnalyzer.getColumns(list);
            for (PDescriptor td : tables) {
                name = td.name;
                boolean hasSchema = false;
                if (td.schema != null && !td.schema.isEmpty()) {
                    name = td.schema + "." + (String)name;
                    hasSchema = true;
                }
                if ((co2 = containers.get(((String)name).toUpperCase())) == null && !hasSchema && schema != null && !schema.isEmpty()) {
                    name = schema + "." + (String)name;
                    co2 = containers.get(((String)name).toUpperCase());
                }
                if (co2 == null) continue;
                td.container = (FKContainer)co2;
                if (sqlNames.get(co2.getObjectID()) != null) continue;
                container.AddToSQLNames(co2);
                sqlNames.put(co2.getObjectID(), co2);
            }
            for (PDescriptor pd : columns) {
                co = pd.refColumn;
                if (co == null || sqlNames.get(co.getObjectID()) != null) continue;
                container.AddToSQLNames(co);
                sqlNames.put(co.getObjectID(), co);
            }
            container.setParsed(!parseError);
            container.setIncorrectSQL(parseError);
            container.setValidSQL(!parseError);
        }
        catch (Exception e) {
            SQLAnalyzer.getLogger().error(" parseColumns() - parsing of query", e);
        }
    }

    public static List<PDescriptor> getFirstColumnNamesAndTables(String sql) {
        HashMap<String, PDescriptor> tmap = new HashMap<String, PDescriptor>();
        Object fmap = null;
        HashMap<CallSite, PDescriptor> cmap = new HashMap<CallSite, PDescriptor>();
        HashMap c2map = new HashMap();
        HashMap<Object, Object> amap = new HashMap<Object, Object>();
        ArrayList cols = new ArrayList();
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        int table_ref = earley.getSymbol(t_ref);
        int column_ = earley.getSymbol(column);
        int dml_tab = earley.getSymbol(dml_table);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        int query_block = earley.getSymbol(q_block);
        int sel_list = earley.getSymbol(select_list);
        int sel_clause = earley.getSymbol(select_clause);
        int al_expr = earley.getSymbol(aliased_expr);
        int frm_clause = earley.getSymbol(from_clause);
        int subquery_fact_clause = earley.getSymbol(subquery_factoring);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            int count = 10;
            Integer qb = 10;
            int qb_end = root.to;
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(qb);
            stack.push(qb_end);
            int subq_fact_end = -1;
            int nextColumn = -1;
            Object last_col = null;
            boolean skipColumns = false;
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    if (n.from < subq_fact_end || n.from < nextColumn) continue;
                    if (n.contains(subquery_fact_clause)) {
                        subq_fact_end = n.to;
                        qb_end = n.to;
                        continue;
                    }
                    if (n.contains(query_block)) {
                        stack.push(qb);
                        stack.push(qb_end);
                        qb = ++count;
                        qb_end = n.to;
                    }
                    if (n.from == qb_end && (subq_fact_end == -1 || subq_fact_end != qb_end)) {
                        qb_end = (Integer)stack.pop();
                        qb = (Integer)stack.pop();
                    }
                    String qb_id = String.valueOf(qb);
                    if (n.contains(frm_clause) && "11".equals(qb_id)) {
                        skipColumns = true;
                    }
                    String cont = SQLAnalyzer.getContent(n, src);
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        String alias;
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) == null) {
                            list.add(pd);
                            tmap.put(name, pd);
                        }
                        if ((alias = pd.alias) == null || alias.isEmpty()) {
                            alias = pd.name;
                        }
                        amap.put(qb_id + alias, pd);
                        HashMap<String, PDescriptor> tables = (HashMap<String, PDescriptor>)amap.get(qb_id);
                        if (tables == null) {
                            tables = new HashMap<String, PDescriptor>();
                            amap.put(qb_id, tables);
                        }
                        tables.put(name, pd);
                        continue;
                    }
                    if (!skipColumns && n.contains(column_)) {
                        String all_expr;
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                        if (pd.valid) {
                            name = pd.toString();
                            cmap.put((CallSite)((Object)(qb_id + name)), pd);
                        }
                        pd.condition = n.parent().contains("condition");
                        if (n.parent().contains(al_expr) && (all_expr = SQLAnalyzer.getContent(n.parent(), src)).length() > cont.length()) {
                            pd.alias = all_expr.substring(cont.length());
                            if (pd.alias.toUpperCase().startsWith("AS")) {
                                pd.alias = pd.alias.substring(2);
                            }
                        }
                        list.add(pd);
                        continue;
                    }
                    if (n.contains(al_expr)) {
                        ParseNode pn;
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        String temp = ((LexerToken)src.get((int)(n.to - 1))).content;
                        nextColumn = n.to;
                        pd.valid = true;
                        pd.alias = temp;
                        int k = n.to - 1;
                        String as = ((LexerToken)src.get((int)(n.to - 2))).content;
                        if ("AS".equalsIgnoreCase(as)) {
                            --k;
                        }
                        if ((pn = n.childAt(n.from, k)) != null && pn.contains(column_)) {
                            SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                            pd.expression = null;
                        } else if (pn != null) {
                            pd.expression = SQLAnalyzer.getContent(pn, src);
                            pd.queryExpression = pn.contains("scalar_subquery_expression");
                        }
                        if (pd.valid) {
                            String name2 = pd.toString();
                            cmap.put((CallSite)((Object)(qb_id + name2)), pd);
                        }
                        list.add(pd);
                        continue;
                    }
                    if (!skipColumns && n.contains("select_term")) {
                        if (cont.indexOf(".*") <= -1) continue;
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                        if (!"*".equals(pd.name)) continue;
                        list.add(pd);
                        continue;
                    }
                    if (!skipColumns && n.contains(sel_list) && "*".equals(cont)) {
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                        if (!"*".equals(pd.name)) continue;
                        list.add(pd);
                        continue;
                    }
                    if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    pd.start = n.from;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        ArrayList<PDescriptor> tlist = new ArrayList<PDescriptor>();
        for (PDescriptor pd : list) {
            if (!"11".equals(pd.query_block_id) || pd.condition) continue;
            tlist.add(pd);
        }
        return tlist;
    }

    public static List<PDescriptor> getTablesAndColumns(String sql, FKContainer container, Map containers) {
        ArrayList<PDescriptor> list;
        block29: {
            String schema = null;
            if (container != null) {
                schema = container.getSchema();
            }
            if (schema != null && schema.isEmpty()) {
                schema = null;
            }
            HashMap<String, PDescriptor> tmap = new HashMap<String, PDescriptor>();
            Object fmap = null;
            HashMap<CallSite, PDescriptor> cmap = new HashMap<CallSite, PDescriptor>();
            HashMap c2map = new HashMap();
            HashMap<Object, Object> amap = new HashMap<Object, Object>();
            ArrayList cols = new ArrayList();
            list = new ArrayList<PDescriptor>();
            SqlEarley earley = SqlEarley.getInstance();
            List src = LexerToken.parse((String)sql);
            Matrix matrix = new Matrix((Parser)earley);
            int table_ref = earley.getSymbol(t_ref);
            int column_ = earley.getSymbol(column);
            int dml_tab = earley.getSymbol(dml_table);
            int param_spec = earley.getSymbol(prm_spec);
            int unconstr_type = earley.getSymbol(unconstrained_type);
            int al_expr = earley.getSymbol(aliased_expr);
            int query_block = earley.getSymbol(q_block);
            try {
                earley.parse(src, (Matriceable)matrix);
                ParseNode root = earley.forest(src, matrix);
                int count = 10;
                Integer qb = 10;
                int qb_end = root.to;
                Stack<Integer> stack = new Stack<Integer>();
                stack.push(qb);
                stack.push(qb_end);
                if (root == null) break block29;
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    if (n.contains(query_block)) {
                        stack.push(qb);
                        stack.push(qb_end);
                        qb = ++count;
                        qb_end = n.to;
                    }
                    if (n.from == qb_end) {
                        qb_end = (Integer)stack.pop();
                        qb = (Integer)stack.pop();
                    }
                    String qb_id = String.valueOf(qb);
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) == null) {
                            list.add(pd);
                            tmap.put(name, pd);
                        }
                        String alias = pd.getTableIdentifier();
                        amap.put(qb_id + alias, pd);
                        HashMap<String, PDescriptor> tables = (HashMap<String, PDescriptor>)amap.get(qb_id);
                        if (tables == null) {
                            tables = new HashMap<String, PDescriptor>();
                            amap.put(qb_id, tables);
                        }
                        tables.put(name, pd);
                        continue;
                    }
                    if (n.contains(column_)) {
                        String all_expr;
                        String cont = SQLAnalyzer.getContent(n, src);
                        PDescriptor pd2 = new PDescriptor();
                        pd2.element = cont;
                        pd2.type = TYPE_COLUMN;
                        pd2.query_block_id = qb_id;
                        pd2.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd2);
                        if (n.parent().contains(al_expr) && (all_expr = SQLAnalyzer.getContent(n.parent(), src)).length() > cont.length()) {
                            pd2.alias = all_expr.substring(cont.length());
                            if (pd2.alias.toUpperCase().startsWith("AS")) {
                                pd2.alias = pd2.alias.substring(2);
                            }
                        }
                        if (!pd2.valid) continue;
                        String name2 = pd2.toString();
                        cmap.put((CallSite)((Object)(qb_id + name2)), pd2);
                        continue;
                    }
                    if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    pd.start = n.from;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
                for (Map.Entry ent : cmap.entrySet()) {
                    PDescriptor pd = (PDescriptor)ent.getValue();
                    if (pd.schema != null && !pd.schema.isEmpty() && pd.table != null && !pd.table.isEmpty()) {
                        if (containers != null) {
                            SQLAnalyzer.resolveContainer(pd, pd.schema, pd.table, pd.name, containers);
                        }
                        list.add(pd);
                        continue;
                    }
                    if (pd.table != null && !pd.table.isEmpty()) {
                        PDescriptor td = (PDescriptor)amap.get(pd.query_block_id + pd.table);
                        if (td == null) {
                            int qid = 0;
                            try {
                                qid = Integer.valueOf(pd.query_block_id);
                            }
                            catch (NumberFormatException name) {
                                // empty catch block
                            }
                            while (qid > 10 && td == null) {
                                td = (PDescriptor)amap.get(String.valueOf(--qid) + pd.table);
                            }
                        }
                        if (td != null) {
                            if (containers != null) {
                                SQLAnalyzer.resolveContainer(pd, td.schema, td.name, pd.name, containers);
                                if (pd.container == null) {
                                    SQLAnalyzer.resolveContainer(pd, schema, td.name, pd.name, containers);
                                }
                                if (pd.container == null) {
                                    SQLAnalyzer.resolveContainer(pd, null, td.name, pd.name, containers);
                                }
                            }
                            list.add(pd);
                            continue;
                        }
                        if (containers == null) continue;
                        ArrayList<PDescriptor> tables = new ArrayList<PDescriptor>();
                        Map map = (Map)amap.get(pd.query_block_id);
                        if (map == null) continue;
                        tables.addAll(map.values());
                        if (pd.table == null) {
                            SQLAnalyzer.resolveContainer(pd, schema, tables, containers);
                        }
                        list.add(pd);
                        continue;
                    }
                    if (containers == null) continue;
                    ArrayList<PDescriptor> tables = new ArrayList<PDescriptor>();
                    Map map = (Map)amap.get(pd.query_block_id);
                    if (map == null) continue;
                    tables.addAll(map.values());
                    if (pd.table == null) {
                        SQLAnalyzer.resolveContainer(pd, schema, tables, containers);
                    }
                    list.add(pd);
                }
            }
            catch (StackOverflowError stackOverflowError) {
                // empty catch block
            }
        }
        return list;
    }

    public static void resolveContainer(PDescriptor cd, String schema, String tname, String cname, Map containers) {
        ContainerObject co;
        Object ltname = tname;
        if (schema != null && !schema.isEmpty()) {
            ltname = schema + "." + tname;
        }
        if ((co = (ContainerObject)containers.get(((String)ltname).toUpperCase())) != null) {
            cd.container = (FKContainer)co;
            ContainedObject cob = co.getElementByName(cd.name);
            if (cob != null) {
                cd.refColumn = cob;
            }
        }
    }

    public static void resolveContainer(PDescriptor cd, String schema, List<PDescriptor> tables, Map containers) {
        String cpref = cd.getColumnPrefix();
        if (cpref == null || cpref.isEmpty()) {
            for (PDescriptor td : tables) {
                ContainerObject co;
                Object name = td.name;
                boolean hasSchema = false;
                if (td.schema != null && !td.schema.isEmpty()) {
                    name = td.schema + "." + (String)name;
                    hasSchema = true;
                }
                if ((co = (ContainerObject)containers.get(((String)name).toUpperCase())) == null && !hasSchema && schema != null && !schema.isEmpty()) {
                    name = schema + "." + (String)name;
                    co = (ContainerObject)containers.get(((String)name).toUpperCase());
                }
                if (co == null) continue;
                td.container = (FKContainer)co;
                ContainedObject cob = co.getElementByName(cd.name);
                if (cob == null) continue;
                cd.container = (FKContainer)co;
                cd.realTable = td.name;
                cd.realSchema = td.schema;
                cd.refColumn = cob;
                return;
            }
        } else {
            for (PDescriptor td : tables) {
                ContainerObject co;
                if (!cpref.equals(td.getTableIdentifier())) continue;
                Object name = td.name;
                boolean hasSchema = false;
                if (td.schema != null && !td.schema.isEmpty()) {
                    name = td.schema + "." + (String)name;
                    hasSchema = true;
                }
                if ((co = (ContainerObject)containers.get(((String)name).toUpperCase())) == null && !hasSchema && schema != null && !schema.isEmpty()) {
                    name = schema + "." + (String)name;
                    co = (ContainerObject)containers.get(((String)name).toUpperCase());
                }
                if (co == null) continue;
                td.container = (FKContainer)co;
                ContainedObject cob = co.getElementByName(cd.name);
                if (cob == null) continue;
                cd.container = (FKContainer)co;
                cd.table = td.name;
                cd.realSchema = td.schema;
                cd.refColumn = cob;
                return;
            }
        }
    }

    public static void resolveColumn(PDescriptor cd, String schema, List<PDescriptor> tables, Map<String, SQLNameHelper> containers) {
        String cpref = cd.getColumnPrefix();
        if (cpref == null || cpref.isEmpty()) {
            for (PDescriptor td : tables) {
                ContainedObject cob;
                SQLNameHelper ch;
                SQLNameHelper nh;
                Object name = td.name;
                boolean hasSchema = false;
                if (td.schema != null && !td.schema.isEmpty()) {
                    name = td.schema + "." + (String)name;
                    hasSchema = true;
                }
                if ((nh = containers.get(((String)name).toUpperCase())) == null && !hasSchema && schema != null && !schema.isEmpty()) {
                    name = schema + "." + (String)name;
                    nh = containers.get(((String)name).toUpperCase());
                }
                if (nh == null || nh.desObj == null) continue;
                td.container = (FKContainer)nh.desObj;
                if (nh.columns == null || (ch = nh.columns.get(cd.name.toUpperCase())) == null || (cob = (ContainedObject)ch.desObj) == null) continue;
                cd.container = (FKContainer)nh.desObj;
                cd.realTable = td.name;
                cd.realSchema = td.schema;
                cd.refColumn = cob;
                return;
            }
        } else {
            for (PDescriptor td : tables) {
                ContainedObject cob;
                SQLNameHelper ch;
                SQLNameHelper nh;
                if (!cpref.equals(td.getTableIdentifier())) continue;
                Object name = td.name;
                boolean hasSchema = false;
                if (td.schema != null && !td.schema.isEmpty()) {
                    name = td.schema + "." + (String)name;
                    hasSchema = true;
                }
                if ((nh = containers.get(((String)name).toUpperCase())) == null && !hasSchema && schema != null && !schema.isEmpty()) {
                    name = schema + "." + (String)name;
                    nh = containers.get(((String)name).toUpperCase());
                }
                if (nh == null || nh.desObj == null) continue;
                td.container = (FKContainer)nh.desObj;
                if (nh.columns == null || (ch = nh.columns.get(cd.name.toUpperCase())) == null || (cob = (ContainedObject)ch.desObj) == null) continue;
                cd.container = (FKContainer)nh.desObj;
                cd.realTable = td.name;
                cd.realSchema = td.schema;
                cd.refColumn = cob;
                return;
            }
        }
    }

    public static void createTableColumns(Table table, List<PDescriptor> headerColumns) {
        if (table.getElementsCollection().isEmpty()) {
            for (PDescriptor pd : headerColumns) {
                ContainedObjectWithDomain col;
                String columnName;
                boolean columnNameHasQuotes = false;
                String columnAlias = pd.alias;
                if (columnAlias == null || columnAlias.isEmpty()) {
                    columnName = pd.name;
                    if (columnName.isEmpty()) {
                        columnName = pd.expression;
                    }
                } else {
                    if (columnAlias.startsWith("\"") && columnAlias.endsWith("\"") && !(columnAlias = columnAlias.substring(1, columnAlias.length() - 1)).equals(columnAlias.toUpperCase())) {
                        columnNameHasQuotes = true;
                    }
                    columnName = columnAlias;
                }
                Column tableColumn = table.createColumn(columnName);
                if (columnNameHasQuotes) {
                    tableColumn.setNameHasQuotes(true);
                }
                if (pd.container == null || pd.refColumn == null) continue;
                FKContainer co = pd.container;
                ContainedObjectWithDomain refCol = (ContainedObjectWithDomain)pd.refColumn;
                if (refCol instanceof AbstractViewElement && (col = ((AbstractViewElement)refCol).getReferencedColumn()) != null) {
                    refCol = col;
                }
                short use = refCol.getUse();
                if (refCol instanceof Column) {
                    tableColumn.setUse(use);
                    if (use == 0) {
                        tableColumn.setDomain(refCol.getDomain());
                    } else if (use == 1) {
                        tableColumn.setLogicalDatatype(refCol.getLogicalDatatype());
                        tableColumn.setDataTypeParameter("size", refCol.getSize());
                        tableColumn.setDataTypeParameter("precision", refCol.getPrecision());
                        tableColumn.setDataTypeParameter("scale", refCol.getScale());
                    } else if (use == 3) {
                        tableColumn.setStructuredType(refCol.getStructuredType());
                        tableColumn.setReference(refCol.isReference());
                    } else if (use == 4) {
                        tableColumn.setCollectionType(refCol.getCollectionType());
                    } else if (use == 2) {
                        tableColumn.setDistinctType(refCol.getDistinctType());
                    }
                    if (columnAlias != null && !columnAlias.isEmpty()) continue;
                    tableColumn.setNameHasQuotes(refCol.getNameHasQuotes());
                    continue;
                }
                ColumnView cv = (ColumnView)refCol;
                cv.getReferencedColumn();
            }
        }
    }

    public static void updateColumns(AbstractView view, List<PDescriptor> headerColumns) {
        boolean isLogicalView = view instanceof EntityView;
        ArrayList oldCols = new ArrayList(view.getElementsCollection());
        view.clearContainers();
        ArrayList<FKContainer> added = new ArrayList<FKContainer>();
        ArrayList<AbstractViewElement> columnViews = new ArrayList<AbstractViewElement>();
        HashMap<AbstractViewElement, AbstractViewElement> found = new HashMap<AbstractViewElement, AbstractViewElement>();
        int i = -1;
        for (PDescriptor pd : headerColumns) {
            ++i;
            String cname = pd.name;
            if (cname == null) {
                cname = pd.alias;
            }
            if (cname == null) {
                cname = "";
            }
            if (pd.container != null && view != pd.container && !view.getObjectID().equals(pd.container.getObjectID()) && pd.refColumn != null) {
                String expr;
                FKContainer co = pd.container;
                if (co == null) continue;
                ContainedObject column = pd.refColumn;
                AbstractViewElement v = SQLAnalyzer.getColumnView(co, view, pd.name, pd.alias == null ? "" : pd.alias, expr = pd.expression, found, i);
                if (v == null) {
                    v = isLogicalView ? new AttributeView(view.getDesignPart()) : new ColumnView(view.getDesignPart());
                    if (column != null) {
                        if (column instanceof Column || column instanceof Attribute) {
                            v.setReferencedColumn((ContainedObjectWithDomain)column);
                        } else {
                            v.setReferencedColumnView((FKElement)column);
                        }
                    }
                    v.setName(cname);
                    v.setDesign(co.getDesign());
                    if (co instanceof Table || co instanceof Entity) {
                        v.setTable(co);
                    } else {
                        v.setView((AbstractView)co);
                    }
                    v.setContainer(view);
                    if (column != null) {
                        v.setDataType(((ContainedObjectWithDomain)column).getDatatypeString(StorageDesignOraclev12c.RDBMS_TYPE.getName()));
                    } else {
                        try {
                            String dt = ViewColumnDTParser.getDataTypeFroExpr(pd.expression, "Oracle");
                            if (dt != null) {
                                v.setDataType(dt);
                            }
                        }
                        catch (Exception dt) {}
                    }
                } else if (column != null) {
                    if (column instanceof Column || column instanceof Attribute) {
                        v.setReferencedColumn((ContainedObjectWithDomain)column);
                    } else {
                        v.setReferencedColumnView((FKElement)column);
                    }
                }
                found.put(v, v);
                String expral = pd.alias;
                if (expral != null && !expral.isEmpty()) {
                    v.setAlias(expral);
                }
                v.setExpression(pd.expression);
                v.setAlias(pd.alias);
                v.setHeaderAlias(pd.headerName);
                columnViews.add(v);
                if (added.contains(co)) continue;
                added.add(co);
                continue;
            }
            AbstractViewElement v = SQLAnalyzer.getColumnView(null, view, pd.name, pd.alias == null ? "" : pd.alias, pd.expression, found, i);
            if (v == null) {
                v = isLogicalView ? new AttributeView(view.getDesignPart()) : new ColumnView(view.getDesignPart());
                v.setName(cname);
                v.setDesign(view.getDesign());
                v.setContainer(view);
                v.setExpression(pd.expression);
                v.setAlias(pd.alias);
            }
            try {
                String dt;
                String tmp = v.getDataTypeString();
                if (tmp != null && ("UNKNOWN".equalsIgnoreCase(tmp) || tmp.isEmpty()) && (dt = ViewColumnDTParser.getDataTypeFroExpr(pd.expression, "Oracle")) != null) {
                    v.setDataType(dt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            found.put(v, v);
            v.setExpression(pd.expression);
            v.setAlias(pd.alias);
            v.setHeaderAlias(pd.headerName);
            columnViews.add(v);
        }
        view.clearElements();
        for (AbstractViewElement cv : columnViews) {
            view.add(cv);
        }
    }

    private static AbstractViewElement getColumnView(ContainerObject container, AbstractView view, String cname, String calias, String cexpression, Map found, int colIndex) {
        ContainedObjectWithDomain co;
        String alias = calias == null ? "" : calias;
        String name = cname == null ? "" : cname;
        String expression = cexpression == null ? "" : cexpression;
        Iterator it = view.getElementsCollection().iterator();
        int ind = -1;
        while (it.hasNext()) {
            String cName;
            AbstractViewElement c = (AbstractViewElement)it.next();
            ++ind;
            if (found.get(c) != null) continue;
            if (c.getReferencedContainer() != null && container != null) {
                if (c.getReferencedContainer() == container) {
                    co = c.getReferencedColumn();
                    if (co == null) {
                        co = c.getReferencedColumnView();
                    }
                    if (name.length() > 0 && colIndex == ind) {
                        if (co != null && name.equalsIgnoreCase(co.getName())) {
                            return c;
                        }
                        if (name.equalsIgnoreCase(c.getName())) {
                            return c;
                        }
                    }
                    if (alias.length() > 0 && expression.length() > 0 && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                        return c;
                    }
                    if (alias.length() > 0 && alias.equalsIgnoreCase(c.getAlias())) {
                        return c;
                    }
                    if (expression.length() > 0 && expression.equalsIgnoreCase(c.getExpression())) {
                        return c;
                    }
                }
            } else {
                if (name.length() > 0 && alias.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias())) {
                    return c;
                }
                if (alias.length() > 0 && expression.length() > 0 && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                    return c;
                }
                if (name.length() > 0 && alias.length() > 0 && name.equalsIgnoreCase(c.getName()) && alias.equalsIgnoreCase(c.getAlias())) {
                    return c;
                }
                if (alias.length() > 0 && expression.length() > 0 && alias.equalsIgnoreCase(c.getAlias()) && expression.equalsIgnoreCase(c.getExpression())) {
                    return c;
                }
                if (alias.length() > 0 && alias.equalsIgnoreCase(c.getAlias())) {
                    return c;
                }
                if (expression.length() > 0 && expression.equalsIgnoreCase(c.getExpression())) {
                    return c;
                }
                if (name.length() > 0 && (name.equalsIgnoreCase(c.getName()) || name.equalsIgnoreCase(c.getPresentationName()))) {
                    return c;
                }
            }
            String newName = alias.isEmpty() ? name : alias;
            String string = cName = c.getAlias().isEmpty() ? c.getName() : c.getAlias();
            if (!(newName.length() > 0 ? newName.equalsIgnoreCase(cName) : expression.length() > 0 && expression.equalsIgnoreCase(c.getExpression()))) continue;
            return c;
        }
        for (AbstractViewElement c : view.getElementsCollection()) {
            ++ind;
            if (found.get(c) != null || c.getReferencedContainer() == null || container == null) continue;
            co = c.getReferencedColumn();
            if (co == null) {
                co = c.getReferencedColumnView();
            }
            if (name.length() <= 0) continue;
            if (co != null && name.equalsIgnoreCase(co.getName())) {
                return c;
            }
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger(SQLAnalyzer.class);
        }
        return logger;
    }

    public static List<String> getColumnsAndConstraintsInAlter(String sql) {
        ArrayList<String> list = new ArrayList<String>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        int col_def = earley.getSymbol(column_def);
        int out_of_line_constr = earley.getSymbol(out_of_line_constraint);
        int inline_constr = earley.getSymbol(inline_constraint);
        int out_of_line_ref_constr = earley.getSymbol(out_of_line_ref_constraint);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    if (!n.contains(out_of_line_constr) && !n.contains(inline_constr) && !n.contains(out_of_line_ref_constr) && !n.contains(col_def)) continue;
                    String cont = SQLAnalyzer.getSource(n, src, sql);
                    list.add(cont);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        String sql1;
        String sql = Service.readFile((String)"D:/pack_1.sql");
        String tsql = TableView.getQuery(sql);
        sql = sql1 = "ALTER TABLE TEST_TAB2 ADD (\n    CONSTRAINT TEST_TAB2_CK17 CHECK ( COL4 IN (\n        'xxxxxxxxxxxxxx (xxxxxxxxxxxxxxx)',\n        'xxxxxx (xxxxxxxxxxxxxxxx)',\n        'xxxx (xxxxxxxxxxxxxxxx)'\n    ) )\n,constraint tab_child_fk  foreign key (col1, col2)\nreferences tab_parent (col1, col2) ,  c1 number, c2 varchar2(120) constraint c2_nn not null);";
        SqlEarley earley = SqlEarley.getInstance();
        int table_ref = earley.getSymbol(t_ref);
        int column_ = earley.getSymbol(column);
        int dml_tab = earley.getSymbol(dml_table);
        int udf = earley.getSymbol(u_funct);
        int f_cal = earley.getSymbol(function_call);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        int query_block = earley.getSymbol(q_block);
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, (Matriceable)matrix);
        ParseNode root = earley.forest(src, matrix);
        int count = 10;
        Integer qb = 10;
        int qb_end = root.to;
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(qb);
        stack.push(qb_end);
        List<PDescriptor> list = SQLAnalyzer.getTablesAndFunctions(sql);
        for (PDescriptor pd : list) {
            System.out.println(pd.toString());
        }
        System.out.println("\n\n===================================================================\n\n");
        list = SQLAnalyzer.getFirstColumnNamesAndTables(sql);
        for (PDescriptor pd : list) {
            System.out.println(pd.toString());
        }
        for (ParseNode n : root.descendants()) {
            if (!n.contains(out_of_line_constraint) && !n.contains(inline_constraint) && !n.contains(column_def)) continue;
            String cont = SQLAnalyzer.getSource(n, src, sql);
            System.out.println(cont);
        }
        root.printTree();
    }

    public static class PDescriptor
    implements Comparable<PDescriptor> {
        public String element;
        public String type = "";
        public String schema;
        public String name;
        public String pack;
        public String alias;
        public String table;
        public String realSchema;
        public String realTable;
        public int start = 0;
        int schemaStart = -1;
        int schemaEnd;
        int tableStart = -1;
        int tableEnd;
        int nameStart = -1;
        int nameEnd;
        boolean valid = false;
        public String query_block_id = "";
        public String headerName;
        public ContainedObject refColumn;
        public FKContainer container;
        public boolean condition = false;
        public boolean queryExpression = false;
        public String expression;

        int getSortValue() {
            return Integer.valueOf(this.query_block_id) * 100000 + this.start;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_COLUMN.equalsIgnoreCase(this.type)) {
                sb.append(String.valueOf(this.schema)).append(".").append(String.valueOf(this.table)).append(".").append(this.name).append(".").append(this.alias + " -- ").append(this.element);
            } else if (SQLAnalyzer.TYPE_TABLE.equalsIgnoreCase(this.type)) {
                sb.append(String.valueOf(this.schema)).append(".").append(".").append(this.name).append("--").append(this.alias);
            } else {
                sb.append(String.valueOf(this.schema)).append(".").append(String.valueOf(this.pack)).append(".").append(this.name);
            }
            return sb.toString().toUpperCase();
        }

        public int getStartPosition() {
            if (this.schemaStart > -1) {
                return this.schemaStart;
            }
            if (this.tableStart > -1) {
                return this.tableStart;
            }
            return this.nameStart;
        }

        public String getColumnPrefix() {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_COLUMN.equalsIgnoreCase(this.type)) {
                if (this.schema != null) {
                    sb.append(String.valueOf(this.schema)).append(".");
                }
                if (this.table != null) {
                    sb.append(String.valueOf(this.table));
                }
            }
            return sb.toString();
        }

        public String getTableLongName() {
            return this.getTableLongName(null);
        }

        public String getTableLongName(String usedSchema) {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_TABLE.equalsIgnoreCase(this.type)) {
                if (this.schema != null) {
                    sb.append(String.valueOf(this.schema)).append(".");
                } else if (usedSchema != null) {
                    sb.append(String.valueOf(usedSchema)).append(".");
                }
                if (this.name != null) {
                    sb.append(String.valueOf(this.name));
                }
            }
            return sb.toString();
        }

        public String getRealLongName() {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_TABLE.equalsIgnoreCase(this.type)) {
                if (this.schema != null) {
                    sb.append(String.valueOf(this.schema)).append(".");
                } else if (this.realSchema != null) {
                    sb.append(String.valueOf(this.realSchema)).append(".");
                }
                if (this.name != null) {
                    sb.append(String.valueOf(this.name));
                }
            } else {
                if (this.schema != null) {
                    sb.append(String.valueOf(this.schema)).append(".");
                } else if (this.realSchema != null) {
                    sb.append(String.valueOf(this.realSchema)).append(".");
                }
                if (this.table != null) {
                    sb.append(String.valueOf(this.table)).append(".");
                } else if (this.realTable != null) {
                    sb.append(String.valueOf(this.realTable)).append(".");
                }
                if (this.name != null) {
                    sb.append(String.valueOf(this.name));
                }
            }
            return sb.toString();
        }

        public String getTableIdentifier() {
            if (SQLAnalyzer.TYPE_TABLE.equalsIgnoreCase(this.type)) {
                if (this.alias != null && !this.alias.isEmpty()) {
                    return this.alias;
                }
                if (this.name != null) {
                    return this.getTableLongName();
                }
            }
            return null;
        }

        public String getColumnIdentifier() {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_COLUMN.equalsIgnoreCase(this.type)) {
                if (this.schema != null) {
                    sb.append(String.valueOf(this.schema)).append(".");
                }
                if (this.table != null) {
                    sb.append(String.valueOf(this.table)).append(".");
                }
                if (this.name != null) {
                    sb.append(String.valueOf(this.name));
                }
            }
            return sb.toString();
        }

        @Override
        public int compareTo(PDescriptor pd) {
            int sv2;
            int sv1 = this.getSortValue();
            if (sv1 < (sv2 = pd.getSortValue())) {
                return -1;
            }
            if (sv1 > sv2) {
                return 1;
            }
            return 0;
        }

        public String getID() {
            if (this.refColumn != null) {
                return this.refColumn.getObjectID();
            }
            if (this.container != null) {
                return this.container.getObjectID();
            }
            return "";
        }
    }
}

