/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexDB2v70
extends AbstractSSBDB2 {
    AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && !((Index)object).isFK() && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxy && ((IndexProxy)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxyDB2 indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(index);
            indexProxy = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyDB2) {
            indexProxy = (IndexProxyDB2)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(indexProxy);
        }
        if (index != null && indexProxy != null && index.getElementsCollection().size() > 0) {
            if (indexProxy.isMarkedGenerate()) {
                if (indexProxy.isCommentChanged()) {
                    this.appendComment(buffer, indexProxy);
                } else {
                    this.appendComment(buffer, index);
                }
                this.appendCreate(buffer);
                this.appendUnique(buffer, indexProxy);
                this.appendNotNull(buffer, indexProxy);
                SSBIndexDB2v70.appendStringWithSpace(buffer, "INDEX");
                SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
                this.appendTable(buffer, index, prettyPrint);
                this.appendElementList(buffer, index, indexProxy, true);
                this.appendUsingBlock(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendFreeBlock(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendGbpCacheBlock(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendDefine(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendCluster(buffer, indexProxy, prettyPrint);
                this.appendBufferPool(buffer, indexProxy, prettyPrint);
                this.appendClose(buffer, indexProxy, prettyPrint);
                this.appendDefer(buffer, indexProxy, prettyPrint);
                this.appendCopy(buffer, indexProxy, prettyPrint);
                this.appendPieceSize(buffer, indexProxy, prettyPrint);
                SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexDB2v70.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementCreateIndex();
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
                }
            } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
            }
        } else if (index != null) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Index ");
            buffer.append(this.storageDesign.getFormatedName(index.getContainerWithKeyObject().getName()) + "." + this.storageDesign.getFormatedName(index.getName()));
            buffer.append(" has no columns");
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexComment(StringBuffer buffer, Index index, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        if (indexProxy != null && indexProxy.isCommentInRDBMSChanged()) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexDB2v70.appendStringWithSpace(buffer, "INDEX");
            SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
            SSBIndexDB2v70.appendStringWithSpace(buffer, "IS");
            SSBIndexDB2v70.appendString(buffer, '\'');
            SSBIndexDB2v70.appendString(buffer, indexProxy.getCommentInRDBMS());
            SSBIndexDB2v70.appendStringWithSpace(buffer, '\'');
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v70.appendLineFinisher(buffer, prettyPrint);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexDB2v70.appendStringWithSpace(buffer, "INDEX");
            SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getLongNameDDL()));
            SSBIndexDB2v70.appendStringWithSpace(buffer, "IS");
            SSBIndexDB2v70.appendString(buffer, '\'');
            SSBIndexDB2v70.appendString(buffer, index.getCommentInRDBMS());
            SSBIndexDB2v70.appendStringWithSpace(buffer, '\'');
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v70.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendTable(StringBuffer buffer, Index index, boolean prettyPrint) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tp = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
        if (tp != null) {
            SSBIndexDB2v70.appendStringWithSpace(buffer, "ON");
            SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
        }
    }

    protected void appendElementList(StringBuffer buffer, Index index, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        if (index.hasIndexExpression()) {
            SSBIndexDB2v70.appendStringWithSpace(buffer, '(');
            SSBIndexDB2v70.appendString(buffer, index.getIndexExpression());
            SSBIndexDB2v70.appendStringWithSpace(buffer, ')');
        } else {
            ColumnProxy[] columns = indexProxy.getColumnProxies();
            ColumnProxy column = null;
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v70.appendString(buffer, ' ');
                SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column.getName()));
                SSBIndexDB2v70.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
                if (i >= columns.length - 1) continue;
                this.appendComma(buffer);
            }
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendUnique(StringBuffer buffer, IndexProxyDB2 index) {
        if (index.isUnique()) {
            SSBIndexDB2v70.appendStringWithSpace(buffer, "UNIQUE");
        }
    }

    protected void appendNotNull(StringBuffer buffer, IndexProxyDB2 indexProxy) {
        if (indexProxy.isUniquePlainIndex() && indexProxy.isWhereNotNull()) {
            SSBIndexDB2v70.appendStringWithSpace(buffer, "WHERE NOT NULL");
        }
    }

    protected void appendUsingBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            VCatDB2 vcat = st.getVCat();
            if (vcat != null) {
                SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v70.appendStringWithSpace(buffer, "USING");
                SSBIndexDB2v70.appendStringWithSpace(buffer, "VCAT");
                SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(vcat.getName()));
            } else {
                StorageGroupDB2 stogroup = st.getStorageGroup();
                if (stogroup != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                    SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v70.appendStringWithSpace(buffer, "USING");
                    SSBIndexDB2v70.appendStringWithSpace(buffer, "STOGROUP");
                    SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(stogroup.getLongNameDDL()));
                    SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v70.appendStringWithSpace(buffer, "PRIQTY");
                    SSBIndexDB2v70.appendStringWithSpace(buffer, st.getSgPriqty());
                    SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v70.appendStringWithSpace(buffer, "SECQTY");
                    SSBIndexDB2v70.appendStringWithSpace(buffer, st.getSgSeqty());
                    SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v70.appendStringWithSpace(buffer, "ERASE");
                    SSBIndexDB2v70.appendStringWithSpace(buffer, st.isSgErase() ? "YES" : "NO");
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "FREEPAGE");
            SSBIndexDB2v70.appendStringWithSpace(buffer, st.getFreePage());
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "PCTFREE");
            SSBIndexDB2v70.appendStringWithSpace(buffer, st.getPctFree());
        }
    }

    protected void appendGbpCacheBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!"".equalsIgnoreCase(st.getGbCache())) {
                SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v70.appendStringWithSpace(buffer, "GBPCACHE");
                SSBIndexDB2v70.appendStringWithSpace(buffer, st.getGbCache());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v70.appendStringWithSpace(buffer, "GBPCACHE");
                SSBIndexDB2v70.appendStringWithSpace(buffer, "CHANGED");
            }
        }
    }

    protected void appendDefine(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (st.isDefine()) {
                SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v70.appendStringWithSpace(buffer, "DEFINE");
                SSBIndexDB2v70.appendStringWithSpace(buffer, "YES");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v70.appendStringWithSpace(buffer, "DEFINE");
                SSBIndexDB2v70.appendStringWithSpace(buffer, "NO");
            }
        }
    }

    protected void appendCluster(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getClusterType().equalsIgnoreCase("NONE")) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "CLUSTER");
            if (indexProxy.getClusterType().equalsIgnoreCase(IndexProxyDB2.CLUSTER_TYPES[2]) && indexProxy.getNumParts() > 0) {
                this.appendPartitions(buffer, indexProxy, prettyPrint);
            }
        }
    }

    protected void appendPartitions(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        IndexPartitionDB2[] partitions = indexProxy.getPartitions();
        SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexDB2v70.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < partitions.length; ++i) {
            IndexPartitionDB2 partition = partitions[i];
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "PARTITION");
            SSBIndexDB2v70.appendStringWithSpace(buffer, partition.getPartNumber());
            SSBIndexDB2v70.appendStringWithSpace(buffer, "VALUES");
            SSBIndexDB2v70.appendStringWithSpace(buffer, '(');
            SSBIndexDB2v70.appendStringWithSpace(buffer, partition.getPartConstants());
            SSBIndexDB2v70.appendStringWithSpace(buffer, ')');
            this.appendUsingBlock(buffer, partition.getStorageTemplate(), prettyPrint);
            this.appendFreeBlock(buffer, partition.getStorageTemplate(), prettyPrint);
            this.appendGbpCacheBlock(buffer, partition.getStorageTemplate(), prettyPrint);
            if (i >= partitions.length - 1) continue;
            this.appendComma(buffer);
        }
        SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexDB2v70.appendStringWithSpace(buffer, ')');
    }

    protected void appendBufferPool(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        BufferPoolDB2 bufferPool = indexProxy.getBufferPool();
        if (bufferPool != null) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "BUFFERPOOL");
            SSBIndexDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(bufferPool.getLongNameDDL()));
        }
    }

    protected void appendClose(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        if (!indexProxy.isClose()) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "CLOSE");
            SSBIndexDB2v70.appendStringWithSpace(buffer, "NO");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "CLOSE");
            SSBIndexDB2v70.appendStringWithSpace(buffer, "YES");
        }
    }

    protected void appendDefer(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexDB2v70.appendStringWithSpace(buffer, "DEFER");
        SSBIndexDB2v70.appendStringWithSpace(buffer, indexProxy.isDefer() ? "YES" : "NO");
    }

    protected void appendCopy(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        if (indexProxy.isCopy()) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "COPY");
            SSBIndexDB2v70.appendStringWithSpace(buffer, "YES");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "COPY");
            SSBIndexDB2v70.appendStringWithSpace(buffer, "NO");
        }
    }

    protected void appendPieceSize(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getPieceSize().equalsIgnoreCase(" ")) {
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendStringWithSpace(buffer, "PIECESIZE");
            SSBIndexDB2v70.appendStringWithSpace(buffer, indexProxy.getPieceSize());
        }
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index object, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Index index = null;
        index = object;
        StorageDesign storageDesign = this.getStorageDesign(index);
        if (index != null && !index.isOidKey()) {
            this.storageDesign = (AbstractStorageDesignDB2)tableProxy.getStorageDesign();
            if (index.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    String indName = index.getName();
                    indName = ApplyNamingStandards.createIndexNameAuto(tableProxy.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                    if (indName.length() > 18) {
                        SSBIndexDB2v70.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexDB2v70.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(18)");
                        SSBIndexDB2v70.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexDB2v70.appendStringWithSpace(buffer, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexDB2v70.appendStringWithSpace(buffer, "UNIQUE");
                    }
                    SSBIndexDB2v70.appendStringWithSpace(buffer, "INDEX");
                    SSBIndexDB2v70.appendStringWithSpace(buffer, storageDesign.getFormatedName(indName));
                    advancedComment = buffer.toString();
                    this.appendTable(buffer, index, true);
                    this.appendConstraintElementList(buffer, index, tableProxy, true);
                    SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    SSBIndexDB2v70.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexDB2v70.appendNewLine(oldbuffer, prettyPrint, 0);
                    oldbuffer.append("-- Error - Index ");
                    oldbuffer.append(storageDesign.getFormatedName(index.getName()));
                    oldbuffer.append(" has no columns");
                    SSBIndexDB2v70.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ArrayList<ColumnProxy> list = new ArrayList<ColumnProxy>();
        for (Column col : index.getElementsCollectionImmutable()) {
            ColumnProxy cp = tableProxy.getColumnProxy(col.getObjectID());
            if (cp == null) continue;
            list.add(cp);
        }
        Object[] columns = list.toArray();
        SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexDB2v70.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexDB2v70.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexDB2v70.appendStringWithSpace(buffer, ',');
            }
            column = (ColumnProxy)columns[i];
            SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v70.appendString(buffer, ' ');
            String columnName = this.storageDesign.getFormatedName(column.getName());
            SSBIndexDB2v70.appendStringWithSpace(buffer, columnName);
            SSBIndexDB2v70.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexDB2v70.appendStringWithSpace(buffer, ')');
    }
}

