/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBArcFKOracle
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    public SSBArcFKOracle(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FKArc;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        Table arcTable;
        FKArc arc = (FKArc)object;
        if (arc.isMarkedGenerate() && arc.isReverse() && arc.getDesign().getAppView().getSettings().isGenerateFKArcTriggers() && !arc.isViewArc() && (arcTable = (Table)arc.getTable()) != null && arc.getFkeys().size() > 1) {
            for (FKIndexAssociation fkey : arc.getFkeys()) {
                FKContainer fkeyTable = fkey.getTable();
                TableProxy fkeyTableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(fkeyTable.getObjectID());
                if (fkeyTableProxy == null || !fkeyTableProxy.isMarkedGenerate()) continue;
                this.appendComment(oldbuffer, arc);
                this.appendArcTrigger(oldbuffer, arc, fkey, fkeyTableProxy, true);
            }
        }
    }

    private void appendArcTrigger(StringBuffer oldbuffer, FKArc arc, FKIndexAssociation fkey, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String fkeyTableLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        String advancedComment = "create Arc constraint trigger for table " + fkeyTableLongName;
        String tablePart = this.getStringWithMaxLength(tableProxy.getName(), 25);
        String arcPart = this.getStringWithMaxLength(arc.getName(), 25 - tablePart.length());
        Object trName = "ARC_" + arcPart + "_" + tablePart;
        trName = this.storageDesign.getFormatedName((String)trName);
        if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            trName = this.storageDesign.getFormatedName(tableProxy.getUserSchema()) + "." + (String)trName;
        }
        String trTab = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        FKElement[] fkeyCols = fkey.getColumns();
        Object trCols = "";
        boolean first = true;
        for (int i = 0; i < fkeyCols.length; ++i) {
            FKElement fkeyCol = fkeyCols[i];
            if (first) {
                trCols = this.storageDesign.getFormatedName(fkeyCol);
                first = false;
                continue;
            }
            trCols = (String)trCols + ", " + this.storageDesign.getFormatedName(fkeyCol);
        }
        if (arc.getDiscriminatorColumn() != null && !arc.isViewArc()) {
            String arcTab = this.storageDesign.getFormatedLongNameDDL(arc.getTable());
            ContainedObject[] arcCols = fkey.getKeyObject().getElements();
            Column arcDCol = arc.getDiscriminatorColumn();
            String fkeyName = this.storageDesign.getFormatedLongNameDDL(fkey);
            if (arcDCol.equals(fkey.getDiscriminatorColumn())) {
                Object fkeyDVal = fkey.getDiscriminatorValue();
                if (fkeyDVal != null && !((String)fkeyDVal).equals("")) {
                    String arcDColDatatype = arcDCol.getDatatypeString(this.storageDesign.getRDBMSType().getName());
                    if (arcDColDatatype.indexOf("CHAR") > -1 && !((String)fkeyDVal).startsWith("'")) {
                        fkeyDVal = "'" + (String)fkeyDVal + "'";
                    }
                    SSBArcFKOracle.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + (String)trName);
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "BEFORE INSERT OR UPDATE OF " + (String)trCols);
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "ON " + trTab);
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "FOR EACH ROW");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "DECLARE");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "d " + arcDColDatatype + ";");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "BEGIN");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "SELECT A." + this.storageDesign.getFormatedName(arcDCol) + " INTO d");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "FROM " + arcTab + " A");
                    for (int j = 0; j < arcCols.length; ++j) {
                        SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                        if (j == 0) {
                            SSBArcFKOracle.appendStringWithSpace(buffer, "WHERE");
                        } else {
                            SSBArcFKOracle.appendStringWithSpace(buffer, "AND");
                        }
                        SSBArcFKOracle.appendString(buffer, "A." + this.storageDesign.getFormatedName(arcCols[j]) + " = :new." + this.storageDesign.getFormatedName(fkeyCols[j]));
                    }
                    SSBArcFKOracle.appendStringWithSpace(buffer, ';');
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "IF (d IS NULL OR d <> " + (String)fkeyDVal + ") THEN");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 2);
                    fkeyDVal = ((String)fkeyDVal).replaceAll("'", "''");
                    SSBArcFKOracle.appendStringWithSpace(buffer, "raise_application_error(-20223,'FK " + fkeyName + " in Table " + trTab + " violates Arc constraint on Table " + arcTab + " - discriminator column " + arcDCol.getName() + " doesn''t have value " + (String)fkeyDVal + "');");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "END IF;");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "EXCEPTION");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "WHEN NO_DATA_FOUND THEN");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 2);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "NULL;");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "WHEN OTHERS THEN");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 2);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "RAISE;");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "END;");
                    this.appendBlockDefinitionToBuffer(oldbuffer, buffer, advancedComment, "/");
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementCreateTrigger();
                } else {
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(oldbuffer, "--  ERROR: No Discriminator Value found for FK " + fkey.getName() + " - constraint trigger for Arc " + arc.getName() + " cannot be generated");
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            } else {
                SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBArcFKOracle.appendStringWithSpace(oldbuffer, "--  ERROR: Discriminator Column found in FK " + fkey.getName() + " not same as in Arc " + arc.getName() + " - constraint trigger for Arc cannot be generated");
                SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        } else {
            SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBArcFKOracle.appendStringWithSpace(oldbuffer, "--  ERROR: No Discriminator Column found in Arc " + arc.getName() + " - constraint trigger for Arc cannot be generated");
            SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }
}

