/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDropFKOracle
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        FKIndexAssociation fk;
        return object instanceof Index && ((Index)object).isFK() ? (fk = ((Index)object).getFKAssociation()).isDropEnabled() && !fk.shouldBeDroppedIndirectly() : object instanceof FKProxyOracle && ((FKProxyOracle)object).isDropEnabled() && !((FKProxyOracle)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Index) {
            FKIndexAssociation fkassociation = ((Index)object).getFKAssociation();
            KeyObject foreignKey = fkassociation.getLocalFKIndex();
            StorageDesign storageDesign = this.getStorageDesign(object);
            SSBDropFKOracle.appendStringWithSpace(buffer, "ALTER");
            SSBDropFKOracle.appendStringWithSpace(buffer, "TABLE");
            SSBDropFKOracle.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(fkassociation.getTable()));
            SSBDropFKOracle.appendNewLine(buffer, prettyPrint, 1);
            this.appendDrop(buffer);
            SSBDropFKOracle.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBDropFKOracle.appendStringWithSpace(buffer, storageDesign.getFormatedName(foreignKey));
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            SSBDropFKOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBDropFKOracle.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            DDLFileMaker.incrementAlterTable();
        } else if (object instanceof IndexProxy) {
            StorageDesign storageDesign = this.getStorageDesign(object);
            IndexProxy indp = (IndexProxy)object;
            SSBDropFKOracle.appendStringWithSpace(buffer, "ALTER");
            SSBDropFKOracle.appendStringWithSpace(buffer, "TABLE");
            SSBDropFKOracle.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(indp.getTableProxy()));
            SSBDropFKOracle.appendNewLine(buffer, prettyPrint, 1);
            this.appendDrop(buffer);
            SSBDropFKOracle.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBDropFKOracle.appendStringWithSpace(buffer, storageDesign.getFormatedName(indp));
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            SSBDropFKOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBDropFKOracle.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            DDLFileMaker.incrementAlterTable();
        }
    }
}

