/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RoleSqlServerv2k;

public class SSBRoleSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        RoleSqlServerv2k role = (RoleSqlServerv2k)object;
        this.storageDesign = role.getStorageDesign();
        this.appendComment(buffer, role);
        this.appendUse(buffer, role, prettyPrint);
        if (!role.getIsApplicationRole()) {
            this.appendAddRole(buffer, role, prettyPrint);
            this.appendAddRoleMember(buffer, role, prettyPrint);
        } else {
            this.appendAddApplRole(buffer, role, prettyPrint);
        }
        this.appendPrivileges(buffer, role, prettyPrint);
    }

    protected void appendUse(StringBuffer buffer, RoleSqlServerv2k role, boolean prettyPrint) {
        if (role.getDatabase() != null && !role.getDatabase().isNullInstance()) {
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "USE");
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role.getDatabase().getName()));
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendAddRole(StringBuffer buffer, RoleSqlServerv2k role, boolean prettyPrint) {
        SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
        SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "sp_addrole");
        SSBRoleSqlServerv2k.appendString(buffer, '\'');
        SSBRoleSqlServerv2k.appendString(buffer, role.getName());
        SSBRoleSqlServerv2k.appendString(buffer, '\'');
        if (role.getOwner() != null) {
            this.appendComma(buffer);
            SSBRoleSqlServerv2k.appendString(buffer, '\'');
            this.appendString(buffer, role.getOwner());
            SSBRoleSqlServerv2k.appendString(buffer, '\'');
        }
        SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "GO");
        SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
    }

    protected void appendAddRoleMember(StringBuffer buffer, RoleSqlServerv2k role, boolean prettyPrint) {
        for (String user : role.getUserSet()) {
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "sp_addrolemember");
            SSBRoleSqlServerv2k.appendString(buffer, '\'');
            SSBRoleSqlServerv2k.appendString(buffer, role.getName());
            SSBRoleSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBRoleSqlServerv2k.appendString(buffer, '\'');
            SSBRoleSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(user));
            SSBRoleSqlServerv2k.appendString(buffer, '\'');
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendAddApplRole(StringBuffer buffer, RoleSqlServerv2k role, boolean prettyPrint) {
        SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
        SSBRoleSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName("sp_addapprole"));
        SSBRoleSqlServerv2k.appendString(buffer, '\'');
        SSBRoleSqlServerv2k.appendString(buffer, role.getName());
        SSBRoleSqlServerv2k.appendString(buffer, '\'');
        this.appendComma(buffer);
        SSBRoleSqlServerv2k.appendString(buffer, '\'');
        SSBRoleSqlServerv2k.appendString(buffer, role.decodePassword());
        SSBRoleSqlServerv2k.appendString(buffer, '\'');
        SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "GO");
        SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendPrivileges(StringBuffer buffer, RoleSqlServerv2k role, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(role.getSystemPrivileges())) {
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            if (role.getDatabase() != null && !role.getDatabase().isNullInstance()) {
                SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "USE");
                this.appendStringWithSpace(buffer, role.getDatabase());
                SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBRoleSqlServerv2k.appendString(buffer, "GO");
                SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "GRANT");
            if (role.getPrivilegesSet().contains("ALL")) {
                SSBRoleSqlServerv2k.appendString(buffer, "ALL");
            } else {
                SSBRoleSqlServerv2k.appendString(buffer, role.getSystemPrivileges());
            }
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBRoleSqlServerv2k.appendStringWithSpace(buffer, "TO");
            this.appendString(buffer, role);
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleSqlServerv2k.appendString(buffer, "GO");
            SSBRoleSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RoleSqlServerv2k && ((RoleSqlServerv2k)object).getDatabase() != null && !((RoleSqlServerv2k)object).getDatabase().isNullInstance() && ((RoleSqlServerv2k)object).isMarkedGenerate();
    }
}

