/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k12;

import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.IndexProxySqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexSqlServerv2k12
extends SSBIndexSqlServerv2k5 {
    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxySqlServerv2k12 indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignSqlServerv2k12)this.getStorageDesign(object);
            indexProxy = (IndexProxySqlServerv2k12)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxySqlServer) {
            indexProxy = (IndexProxySqlServerv2k12)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k12)this.getStorageDesign(object);
        }
        if (indexProxy != null && indexProxy.isCommentChanged()) {
            this.appendComment(buffer, indexProxy);
        } else {
            this.appendComment(buffer, index);
        }
        if (indexProxy != null) {
            if (indexProxy.isMarkedGenerate()) {
                SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, "CREATE");
                this.appendUnique(buffer, indexProxy);
                this.appendClustered(buffer, indexProxy);
                this.appendColumnstore(buffer, indexProxy);
                SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, "INDEX");
                SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
                this.appendTable(buffer, indexProxy, prettyPrint);
                this.appendIncludeColumn(buffer, indexProxy, prettyPrint);
                this.appendOptions(buffer, indexProxy, prettyPrint);
                this.appendFilegroup(buffer, indexProxy, prettyPrint);
                SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, "GO");
                DDLFileMaker.incrementCreateIndex();
                SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 0);
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
                }
                this.appendExtProperties(buffer, indexProxy, prettyPrint);
            } else if (index.hasIndexExpression()) {
                SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, index.getIndexExpression());
            } else {
                buffer.append("-- Index ").append(index.getName()).append(" on Table ").append(indexProxy.getTableName()).append(" not created in ddl");
                SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 0);
            }
        } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
        }
    }

    private void appendColumnstore(StringBuffer buffer, IndexProxySqlServerv2k12 index) {
        if (index.isColumnstoreIndex()) {
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, "COLUMNSTORE");
        }
    }

    protected void appendOptions(StringBuffer buffer, IndexProxySqlServerv2k12 index, boolean prettyPrint) {
        if (!index.isColumnstoreIndex()) {
            super.appendOptions(buffer, index, prettyPrint);
        } else if ((index.getMaxdop() > 0 || index.getDropExisting().equalsIgnoreCase("ON")) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, "WITH");
            SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, '(');
            SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k12.appendSpace(buffer);
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, "DROP_EXISTING");
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, '=');
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, index.getDropExisting());
            this.appendComma(buffer);
            SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k12.appendSpace(buffer);
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, "MAXDOP");
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, '=');
            SSBIndexSqlServerv2k12.appendStringWithSpace(buffer, Integer.toString(index.getMaxdop()));
            SSBIndexSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k12.appendString(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxySqlServerv2k12 && ((TableProxySqlServerv2k5)((IndexProxySqlServerv2k12)object).getTableProxy()).getDatabase() != null && !((TableProxySqlServerv2k5)((IndexProxySqlServerv2k12)object).getTableProxy()).getDatabase().isNullInstance() && ((IndexProxy)object).isMarkedGenerate() && !((IndexProxySqlServerv2k12)object).isPrimaryXmlIndex();
    }
}

