/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBPartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBPartitionFunctionSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PartitionFunctionSqlServerv2k5 partFunc = (PartitionFunctionSqlServerv2k5)object;
        this.storageDesign = partFunc.getStorageDesign();
        if (!((PartitionFunctionSqlServerv2k5)object).getInputType().equals("")) {
            this.appendComment(buffer, partFunc);
            this.appendPartitionFunction(buffer, partFunc, prettyPrint);
            this.appendPartitionSchema(buffer, partFunc, prettyPrint);
            DDLFileMaker.incrementPartitionFunction();
        } else {
            SSBPartitionFunctionSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Empty input type in partition function ");
            buffer.append(this.storageDesign.getFormatedName(partFunc.getName()));
            SSBPartitionFunctionSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendPartitionFunction(StringBuffer buffer, PartitionFunctionSqlServerv2k5 partFunc, boolean prettyPrint) {
        SSBPartitionFunctionSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        this.appendDataBase(buffer, partFunc.getDatabase(), prettyPrint);
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, "PARTITION");
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, "FUNCTION");
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partFunc.getName()));
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, '(');
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, partFunc.getInputType());
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, ')');
        SSBPartitionFunctionSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, "AS");
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, "RANGE");
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, partFunc.getRangeType());
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, "FOR");
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, "VALUES");
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, '(');
        if (!"".equalsIgnoreCase(partFunc.getBoundaryValues())) {
            this.appendBoundaryValues(buffer, partFunc, prettyPrint);
        }
        SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, ')');
        SSBPartitionFunctionSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        SSBPartitionFunctionSqlServerv2k5.appendString(buffer, "GO");
        SSBPartitionFunctionSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendBoundaryValues(StringBuffer buffer, PartitionFunctionSqlServerv2k5 partFunc, boolean prettyPrint) {
        PartitionFunctionSqlServer.InlineList boundaryValues = partFunc.getBValuesSet();
        for (int i = 0; i < boundaryValues.size(); i += 2) {
            SSBPartitionFunctionSqlServerv2k5.appendString(buffer, '\'');
            this.appendString(buffer, boundaryValues.get(i));
            SSBPartitionFunctionSqlServerv2k5.appendString(buffer, '\'');
            if (i >= boundaryValues.size() - 2) continue;
            SSBPartitionFunctionSqlServerv2k5.appendStringWithSpace(buffer, ',');
        }
    }

    private void appendPartitionSchema(StringBuffer buffer, PartitionFunctionSqlServerv2k5 partFunc, boolean prettyPrint) {
        Iterator it = partFunc.getPartitionScheme().iterator();
        SSBPartitionSchemeSqlServerv2k5 ssbPartSchema = new SSBPartitionSchemeSqlServerv2k5();
        ssbPartSchema.setStorageDesign(this.getStorageDesign());
        while (it.hasNext()) {
            PartitionSchemeSqlServerv2k5 partSchema = (PartitionSchemeSqlServerv2k5)it.next();
            if (!ssbPartSchema.canHandle(partSchema)) continue;
            ssbPartSchema.doAppend(buffer, partSchema, prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof PartitionFunctionSqlServerv2k5 && ((PartitionFunctionSqlServerv2k5)object).getDatabase() != null && ((PartitionFunctionSqlServerv2k5)object).isMarkedGenerate();
    }
}

