/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v81.SSBTableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DataBaseUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseUDBv81
extends AbstractSSBUDB {
    public static final String USING_CODESET = "USING CODESET";
    public static final String TERRITORY = "TERRITORY";
    public static final String COLLATE_USING = "COLLATE USING";
    public static final String NUMSEGS = "NUMSEGS";
    public static final String DEFAULT_EXTENT_SIZE = "DFT_EXTENT_SZ";
    public static final String CATALOG_TABLESPACE = "CATALOG TABLESPACE";
    public static final String USER_TABLESPACE = "USER TABLESPACE";
    public static final String TEMP_TABLESPACE = "TEMPORARY TABLESPACE";
    public static final String AUTOCONFIGURE = "AUTOCONFIGURE";
    public static final String WITHSTR = "WITH";
    public static final String APPLY = "APPLY";
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseUDBv81 && ((DataBaseUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DataBaseUDBv81 database = (DataBaseUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendCreate(buffer, database);
        this.appendAutomaticStorage(buffer, database, prettyPrint);
        this.appendOnPath(buffer, database, prettyPrint);
        this.appendAlias(buffer, database, prettyPrint);
        this.appendUsingCodesetTerritory(buffer, database, prettyPrint);
        this.appendCollateUsing(buffer, database, prettyPrint);
        this.appendNumsegs(buffer, database, prettyPrint);
        this.appendDefaultExtentSize(buffer, database, prettyPrint);
        this.appendCatalogTableSpace(buffer, database, prettyPrint);
        this.appendUserTableSpace(buffer, database, prettyPrint);
        this.appendTemporaryTableSpace(buffer, database, prettyPrint);
        if (database.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendWith(buffer, database, prettyPrint);
        }
        this.appendAutoConfigure(buffer, database, prettyPrint);
        SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBDataBaseUDBv81.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateDatabase();
    }

    protected void appendCreate(StringBuffer buffer, DataBaseUDBv81 database) {
        this.appendCreate(buffer);
        SSBDataBaseUDBv81.appendStringWithSpace(buffer, "DATABASE");
        SSBDataBaseUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(database.getName()));
    }

    protected void appendAutomaticStorage(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (!database.getAutomaticStorage().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, "AUTOMATIC");
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, "STORAGE");
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getAutomaticStorage());
        }
    }

    protected void appendOnPath(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (!database.getOnPath().equals("")) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, "ON");
            StringTokenizer paths = new StringTokenizer(database.getOnPath(), ",");
            int num = paths.countTokens();
            for (int i = 0; i < num; ++i) {
                SSBDataBaseUDBv81.appendString(buffer, '\'');
                SSBDataBaseUDBv81.appendString(buffer, paths.nextToken().trim());
                SSBDataBaseUDBv81.appendString(buffer, '\'');
                if (i < num - 1) {
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, ",");
                    continue;
                }
                SSBDataBaseUDBv81.appendSpace(buffer);
            }
            if (!database.getDBPathOn().equals("")) {
                SSBDataBaseUDBv81.appendStringWithSpace(buffer, "DBPATH");
                SSBDataBaseUDBv81.appendStringWithSpace(buffer, "ON");
                SSBDataBaseUDBv81.appendString(buffer, '\'');
                SSBDataBaseUDBv81.appendString(buffer, database.getDBPathOn());
                SSBDataBaseUDBv81.appendStringWithSpace(buffer, '\'');
            }
        }
    }

    protected void appendAlias(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (!database.getAlias().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, "ALIAS");
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getAlias());
        }
    }

    protected void appendUsingCodesetTerritory(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (!database.getCodeSet().equalsIgnoreCase("") && !database.getTerritory().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, USING_CODESET);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getCodeSet());
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, TERRITORY);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getTerritory());
        }
    }

    protected void appendCollateUsing(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (!database.getCollatingSequence().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, COLLATE_USING);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getCollatingSequence());
        }
    }

    protected void appendNumsegs(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (database.getSegmentNumber() > 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, NUMSEGS);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getSegmentNumber());
        }
    }

    protected void appendDefaultExtentSize(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (database.getDefaultExtentSize() > 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, DEFAULT_EXTENT_SIZE);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getDefaultExtentSize());
        }
    }

    protected void appendCatalogTableSpace(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (database.getCatalogTableSpace() != null && !database.getCatalogTableSpace().isNullInstance() && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, CATALOG_TABLESPACE);
            this.appendTableSpaceDefinition(buffer, (TableSpaceUDBv81)database.getCatalogTableSpace(), prettyPrint);
        }
    }

    protected void appendUserTableSpace(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (database.getUserTableSpace() != null && !database.getUserTableSpace().isNullInstance()) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, USER_TABLESPACE);
            this.appendTableSpaceDefinition(buffer, (TableSpaceUDBv81)database.getUserTableSpace(), prettyPrint);
        }
    }

    protected void appendTemporaryTableSpace(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (database.getTemporaryTableSpace() != null && !database.getTemporaryTableSpace().isNullInstance()) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, TEMP_TABLESPACE);
            this.appendTableSpaceDefinition(buffer, (TableSpaceUDBv81)database.getTemporaryTableSpace(), prettyPrint);
        }
    }

    protected void appendAutoConfigure(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (database.getAutoConfigure() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, AUTOCONFIGURE);
            if (database.getUseAdminProperty() || database.getUseBpResizeable() || database.getUseIsolation() || database.getUseMemPercent() || database.getUseNumLocalApps() || database.getUseNumRemoteApps() || database.getUseNumStmts() || database.getUseTpm() || database.getUseWorkloadType()) {
                SSBDataBaseUDBv81.appendStringWithSpace(buffer, "USING");
                if (database.getUseAdminProperty()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "admin_property");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getAdminProperty());
                }
                if (database.getUseBpResizeable()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "bp_resizeable");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getBpResizeable());
                }
                if (database.getUseIsolation()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "isolation");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getIsolation());
                }
                if (database.getUseMemPercent()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "mem_percent");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getMemPercent());
                }
                if (database.getUseNumLocalApps()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "num_local_apps");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getNumLocalApps());
                }
                if (database.getUseNumRemoteApps()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "num_remote_apps");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getNumRemoteApps());
                }
                if (database.getUseNumStmts()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "num_stmts");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getNumStmts());
                }
                if (database.getUseTpm()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "tpm");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getTpm());
                }
                if (database.getUseWorkloadType()) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, "workload_type");
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getWorkloadType());
                }
                if ("".equalsIgnoreCase(database.getApplyChanges().trim())) {
                    SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, APPLY);
                    SSBDataBaseUDBv81.appendStringWithSpace(buffer, database.getApplyChanges());
                }
            }
        }
    }

    private void appendTableSpaceDefinition(StringBuffer buffer, TableSpaceUDBv81 tablespace, boolean prettyPrint) {
        SSBTableSpaceUDBv81 ssbTableSpace = new SSBTableSpaceUDBv81();
        ssbTableSpace.appendManagedBy(buffer, tablespace);
        ssbTableSpace.appendUsingContainer(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendExtentSize(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendPrefetchSize(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendOverhead(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendTransferRate(buffer, tablespace, prettyPrint);
        ssbTableSpace.appendDroppedTableRecovery(buffer, tablespace, prettyPrint);
    }

    protected void appendWith(StringBuffer buffer, DataBaseUDBv81 database, boolean prettyPrint) {
        if (!database.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(buffer, WITHSTR);
            SSBDataBaseUDBv81.appendString(buffer, '\"');
            SSBDataBaseUDBv81.appendString(buffer, database.getCommentInRDBMS());
            SSBDataBaseUDBv81.appendString(buffer, '\"');
        }
    }
}

