/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class RSMappings
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_MAPPINGS (Logical_Model_ID, Logical_Model_OVID, Logical_Model_Name, Logical_Object_ID, Logical_Object_OVID, Logical_Object_Name, Logical_Object_Type, Relational_Model_ID, Relational_Model_OVID, Relational_Model_Name, Relational_Object_ID, Relational_Object_OVID, Relational_Object_Name, Relational_Object_Type, Entity_ID, Entity_OVID, Entity_Name, Table_ID, Table_OVID, Table_Name, Design_ID, Design_OVID, Design_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ArrayList allMappings = new ArrayList();
        allMappings.addAll(design.getExtendedMap().getAllMappings());
        for (RelationalDesign rd : design.getRelationalDesigns()) {
            if (!rd.isLoaded()) continue;
            allMappings.addAll(rd.getRMExtendedMap().getAllMappings());
        }
        for (XtdMapping xtdMap : allMappings) {
            DesignObject relObj;
            DesignObject logicalObj;
            if (xtdMap.isDeleted()) continue;
            if (xtdMap.getOwnerDesignPart() instanceof LogicalDesign) {
                logicalObj = xtdMap.getOwnerObject();
                relObj = xtdMap.getTargetObject();
            } else {
                logicalObj = xtdMap.getTargetObject();
                relObj = xtdMap.getOwnerObject();
            }
            if (logicalObj == null || (String)map.get(logicalObj.getObjectID()) == null || relObj == null || (String)map.get(relObj.getObjectID()) == null) {
                System.out.println(xtdMap);
                continue;
            }
            stmt.setString(1, logicalObj.getDesignPart().getObjectID());
            stmt.setString(2, (String)map.get(logicalObj.getDesignPart().getObjectID()));
            stmt.setString(3, logicalObj.getDesignPart().getName());
            stmt.setString(4, logicalObj.getObjectID());
            stmt.setString(5, (String)map.get(logicalObj.getObjectID()));
            stmt.setString(6, logicalObj.getName());
            stmt.setString(7, logicalObj.getObjectTypeName());
            stmt.setString(8, relObj.getDesignPart().getObjectID());
            stmt.setString(9, (String)map.get(relObj.getDesignPart().getObjectID()));
            stmt.setString(10, relObj.getDesignPart().getName());
            stmt.setString(11, relObj.getObjectID());
            stmt.setString(12, (String)map.get(relObj.getObjectID()));
            stmt.setString(13, relObj.getName());
            stmt.setString(14, relObj.getObjectTypeName());
            if (logicalObj instanceof Entity) {
                stmt.setString(15, logicalObj.getObjectID());
                stmt.setString(16, (String)map.get(logicalObj.getObjectID()));
                stmt.setString(17, logicalObj.getName());
            } else if (logicalObj instanceof EntityView) {
                stmt.setString(15, logicalObj.getObjectID());
                stmt.setString(16, (String)map.get(logicalObj.getObjectID()));
                stmt.setString(17, null);
            } else if (logicalObj instanceof Attribute) {
                stmt.setString(15, ((Attribute)logicalObj).getContainer().getObjectID());
                stmt.setString(16, (String)map.get(((Attribute)logicalObj).getContainer().getObjectID()));
                stmt.setString(17, ((Attribute)logicalObj).getContainer().getName());
            } else if (logicalObj instanceof CandidateKey) {
                stmt.setString(15, ((CandidateKey)logicalObj).getContainerObject().getObjectID());
                stmt.setString(16, (String)map.get(((CandidateKey)logicalObj).getContainerObject().getObjectID()));
                stmt.setString(17, ((CandidateKey)logicalObj).getContainerObject().getName());
            } else if (logicalObj instanceof Relation) {
                stmt.setString(15, ((Relation)logicalObj).getTargetEntity().getObjectID());
                stmt.setString(16, (String)map.get(((Relation)logicalObj).getTargetEntity().getObjectID()));
                stmt.setString(17, ((Relation)logicalObj).getTargetEntity().getName());
            } else if (logicalObj instanceof Arc && ((Arc)logicalObj).getEntity() != null) {
                stmt.setString(15, ((Arc)logicalObj).getEntity().getObjectID());
                stmt.setString(16, (String)map.get(((Arc)logicalObj).getEntity().getObjectID()));
                stmt.setString(17, ((Arc)logicalObj).getEntity().getName());
            } else {
                stmt.setString(15, null);
                stmt.setString(16, null);
                stmt.setString(17, null);
            }
            if (relObj instanceof Table) {
                stmt.setString(18, relObj.getObjectID());
                stmt.setString(19, (String)map.get(relObj.getObjectID()));
                stmt.setString(20, relObj.getName());
            } else if (relObj instanceof TableView) {
                stmt.setString(18, relObj.getObjectID());
                stmt.setString(19, (String)map.get(relObj.getObjectID()));
                stmt.setString(20, null);
            } else if (relObj instanceof Column) {
                stmt.setString(18, ((Column)relObj).getContainer().getObjectID());
                stmt.setString(19, (String)map.get(((Column)relObj).getContainer().getObjectID()));
                stmt.setString(20, ((Column)relObj).getContainer().getName());
            } else if (relObj instanceof Index) {
                stmt.setString(18, ((Index)relObj).getContainerObject().getObjectID());
                stmt.setString(19, (String)map.get(((Index)relObj).getContainerObject().getObjectID()));
                stmt.setString(20, ((Index)relObj).getContainerObject().getName());
            } else if (relObj instanceof FKIndexAssociation) {
                stmt.setString(18, ((FKIndexAssociation)relObj).getTable().getObjectID());
                stmt.setString(19, (String)map.get(((FKIndexAssociation)relObj).getTable().getObjectID()));
                stmt.setString(20, ((FKIndexAssociation)relObj).getTable().getName());
            } else if (relObj instanceof FKArc && ((FKArc)relObj).getTable() != null) {
                stmt.setString(18, ((FKArc)relObj).getTable().getObjectID());
                stmt.setString(19, (String)map.get(((FKArc)relObj).getTable().getObjectID()));
                stmt.setString(20, ((FKArc)relObj).getTable().getName());
            } else {
                stmt.setString(18, null);
                stmt.setString(19, null);
                stmt.setString(20, null);
            }
            stmt.setString(21, design.getObjectID());
            stmt.setString(22, (String)map.get(design.getObjectID()));
            stmt.setString(23, design.getName());
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

