/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;

public class RSRDBMSSites
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_RDBMS_SITES (Site_Name, Site_ID, Site_OVID, RDBMS_Type, Design_OVID) VALUES (?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = design.getRDBMSSiteSet().iterator();
        while (it.hasNext()) {
            RDBMSSite site = (RDBMSSite)it.next();
            stmt.setString(1, site.getName());
            stmt.setString(2, site.getObjectID());
            stmt.setString(3, RSRDBMSSites.getOrCreateOVID(map, site.getObjectID()));
            stmt.setInt(4, site.getType().getType());
            stmt.setString(5, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

