/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.Role;

public class RSRoles
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Role> list = new ArrayList<Role>(1000);
        int count = 0;
        ArrayList<Role> rolesCollection = new ArrayList<Role>();
        String query = "INSERT INTO DMRS_ROLES (Role_ID, Role_OVID, Role_Name, Model_ID, Model_OVID, Model_Name, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getRoleSet().iterator();
        while (it.hasNext()) {
            Role role2 = (Role)it.next();
            String roleOVID = RSRoles.getOrCreateOVID(map, role2.getObjectID());
            rolesCollection.add(role2);
            stmt.setString(1, role2.getObjectID());
            stmt.setString(2, roleOVID);
            stmt.setString(3, role2.getName());
            stmt.setString(4, processModel.getObjectID());
            stmt.setString(5, (String)map.get(processModel.getObjectID()));
            stmt.setString(6, processModel.getName());
            stmt.setString(7, role2.getDescription());
            stmt.setString(8, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(role2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Role role2 : list) {
                RSObjectNotes.export(map, connection, role2);
                RSComments.export(map, connection, role2);
                RSDynamicProperties.export(design, map, connection, role2);
            }
            list.clear();
        }
        RSRoles.exportProcesses(map, connection, rolesCollection, design);
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Role role : list) {
                RSObjectNotes.export(map, connection, role);
                RSComments.export(map, connection, role);
                RSDynamicProperties.export(design, map, connection, role);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportProcesses(Map map, Connection connection, List roles, Design design) throws Exception {
        int count = 0;
        String procQuery = "INSERT INTO DMRS_ROLE_PROCESSES (Role_ID, Role_OVID, Role_Name, Process_ID, Process_OVID, Process_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement procStmt = connection.prepareStatement(procQuery);
        for (Role role : roles) {
            for (Process proc : role.getProcesses()) {
                String procOVID = (String)map.get(proc.getObjectID());
                procStmt.setString(1, role.getObjectID());
                procStmt.setString(2, (String)map.get(role.getObjectID()));
                procStmt.setString(3, role.getName());
                procStmt.setString(4, proc.getObjectID());
                procStmt.setString(5, procOVID);
                procStmt.setString(6, proc.getName());
                procStmt.setString(7, (String)map.get(design.getObjectID()));
                procStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                procStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            procStmt.executeBatch();
        }
        procStmt.close();
        procStmt = null;
    }
}

