/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSTransformationFlows
extends RSGeneral {
    public static void export(Map map, Connection connection, TransformationTask transformTask) throws Exception {
        ArrayList<TransformationFlow> list = new ArrayList<TransformationFlow>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_TRANSFORMATION_FLOWS (Transformation_Flow_ID, Transformation_Flow_OVID, Transformation_Flow_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = transformTask.getFlowSet().iterator();
        while (it.hasNext()) {
            TransformationFlow transformFlow2 = (TransformationFlow)it.next();
            String transformFlowOVID = RSTransformationFlows.getOrCreateOVID(map, transformFlow2.getObjectID());
            AbstractProcessObject src = transformFlow2.getSource();
            AbstractProcessObject dest = transformFlow2.getDestination();
            stmt.setString(1, transformFlow2.getObjectID());
            stmt.setString(2, transformFlowOVID);
            stmt.setString(3, transformFlow2.getName());
            stmt.setString(4, transformTask.getObjectID());
            stmt.setString(5, (String)map.get(transformTask.getObjectID()));
            stmt.setString(6, transformTask.getName());
            if (src != null) {
                stmt.setString(7, src.getObjectID());
                stmt.setString(8, RSTransformationFlows.getOrCreateOVID(map, src.getObjectID()));
                stmt.setString(9, src.getName());
                stmt.setString(13, src.getObjectTypeName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
                stmt.setString(13, null);
            }
            if (dest != null) {
                stmt.setString(10, dest.getObjectID());
                stmt.setString(11, RSTransformationFlows.getOrCreateOVID(map, dest.getObjectID()));
                stmt.setString(12, dest.getName());
                stmt.setString(14, dest.getObjectTypeName());
            } else {
                stmt.setString(10, null);
                stmt.setString(11, null);
                stmt.setString(12, null);
                stmt.setString(14, null);
            }
            stmt.setString(15, transformFlow2.getSystemObjective());
            stmt.setString(16, transformFlow2.isLogging() ? "Y" : "N");
            stmt.setString(17, transformFlow2.isOpCreate() ? "Y" : "N");
            stmt.setString(18, transformFlow2.isOpRead() ? "Y" : "N");
            stmt.setString(19, transformFlow2.isOpUpdate() ? "Y" : "N");
            stmt.setString(20, transformFlow2.isOpDelete() ? "Y" : "N");
            Object crud = "";
            if (transformFlow2.isOpCreate()) {
                crud = "C";
            }
            if (transformFlow2.isOpRead()) {
                crud = (String)crud + "R";
            }
            if (transformFlow2.isOpUpdate()) {
                crud = (String)crud + "U";
            }
            if (transformFlow2.isOpDelete()) {
                crud = (String)crud + "D";
            }
            stmt.setString(21, (String)crud);
            stmt.setString(22, (String)map.get(transformTask.getDesign().getObjectID()));
            stmt.addBatch();
            list.add(transformFlow2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (TransformationFlow transformFlow2 : list) {
                RSObjectNotes.export(map, connection, transformFlow2);
                RSComments.export(map, connection, transformFlow2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (TransformationFlow transformFlow : list) {
                RSObjectNotes.export(map, connection, transformFlow);
                RSComments.export(map, connection, transformFlow);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

