/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.swingui.search.ModifiedFlowLayout;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractPinnablePanel
extends JPanel {
    protected int PIN_CMD_ID = 68;
    protected int NULL_CMD_ID = -123456;
    protected boolean m_isPinned = false;
    protected ToggleToolButton _pinToggle;
    private WorksheetState m_state = WorksheetState.CLOSED;
    private String m_id = null;
    private static final long serialVersionUID = 1L;
    protected Toolbar _toolbar;
    private WorksheetContext m_ctx;
    private Icon overlayIcon = null;

    public AbstractPinnablePanel(String id) {
        this.m_id = id;
        this.setLayout(new BorderLayout());
    }

    public JComponent getGUI() {
        return this;
    }

    public WorksheetState getState() {
        return this.m_state;
    }

    public boolean isCloseable() {
        return true;
    }

    public void setState(WorksheetState state) {
        this.m_state = state;
    }

    protected void initToolbar() {
        if (this.m_id == null) {
            return;
        }
        this._toolbar = new Toolbar();
        this._toolbar.setLayout((LayoutManager)new ModifiedFlowLayout(0));
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        this.add((Component)this._toolbar, "North");
        if (this.PIN_CMD_ID != this.NULL_CMD_ID && this.isCloseable()) {
            Icon icon = this.m_isPinned ? RaptorImagesArb.getIcon((String)"PINNED") : OracleIcons.getIcon((String)"pin.png");
            ToggleAction pinAction = new ToggleAction(Messages.getString("AbstractPinnablePanel.Pin"), icon){

                public void actionPerformed(ActionEvent e) {
                    Icon icon = AbstractPinnablePanel.this.m_isPinned ? OracleIcons.getIcon((String)"pin.png") : RaptorImagesArb.getIcon((String)"PINNED");
                    AbstractPinnablePanel.this._pinToggle.setIcon(icon);
                    AbstractPinnablePanel.this.m_isPinned = !AbstractPinnablePanel.this.m_isPinned;
                }
            };
            this._pinToggle = this._toolbar.addToggleButton(pinAction);
            pinAction.setState(this.isPinned());
            this._pinToggle.setIcon(icon);
        }
        this._toolbar.addSeparator();
    }

    public boolean isPinned() {
        return this.m_isPinned;
    }

    public void setPinned(boolean isPinned) {
        if (this._pinToggle.isSelected() && !isPinned) {
            this._pinToggle.doClick();
        } else if (!this._pinToggle.isSelected() && isPinned) {
            this._pinToggle.doClick();
        }
    }

    public String getID() {
        return this.m_id;
    }

    public String getLastStatusMessage() {
        return null;
    }

    public void publishStatusMessage(String message, Exception e) {
    }

    public void registerConsumer(IStatusMessageConsumer consumer) {
    }

    public void setStatusMessage(String message, Exception e) {
    }

    public WorksheetContext getContext() {
        return this.m_ctx;
    }

    public void setContext(WorksheetContext ctx) {
        this.m_ctx = ctx;
    }

    public Icon getTabIcon() {
        return this.overlayIcon;
    }

    public void setOverlayIcon(Icon overlayIcon) {
        this.overlayIcon = overlayIcon;
    }
}

