/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.plSqlSourceEditors;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlSourceURLConnection;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlSourceUrlFileSystemHelper;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.net.URLFactory;

public abstract class PlSqlSourceURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger LOGGER = new Logger(PlSqlSourceURLStreamHandlerFactory.class);

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.getUrlFileSystemHelper().getProtocol().equals(protocol)) {
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) {
                    RelationalDesign relationalDesign = (RelationalDesign)ApplicationView.getInstance().getCurrentDesign().getRelationalDesigns().getById(url.getHost());
                    StorageObjectSet storageObjectSet = PlSqlSourceURLStreamHandlerFactory.this.getStorageObjectSet((StorageDesignOracle)relationalDesign.getStorageDesign());
                    return new PlSqlSourceURLConnection(url, (PlSqlSourceStorageObjectOracle)storageObjectSet.getById(url.getFile()));
                }
            };
        }
        return null;
    }

    public static URL generateUrl(String protocol, PlSqlSourceStorageObjectOracle storageObject) {
        URL url = URLFactory.newURL((String)protocol, null, (String)storageObject.getStorageDesign().getPhysicalDesign().getObjectID(), (int)-1, (String)storageObject.getObjectID(), null, null);
        Object filePath = null;
        filePath = url != null ? url.toExternalForm() : "";
        if (((String)filePath).startsWith("file://") && ((String)filePath).charAt(7) != '/') {
            filePath = ((String)filePath).substring(0, 7) + File.separator + ((String)filePath).substring(7);
        }
        try {
            url = new URL((String)filePath);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e);
        }
        return url;
    }

    protected abstract PlSqlSourceUrlFileSystemHelper getUrlFileSystemHelper();

    protected abstract StorageObjectSet getStorageObjectSet(StorageDesignOracle var1);
}

