/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelSynchronizationPhysicalOraclePreferences;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class ModelSynchronizationPhysicalOraclePP
extends AbstractPP {
    private static final String DIALOG_NAME = Messages.getString("OptionsDialog.NameElementProvider");
    private JTable itemsTable;
    private List itemsList = new ArrayList();
    private JCheckBox cbPartitions;
    private JCheckBox cbTriggers;
    private JCheckBox cbStructuredTypesScan;
    private JCheckBox cbSecondaryTables;
    private JCheckBox cbSpatialProperties;

    public ModelSynchronizationPhysicalOraclePP() {
        this.setHelpID("MODEL_SYNC_PHYSICAL_ORACLE");
        JPanel main = new JPanel(new GridBagLayout());
        this.itemsTable = new JTable(new ItemsTableModel());
        JTableHeader header = this.itemsTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        TableColumn selectedColumn = this.itemsTable.getColumnModel().getColumn(1);
        selectedColumn.setPreferredWidth(150);
        selectedColumn.setMaxWidth(150);
        this.itemsTable.setSelectionMode(0);
        main.add((Component)new JScrollPane(this.itemsTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        JPanel pnOptions = new JPanel(new GridBagLayout());
        this.cbPartitions = new JCheckBox(Messages.getString("ModelSynchronizationPhysicalOraclePP.Partitions"));
        this.addItem(pnOptions, this.cbPartitions, 0, 0, 1, 1, 17, 1, 100);
        this.cbTriggers = new JCheckBox(Messages.getString("ModelSynchronizationPhysicalOraclePP.Triggers"));
        this.addItem(pnOptions, this.cbTriggers, 0, 1, 1, 1, 17, 1, 100);
        this.cbStructuredTypesScan = new JCheckBox(Messages.getString("ModelSynchronizationPhysicalOraclePP.ScanForUsedStructuredTypes"));
        this.addItem(pnOptions, this.cbStructuredTypesScan, 0, 2, 1, 1, 17, 1, 100);
        this.cbSecondaryTables = new JCheckBox(Messages.getString("ModelSynchronizationPhysicalOraclePP.SecondaryTables"));
        this.addItem(pnOptions, this.cbSecondaryTables, 0, 3, 1, 1, 17, 1, 100);
        this.cbSpatialProperties = new JCheckBox(Messages.getString("ModelSynchronizationPhysicalOraclePP.SpatialProperties"));
        this.addItem(pnOptions, this.cbSpatialProperties, 0, 4, 1, 1, 17, 1, 100);
        JPanel pnImportOptions = new JPanel(new GridBagLayout());
        pnImportOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelSynchronizationPhysicalOraclePP.ImportOptions")));
        pnImportOptions.add((Component)pnOptions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(main, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.add(pnImportOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        this.itemsList.clear();
        for (SyncObject so : settings.getSyncObjects()) {
            if (!so.getDatabase().equals("Oracle")) continue;
            this.itemsList.add(so);
        }
        this.itemsTable.updateUI();
        this.cbPartitions.setSelected(settings.isImportPartitions());
        this.cbTriggers.setSelected(settings.isImportTriggers());
        this.cbStructuredTypesScan.setSelected(settings.isScanForUsedStructuredTypes());
        this.cbSecondaryTables.setSelected(settings.isImportSecondaryTables());
        this.cbSpatialProperties.setSelected(settings.isImportSpatialProperties());
    }

    public void onExit(TraversableContext tc) {
        for (SyncObject so : this.itemsList) {
            SyncObject sObj = settings.getSyncObject(so.getType(), so.getDatabase());
            if (sObj == null) continue;
            sObj.setUsed(so.isUsed());
        }
        settings.setImportPartitions(this.cbPartitions.isSelected());
        settings.setImportTriggers(this.cbTriggers.isSelected());
        settings.setScanForUsedStructuredTypes(this.cbStructuredTypesScan.isSelected());
        settings.setImportSecondaryTables(this.cbSecondaryTables.isSelected());
        settings.setImportSpatialProperties(this.cbSpatialProperties.isSelected());
        ModelSynchronizationPhysicalOraclePreferences preferences = this.getModelSynchronizationPhysicalOraclePreferences(tc);
        preferences.rebuildHashStructure(settings);
        preferences.setImportPartitions(this.cbPartitions.isSelected());
        preferences.setImportTriggers(this.cbTriggers.isSelected());
        preferences.setScanForUsedStructuredTypes(this.cbStructuredTypesScan.isSelected());
        preferences.setImportSecondaryTables(this.cbSecondaryTables.isSelected());
        preferences.setImportSpatialProperties(this.cbSpatialProperties.isSelected());
    }

    @Override
    protected String getDialogName() {
        return DIALOG_NAME;
    }

    private ModelSynchronizationPhysicalOraclePreferences getModelSynchronizationPhysicalOraclePreferences(TraversableContext tc) {
        return ModelSynchronizationPhysicalOraclePreferences.getInstance(tc.getPropertyStorage());
    }

    class ItemsTableModel
    extends AbstractTableModel {
        ItemsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ModelSynchronizationPhysicalOraclePP.this.itemsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ModelSynchronizationPhysicalOraclePP.Type");
            }
            return Messages.getString("ModelSynchronizationPhysicalOraclePP.Synchronize");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SyncObject so = (SyncObject)ModelSynchronizationPhysicalOraclePP.this.itemsList.get(rowIndex);
            if (columnIndex == 0) {
                return so.getType();
            }
            if (columnIndex == 1) {
                return so.isUsed();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            SyncObject so = (SyncObject)ModelSynchronizationPhysicalOraclePP.this.itemsList.get(row);
            if (column == 1) {
                so.setUsed((Boolean)value);
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }
    }
}

