/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.git;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.GeneralStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationAdd;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationAddAll;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationCherryPick;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationCommit;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationCommitAll;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationCommitHistoryGraph;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationCommitVersionHistory;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationDiffBranch;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationExportUncommitted;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationMerge;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationPull;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationResolveConflict;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationRevert;
import oracle.dbtools.crest.fcp.vcs.git.DMGITStashCreateCommand;
import oracle.dbtools.crest.fcp.vcs.git.DMGitPullWizard;
import oracle.dbtools.crest.fcp.vcs.git.RepositoryRemove;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.XMLFromMapToSteramTransformer;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DMGitCellRenderer;
import oracle.dbtools.crest.swingui.DMGitRelPathCellRenderer;
import oracle.dbtools.crest.swingui.DMGitStringCellRenderer;
import oracle.dbtools.crest.swingui.DMGitStringConverter;
import oracle.dbtools.crest.util.TimeLog;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.URICache;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.commithistory.CommitVersionDockableWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModelEvent;
import oracle.jdeveloper.vcs.vop.VersionOperationModelListener;
import oracle.jdeveloper.vcs.vop.VersionOperationTablePanel;
import oracle.jdevimpl.vcs.generic.profile.StatusInfo;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITFileProtocolHelper;
import oracle.jdevimpl.vcs.git.GITHistoryEntryProducer;
import oracle.jdevimpl.vcs.git.GITOverlayItemProducer;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionDockableWindow;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitConflictDescriptor;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GitClientHelper {
    private static String SEARCH = ">>>>>>>";
    private static String SEARCH2 = "<<<<<<<";
    private static String SEARCH3 = "=======";
    static List<IdeAction> dmGitActions = new ArrayList<IdeAction>();
    private static ViewId gitPCWViewId = new ViewId("oracle-jdeveloper-git-PendingChangesWindow");
    public static String ADDED = "Added";
    public static String DELETED = "Deleted";
    public static String MODIFIED = "Modified";
    public static String RENAMED = "Renamed";
    public static String COPIED = "Copied";
    public static String UNKNOWN = "Unknown";
    static PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("model".equalsIgnoreCase(name)) {
                JComboBox cb = (JComboBox)evt.getSource();
                if (!ApplicationView.closing) {
                    GitClientHelper.replaceModel(cb);
                }
            }
        }
    };
    static ChangeListWindow.ScopeFilter ALL_APPS = null;
    static ChangeListWindow.ScopeFilter ACTIVE_APP = null;
    static ChangeListWindow GIT_ChangeListWindow = null;
    static JComboBox SCOPE_CB = null;
    static Observer PROJECT_OBSERVER = new Observer(){

        public void update(Object observed, UpdateMessage change) {
            Object obj;
            if (change.getMessageID() == IdeConstants.ACTIVE_PROJECT_CHANGED && SCOPE_CB != null && GIT_ChangeListWindow != null && ACTIVE_APP != null && (obj = SCOPE_CB.getSelectedItem()) != null && obj instanceof DMScopeFilter) {
                DMScopeFilter f = (DMScopeFilter)((Object)obj);
                if (!f.isActiveApp()) {
                    return;
                }
                Workspace workspace = (Workspace)change.getModifyObjects().get(1);
                if (workspace == f.workspace) {
                    return;
                }
                GitClientHelper.setWorkspace(ACTIVE_APP, workspace);
                f.workspace = workspace;
                GitClientHelper.clearStatusCache();
                if (!ApplicationView.closing) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            GIT_ChangeListWindow.refresh();
                        }
                    });
                }
            }
        }
    };
    public static String MODELER_PATHS = "data_modeler_paths";
    private static DMVersionOperationModelListener versionOperationModelListener = null;
    public static boolean isChangeListModelListenerAdded = false;

    public static void main(String[] args) {
    }

    public static void doRemove(List<String> fileNames) {
        if (!fileNames.isEmpty()) {
            ArrayList<File> list = new ArrayList<File>();
            for (String fileName : fileNames) {
                File filePath = new File(fileName);
                if (!filePath.exists()) continue;
                list.add(filePath);
            }
            if (list.size() > 0) {
                GITFileProtocolHelper fh = new GITFileProtocolHelper();
                for (File f : list) {
                    try {
                        URL url = f.toURI().toURL();
                        fh.delete(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void doRemove(File[] files) {
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            if (!f.exists()) continue;
            list.add(f);
        }
        if (list.size() > 0) {
            GITFileProtocolHelper fh = new GITFileProtocolHelper();
            for (File f : list) {
                try {
                    URL url = f.toURI().toURL();
                    fh.delete(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void attachRenderersToGitHistory() {
        try {
            ViewId hist = new ViewId("GIT-Commit-Version");
            Dockable gitPCWDocable = DockStation.getDockStation().findDockable(hist);
            if (gitPCWDocable != null && gitPCWDocable instanceof GITCommitVersionDockableWindow) {
                Field cf = CommitVersionDockableWindow.class.getDeclaredField("_commitDetail");
                cf.setAccessible(true);
                Object cfValue = cf.get(gitPCWDocable);
                if (cfValue instanceof CommitVersionDockableWindow.CommitDetail) {
                    Field field = CommitVersionDockableWindow.CommitDetail.class.getDeclaredField("_table");
                    field.setAccessible(true);
                    Object fieldValue = field.get(cfValue);
                    if (fieldValue instanceof JTable) {
                        JTable table = (JTable)fieldValue;
                        ((JTable)fieldValue).setDefaultRenderer(String.class, new DMGitRelPathCellRenderer((GITCommitVersionDockableWindow)gitPCWDocable));
                        table.getColumnModel().getColumn(1).setCellRenderer(new DMGitRelPathCellRenderer((GITCommitVersionDockableWindow)gitPCWDocable));
                        RowSorter<? extends TableModel> rs = table.getRowSorter();
                        if (rs != null && rs instanceof TableRowSorter) {
                            TableRowSorter trs = (TableRowSorter)rs;
                            TableStringConverter sc = trs.getStringConverter();
                            if (!(sc instanceof DMGitStringConverter)) {
                                TableRowSorter n = new TableRowSorter(table.getModel()){

                                    @Override
                                    protected boolean useToString(int column) {
                                        return true;
                                    }
                                };
                                n.setStringConverter(new DMGitStringConverter());
                                table.setRowSorter(n);
                            }
                        } else if (rs == null) {
                            TableRowSorter n = new TableRowSorter(table.getModel()){

                                @Override
                                protected boolean useToString(int column) {
                                    return true;
                                }
                            };
                            n.setStringConverter(new DMGitStringConverter());
                            table.setRowSorter(n);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void replaceGitActions() {
        IdeAction action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.revert"));
        if (action != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationRevert.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.commit-history"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationCommitVersionHistory.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.commit"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationCommit.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.commit-all"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationCommitAll.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.add"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationAdd.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.addall"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationAddAll.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.history-graph"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationCommitHistoryGraph.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.diff-branch"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationDiffBranch.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.stash-create"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITStashCreateCommand.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.export-uncommitted"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationExportUncommitted.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.resolve-conflict"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationResolveConflict.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.merge"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationMerge.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.pull"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationPull.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)Ide.findCmdID((String)"oracle.jdeveloper.git.cherrypick"))) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), DMGITOperationCherryPick.class.getName()));
            dmGitActions.add(action);
        }
        if ((action = IdeAction.get((int)RepositoryRemove.CMD)) != null) {
            action.setEnabled(true);
            action.setCommand(new MetaClass(DataModelerAddin.class.getClassLoader(), RepositoryRemove.class.getName()));
        }
    }

    public static void resetGitActions(Action[] actions) {
        for (Action act : actions) {
            IdeAction action;
            IdeAction dmAction;
            if (!(act instanceof IdeAction) || (dmAction = GitClientHelper.findAction((action = (IdeAction)act).getCommandId(), dmGitActions)) == null) continue;
            action.setCommand(dmAction.getCommandMetaClass());
        }
    }

    private static IdeAction findAction(int id, List<IdeAction> actions) {
        for (IdeAction action : actions) {
            if (id != action.getCommandId()) continue;
            return action;
        }
        return null;
    }

    public static Pair<String, File> getPreviousCommitId(GitClient client, File file, String commitId, GITCommandProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        SearchCriteria sc = new SearchCriteria();
        sc.setRevisionTo(commitId);
        sc.setFiles(new File[]{file});
        sc.setFollowRenames(true);
        sc.setLimit(2);
        GitRevisionInfo[] info = client.log(sc, (ProgressMonitor)monitor);
        if (info.length != 2) {
            return null;
        }
        Map files = info[0].getModifiedFiles();
        GitRevisionInfo.GitFileInfo fileInfo = (GitRevisionInfo.GitFileInfo)files.get(file);
        return new Pair((Object)info[1].getRevision(), (Object)(fileInfo.getOriginalFile() != null ? fileInfo.getOriginalFile() : file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getObjectName(URL url, File file, String operation, String commitID) {
        String name = null;
        if (commitID != null && !commitID.isEmpty()) {
            GitClient client = null;
            try {
                InputStream is;
                GITCommandProgressMonitor monitor;
                Pair<String, File> previous;
                String cid = commitID;
                if ("Delete".equalsIgnoreCase(operation) && (previous = GitClientHelper.getPreviousCommitId(client = GITClientAdaptor.getClient((URL)url), file, commitID, monitor = new GITCommandProgressMonitor("catFile"))) != null) {
                    cid = (String)previous.getFirst();
                }
                if ((is = GITHistoryEntryProducer.openInputStream((URL)url, (String)cid)) == null) return name;
                byte[] b = new byte[1000];
                is.read(b, 0, 300);
                String s = new String(b, Charset.forName("UTF-8"));
                name = GitClientHelper.getNameFromXML(s);
                is.close();
                return name;
            }
            catch (Exception cid) {
                return name;
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
        InputStream is = null;
        try {
            is = GITHistoryEntryProducer.openInputStream((URL)url, (String)"HEAD");
            if (is == null) return name;
            byte[] b = new byte[1000];
            is.read(b, 0, 300);
            String s = new String(b, Charset.forName("UTF-8"));
            name = GitClientHelper.getNameFromXML(s);
            is.close();
            return name;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public static String getNameFromXML(String xml) {
        String part;
        String p = " name=\"";
        int ind = xml.indexOf(p);
        if (ind > 0 && (ind = (part = xml.substring(ind + p.length())).indexOf(34)) > 0) {
            return part.substring(0, ind);
        }
        return null;
    }

    public static String getClassFromXML(String xml) {
        String part;
        String p = " class=\"";
        int ind = xml.indexOf(p);
        if (ind > 0 && (ind = (part = xml.substring(ind + p.length())).indexOf(34)) > 0) {
            return part.substring(0, ind);
        }
        return null;
    }

    public static String getClassFromXMLFile(File file) {
        String part;
        String p;
        int ind;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        String xml = null;
        if (is != null) {
            byte[] b = new byte[1000];
            try {
                ((InputStream)is).read(b, 0, 300);
                xml = new String(b, Charset.forName("UTF-8"));
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (xml != null && (ind = xml.indexOf(p = " class=\"")) > 0 && (ind = (part = xml.substring(ind + p.length())).indexOf(34)) > 0) {
            return part.substring(0, ind);
        }
        return null;
    }

    public static String getNameFromXMLFile(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        String xml = null;
        if (is != null) {
            byte[] b = new byte[1000];
            try {
                ((InputStream)is).read(b, 0, 300);
                xml = new String(b, Charset.forName("UTF-8"));
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (xml != null) {
            return GitClientHelper.getNameFromXML(xml);
        }
        return null;
    }

    public static void postProcessRevert(URL[] urls, VCSStatus[] status) {
        if (urls.length > 0) {
            ArrayList<VersioningTreeNode> list = new ArrayList<VersioningTreeNode>();
            for (int i = 0; i < urls.length; ++i) {
                String stat;
                URL url = urls[i];
                Design d = ApplicationView.getInstance().getDesignForURL(url);
                if (d == null) continue;
                File file = new File(URLFileSystem.getPath((URL)url));
                String text = status[i].getOverlay().getShortLabel();
                if (status[i] instanceof StatusInfo) {
                    text = ((StatusInfo)status[i]).getID();
                }
                if ("PENDING".equalsIgnoreCase(stat = StorableObjectStatus.translateVCS_StatusInfo(text))) {
                    stat = "M";
                }
                GeneralStorableObjectStatus st = new GeneralStorableObjectStatus(d, file, stat);
                VersioningTreeNode node = new VersioningTreeNode(st);
                list.add(node);
            }
            VersioningTreeNode.refresh(list, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToGit(Design design) {
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File file = new File(new File(path), name + ".dmd");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)dir.toURI().toURL());
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Add design to Git - " + dir.getPath());
            client.add(new File[]{file, dir}, (ProgressMonitor)monitor);
        }
        catch (MalformedURLException | GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public static void commitDesign(Design design) {
        GitClientHelper.commitDesign(design, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commitDesign(Design design, String message) {
        Object mes = "Initial commit of design " + design.getName();
        if (message != null && !message.trim().isEmpty()) {
            mes = message;
        }
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File file = new File(new File(path), name + ".dmd");
        File gitIgnore = new File(new File(path), ".gitignore");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)dir.toURI().toURL());
            GitUser user = client.getUser();
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Commit design to Git - " + dir.getPath());
            client.commit(new File[]{gitIgnore, file, dir}, (String)mes, user, user, (ProgressMonitor)monitor);
            GitClientHelper.clearStatusCache(design);
        }
        catch (MalformedURLException | GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveMergeConflict(URL url, byte[] bytes) {
        GitClient client = null;
        if (bytes.length > 0) {
            try {
                client = GITClientAdaptor.getClient((URL)url);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Resolve merge conflict - checkout HEAD, write new content, clear temp files");
                File file = new File(url.getPath());
                File[] files = new File[]{file};
                client.checkout(files, "HEAD", false, (ProgressMonitor)monitor);
                try {
                    GitClientHelper.writeBytesToFile(bytes, file.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                GitClientHelper.removeGitTempFiles(file);
                client.add(files, (ProgressMonitor)monitor);
                if (monitor.getError() != null) {
                    // empty if block
                }
                VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
                profile.getPolicyStatusCache().clear(url);
                GITOverlayItemProducer.clearVersion((URL[])new URL[]{url});
            }
            catch (GitException e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveMergeConflict(URL url, Map mergedMap, boolean compressedDesign) {
        if (mergedMap != null) {
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient((URL)url);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Resolve merge conflict - checkout HEAD, write new content, clear temp files");
                File file = new File(url.getPath());
                File[] files = new File[]{file};
                client.checkout(files, "HEAD", false, (ProgressMonitor)monitor);
                XMLFromMapToSteramTransformer.transformMapToXMLFileStram(mergedMap, file.getAbsolutePath(), false, null, true);
                client.add(files, (ProgressMonitor)monitor);
                if (monitor.getError() != null) {
                    // empty if block
                }
                VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
                profile.getPolicyStatusCache().clear(url);
                GITOverlayItemProducer.clearVersion((URL[])new URL[]{url});
            }
            catch (GitException e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public static void resolveConflictWithOURS(URL url) {
        GitClientHelper.resolveConflictWithOURS(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveConflictWithOURS(URL url, boolean bothDeleted) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Resolve merge conflict - checkout HEAD, write new content, clear temp files");
            File file = new File(url.getPath());
            File[] files = new File[]{file};
            client.checkout(files, "HEAD", false, (ProgressMonitor)monitor);
            if (!bothDeleted) {
                client.add(files, (ProgressMonitor)monitor);
            }
            if (monitor.getError() != null) {
                // empty if block
            }
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
            profile.getPolicyStatusCache().clear(url);
            GITOverlayItemProducer.clearVersion((URL[])new URL[]{url});
        }
        catch (GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveConflictWithTheirs(URL url) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Resolve merge conflict - checkout HEAD, write new content, clear temp files");
            File file = new File(url.getPath());
            String path = file.getPath();
            byte[] bytes = null;
            try {
                bytes = GitClientHelper.getBytesForFileInConflict(url, 3, client);
            }
            catch (GITProcessException e) {
                e.printStackTrace();
            }
            File[] files = new File[]{file};
            client.checkout(files, "HEAD", false, (ProgressMonitor)monitor);
            if (bytes != null) {
                GitClientHelper.writeBytesToFile(bytes, path);
                client.add(files, (ProgressMonitor)monitor);
            }
            if (monitor.getError() != null) {
                // empty if block
            }
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
            profile.getPolicyStatusCache().clear(url);
            GITOverlayItemProducer.clearVersion((URL[])new URL[]{url});
        }
        catch (GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveConflictDeletedByThem(URL url) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Resolve merge conflict - checkout HEAD,remove the file from repository");
            File file = new File(url.getPath());
            File[] files = new File[]{file};
            client.checkout(files, "HEAD", false, (ProgressMonitor)monitor);
            client.remove(files, false, (ProgressMonitor)monitor);
            client.add(files, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                // empty if block
            }
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
            profile.getPolicyStatusCache().clear(url);
            GITOverlayItemProducer.clearVersion((URL[])new URL[]{url});
        }
        catch (GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public static void clearStatusCache(Collection<URL> urls) {
        GitClientHelper.clearStatusCache(urls.toArray(new URL[0]));
    }

    public static void clearStatusCache(URL[] urls) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        profile.getPolicyStatusCache().clear(urls, Depth.INFINITY);
        GITOverlayItemProducer.clearVersion((URL[])urls);
    }

    public static StatusInfo getCachedStatus(URL url) {
        try {
            Object obj;
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
            StatusCache stat = profile.getPolicyStatusCache();
            Field cachefield = StatusCache.class.getDeclaredField("_cache");
            cachefield.setAccessible(true);
            Object cache = cachefield.get(stat);
            if (cache instanceof Map && (obj = ((Map)cache).get(URICache.get((URL)url))) instanceof StatusInfo) {
                return (StatusInfo)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static VCSStatus[] triggerToCache(URL[] urls) {
        try {
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
            StatusCache stat = profile.getPolicyStatusCache();
            return (VCSStatus[])stat.get(urls);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clearStatusCache() {
    }

    public static void clearStatusCache(File file) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        URL[] urls = null;
        try {
            urls = new URL[]{file.toURI().toURL()};
            profile.getPolicyStatusCache().clear(urls, Depth.INFINITY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearStatusCache(Design design) {
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File file = new File(new File(path), name + ".dmd");
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        URL[] urls = null;
        try {
            urls = new URL[]{file.toURI().toURL(), dir.toURI().toURL()};
            profile.getPolicyStatusCache().clear(urls, Depth.INFINITY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearStatusCache(List<StorableObject> list) {
        if (list.size() > 0) {
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
            URL[] files = new URL[list.size()];
            try {
                int i = 0;
                for (StorableObject so : list) {
                    files[i] = new File(so.getStorageName()).toURI().toURL();
                    ++i;
                }
                profile.getPolicyStatusCache().clear(files);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static List<URL> getFileURLsForDesign(Design design) {
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File file = new File(new File(path), name + ".dmd");
        ArrayList<URL> files = new ArrayList<URL>();
        try {
            files.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        GitClientHelper.addFileURLs(dir, files);
        return files;
    }

    private static void addFileURLs(File dir, List<URL> files) {
        if (dir.isFile()) {
            try {
                files.add(dir.toURI().toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (File f : dir.listFiles()) {
                GitClientHelper.addFileURLs(f, files);
            }
        }
    }

    public static List<File> getFilesForDesign(Design design) {
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File file = new File(new File(path), name + ".dmd");
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        GitClientHelper.addFiles(dir, files);
        return files;
    }

    private static void addFiles(File dir, List<File> files) {
        if (dir.isFile()) {
            files.add(dir);
        } else {
            for (File f : dir.listFiles()) {
                GitClientHelper.addFiles(f, files);
            }
        }
    }

    public static Object[] getStatuses(URL[] urls) {
        return GitClientHelper.getStatuses(GIT_ChangeListWindow, urls);
    }

    public static Object[] getStatuses(ChangeListWindow gitPCWDocable, URL[] urls) {
        try {
            if (gitPCWDocable != null) {
                Field cf = ChangeListWindow.class.getDeclaredField("_changeLists");
                cf.setAccessible(true);
                Object cfValue = cf.get(gitPCWDocable);
                if (cfValue instanceof ChangeList[]) {
                    Field mfield = ChangeList.class.getDeclaredField("_model");
                    mfield.setAccessible(true);
                    for (ChangeList cl : (ChangeList[])cfValue) {
                        Field modefield = ChangeList.class.getDeclaredField("_modeId");
                        modefield.setAccessible(true);
                        Object mode = modefield.get(cl);
                        if (!"oracle.jdeveloper.git.OUTGOING".equalsIgnoreCase(mode.toString())) continue;
                        return cl.getPolicyStatusCache().get(urls);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isChanged(GitStatus stat) {
        if (!stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL) && stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL)) {
            return true;
        }
        if (!stat.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_NORMAL) && stat.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_NORMAL)) {
            return true;
        }
        return !stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_NORMAL) && stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitConflictDescriptor getConflictDescriptor(File file) {
        if (file.isFile()) {
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient((URL)file.toURI().toURL());
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Get status of file - " + file.getName());
                Map map = client.getStatus(new File[]{file}, (ProgressMonitor)monitor);
                for (Map.Entry entry : map.entrySet()) {
                    GitStatus stat = (GitStatus)entry.getValue();
                    if (!stat.isConflict()) continue;
                    GitConflictDescriptor gitConflictDescriptor = stat.getConflictDescriptor();
                    return gitConflictDescriptor;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (GitException e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitStatus getStatus(File file) {
        if (file.isFile()) {
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient((URL)file.toURI().toURL());
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Get status of file - " + file.getName());
                Map map = client.getStatus(new File[]{file}, (ProgressMonitor)monitor);
                Iterator iterator = map.entrySet().iterator();
                if (iterator.hasNext()) {
                    GitStatus stat;
                    Map.Entry entry = iterator.next();
                    GitStatus gitStatus = stat = (GitStatus)entry.getValue();
                    return gitStatus;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (GitException e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GitStatus> getStatuses(File[] files) {
        ArrayList<GitStatus> list = new ArrayList<GitStatus>();
        if (files.length > 0) {
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient((URL)files[0].toURI().toURL());
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Get status for files");
                Map map = client.getStatus(files, (ProgressMonitor)monitor);
                for (Map.Entry entry : map.entrySet()) {
                    GitStatus stat = (GitStatus)entry.getValue();
                    list.add(stat);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (GitException e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixBrokenFiles(List<GitStatus> list) {
        GitClient client = null;
        try {
            for (GitStatus s : list) {
                File f;
                GitConflictDescriptor descr = s.getConflictDescriptor();
                if (!GitConflictDescriptor.Type.BOTH_MODIFIED.equals((Object)descr.getType()) && !GitConflictDescriptor.Type.BOTH_ADDED.equals((Object)descr.getType()) || !GitClientHelper.isFileBroken(f = s.getFile())) continue;
                URL url = f.toURI().toURL();
                if (client == null) {
                    client = GITClientAdaptor.getClient((URL)url);
                }
                byte[] bytes = GitClientHelper.getBytesForFileInConflict(url, 2, client);
                GitClientHelper.writeBytesToFile(bytes, f.getCanonicalPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GitStatus> getConflictsForDesign(Design design) {
        ArrayList<GitStatus> list = new ArrayList<GitStatus>();
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File file = new File(new File(path), name + ".dmd");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)file.toURI().toURL());
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Get conflicts of design - " + name);
            Map map = client.getConflicts(new File[]{file, dir}, (ProgressMonitor)monitor);
            for (Map.Entry entry : map.entrySet()) {
                GitStatus stat = (GitStatus)entry.getValue();
                if (!stat.isConflict()) continue;
                list.add(stat);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GitStatus> getStatusesForDesign(Design design) {
        ArrayList<GitStatus> list = new ArrayList<GitStatus>();
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File file = new File(new File(path), name + ".dmd");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)file.toURI().toURL());
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Get conflicts of design - " + name);
            Map map = client.getStatus(new File[]{file, dir}, (ProgressMonitor)monitor);
            for (Map.Entry entry : map.entrySet()) {
                GitStatus stat = (GitStatus)entry.getValue();
                list.add(stat);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GitStatus> getConflictsForFiles(File[] files) {
        ArrayList<GitStatus> list = new ArrayList<GitStatus>();
        if (files.length > 0) {
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient((URL)files[0].toURI().toURL());
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Get conflicts for files ");
                Map map = client.getConflicts(files, (ProgressMonitor)monitor);
                for (Map.Entry entry : map.entrySet()) {
                    GitStatus stat = (GitStatus)entry.getValue();
                    if (!stat.isConflict()) continue;
                    list.add(stat);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (GitException e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream openInputStreamForConflict(URL url, int type) throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("CatIndexFile");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File file = new File(url.getPath());
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)url);
            boolean stat = client.catIndexEntry(file, type, (OutputStream)out, (ProgressMonitor)monitor);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (GitException gitException) {
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesForFileInConflict(URL url, int type, GitClient existingClient) throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("CatIndexFile");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File file = new File(url.getPath());
        GitClient client = null;
        try {
            client = existingClient != null ? existingClient : GITClientAdaptor.getClient((URL)url);
            client.catIndexEntry(file, type, (OutputStream)out, (ProgressMonitor)monitor);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (GitException gitException) {
        }
        finally {
            if (client != null && existingClient == null) {
                client.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialCommitSystemTypesDir(String systemTypesDir, String message) {
        String mes = "Initial commit of System Types Directory";
        if (message != null && !message.trim().isEmpty()) {
            mes = message;
        }
        File file = new File(systemTypesDir);
        File[] files = new File[]{file};
        GitClient client = null;
        try {
            URL url = file.toURI().toURL();
            if (GitClientHelper.isGitVersioned(url)) {
                client = GITClientAdaptor.getClient((URL)url);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Get status of System Types Directory - " + systemTypesDir);
                Map map = client.getStatus(files, (ProgressMonitor)monitor);
                boolean toadd = false;
                boolean changed = false;
                for (Map.Entry entry : map.entrySet()) {
                    GitStatus stat = (GitStatus)entry.getValue();
                    if (stat.isConflict()) {
                        return;
                    }
                    toadd = toadd || !stat.isTracked();
                    changed = changed || GitClientHelper.isChanged(stat);
                }
                if (toadd || changed) {
                    GitClientHelper.addToGit(file, client);
                    GitUser user = client.getUser();
                    monitor.setOperation("Commit System Types Directory to Git - " + systemTypesDir);
                    client.commit(files, mes, user, user, (ProgressMonitor)monitor);
                }
                ApplicationView.getInstance().updateWorkspace(systemTypesDir);
            }
        }
        catch (MalformedURLException | GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public static void addToGit(String path) {
        File file = null;
        file = new File(path);
        if (file != null) {
            GitClientHelper.addToGit(file, null);
        }
    }

    public static void addToGit(File file) {
        GitClientHelper.addToGit(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToGit(File file, GitClient existingClient) {
        GitClient client = null;
        try {
            client = existingClient != null ? existingClient : GITClientAdaptor.getClient((URL)file.toURI().toURL());
            if (client == null) {
                return;
            }
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Add file to Git - " + file.getPath());
            client.add(new File[]{file}, (ProgressMonitor)monitor);
        }
        catch (MalformedURLException | GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null && existingClient == null) {
                client.release();
            }
        }
    }

    public static void ensureGlobalIgnoreList(String path) {
        File fpath = new File(path);
        File fignore = new File(fpath, ".gitignore");
        List<String> list = null;
        String pignore = fignore.getPath();
        list = fignore.exists() ? GitClientHelper.readFile(pignore) : new ArrayList<String>();
        if (list != null) {
            boolean changed = false;
            PatternFilters pfs = GlobalIgnoreList.getPatternFilters();
            for (PatternFilter pf : pfs.getFilters()) {
                String p;
                if (!pf.isExclude() || list.contains(p = pf.getPattern())) continue;
                list.add(p);
                changed = true;
            }
            if (changed) {
                GitClientHelper.writeToFile(list, pignore);
                GitClientHelper.addToGit(fignore);
            }
        }
    }

    private static List<String> readFile(String path) {
        List<String> list = null;
        try {
            list = Files.readAllLines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void writeToFile(List<String> list, String path) {
        try {
            Files.write(Paths.get(path, new String[0]), list, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeBytesToFile(byte[] bytes, String path) {
        try {
            Files.write(Paths.get(path, new String[0]), bytes, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] readBytesFromFile(String path) {
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDesignToIndex(Design design) {
        String name = design.getName();
        String path = design.getDesignPath();
        File dir = new File(new File(path), name);
        File dmdFile = new File(new File(path), name + ".dmd");
        File[] des = new File[]{dir, dmdFile};
        ArrayList files = new ArrayList();
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)dir.toURI().toURL());
            TimeLog.log("start  adding design to git");
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Add models to Git index - " + dir.getPath());
            client.add(des, (ProgressMonitor)monitor);
            TimeLog.log("end  adding design to git");
        }
        catch (MalformedURLException | GitException e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addModels(Design design, List list) {
        if (list.size() > 0) {
            String name = design.getName();
            String path = design.getDesignPath();
            File dir = new File(new File(path), name);
            ArrayList<File> files = new ArrayList<File>();
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient((URL)dir.toURI().toURL());
                if (client == null) {
                    return;
                }
                TimeLog.log("start  adding models to git");
                for (ModelIDObject object : list) {
                    if (object instanceof StorageDesign) {
                        StorageDesign sd = (StorageDesign)object;
                        files.add(new File(sd.getStoragePath()));
                        continue;
                    }
                    if (!(object instanceof DesignPart)) continue;
                    DesignPart dp = (DesignPart)object;
                    File fileToAdd = new File(dp.getStoragePath());
                    files.add(fileToAdd);
                    if (dp instanceof TransformationTask && GitClientHelper.isFileAndDirModel(dp.getClass())) {
                        File modelFile = new File(dp.getStoragePath()).getParentFile().getParentFile();
                        modelFile = new File(modelFile.getAbsolutePath() + ".xml");
                        files.add(modelFile);
                        continue;
                    }
                    if (!GitClientHelper.isFileAndDirModel(dp.getClass())) continue;
                    files.add(new File(dp.getStorageName()));
                }
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Add models to Git index - " + dir.getPath());
                client.add(files.toArray(new File[0]), (ProgressMonitor)monitor);
                TimeLog.log("end  adding models to git");
            }
            catch (MalformedURLException | GitException e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addObjectsToGitIndex(Design design, List<StorableObject> list) {
        if (list.size() > 0) {
            String name = design.getName();
            String path = design.getDesignPath();
            File dir = new File(new File(path), name);
            ArrayList<File> files = new ArrayList<File>(list.size());
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient((URL)dir.toURI().toURL());
                if (client == null) {
                    return;
                }
                TimeLog.log("start  adding objects to git - " + list.size());
                for (StorableObject so : list) {
                    if (so instanceof ModelIDObject) {
                        files.add(new File(((ModelIDObject)so).getSegmentedStorageName()));
                        continue;
                    }
                    files.add(new File(so.getStorageName()));
                }
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Add objects to Git index - design " + design.getName());
                client.add(files.toArray(new File[0]), (ProgressMonitor)monitor);
                TimeLog.log("end  adding objects to git");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public static boolean isFileAndDirModel(Class aClass) {
        return XMLTransformationManager.isFileAndDirModel(aClass);
    }

    public static boolean isGitVersioned(Design design) {
        try {
            String name = design.getName();
            String path = design.getDesignPath();
            File dir = new File(new File(path), name);
            return GITUtil.insideWorkingCopy((URL)dir.toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isGitVersioned(URL url) {
        try {
            return GITUtil.insideWorkingCopy((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isGitVersioned(String path) {
        try {
            return GitClientHelper.isGitVersioned(new File(path).toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isGitVersioned(File file) {
        try {
            return GitClientHelper.isGitVersioned(file.toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void refreshGitChangeList() {
        try {
            Dockable gitPCWDocable = DockStation.getDockStation().findDockable(gitPCWViewId);
            if (gitPCWDocable != null && gitPCWDocable instanceof ChangeListWindow) {
                Field cf = ChangeListWindow.class.getDeclaredField("_changeLists");
                cf.setAccessible(true);
                Object cfValue = cf.get(gitPCWDocable);
                if (cfValue instanceof ChangeList[]) {
                    Field field = ChangeList.class.getDeclaredField("_vop");
                    field.setAccessible(true);
                    for (ChangeList cl : (ChangeList[])cfValue) {
                        Object fieldValue = field.get(cl);
                        if (!(fieldValue instanceof VersionOperationTablePanel)) continue;
                        ((VersionOperationTablePanel)fieldValue).setDefaultRenderer(String.class, (TableCellRenderer)new DMGitStringCellRenderer());
                        ((VersionOperationTablePanel)fieldValue).setDefaultRenderer(Displayable.class, (TableCellRenderer)((Object)new DMGitCellRenderer()));
                    }
                }
                ((ChangeListWindow)gitPCWDocable).refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setWorkspaceAsOpen(Workspace w) {
        try {
            Field cf = Node.class.getDeclaredField("isOpen");
            cf.setAccessible(true);
            cf.set(w, true);
            cf = Node.class.getDeclaredField("isLoaded");
            cf.setAccessible(true);
            cf.set(w, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeGitTempFiles(File file) {
        try {
            File base = new File(file.getCanonicalPath() + ".BASE.xml");
            base.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File local = new File(file.getCanonicalPath() + ".LOCAL.xml");
            local.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File remote = new File(file.getCanonicalPath() + ".REMOTE.xml");
            remote.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileBroken(File file) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(SEARCH) && !line.startsWith(SEARCH2) && !line.startsWith(SEARCH3)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static void logMergeConflicts(Collection<File> conflicts) {
        if (!conflicts.isEmpty()) {
            GitClientHelper.log(TimeLog.getTime() + " - " + Resource.get((String)"MERGE_FAIL_OP_CONFLICT") + "\n");
            GitClientHelper.logFiles(conflicts, null);
        }
    }

    public static void logMergeFailures(Collection<File> failures) {
        if (!failures.isEmpty()) {
            GitClientHelper.log(TimeLog.getTime() + " - " + Resource.get((String)"MERGE_FAIL_OP_CONFLICT") + "\n");
            GitClientHelper.logFiles(failures, null);
        }
    }

    public static void logFilesUpdated(Collection<File> updates) {
        if (!updates.isEmpty()) {
            GitClientHelper.log(TimeLog.getTime() + " - Updated files:\n");
            GitClientHelper.logFiles(updates, null);
        }
    }

    public static void logUpdatedFiles(Collection<FileDescriptor> updates) {
        if (!updates.isEmpty()) {
            GitClientHelper.log(TimeLog.getTime() + " - Updated files:\n");
            GitClientHelper.logFilesWithStatus(updates, null);
        }
    }

    public static void logFilesWithStatus(Collection<FileDescriptor> files, String information) {
        if (files.isEmpty()) {
            return;
        }
        if (information != null && !information.isEmpty()) {
            GitClientHelper.log(information);
            GitClientHelper.log("\n");
        }
        if (information != null && !information.isEmpty()) {
            GitClientHelper.log(information);
            GitClientHelper.log("\n");
        }
        String fd = GitClientHelper.getFilesDescriptionWitStatus(files, false);
        GitClientHelper.log(fd);
    }

    public static String getFilesDescriptionWitStatus(Collection<FileDescriptor> files, boolean singlePresentation) {
        StringBuilder sb = new StringBuilder();
        for (FileDescriptor fd : files) {
            File f = fd.file;
            boolean processed = false;
            try {
                Design d;
                URL url = f.toURI().toURL();
                if (url != null && (d = ApplicationView.getInstance().getDesignForURL(url)) != null) {
                    Design.ObjectDescriptor ds;
                    String pathName = "";
                    String path = f.getParentFile().getCanonicalPath();
                    String od = d.getPathWithNames(path, false);
                    if (od != null) {
                        pathName = od;
                    }
                    if ((ds = d.getObjectDescriptor(url, null)) != null) {
                        String type = fd.getStatus() + " - ";
                        sb.append(type + ds.name + " at " + pathName + "\n");
                        processed = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (singlePresentation && (!singlePresentation || processed)) continue;
            sb.append("\t" + fd.getStatus() + " - ");
            sb.append(f.getPath());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void logFiles(Collection<File> files, String information) {
        if (files.isEmpty()) {
            return;
        }
        if (information != null && !information.isEmpty()) {
            GitClientHelper.log(information);
            GitClientHelper.log("\n");
        }
        if (information != null && !information.isEmpty()) {
            GitClientHelper.log(information);
            GitClientHelper.log("\n");
        }
        String fd = GitClientHelper.getFilesDescription(files, false);
        GitClientHelper.log(fd);
    }

    public static String getFilesDescription(Collection<File> files, boolean singlePresentation) {
        StringBuilder sb = new StringBuilder();
        for (File f : files) {
            boolean processed = false;
            try {
                Design d;
                URL url = f.toURI().toURL();
                if (url != null && (d = ApplicationView.getInstance().getDesignForURL(url)) != null) {
                    Design.ObjectDescriptor ds;
                    String pathName = "";
                    String path = f.getParentFile().getCanonicalPath();
                    String od = d.getPathWithNames(path, false);
                    if (od != null) {
                        pathName = od;
                    }
                    if ((ds = d.getObjectDescriptor(url, null)) != null) {
                        Object type = "";
                        if (ds.object != null) {
                            type = ds.object.getObjectTypeName() + " - ";
                        }
                        sb.append((String)type + ds.name + " at " + pathName + "\n");
                        processed = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (singlePresentation && (!singlePresentation || processed)) continue;
            sb.append("\t");
            sb.append(f.getPath());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void reportMergeConflicts(Collection<File> conflicts) {
        GitClientHelper.reportFiles(conflicts, Resource.get((String)"MERGE_CONFLICT_TITLE"), Resource.get((String)"MERGE_CONFLICT_OP_UI_FAILURE"));
    }

    public static void reportMergeFailures(Collection<File> failures) {
        GitClientHelper.reportFiles(failures, Resource.get((String)"MERGE_FAILED_TITLE"), Resource.get((String)"MERGE_FAIL_OP_UI_FAILURE"));
    }

    public static void reportFiles(Collection<File> files, String title, String msg) {
        if (files == null || files.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append('\n');
        sb.append(GitClientHelper.getFilesDescription(files, true));
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)sb.toString(), (String)title, null);
    }

    public static void log(String message) {
        if (VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.git").getAutoLogMessages()) {
            LogManager.getLogManager().getMsgPage().log((Object)message);
        }
    }

    public static String getActiveBranch(GitClient client) throws GITProcessException {
        Map branches;
        if (client == null) {
            return "";
        }
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
        try {
            branches = client.getBranches(false, (ProgressMonitor)monitor);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger((String)DMGitPullWizard.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.get((String)"WZ_PULL_LOCAL_BRANCH_ERROR"), e.getMessage());
        }
        if (monitor.getError() != null) {
            throw new GITProcessException(Resource.get((String)"PROCESS_EXCEPTION_CHECKOUT_ERROR"), monitor.getError());
        }
        GitBranch activeBranch = GITUtil.getActiveBranch((Map)branches);
        if (activeBranch != null) {
            return activeBranch.getName();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActiveBranch(Design design) {
        String res = "";
        String name = design.getName();
        String path = design.getDesignPath();
        File file = new File(new File(path), name + ".dmd");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)file.toURI().toURL());
            res = GitClientHelper.getActiveBranch(client);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return res;
    }

    public static Map<File, FileDescriptor> getModifiedFiles(GitClient client, String fromRevision, String toRevision, GITCommandProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        GitRevisionInfo[] revs;
        HashMap<File, FileDescriptor> modifiedFiles = new HashMap<File, FileDescriptor>();
        SearchCriteria sc = new SearchCriteria();
        sc.setRevisionFrom(fromRevision);
        sc.setRevisionTo(toRevision);
        for (GitRevisionInfo info : revs = client.log(sc, (ProgressMonitor)monitor)) {
            Map m = info.getModifiedFiles();
            long commitTime = info.getCommitTime();
            for (File f : m.keySet()) {
                GitRevisionInfo.GitFileInfo gfi = (GitRevisionInfo.GitFileInfo)m.get(f);
                FileDescriptor fd = (FileDescriptor)modifiedFiles.get(f);
                if (fd == null) {
                    fd = new FileDescriptor();
                    fd.file = f;
                    modifiedFiles.put(f, fd);
                }
                fd.setOperation(gfi.getStatus(), commitTime);
            }
        }
        return modifiedFiles;
    }

    public static Map<File, FileDescriptor> getModifiedFiles(GitRevisionInfo info) {
        HashMap<File, FileDescriptor> modifiedFiles = new HashMap<File, FileDescriptor>();
        try {
            Map m = info.getModifiedFiles();
            long commitTime = info.getCommitTime();
            for (File f : m.keySet()) {
                GitRevisionInfo.GitFileInfo gfi = (GitRevisionInfo.GitFileInfo)m.get(f);
                FileDescriptor fd = (FileDescriptor)modifiedFiles.get(f);
                if (fd == null) {
                    fd = new FileDescriptor();
                    fd.file = f;
                    modifiedFiles.put(f, fd);
                }
                fd.setOperation(gfi.getStatus(), commitTime);
            }
        }
        catch (GitException e) {
            e.printStackTrace();
        }
        return modifiedFiles;
    }

    public static void updateChangedDesigns(Collection<FileDescriptor> changed) {
        ArrayList<VersioningTreeNode> sysFiles = new ArrayList<VersioningTreeNode>();
        HashMap map = new HashMap();
        for (FileDescriptor fileDescriptor : changed) {
            File file = fileDescriptor.file;
            try {
                URL url = file.toURI().toURL();
                Design d = ApplicationView.getInstance().getDesignForURL(url);
                if (d != null) {
                    ArrayList<VersioningTreeNode> list = (ArrayList<VersioningTreeNode>)map.get(d);
                    if (list == null) {
                        list = new ArrayList<VersioningTreeNode>();
                        map.put(d, list);
                    }
                    GeneralStorableObjectStatus st = new GeneralStorableObjectStatus(d, file, fileDescriptor.getShortStorableStatus());
                    VersioningTreeNode tn = new VersioningTreeNode(st);
                    list.add(tn);
                    continue;
                }
                try {
                    GeneralStorableObjectStatus st = new GeneralStorableObjectStatus(null, file, fileDescriptor.getShortStorableStatus());
                    VersioningTreeNode tn = new VersioningTreeNode(st);
                    sysFiles.add(tn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (sysFiles.size() > 0) {
            try {
                VersioningTreeNode.refresh(sysFiles, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            VersioningTreeNode.refresh(list, false);
        }
    }

    public static Workspace getWorkspace(ChangeListWindow.ScopeFilter origin) {
        Workspace workspace = null;
        if (origin != null) {
            try {
                Field cf = ChangeListWindow.ScopeFilter.class.getDeclaredField("_workspace");
                cf.setAccessible(true);
                Object cfValue = cf.get(origin);
                if (cfValue instanceof Workspace) {
                    workspace = (Workspace)cfValue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return workspace;
    }

    public static void setWorkspace(ChangeListWindow.ScopeFilter origin, Workspace workspace) {
        if (origin != null) {
            try {
                Field cf = ChangeListWindow.ScopeFilter.class.getDeclaredField("_workspace");
                cf.setAccessible(true);
                cf.set(origin, workspace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void fixScopeComboBox(Toolbar tb, ChangeListWindow w) {
        Ide.getSystem().detach(PROJECT_OBSERVER);
        Ide.getSystem().attach(PROJECT_OBSERVER);
        GIT_ChangeListWindow = w;
        try {
            Field cf = ChangeListWindow.class.getDeclaredField("ALL_APPLICATIONS_SCOPE");
            cf.setAccessible(true);
            Object cfValue = cf.get(w);
            ALL_APPS = (ChangeListWindow.ScopeFilter)cfValue;
            cf = ChangeListWindow.class.getDeclaredField("ACTIVE_APPLICATION_SCOPE");
            cf.setAccessible(true);
            cfValue = cf.get(w);
            ACTIVE_APP = (ChangeListWindow.ScopeFilter)cfValue;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int c = tb.getComponentCount();
        for (int i = 0; i < c; ++i) {
            Component cp = tb.getComponentAtIndex(i);
            if (!(cp instanceof JComboBox)) continue;
            SCOPE_CB = (JComboBox)cp;
            ((JComboBox)cp).setRenderer(new DMDefaultListCellRenderer());
            GitClientHelper.fixScopeComboBox((JComboBox)cp);
        }
    }

    public static void fixScopeComboBox(JComboBox cb) {
        cb.removePropertyChangeListener(propListener);
        cb.addPropertyChangeListener("model", propListener);
        GitClientHelper.replaceModel(cb);
    }

    public static void validateWorkspaceInModel(JComboBox cb, Workspace w) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        if (model.getSize() == 0) {
            return;
        }
        Object obj = model.getElementAt(0);
        if (obj instanceof DMScopeFilter) {
            boolean found = false;
            for (int i = 0; i < model.getSize(); ++i) {
                Object item = model.getElementAt(i);
                if (!(item instanceof DMScopeFilter)) {
                    return;
                }
                DMScopeFilter f = (DMScopeFilter)((Object)item);
                if (!f.activeApp && !f.allApps && w == f.workspace) {
                    found = true;
                    break;
                }
                if (found) continue;
                model.addElement(new DMScopeFilter(w));
            }
        }
    }

    public static void replaceModel(JComboBox cb) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        if (model.getSize() == 0) {
            return;
        }
        Object obj = model.getElementAt(0);
        if (!(obj instanceof DMScopeFilter)) {
            Object selected = model.getSelectedItem();
            DMScopeFilter newsel = null;
            ArrayList<DMScopeFilter> list = new ArrayList<DMScopeFilter>();
            for (int i = 0; i < model.getSize(); ++i) {
                Object item = model.getElementAt(i);
                if (!(item instanceof ChangeListWindow.ScopeFilter)) continue;
                DMScopeFilter f = null;
                f = ALL_APPS == item ? new DMScopeFilter((ChangeListWindow.ScopeFilter)item, true, false) : (ACTIVE_APP == item ? new DMScopeFilter((ChangeListWindow.ScopeFilter)item, false, true) : new DMScopeFilter((ChangeListWindow.ScopeFilter)item));
                if (selected == item) {
                    newsel = f;
                }
                list.add(f);
            }
            if (list.size() == model.getSize()) {
                model.removeAllElements();
                for (DMScopeFilter f : list) {
                    model.addElement(f);
                }
                if (newsel != null) {
                    model.setSelectedItem((Object)newsel);
                }
            }
        }
    }

    public static DMVersionOperationModelListener getDMVersionOperationModelListener() {
        if (versionOperationModelListener == null) {
            versionOperationModelListener = new DMVersionOperationModelListener();
        }
        return versionOperationModelListener;
    }

    public static void addChangeListModelListener() {
        GitClientHelper.addChangeListModelListener(GIT_ChangeListWindow);
    }

    public static void addChangeListModelListener(ChangeListWindow gitPCWDocable) {
        try {
            if (gitPCWDocable != null) {
                Field cf = ChangeListWindow.class.getDeclaredField("_changeLists");
                cf.setAccessible(true);
                Object cfValue = cf.get(gitPCWDocable);
                if (cfValue instanceof ChangeList[]) {
                    Field mfield = ChangeList.class.getDeclaredField("_model");
                    mfield.setAccessible(true);
                    for (ChangeList cl : (ChangeList[])cfValue) {
                        Object m;
                        Field modefield = ChangeList.class.getDeclaredField("_modeId");
                        modefield.setAccessible(true);
                        Object mode = modefield.get(cl);
                        if (!"oracle.jdeveloper.git.OUTGOING".equalsIgnoreCase(mode.toString()) || (m = mfield.get(cl)) == null || !(m instanceof MutableVersionOperationModel)) continue;
                        MutableVersionOperationModel model = (MutableVersionOperationModel)m;
                        model.removeVersionOperationListener((VersionOperationModelListener)GitClientHelper.getDMVersionOperationModelListener());
                        model.addVersionOperationModelListener((VersionOperationModelListener)GitClientHelper.getDMVersionOperationModelListener());
                        isChangeListModelListenerAdded = true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void modifyGitChangeList() {
        try {
            Dockable gitPCWDocable = DockStation.getDockStation().findDockable(gitPCWViewId);
            if (gitPCWDocable != null && gitPCWDocable instanceof ChangeListWindow) {
                Field cf = ChangeListWindow.class.getDeclaredField("_changeLists");
                cf.setAccessible(true);
                Object cfValue = cf.get(gitPCWDocable);
                if (cfValue instanceof ChangeList[]) {
                    Field field = ChangeList.class.getDeclaredField("_vop");
                    field.setAccessible(true);
                    Field mfield = ChangeList.class.getDeclaredField("_model");
                    mfield.setAccessible(true);
                    for (ChangeList cl : (ChangeList[])cfValue) {
                        Object m;
                        Object fieldValue = field.get(cl);
                        if (fieldValue instanceof VersionOperationTablePanel) {
                            ((VersionOperationTablePanel)fieldValue).setDefaultRenderer(String.class, (TableCellRenderer)new DMGitStringCellRenderer());
                            ((VersionOperationTablePanel)fieldValue).setDefaultRenderer(Displayable.class, (TableCellRenderer)((Object)new DMGitCellRenderer()));
                        }
                        if ((m = mfield.get(cl)) == null || !(m instanceof MutableVersionOperationModel)) continue;
                        isChangeListModelListenerAdded = true;
                    }
                }
                Toolbar tb = ((ChangeListWindow)gitPCWDocable).getToolbar();
                GitClientHelper.resetGitActions(tb.getActions());
                GitClientHelper.fixScopeComboBox(tb, (ChangeListWindow)gitPCWDocable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateComboBoxModel() {
        try {
            Dockable gitPCWDocable = DockStation.getDockStation().findDockable(gitPCWViewId);
            if (gitPCWDocable != null && gitPCWDocable instanceof ChangeListWindow) {
                Method cf = ChangeListWindow.class.getDeclaredMethod("updateScopeComboBoxModel", new Class[0]);
                cf.setAccessible(true);
                cf.invoke((Object)gitPCWDocable, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static URL getRepositoryRoot(String path) {
        try {
            File file;
            for (file = new File(path); file != null && !GITUtil.isReposRoot((URL)file.toURI().toURL()); file = file.getParentFile()) {
            }
            if (file != null) {
                return file.toURI().toURL();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getNumberOfWorkspacesForThatRepository(String path) {
        URL url = GitClientHelper.getRepositoryRoot(path);
        if (url != null) {
            Workspace[] workspaces;
            int res = 0;
            for (Workspace w : workspaces = VCSModelUtils.findCachedWorkspaces()) {
                URL wurl = w.getURL();
                if (wurl == null || !URLFileSystem.isBaseURLFor((URL)url, (URL)wurl)) continue;
                ++res;
            }
            return res;
        }
        return 0;
    }

    static class DMVersionOperationModelListener
    implements VersionOperationModelListener {
        DMVersionOperationModelListener() {
        }

        public void itemsRemoved(VersionOperationModelEvent e) {
            VersionOperationModel model = (VersionOperationModel)e.getSource();
            TimeLog.log("model count " + model.getCount() + " // removed " + e.getStart() + " - " + e.getEnd());
            if (model.getCount() > 0) {
                int k = 0;
                int n = ++k;
            }
        }

        public void itemsInserted(VersionOperationModelEvent e) {
            VersionOperationModel model = (VersionOperationModel)e.getSource();
            TimeLog.log("model count " + model.getCount() + " // inserted " + e.getStart() + " - " + e.getEnd());
            if (model.getCount() > 0) {
                int k = 0;
                int n = ++k;
            }
        }

        public void itemsChanged(VersionOperationModelEvent e) {
            VersionOperationModel model = (VersionOperationModel)e.getSource();
            TimeLog.log("model count " + model.getCount() + " // changed " + e.getStart() + " - " + e.getEnd());
            if (model.getCount() > 0) {
                int k = 0;
                int n = ++k;
            }
        }

        public void completenessChanged(VersionOperationModelEvent e) {
            VersionOperationModel model = (VersionOperationModel)e.getSource();
            if (((MutableVersionOperationModel)model).isComplete()) {
                TimeLog.log("model count " + model.getCount() + " // completed " + e.getStart() + " - " + e.getEnd());
                ((MutableVersionOperationModel)model).getCount();
            }
        }
    }

    public static class DMDefaultListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            if (value instanceof String) {
                return this;
            }
            if (value instanceof DMScopeFilter) {
                DMScopeFilter scope = (DMScopeFilter)((Object)value);
                if (scope.isAllApps()) {
                    this.setText(VCSArb.get((String)"CHANGELIST_SCOPE_ALL_APPLICATIONS"));
                    this.setIcon(OracleIcons.getIcon((String)"applications.png"));
                } else if (scope.isActiveApp()) {
                    this.setText(VCSArb.get((String)"CHANGELIST_SCOPE_ACTIVE_APPLICATION"));
                    this.setIcon(OracleIcons.getIcon((String)"application.png"));
                } else if (scope.origin != null) {
                    this.setText(scope.origin.getShortLabel());
                    this.setIcon(scope.origin.getIcon());
                } else {
                    this.setText(scope.getShortLabel());
                    this.setIcon(scope.getIcon());
                }
            }
            return this;
        }
    }

    public static class DMScopeFilter
    extends ChangeListWindow.ScopeFilter {
        private Workspace workspace;
        private Project project;
        private ChangeListWindow.ScopeFilter origin;
        private boolean allApps;
        private boolean activeApp;

        public DMScopeFilter(ChangeListWindow.ScopeFilter origin) {
            this.origin = origin;
            this.syncProject();
            this.syncWorkspace();
        }

        public DMScopeFilter(Workspace workspace) {
            this.workspace = workspace;
        }

        public DMScopeFilter(ChangeListWindow.ScopeFilter origin, boolean allApps, boolean activeApp) {
            this.origin = origin;
            this.allApps = allApps;
            this.activeApp = activeApp;
            this.syncProject();
            this.syncWorkspace();
        }

        public void syncWorkspace() {
            if (this.origin != null) {
                try {
                    Field cf = ChangeListWindow.ScopeFilter.class.getDeclaredField("_workspace");
                    cf.setAccessible(true);
                    Object cfValue = cf.get(this.origin);
                    if (cfValue instanceof Workspace) {
                        this.workspace = (Workspace)cfValue;
                    }
                    cf.set((Object)this, cfValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void syncProject() {
            if (this.origin != null) {
                try {
                    Field cf = ChangeListWindow.ScopeFilter.class.getDeclaredField("_project");
                    cf.setAccessible(true);
                    Object cfValue = cf.get(this.origin);
                    cf.set((Object)this, cfValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public boolean accept(URL url) {
            try {
                if (this.isActiveApp()) {
                    this.syncWorkspace();
                }
                if (this.workspace != null) {
                    if (GlobalIgnoreList.isGloballyIgnored((URL)url)) {
                        return false;
                    }
                    if (URLFileSystem.equals((URL)this.workspace.getURL(), (URL)url)) {
                        return true;
                    }
                    String paths = this.workspace.getProperty(MODELER_PATHS);
                    if (paths != null && !paths.isEmpty()) {
                        String[] parts = paths.split(";");
                        URL workspaceDirUrl = URLFileSystem.getParent((URL)this.workspace.getURL());
                        for (String path : parts) {
                            if (!URLFileSystem.isBaseURLFor((URL)URLFactory.newURL((URL)workspaceDirUrl, (String)path), (URL)url)) continue;
                            return true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (this.origin != null) {
                return this.origin.accept(url);
            }
            return super.accept(url);
        }

        public boolean isAllApps() {
            return this.allApps;
        }

        public void setAllApps(boolean allApps) {
            this.allApps = allApps;
        }

        public boolean isActiveApp() {
            return this.activeApp;
        }

        public void setActiveApp(boolean activeApp) {
            this.activeApp = activeApp;
        }

        public String toExternalForm() {
            if (this.origin == ALL_APPS) {
                return "ALL_APPLICATIONS";
            }
            if (this.origin == ACTIVE_APP) {
                return "ACTIVE_APPLICATION";
            }
            if (this.workspace != null) {
                return "APPLICATION=" + this.workspace.getURL().toExternalForm();
            }
            if (this.project != null) {
                return "PROJECT=" + this.project.getURL().toExternalForm();
            }
            return "empty";
        }
    }

    public static class DMComboBoxModel
    extends DefaultComboBoxModel {
    }

    public static class FileDescriptor {
        public File file;
        GitRevisionInfo.GitFileInfo.Status lastStatus = GitRevisionInfo.GitFileInfo.Status.UNKNOWN;
        public boolean added;
        public boolean deleted;
        public boolean modified;
        public long addedTime;
        public long deletedTime;
        public long modifiedTime;
        public long lastCommit;

        public String getStatus() {
            if (!this.deleted) {
                if (this.added) {
                    return ADDED;
                }
                if (this.modified) {
                    return MODIFIED;
                }
            } else {
                if (this.added) {
                    return this.addedTime > this.deletedTime ? ADDED : DELETED;
                }
                return DELETED;
            }
            return this.getLastStatus();
        }

        public String getShortStorableStatus() {
            String str = this.getStatus();
            if (ADDED.equalsIgnoreCase(str)) {
                return "A";
            }
            if (MODIFIED.equalsIgnoreCase(str)) {
                return "M";
            }
            if (DELETED.equalsIgnoreCase(str)) {
                return "D";
            }
            return "?";
        }

        public String getLastStatus() {
            switch (this.lastStatus) {
                case ADDED: {
                    return ADDED;
                }
                case REMOVED: {
                    return DELETED;
                }
                case MODIFIED: {
                    return MODIFIED;
                }
                case COPIED: {
                    return COPIED;
                }
                case RENAMED: {
                    return RENAMED;
                }
            }
            return UNKNOWN;
        }

        public void setOperation(GitRevisionInfo.GitFileInfo.Status status, long commitTime) {
            this.lastStatus = status;
            this.lastCommit = commitTime;
            switch (status) {
                case ADDED: {
                    this.added = true;
                    this.addedTime = commitTime;
                    break;
                }
                case REMOVED: {
                    this.deleted = true;
                    this.deletedTime = commitTime;
                    break;
                }
                case MODIFIED: {
                    this.modified = true;
                    this.modifiedTime = commitTime;
                    break;
                }
            }
        }
    }
}

