/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;

public class DataModelerChangeListScopeComboBoxRenderer
extends JLabel
implements ListCellRenderer {
    protected static Color defaultScopeComboBoxForeground = Color.BLACK;

    public DataModelerChangeListScopeComboBoxRenderer() {
        this.setOpaque(true);
        this.setForeground(defaultScopeComboBoxForeground);
    }

    public FontMetrics getFontMetrics() {
        return super.getFontMetrics(super.getFont());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Design design = (Design)value;
        String folder = null;
        Object name = null;
        if (design != null) {
            if (design.isSVNVersioned()) {
                name = design.getName();
                folder = new File(design.getStorageName()).getParent();
                this.setForeground(defaultScopeComboBoxForeground);
            } else if (SVNClientHelper.getInstance().isVersioned(design.getAppView().getSettings().getDefaultSystemTypesPath())) {
                folder = new File(design.getAppView().getSettings().getDefaultSystemTypesPath()).getPath();
                name = "System Types [" + design.getName() + "]";
                this.setForeground(new Color(166, 128, 100));
            } else {
                this.setForeground(defaultScopeComboBoxForeground);
            }
            if (folder != null) {
                this.setText((String)name + " (" + folder + ")");
            }
        }
        return this;
    }
}

