/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCommit;
import oracle.jdevimpl.vcs.svn.op.ui.LockOptionsCustomizer;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class SVNLockCommand
extends AbstractSVNOperation {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.lock" : SVNLockCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.lock", SVNLockCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    protected VersionOperationSelectTablePanel versionOperationPanel = null;

    public SVNLockCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected boolean isAvailableImpl() throws Exception {
        return SVN_CLIENT_HELPER.actionsEnabled(null, this.getContext(), true, true, false, false, false, true, false, true);
    }

    protected int doitImpl() throws Exception {
        CommandState commandState = VCSClientHelper.createCommandState(this.context.getView(), true, true);
        DisplayableLocatableNode[] locatables = (DisplayableLocatableNode[])commandState.getLocatables();
        if (commandState.getLocatables() != null && commandState.getLocatables().length > 0) {
            boolean res = this.invokeCommand(this.getProfile(), commandState);
            if (res) {
                NavigationTreeRenderer.updateNavTreeNodesSVNStatuses(locatables);
            }
            return 0;
        }
        return 1;
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        if (!this.prepareStateForUI(commandState)) {
            return false;
        }
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes);
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer, commandState);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                if (SVNLockCommand.this.versionOperationPanel != null) {
                    Locatable[] locatables = SVNLockCommand.this.versionOperationPanel.getSelectedLocatables();
                    commandState.setLocatables(locatables);
                }
                boolean result = true;
                try {
                    result = SVNLockCommand.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
                }
                catch (Exception ex) {
                    throw SVNExceptionWrapper.wrapException((Exception)ex);
                }
                return result;
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(Collection nodes) {
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.subversion", (VCSOptionsCustomizer)new LockOptionsCustomizer());
        customizer.setShowReuseCommentsOption(false);
        customizer.setRecentCommentsModel(SVNOperationCommit.getRecentCommentsModel());
        customizer.setShowTemplatesAndCommentsCombo(true);
        customizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get((String)"SVN_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        customizer.setContextURLs(VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Collection)nodes)));
        return customizer;
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] locatables = commandState.getLocatables();
        if (locatables.length > 0) {
            List<File> files = DisplayableLocatableNode.convertToFileList(locatables, true);
            for (int i = files.size() - 1; i >= 0; --i) {
                File file = files.get(i);
                if (!file.exists()) {
                    files.remove(file);
                    file = new File(file.toString() + "z");
                    if (SVN_CLIENT_HELPER.getRevision(file) <= 0L) continue;
                    files.add(file);
                    continue;
                }
                if (SVN_CLIENT_HELPER.getRevision(file) > 0L) continue;
                files.remove(file);
            }
            if (files.size() > 0) {
                SVNClientHelper.getInstance().doLock(files.toArray(new File[0]), (Boolean)options.get("oracle.jdeveloper.subversion.STEAL_LOCKS"), (String)options.get("setting_comments"));
            }
        }
        return true;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.lock");
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this.versionOperationPanel = SVN_CLIENT_HELPER.createVersionOperationTablePanel((List)nodes);
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.versionOperationPanel, (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
    }

    public String getHelpTopicId() {
        return super.getHelpTopicId();
    }
}

