/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChangeListTreePanel;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.MergeConflictsDialog;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOperationUpdate;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import org.tigris.subversion.svnclientadapter.ISVNStatus;

public class SVNUpdateCommand
extends DMSVNOperationUpdate {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.update" : SVNUpdateCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.update", SVNUpdateCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public static IdeAction getAction() {
        return ACTION;
    }

    public SVNUpdateCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.update");
    }

    public boolean isAvailable() {
        if (this.context != null) {
            Design design = VCSClientHelper.getSelectionDesign(this.context.getView());
            if (design != null) {
                return design.isSVNVersioned();
            }
            return false;
        }
        return this.isAvailableImpl();
    }

    public boolean isAvailableImpl() {
        return SVN_CLIENT_HELPER.actionsEnabled(SVNChangeListWindow.getSVNIncomingChangesChangeList(), null, false, false, false, true, true, true, false, true);
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        ArrayList<VersioningTreeNode> treeNodesForRefreshing = new ArrayList<VersioningTreeNode>();
        List<File> filePaths = this.collectFilePaths(treeNodesForRefreshing);
        if (!filePaths.isEmpty()) {
            Collections.sort(filePaths);
            if (this.containsDeletedSystemFiles(treeNodesForRefreshing) && JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNCommitCommand.UpdateDeletedSystemTypes"), Messages.getString("SVNCommitCommand.UpdateDeletedSystemTypesTitle"), 2) != 0) {
                return 1;
            }
            this.updateNotAddedParents(filePaths);
            ArrayList<File> conflicted = new ArrayList<File>();
            SVN_CLIENT_HELPER.doUpdate(filePaths.toArray(new File[0]), true, conflicted);
            if (conflicted.size() > 0) {
                this.fixConflicts(conflicted, treeNodesForRefreshing);
            }
            VersioningTreeNode.refresh(treeNodesForRefreshing, false);
            SVNChangeListWindow.getSVNIncomingChangesChangeList().refresh();
        }
        return 0;
    }

    protected void fixConflicts(List<File> conflicted, List<VersioningTreeNode> nodesForRefreshing) {
        if (conflicted.size() > 0) {
            ArrayList<MergeConflict> updConflicts = new ArrayList<MergeConflict>();
            for (File file : conflicted) {
                ISVNStatus stat = SVN_CLIENT_HELPER.getSingleStatusLocal(file);
                updConflicts.add(new MergeConflict(stat));
            }
            for (MergeConflict mergeConflict : updConflicts) {
                SVNClientHelper.copyOverConflicted(mergeConflict.getLocalFile(), mergeConflict.getLocalLabel());
            }
            MergeConflictsDialog.getInstance().processConflicts(this.getDesign(), updConflicts, nodesForRefreshing, false);
        }
    }

    protected Design getDesign() {
        Object obj = SVNChangeListWindow.getSelectedElementInScopeCB();
        if (obj instanceof Design) {
            return (Design)obj;
        }
        return ApplicationView.getInstance().getCurrentDesign();
    }

    protected void updateNotAddedParents(List<File> filePaths) {
        ArrayList<File> notAddedParents = new ArrayList<File>();
        for (File filePath : filePaths) {
            SVN_CLIENT_HELPER.findNotAddedParents(filePath, notAddedParents);
        }
        if (!notAddedParents.isEmpty()) {
            Collections.sort(notAddedParents);
            SVN_CLIENT_HELPER.doUpdate(notAddedParents.toArray(new File[0]), false);
        }
    }

    private boolean containsDeletedSystemFiles(List<VersioningTreeNode> treeNodes) {
        File defaultRDBMSFile = XMLTransformationManager.getDefaultRDBMSFile();
        File defaultTypesFile = XMLTransformationManager.getDefaultTypesFile();
        for (VersioningTreeNode treeNode : treeNodes) {
            File filePath = treeNode.getFilePath();
            if (!filePath.equals(defaultRDBMSFile) && !filePath.equals(defaultTypesFile) || !treeNode.getStorableObjectStatus().isDeleted()) continue;
            return true;
        }
        return false;
    }

    protected List<File> collectFilePaths(List<VersioningTreeNode> treeNodesForRefreshing) {
        ChangeListTreePanel pan = (ChangeListTreePanel)SVNChangeListWindow.getSVNIncomingChangesChangeList().getPanel();
        return pan.getSelectedFilePaths(treeNodesForRefreshing, false, true, true);
    }
}

