/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.db2.SHColumnElements;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateDistinctTypeDB2;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class DomainHandlerReadDDLDB2
implements StatementsConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;

    public DomainHandlerReadDDLDB2(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList statements) {
        Iterator itStat = statements.iterator();
        while (itStat.hasNext()) {
            String statement = DDLStatementHandler.clearCR((String)itStat.next());
            if (Token.startsWithString(statement = statement.replaceAll("\"", ""), "create distinct type")) {
                SHCreateDistinctTypeDB2 distTypes = new SHCreateDistinctTypeDB2(this.design, this.factoryLogical);
                distTypes.parseDistinctType(statement);
            }
            if (!Token.startsWithString(statement, "create table")) continue;
            ArrayList columns = this.getColumns(statement);
            for (String oneColumn : columns) {
                this.createOneDomain(oneColumn);
            }
        }
    }

    private ArrayList getColumns(String statement) {
        ArrayList<String> tableColumns = new ArrayList<String>();
        String columnStatement = Token.getValBetweenBrackets(statement, 1);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracket(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracket(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString();
                }
            }
            tableColumns.add(oneColumn.trim());
        }
        return tableColumns;
    }

    private void createOneDomain(String statement) {
        SHColumnElements columnElements = new SHColumnElements();
        Map elements = columnElements.getElementsColumn(statement);
        String columnName = (String)elements.get("columnname");
        if (!"".equalsIgnoreCase(columnName)) {
            String datatype = (String)elements.get("datatype");
            String[] parameters = new String[]{(String)elements.get("precision"), (String)elements.get("scale"), (String)elements.get("size")};
            if (datatype != null) {
                String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignDB2v70.RDBMS_TYPE, nameDatatype);
                this.factory.getInstance(this.design, logicalDT, null, 2, parameters, null);
            }
        }
    }
}

