/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RoleOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRoleOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateRoleOraclev10g.class);

    public SHCreateRoleOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateRoleOraclev10g.clearCR(line);
        if (Token.startsWithString(statement, "create role")) {
            try {
                this.parseRole(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateRoleOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseRole(String statement) {
        RoleOraclev10g role;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev10g stoDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(site);
        if (stoDesign != null && (role = (RoleOraclev10g)stoDesign.getRoleSet().createRole()) != null) {
            this.initName(role);
            this.initIdentified(role);
            this.design.getRelationalDesign().stampModelObjectDDL(role);
        }
    }

    private void initName(RoleOraclev10g role) {
        String name = Token.getQuotedNameAfterToken(this.statement, "ROLE").trim();
        role.setName(name);
    }

    private void initIdentified(RoleOraclev10g role) {
        if (Token.hasToken(this.statement, "NOT")) {
            role.setIdentified("NO");
        } else {
            role.setIdentified("YES");
            String str = Token.getTokenAfter(this.statement, "IDENTIFIED").trim();
            if ("BY".equalsIgnoreCase(str)) {
                String pass = Token.getTokenAfter(this.statement, "BY").trim();
                role.setAuthType(RoleOraclev9i.getAuthTypes()[0]);
                role.encodePassword(pass);
            } else if ("USING".equalsIgnoreCase(str)) {
                role.setAuthType(RoleOraclev9i.getAuthTypes()[3]);
                String using = Token.getStringAfter(this.statement, "USING").trim();
                int pointPos = using.indexOf(".");
                if (pointPos != -1) {
                    role.setSchema(using.substring(0, pointPos));
                    role.setPack(using.substring(pointPos + 2));
                } else {
                    role.setPack(using);
                }
            } else {
                role.setAuthType(str);
            }
        }
    }
}

