/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexUDB
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private String indexName = "";
    private StorageDesignUDB stoDesign;
    private String schemaName = null;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateIndexUDB.class);

    public SHCreateIndexUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateIndexUDB.clearCR(line);
        if (Token.startsWithString(statement, "create index") || Token.startsWithString(statement, "create unique index")) {
            try {
                this.index = null;
                this.createIndex(statement);
                if (this.failed) {
                    this.importLog.addFailedStatement(SHCreateIndexUDB.FormatCR(line, "\n"));
                } else {
                    this.importLog.incrementImportedStatements();
                }
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateIndexUDB.FormatCR(line, "\n"));
            }
            this.index = null;
            this.table = null;
            this.indexName = "";
            this.stoDesign = null;
            this.schemaName = null;
            this.failed = false;
        } else {
            this.nextHandler(line);
        }
    }

    private void createIndex(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            if (this.index != null) {
                IndexProxyUDB indexProxy;
                this.initUnique();
                this.setColumnForIndex();
                RDBMSSite site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
                if (this.stoDesign != null && (indexProxy = (IndexProxyUDB)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initSchema(indexProxy, this.stoDesign);
                    this.initInclude(indexProxy);
                    this.initCluster(indexProxy);
                    this.initPctFree(indexProxy);
                    this.initMinPctUsed(indexProxy);
                    this.initReverseScans(indexProxy);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            StringBuffer message = new StringBuffer(e.getMessage());
            message.append(" in SHCreateIndex.createIndex");
            LOGGER.error(message.toString());
            this.importLog.addError("Creating index for statement " + statement + " for UDB failed");
            this.failed = true;
        }
    }

    private void constructIndex() throws ObjectDoesNotExistException {
        String tableName = this.getTableName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(tableName);
        if (this.table != null) {
            Index[] indexes = (Index[])this.table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index ind = indexes[i];
                if (!ind.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = ind;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else {
            this.importLog.addError("Specified table " + tableName + " for index " + this.indexName + " does not exist");
            throw new ObjectDoesNotExistException("Table");
        }
    }

    private void initUnique() {
        boolean unique;
        if (!this.index.isPK() && (unique = Token.hasToken(this.statement, "UNIQUE"))) {
            this.index.setIndexState("Unique Plain Index");
        }
    }

    private String initIndexName() {
        String name = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.schemaName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        Map columnCollection = this.getColumnsForTable();
        if (columnCollection.size() > 0) {
            String columnString = Token.getValBetweenBrackets(this.statement, 1).trim();
            boolean functionString = Token.hasCloseAndOpenBrackets(columnString);
            if (functionString) {
                this.index.setIndexExpression(columnString);
                return;
            }
            columnString = Token.getNamesOnly(columnString);
            StringTokenizer columnToken = new StringTokenizer(columnString, ",");
            while (columnToken.hasMoreTokens()) {
                Column columnTable;
                String columnName = columnToken.nextToken().trim();
                String sortOrder = "ASC";
                if (Token.getLastToken(columnName).equalsIgnoreCase("ASC") || Token.getLastToken(columnName).equalsIgnoreCase("DESC")) {
                    if (Token.getLastToken(columnName).equalsIgnoreCase("DESC")) {
                        sortOrder = "DESC";
                    }
                    columnName = columnName.substring(0, columnName.lastIndexOf(32));
                }
                if ((columnTable = (Column)columnCollection.get(columnName)) != null) {
                    this.index.add(columnTable);
                    this.index.setColumnSortOrder(columnTable, sortOrder);
                    continue;
                }
                this.importLog.addError("Setting column " + columnName + " for index failed");
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> collectionColumns = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columns = (Column[])this.table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    private String getTableName() {
        int posPoint;
        String name = Token.getNameAfterToken(this.statement, "ON", '\"', '\"').trim();
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40));
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        name = Token.removeQuotes(name);
        return name;
    }

    private void initCluster(IndexProxyUDB indexProxy) {
        if (Token.hasToken(this.statement, "CLUSTER")) {
            indexProxy.setCluster(true);
        }
    }

    private void initInclude(IndexProxyUDB indexProxy) {
        if (Token.hasToken(this.statement, "INCLUDE")) {
            String part = this.statement.substring(this.statement.indexOf("INCLUDE") + "INCLUDE".length()).trim();
            String columns = Token.getValBetweenBrackets(part);
            indexProxy.setColumnList(columns);
        }
    }

    private void initPctFree(IndexProxyUDB indexProxy) {
        if (Token.hasToken(this.statement, "PCTFREE")) {
            try {
                int pctFree = Integer.parseInt(Token.getTokenAfter(this.statement, "PCTFREE"));
                indexProxy.setPercentageFree(pctFree);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexUDB.initPctFree : " + e.getMessage());
            }
        }
    }

    private void initMinPctUsed(IndexProxyUDB indexProxy) {
        if (Token.hasToken(this.statement, "MINPCTUSED")) {
            try {
                int minPctUsed = Integer.parseInt(Token.getTokenAfter(this.statement, "MINPCTUSED"));
                indexProxy.setMinimumPercentageUsed(minPctUsed);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MINPCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexUDB.initMinPctUsed : " + e.getMessage());
            }
        }
    }

    private void initReverseScans(IndexProxyUDB indexProxy) {
        if (Token.hasToken(this.statement, "ALLOW")) {
            indexProxy.setReverseScanSupport(true);
        }
    }

    private void initSchema(IndexProxyUDB indexProxy, StorageDesignUDB storageDesign) {
        if (this.schemaName != null) {
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(this.schemaName);
            if (schema != null) {
                indexProxy.setSchema(schema);
            } else {
                OwnerUDB owner = (OwnerUDB)((StorageDesignUDB)indexProxy.getStorageDesign()).getOwnerSet().getByName(this.schemaName);
                if (owner == null) {
                    owner = (OwnerUDB)((StorageDesignUDB)indexProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    owner.setName(this.schemaName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                indexProxy.setOwner(owner);
            }
        } else if (this.getOwner() != null) {
            indexProxy.setOwner((OwnerUDB)this.getOwner());
        }
    }
}

