/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewUDB
extends DDLStatementHandler
implements StatementsConstants {
    private boolean allColumnsAreMade;
    private AbstractView view;
    private String schemaName = null;
    private String userDefined;
    private static final Logger LOGGER = new Logger(SHCreateViewUDB.class);

    public SHCreateViewUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateViewUDB.clearCR(line);
        if (Token.startsWithString(statement, "create view") || Token.startsWithString(statement, "create or replace view") || Token.startsWithString(statement, "create federated view")) {
            try {
                this.userDefined = line;
                this.parseView(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(line);
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseView(String statement) {
        this.statement = statement;
        this.allColumnsAreMade = true;
        if (this.allColumnsAreMade) {
            this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
            String nameView = this.initName();
            if (this.schemaName != null && !"".equals(this.schemaName)) {
                this.view.setSchema(this.schemaName);
            }
            this.view.setName(nameView);
            this.design.getRelationalDesign().stampModelObjectDDL(this.view);
            if (Token.getTokenAfter(statement, nameView).trim().equalsIgnoreCase("OF")) {
                TableViewProxyUDB viewProxy;
                RDBMSSite site = this.design.getSelectedRDBMSSite();
                StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
                if (storageDesign != null && (viewProxy = (TableViewProxyUDB)storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                    StructuredType type;
                    String temp = Token.getStringAfterToken(statement, "OF").trim();
                    String stName = Token.getFirstToken(temp).trim();
                    int posPoint = stName.indexOf(46);
                    if (posPoint > 0) {
                        stName = Token.getValAfterCharacter(stName, '.');
                    }
                    if ((type = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                        this.view.setBasedOnStructuredType(type);
                    } else {
                        LOGGER.error("Unable to find required Structured Type: " + stName);
                    }
                    if (Token.hasToken(statement, "UNDER")) {
                        AbstractView superView;
                        String superViewName = Token.getTokenAfter(statement, "UNDER").trim();
                        posPoint = superViewName.indexOf(46);
                        if (posPoint > 0) {
                            superViewName = Token.getValAfterCharacter(superViewName, '.');
                        }
                        if ((superView = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getByName(superViewName)) != null) {
                            ContainerView parentTV = (ContainerView)superView.getTopView();
                            ContainerView childTV = (ContainerView)this.view.getTopView();
                            if (parentTV != null && childTV != null) {
                                TypeSubstitution ts = this.design.getRelationalDesign().createTypeSubstitution();
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                ts.setChildCV(childTV);
                                ts.setParentCV(parentTV);
                                ts.addToAllDPVs();
                            }
                        }
                    }
                    if (Token.hasString(statement, "REF IS")) {
                        String oidColumnName = Token.getStringAfter(statement, "REF IS").trim();
                        oidColumnName = Token.getFirstToken(oidColumnName).trim();
                        viewProxy.setOidColumnName(oidColumnName);
                        if (Token.hasToken(statement, "UNCHECKED")) {
                            viewProxy.setOidColumnUniqueness(false);
                        }
                    }
                }
            } else {
                TableViewProxyUDB viewProxy;
                RDBMSSite site;
                StorageDesignUDB storageDesign;
                this.initUserDefinedSql();
                if (!this.initCols()) {
                    this.initCol();
                }
                if ((storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site = this.design.getSelectedRDBMSSite())) != null && (viewProxy = (TableViewProxyUDB)storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                    this.initCheckOption(viewProxy);
                    this.initOwner(viewProxy, storageDesign);
                }
            }
        }
    }

    public boolean initCols() {
        String beforeSelect = Token.getStringBeforeToken(this.statement, "AS");
        if (!Token.hasToken(beforeSelect, "OF") && Token.hasCloseAndOpenBrackets(beforeSelect)) {
            String cols = Token.getValBetweenBrackets(beforeSelect, 1);
            if (!"".equalsIgnoreCase(cols)) {
                StringTokenizer tokenizer = new StringTokenizer(cols, ",");
                String column = "";
                while (tokenizer.hasMoreTokens()) {
                    column = Token.removeQuotes(tokenizer.nextToken());
                    AbstractViewElement cvExp = this.view.createViewElement(this.view.getDesignPart());
                    cvExp.setName(column);
                    cvExp.setDesign(this.design);
                    cvExp.setAlias(column);
                    cvExp.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                    this.view.add(cvExp);
                }
            }
            return true;
        }
        return false;
    }

    private void initCheckOption(TableViewProxyUDB viewProxy) {
        String beforeCheckOption = Token.getStringBeforeToken(this.statement, "CHECK OPTION");
        if (beforeCheckOption.isEmpty()) {
            viewProxy.setCheckOption(false);
        } else {
            viewProxy.setCheckOption(true);
            if (beforeCheckOption.toUpperCase().endsWith("LOCAL")) {
                viewProxy.setCheckOptionScope("LOCAL");
            } else {
                viewProxy.setCheckOptionScope("CASCADED");
            }
        }
    }

    private void initUserDefinedSql() {
        String sql = this.parseAsSelect(this.userDefined);
        String sqlUpper = sql.toUpperCase();
        int lastWithIndex = sqlUpper.lastIndexOf("WITH");
        if (lastWithIndex > -1 && sqlUpper.indexOf("CHECK OPTION", lastWithIndex) > -1) {
            sql = sql.substring(0, lastWithIndex).trim();
        }
        this.view.setUserDefinedSQL(sql);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("DB2");
    }

    private String parseAsSelect(String userDef) {
        String beforeAs = Token.getStringBefore2(userDef, "AS");
        String afterAs = Token.getStringAfter(userDef, "AS");
        if (!"".equals(beforeAs) && !"".equals(afterAs) && afterAs.startsWith("(")) {
            afterAs = Token.getValBetweenBrackets(afterAs);
            return beforeAs + " AS " + afterAs;
        }
        return userDef;
    }

    private void initOwner(TableViewProxyUDB tableViewProxy, StorageDesignUDB storageDesign) {
        if (this.schemaName != null) {
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(this.schemaName);
            if (schema == null) {
                schema = storageDesign.getSchemaSet().createSchema();
                schema.setName(this.schemaName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
            }
            if (schema != null) {
                tableViewProxy.setSchema(schema);
            }
        }
    }

    private String initName() {
        String name = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.schemaName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    public void initCol() {
        String statementAs = this.removeClosingBrackets(this.statement);
        String stmt = Token.getStringAfter(statementAs, "AS SELECT").trim();
        if (stmt.equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            stmt = Token.getStringAfter(statementAs, "SELECT").trim();
        }
        if (!stmt.equalsIgnoreCase("")) {
            if (Token.hasToken(statementAs, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf("FROM");
                String beforeFrom = stmt.substring(0, fromInd);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")")) {
                    fromInd = stmt.toUpperCase().indexOf("FROM", fromInd + 1);
                    beforeFrom = stmt.substring(0, fromInd);
                }
                stmt = beforeFrom;
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            Object columnAlias = null;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                if (Token.hasToken(column, "AS")) {
                    columnAlias = Token.getNameAfterToken(column, "AS", '\"', '\"');
                    column = Token.getStringBeforeToken(column, "AS");
                }
                column = Token.encodeQuotedString(column);
                if (columnAlias == null && column.indexOf(32) > -1) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = ((String)columnAlias).lastIndexOf(34);
                        columnAlias = ((String)columnAlias).substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else if (column.charAt(column.length() - 1) == '\'') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = ((String)columnAlias).lastIndexOf(39);
                        columnAlias = ((String)columnAlias).substring(lastIndex) + "'";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                if (!Token.hasCloseAndOpenBrackets(column = Token.removeQuotes(Token.decodeQuotedString(column))) && column.indexOf(43) == -1 && column.indexOf(45) == -1 && column.indexOf(42) == -1 && column.indexOf(47) == -1 && column.indexOf(58) == -1 && column.indexOf("||") == -1 && !Token.hasToken(column, "CONCAT") && column.indexOf(46) > -1 && (column = column.substring(column.indexOf(46) + 1)).indexOf(46) > -1) {
                    column = column.substring(column.indexOf(46) + 1);
                }
                if (column.equalsIgnoreCase("") || column.equalsIgnoreCase("*")) continue;
                AbstractViewElement cvExp = this.view.createViewElement(this.view.getDesignPart());
                cvExp.setName(column);
                cvExp.setDesign(this.design);
                cvExp.setExpression(column);
                cvExp.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                this.view.add(cvExp);
                if (columnAlias != null) {
                    columnAlias = Token.removeQuotes(Token.decodeQuotedString((String)columnAlias));
                    cvExp.setAlias((String)columnAlias);
                    cvExp.setHeaderAlias((String)columnAlias);
                    continue;
                }
                cvExp.setAlias(cvExp.getName());
            }
        }
    }

    public void setView(AbstractView view) {
        this.view = view;
    }

    private String removeClosingBrackets(String statement) {
        int ind = statement.toLowerCase().indexOf(" as ");
        String stb = "";
        Object stmt = statement;
        if (ind > -1) {
            stb = statement.substring(0, ind + 4);
            stmt = statement.substring(ind + 4).trim();
            if (((String)stmt).charAt(0) == '(') {
                stmt = Token.getValBetweenBrackets((String)stmt);
            }
            stmt = stb + (String)stmt;
        }
        return stmt;
    }
}

