/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.erwin.ERSAXHandler;
import oracle.dbtools.crest.imports.erwin.ERwinConstantsv7x;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DPVMainPanel;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ERSAXParserv7x
extends ERSAXHandler
implements ERwinConstantsv7x {
    protected static final Logger LOGGER = new Logger(ERSAXParserv7x.class);
    private Design design;
    private LogicalDesign logical;
    private RelationalDesign relational;
    private boolean fileOK;
    private ImportLogger importLog;
    private static int PROGRESS_INCREMENT = 5;
    private static String ID_PREFIX_ATTRIBUTE = "ATT-";
    private static String ID_PREFIX_ATTRIBUTE_VIEW = "AVW-";
    private static String ID_PREFIX_CANDIDATE_KEY = "CKY-";
    private static String ID_PREFIX_COLUMN = "COL-";
    private static String ID_PREFIX_COLUMN_VIEW = "CVW-";
    private static String ID_PREFIX_DOMAIN = "DOM-";
    private static String ID_PREFIX_ENTITY = "ENT-";
    private static String ID_PREFIX_ENTITY_VIEW = "EVW-";
    private static String ID_PREFIX_FK_INDEX_ASSOCIATION = "FKI-";
    private static String ID_PREFIX_FK_INDEX_ASSOCIATION2 = "FK2-";
    private static String ID_PREFIX_FUNCTION = "FUN-";
    private static String ID_PREFIX_INDEX = "IND-";
    private static String ID_PREFIX_INHERITANCE_RELATION = "IHR-";
    private static String ID_PREFIX_PACKAGE = "PKG-";
    private static String ID_PREFIX_PARTITION = "PRT-";
    private static String ID_PREFIX_PK_INDEX = "XPK-";
    private static String ID_PREFIX_RELATION = "REL-";
    private static String ID_PREFIX_SEQUENCE = "SEQ-";
    private static String ID_PREFIX_STORED_PROCEDURE = "PRC-";
    private static String ID_PREFIX_TABLE = "TAB-";
    private static String ID_PREFIX_TABLE_VIEW = "TVW-";
    private static String ID_PREFIX_TABLESPACE = "TSP-";
    private static String ID_PREFIX_TRIGGER = "TRG-";
    private static int DO_SCRATCH_ENTITY_WIDTH = 200;
    private static int DO_SCRATCH_ENTITY_HEIGHT = 200;
    private static int DO_MTM_ENTITY_WIDTH = 200;
    private static int DO_MTM_ENTITY_HEIGHT = 100;
    private static String UDP_LIBRARY_PREFIX = "UDPLibraryImportedFrom_ERwin.udposdm";
    private String UDP_Definition_Group;
    private TempUDP tempUDP;
    private String tempUDPID;
    private TempUDPInstance tempUDPInstance;
    private String tempUDPInstanceID;
    private UDPLibrary udpLibrary = null;
    private UserDefinedProperty UDPObject = null;
    private Map UDPMap = new TreeMap();
    private String targetServer;
    private String targetVersion;
    private RDBMSType rdbmsType = null;
    private RDBMSSite rdbmsSite = null;
    private StorageDesignOracle oracleStorage = null;
    private boolean createLogical;
    private boolean createRelational;
    private String designName;
    private Map logicalObjects = new TreeMap();
    private Map relationalObjects = new TreeMap();
    private Map relationKey = new TreeMap();
    private List logicalViews = new ArrayList();
    private List relationalViews = new ArrayList();
    private List logicalFKElements = new ArrayList();
    private List relationalFKElements = new ArrayList();
    private TempEntity tempEntity;
    private String tempEntityID;
    private TempAttribute tempAttribute;
    private String tempAttributeID;
    private TempKey tempKey;
    private String tempKeyID;
    private TempKeyMember tempKeyMember;
    private String tempKeyMemberID;
    private TempPhysicalStorage tempPhysicalStorage;
    private String tempPhysicalStorageID;
    private TempTrigger tempTableTrigger;
    private String tempTableTriggerID;
    private TempPartition tempPartition;
    private String tempPartitionID;
    private TempPartitionInfo tempPartitionInfo;
    private String tempPartitionInfoID;
    private TempSubPartitionInfo tempSubPartitionInfo;
    private String tempSubPartitionInfoID;
    private Map domains = new TreeMap();
    private Map childDomains = new TreeMap();
    private List usedDomains = new ArrayList();
    private TempDomain tempDomain;
    private String tempDomainID;
    private Map tablespaces = new TreeMap();
    private TempOracleTablespace tempOracleTablespace;
    private String tempOracleTablespaceID;
    private boolean isMainLogical = true;
    private boolean isMainRelational = true;
    private List subjectAreas = new ArrayList();
    private TempSubjectArea tempSubjectArea;
    private String tempSubjectAreaID;
    private TempStoredDisplay tempStoredDisplay;
    private String tempStoredDisplayID;
    private TempDrawingObject tempDrawingObject;
    private String tempDrawingObjectID;
    private List inheritanceObjects = new ArrayList();
    private List replacedAttributes = new ArrayList();
    private List manyToManyTables = new ArrayList();
    private TempRelationship tempRelationship;
    private String tempRelationshipID;
    private Map defaultValues = new TreeMap();
    private TempDefaultValue tempDefaultValue;
    private String tempDefaultValueID;
    private Map validationRules = new TreeMap();
    private TempValidationRule tempValidationRule;
    private String tempValidationRuleID;
    private Map storedProcedures = new TreeMap();
    private TempPLSQLSource tempStoredProcedure;
    private String tempStoredProcedureID;
    private TempMTMTransform tempMTMTransform;
    private String tempMTMTransformID;
    private Map rollUpTransforms = new TreeMap();
    private TempRollUpTransform tempRollUpTransform;
    private String tempRollUpTransformID;
    private TempRollUpSubTransform tempRollUpSubTransform;
    private String tempRollUpSubTransformID;
    private String tempSourceObjectRef;
    private String tempTargetObjectRef;
    private List logicalViews2 = new ArrayList();
    private List relationalViews2 = new ArrayList();
    private TempView tempView;
    private String tempViewID;
    private TempViewAttribute tempViewAttribute;
    private String tempViewAttributeID;
    private TempTrigger tempViewTrigger;
    private String tempViewTriggerID;
    private TempSequence tempSequence;
    private String tempSequenceID;
    private Map fonts = new TreeMap();
    private TempFont tempFont;
    private String tempFontID;
    private String defaultNameFontID;
    private String defaultNameColor;
    private String defaultFillColor;
    private String defaultOutlineColor;
    private String defaultAttributeFontID;
    private String defaultAttributeColor;
    private TempPLSQLSource tempOraclePackage;
    private String tempOraclePackageID;
    private Map functions = new TreeMap();
    private TempPLSQLSource tempFunction;
    private String tempFunctionID;
    private Stack scratchGroupStack = new Stack();
    private Stack scratchObjectStack = new Stack();
    private Map scratchObjects = new TreeMap();
    private TempScratchObject tempScratchObject;
    private String tempScratchObjectID;
    private List domainWaitingList = new ArrayList();
    private List schemaWaitingList = new ArrayList();
    private List storedProcedureWaitingList = new ArrayList();
    private List functionWaitingList = new ArrayList();
    private List tablespaceWaitingList = new ArrayList();
    private List defaultValueWaitingList = new ArrayList();
    private List validationRuleWaitingList = new ArrayList();
    private List fontWaitingList = new ArrayList();
    private List transformWaitingList = new ArrayList();

    public ERSAXParserv7x(ApplicationView appView, boolean inExistingDesign, ImportLogger importLog) {
        super(appView, inExistingDesign);
        this.design = appView.getCurrentDesign();
        this.logical = this.design.getLogicalDesign();
        this.relational = this.design.getRelationalDesign();
        this.fileOK = false;
        this.importLog = importLog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (attributes == null) {
                LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML File - No Attributes found for Tag " + qName);
                throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatNoAttributes"), qName));
            }
            if (qName.equalsIgnoreCase("ERwin")) {
                this.monitorProgress(Messages.getString("ERSAXParserv7x.StartOfImport"), 0);
                this.initWaitingLists();
                String fileVersion = attributes.getValue("FileVersion");
                if (!fileVersion.startsWith("7.3.")) {
                    LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML File - FileVersion=" + fileVersion);
                    throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileVersionNotSupported"), "7.3", fileVersion));
                }
                this.fileOK = true;
            } else if (!this.fileOK) {
                LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML File - First Tag is " + qName);
                throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidTagStart"), "ERwin", qName));
            }
            this.stack.push(qName);
            this.text.reset();
            if (this.stack.search("UDP:UDP_Definition_Groups") != -1) {
                this.startUDPDefinitionGroups(uri, localName, qName, attributes);
            }
            if (this.stack.search("EMX:Model") == -1) return;
            if (this.stack.search("ModelEnvProps") != -1) {
                this.startModelEnvProps(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("ModelProps") != -1) {
                this.startModelProps(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Entity_Groups") != -1) {
                this.startEntitiesAndAttributes(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Domain_Groups") != -1) {
                this.startDomains(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("AttributeProps") != -1) {
                this.startAttributes(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Oracle_Tablespace_Groups") != -1) {
                this.startOracleTablespaces(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Subject_Area_Groups") != -1) {
                this.startSubjectAreas(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Relationship_Groups") != -1) {
                this.startRelationships(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Default_Groups") != -1) {
                this.startDefaultValues(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Validation_Rule_Groups") != -1) {
                this.startValidationRules(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Stored_Procedure_Groups") != -1) {
                this.startStoredProcedures(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Many_To_Many_Transform_Groups") != -1) {
                this.startManyToManyTransforms(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Supertype_Subtype_Roll_Up_Transform_Groups") != -1) {
                this.startRollUpTransforms(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("View_Groups") != -1) {
                this.startViews(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Sequence_Groups") != -1) {
                this.startSequences(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Font_Groups") != -1) {
                this.startFonts(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Default_Fonts_And_Colors_Groups") != -1) {
                this.startDefaultFontsAndColors(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Oracle_Package_Groups") != -1) {
                this.startOraclePackages(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Function_Groups") != -1) {
                this.startFunctions(uri, localName, qName, attributes);
                return;
            }
            if (this.stack.search("Transform_Scratch_Object_Groups") == -1) return;
            this.startTransformScratchObjects(uri, localName, qName, attributes);
            return;
        }
        catch (EmptyStackException e) {
            LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML - Stack error at " + qName, e);
            throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidStackStart"), qName));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (!((String)this.stack.peek()).equalsIgnoreCase(qName)) {
                LOGGER.error("ERSAXParserv7x.endElement() - Invalid XML - Stack error at " + qName);
                throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidTagEnd"), (String)this.stack.peek(), qName));
            }
            if (this.stack.search("UDP:UDP_Definition_Groups") != -1) {
                this.endUDPDefinitionGroups(uri, localName, qName);
            }
            if (this.stack.search("EMX:Model") != -1) {
                if (this.stack.search("ModelEnvProps") != -1) {
                    this.endModelEnvProps(uri, localName, qName);
                } else if (this.stack.search("ModelProps") != -1) {
                    this.endModelProps(uri, localName, qName);
                } else if (this.stack.search("Entity_Groups") != -1) {
                    this.endEntitiesAndAttributes(uri, localName, qName);
                } else if (this.stack.search("Domain_Groups") != -1) {
                    this.endDomains(uri, localName, qName);
                } else if (this.stack.search("Oracle_Tablespace_Groups") != -1) {
                    this.endOracleTablespaces(uri, localName, qName);
                } else if (this.stack.search("Subject_Area_Groups") != -1) {
                    this.endSubjectAreas(uri, localName, qName);
                } else if (this.stack.search("Relationship_Groups") != -1) {
                    this.endRelationships(uri, localName, qName);
                } else if (this.stack.search("Default_Groups") != -1) {
                    this.endDefaultValues(uri, localName, qName);
                } else if (this.stack.search("Validation_Rule_Groups") != -1) {
                    this.endValidationRules(uri, localName, qName);
                } else if (this.stack.search("Stored_Procedure_Groups") != -1) {
                    this.endStoredProcedures(uri, localName, qName);
                } else if (this.stack.search("Many_To_Many_Transform_Groups") != -1) {
                    this.endManyToManyTransforms(uri, localName, qName);
                } else if (this.stack.search("Supertype_Subtype_Roll_Up_Transform_Groups") != -1) {
                    this.endRollUpTransforms(uri, localName, qName);
                } else if (this.stack.search("View_Groups") != -1) {
                    this.endViews(uri, localName, qName);
                } else if (this.stack.search("Sequence_Groups") != -1) {
                    this.endSequences(uri, localName, qName);
                } else if (this.stack.search("Font_Groups") != -1) {
                    this.endFonts(uri, localName, qName);
                } else if (this.stack.search("Default_Fonts_And_Colors_Groups") != -1) {
                    this.endDefaultFontsAndColors(uri, localName, qName);
                } else if (this.stack.search("Oracle_Package_Groups") != -1) {
                    this.endOraclePackages(uri, localName, qName);
                } else if (this.stack.search("Function_Groups") != -1) {
                    this.endFunctions(uri, localName, qName);
                } else if (this.stack.search("Transform_Scratch_Object_Groups") != -1) {
                    this.endTransformScratchObjects(uri, localName, qName);
                }
            }
            if (qName.equalsIgnoreCase("ERwin")) {
                this.monitorProgress(Messages.getString("ERSAXParserv7x.ResolveReferences"), PROGRESS_INCREMENT);
                this.resolveWaitingLists();
                this.resolveSubjectAreas();
                if (this.isMainLogical) {
                    this.design.getLogicalDesign().rearrangeEntities();
                    this.design.getLogicalDesign().rearrangeViews();
                    this.design.getLogicalDesign().getMainView().setAutoRoute(true);
                    this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
                }
                if (this.isMainRelational) {
                    ((DPVRelational)this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                    this.design.getRelationalDesign().rearrangeViews();
                    this.design.getRelationalDesign().getMainView().setAutoRoute(true);
                    this.design.getRelationalDesign().getMainView().getWorkSpace().updateSettings();
                }
                this.resolveDesignModels();
                this.setDesignName(this.designName);
                if (this.udpLibrary != null) {
                    this.udpLibrary.setFileName("UDPLibraryImportedFrom_ERwin.udposdm");
                    this.design.getAppView().getUDPLibrariesPersistence().merge(this.udpLibrary, XMLTransformationManager.getDefaultSystemTypesPath());
                    this.design.getAppView().getUDPLibrariesPersistence().load(this.design, this.design.getAppView());
                }
                Object[] pathway = new Object[]{this.design.getParent(), this.design};
                JTree tree = this.design.getAppView().getBrowserPanel().getJTree();
                int row = tree.getRowForPath(new TreePath(pathway));
                tree.collapseRow(row);
                tree.expandRow(row);
                this.monitorProgress(Messages.getString("ERSAXParserv7x.EndOfImport"), 100);
            }
            this.stack.pop();
            if (qName.equalsIgnoreCase("ERwin")) {
                if (!this.stack.empty()) {
                    LOGGER.error("ERSAXParserv7x.endElement() - Invalid XML - Stack error at " + qName);
                    throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidStackEnd"), qName));
                }
                this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportComplete"), -1);
            }
        }
        catch (EmptyStackException e) {
            LOGGER.error("ERSAXParserv7x.endElement() - Invalid XML - Stack error at " + qName, e);
            throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidStackEnd"), qName));
        }
    }

    private void startUDPDefinitionGroups(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("UDP:UDP_Definition_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportUDPs"), PROGRESS_INCREMENT);
            this.udpLibrary = new UDPLibrary();
            this.UDPMap = new TreeMap();
            this.UDP_Definition_Group = "";
        } else if (qName.toUpperCase().endsWith("_Groups".toUpperCase()) && this.stack.search("Property_Type") == -1) {
            this.UDP_Definition_Group = qName;
        } else if (this.stack.search("Property_Type") != -1 && !"".equals(this.UDP_Definition_Group)) {
            this.startUDPPropertyType(uri, localName, qName, attributes);
        }
    }

    private void startUDPPropertyType(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Property_Type")) {
            this.tempUDPID = attributes.getValue("id");
            this.tempUDP = new TempUDP(this.tempUDPID, attributes.getValue("name"));
            this.tempUDP.setDefGroup(this.UDP_Definition_Group);
        }
    }

    private void endUDPDefinitionGroups(String uri, String localName, String qName) throws SAXException {
        if (this.stack.search("Property_Type") == -1) {
            this.UDP_Definition_Group = "";
        } else if (this.stack.search("Property_Type") != -1 && !"".equals(this.UDP_Definition_Group)) {
            this.endUDPPropertyType(uri, localName, qName);
        }
    }

    private void endUDPPropertyType(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Property_Type")) {
            this.UDPObject = new UserDefinedProperty(this.udpLibrary, this.tempUDP.getName(), this.tempUDP.getUDPType());
            this.UDPObject.setDisplayName("");
            this.UDPObject.setDescription(this.tempUDP.getDefinition());
            Class udpClass = this.tempUDP.getUDPLogicalClass();
            if (udpClass != null) {
                this.UDPObject.getObjectsVisibilityMap().put(udpClass, true);
            }
            if ((udpClass = this.tempUDP.getUDPPhysicalClass()) != null) {
                this.UDPObject.getObjectsVisibilityMap().put(udpClass, true);
            }
            this.UDPObject.setLovMap(this.tempUDP.getLOVMap());
            this.udpLibrary.getPropertiesList().add(this.UDPObject);
            this.UDPMap.put(this.tempUDP.getID(), this.UDPObject);
        } else if (this.stack.search("Property_TypeProps") != -1) {
            if (qName.equalsIgnoreCase("Definition")) {
                this.tempUDP.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("tag_Udp_Data_Type")) {
                this.tempUDP.setDataType(this.getText());
            } else if (qName.equalsIgnoreCase("tag_Udp_Default_Value")) {
                this.tempUDP.setDefaultValue(this.getText());
            } else if (qName.equalsIgnoreCase("tag_Udp_Values_List")) {
                this.tempUDP.setValuesList(this.getText());
            } else if (qName.equalsIgnoreCase("tag_Is_Logical")) {
                this.tempUDP.setIsLogical(this.getText());
            } else if (qName.equalsIgnoreCase("tag_Is_Physical")) {
                this.tempUDP.setIsPhysical(this.getText());
            }
        }
    }

    private void startModelEnvProps(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("ModelEnvProps")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportModelEnvironment"), PROGRESS_INCREMENT);
            this.targetServer = "";
            this.targetVersion = "";
        }
    }

    private void endModelEnvProps(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("ModelEnvProps")) {
            this.rdbmsType = null;
            if (this.targetServer.equalsIgnoreCase("1075858978")) {
                this.rdbmsType = this.targetVersion.equals("7") ? StorageDesignDB2v70.RDBMS_TYPE : (this.targetVersion.equals("8") ? StorageDesignDB2v70.RDBMS_TYPE : StorageDesignDB2v80.RDBMS_TYPE);
            } else if (this.targetServer.equalsIgnoreCase("1075858979")) {
                this.rdbmsType = this.targetVersion.equals("9") ? StorageDesignOraclev9i.RDBMS_TYPE : (this.targetVersion.equals("10") ? StorageDesignOraclev10g.RDBMS_TYPE : (this.targetVersion.equals("11") ? StorageDesignOraclev11g.RDBMS_TYPE : (this.targetVersion.equals("12") ? StorageDesignOraclev12cR2.RDBMS_TYPE : StorageDesignOraclev12c.RDBMS_TYPE)));
            } else if (this.targetServer.equalsIgnoreCase("1075859016")) {
                this.rdbmsType = this.targetVersion.equals("8") ? StorageDesignSqlServerv2k.RDBMS_TYPE : (this.targetVersion.equals("9") ? StorageDesignSqlServerv2k5.RDBMS_TYPE : StorageDesignSqlServerv2k.RDBMS_TYPE);
            } else if (this.targetServer.equalsIgnoreCase("1075858977")) {
                this.rdbmsType = this.targetVersion.equals("7") ? StorageDesignUDBv71.RDBMS_TYPE : (this.targetVersion.equals("8") ? StorageDesignUDBv81.RDBMS_TYPE : (this.targetVersion.equals("9") ? StorageDesignUDBv9.RDBMS_TYPE : StorageDesignUDBv71.RDBMS_TYPE));
            }
            if (this.rdbmsType != null) {
                this.rdbmsSite = this.design.getFirstOfType(this.rdbmsType);
                this.design.setSelectedRDBMSSite(this.rdbmsSite);
                if ("Oracle Database".equalsIgnoreCase(this.rdbmsType.getProductName())) {
                    this.oracleStorage = (StorageDesignOracle)this.design.getStorageDesign(this.rdbmsSite);
                    this.relational.getStorageDesignFactory().getSorageDesigns().add(this.oracleStorage);
                    this.oracleStorage.setOpen(true);
                }
            }
        } else if (qName.equalsIgnoreCase("Target_Server")) {
            this.targetServer = this.getText();
        } else if (qName.equalsIgnoreCase("Target_Server_Version")) {
            this.targetVersion = this.getText();
        }
    }

    private void startModelProps(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("ModelProps")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportModelProperties"), PROGRESS_INCREMENT);
            this.createLogical = true;
            this.createRelational = true;
            this.designName = "";
        }
    }

    private void endModelProps(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Name")) {
            this.designName = this.getText();
        } else if (qName.equalsIgnoreCase("Type")) {
            if (this.getText().equalsIgnoreCase("1")) {
                this.createRelational = false;
            } else if (this.getText().equalsIgnoreCase("2")) {
                this.createLogical = false;
            }
        }
    }

    private void startEntitiesAndAttributes(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Entity_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportEntitiesAndAttributes"), PROGRESS_INCREMENT);
            this.logicalObjects = new TreeMap();
            this.relationalObjects = new TreeMap();
            this.logicalViews = new ArrayList();
            this.relationalViews = new ArrayList();
            this.logicalFKElements = new ArrayList();
            this.relationalFKElements = new ArrayList();
        } else if (qName.equalsIgnoreCase("Entity")) {
            this.tempEntityID = attributes.getValue("id");
            this.tempEntity = new TempEntity(this.tempEntityID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Attribute_Groups")) {
            this.tempEntity.initAttributes();
        } else if (qName.equalsIgnoreCase("Attribute")) {
            this.tempAttributeID = attributes.getValue("id");
            this.tempAttribute = new TempAttribute(this.tempAttributeID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Logical_Data_Type")) {
            String yes;
            if (attributes.getLength() > 0 && attributes.getIndex("Derived") > -1 && this.tempAttribute != null && "Y".equals(yes = attributes.getValue("Derived"))) {
                this.tempAttribute.dataTypeDerived = true;
            }
        } else if (qName.equalsIgnoreCase("Key_Group_Groups")) {
            this.tempEntity.initKeys();
        } else if (qName.equalsIgnoreCase("Key_Group")) {
            this.tempKeyID = attributes.getValue("id");
            this.tempKey = new TempKey(this.tempKeyID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Key_Group_Member")) {
            this.tempKeyMemberID = attributes.getValue("id");
            this.tempKeyMember = new TempKeyMember(this.tempKeyMemberID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Oracle_Physical_Storage_Groups") && this.stack.search("Oracle_Partition_Description") == -1) {
            this.tempEntity.initPhysicalStorages();
        } else if (qName.equalsIgnoreCase("Oracle_Physical_Storage") && this.stack.search("Oracle_Partition_Description") == -1) {
            this.tempPhysicalStorageID = attributes.getValue("id");
            this.tempPhysicalStorage = new TempPhysicalStorage(this.tempPhysicalStorageID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Trigger_Groups")) {
            this.tempEntity.initTriggers();
        } else if (qName.equalsIgnoreCase("Trigger")) {
            this.tempTableTriggerID = attributes.getValue("id");
            this.tempTableTrigger = new TempTrigger(this.tempTableTriggerID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Oracle_Range_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (qName.equalsIgnoreCase("Oracle_Range_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "1");
        } else if (qName.equalsIgnoreCase("Oracle_Range_Partition_Info_Groups")) {
            this.tempPartition.initPartitionInfos();
        } else if (qName.equalsIgnoreCase("Oracle_Range_Partition_Info")) {
            this.tempPartitionInfoID = attributes.getValue("id");
            this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Oracle_List_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (qName.equalsIgnoreCase("Oracle_List_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "2");
        } else if (qName.equalsIgnoreCase("Oracle_List_Partition_Info_Groups")) {
            this.tempPartition.initPartitionInfos();
        } else if (qName.equalsIgnoreCase("Oracle_List_Partition_Info")) {
            this.tempPartitionInfoID = attributes.getValue("id");
            this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Oracle_Hash_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (qName.equalsIgnoreCase("Oracle_Hash_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "3");
            this.tempPartitionInfoID = "";
            this.tempPartitionInfo = null;
        } else if (qName.equalsIgnoreCase("Oracle_Individual_Hash_Partition_Groups")) {
            this.tempPartition.initPartitionInfos();
        } else if (qName.equalsIgnoreCase("Oracle_Individual_Hash_Partition")) {
            this.tempPartitionInfoID = attributes.getValue("id");
            this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Oracle_Composite_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (qName.equalsIgnoreCase("Oracle_Composite_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "4");
        } else if (qName.equalsIgnoreCase("Oracle_Subpartition_Spec_Groups")) {
            this.tempPartitionInfo.initSubPartitionInfos();
        } else if (qName.equalsIgnoreCase("Oracle_Subpartition_Spec")) {
            this.tempSubPartitionInfoID = attributes.getValue("id");
            this.tempSubPartitionInfo = new TempSubPartitionInfo(this.tempSubPartitionInfoID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("UDP_Instance")) {
            this.tempUDPInstanceID = attributes.getValue("id");
            this.tempUDPInstance = new TempUDPInstance(this.tempUDPInstanceID, attributes.getValue("name"));
        }
    }

    private void endEntitiesAndAttributes(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Entity_Groups")) {
            if (this.createLogical) {
                this.parseEntityViews();
            }
            if (this.createRelational) {
                this.parseTableViews();
            }
            if (this.createLogical && this.createRelational) {
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
            }
        } else if (qName.equalsIgnoreCase("Entity")) {
            this.parseEntity();
        } else if (this.stack.search("EntityProps") != -1) {
            if (qName.equalsIgnoreCase("Type")) {
                this.tempEntity.setType(this.getText());
            } else if (qName.equalsIgnoreCase("Physical_Name")) {
                this.tempEntity.setPhysicalName(this.getText());
            } else if (qName.equalsIgnoreCase("Schema_Name")) {
                this.tempEntity.setSchemaName(this.getText());
            } else if (qName.equalsIgnoreCase("Is_Physical_Only")) {
                this.tempEntity.setPhysicalOnly(this.getText());
            } else if (qName.equalsIgnoreCase("Is_Logical_Only")) {
                this.tempEntity.setLogicalOnly(this.getText());
            } else if (qName.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempEntity.setHideInLogical(this.getText());
            } else if (qName.equalsIgnoreCase("Hide_In_Physical")) {
                this.tempEntity.setHideInPhysical(this.getText());
            } else if (qName.equalsIgnoreCase("Definition")) {
                this.tempEntity.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Fill_Color")) {
                this.tempEntity.setBgColorVal(this.getText());
            } else if (qName.equalsIgnoreCase("Outline_Color")) {
                this.tempEntity.setOutlineColorVal(this.getText());
            } else if (qName.equalsIgnoreCase("Default_Entity_Name_Font_Ref")) {
                this.tempEntity.setNameFontID(this.getText());
            } else if (qName.equalsIgnoreCase("Default_Entity_Name_Color")) {
                this.tempEntity.setNameColorVal(this.getText());
            } else if (qName.equalsIgnoreCase("Compress_Type")) {
                this.tempEntity.setCompressType(this.getText());
            } else if (qName.equalsIgnoreCase("Comment") || qName.equalsIgnoreCase("Note")) {
                this.tempEntity.setComment(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Partition_Type")) {
                this.tempEntity.setPartitionType(this.getText());
            } else if (qName.equalsIgnoreCase("Source_Of_Transforms_Ref")) {
                this.tempEntity.addSourceOfTransform(this.getText());
            } else if (qName.equalsIgnoreCase("Target_Of_Transforms_Ref")) {
                this.tempEntity.addTargetOfTransform(this.getText());
            } else if (qName.equalsIgnoreCase("Validation_Rule_Ref")) {
                this.tempEntity.addValidRuleRef(this.getText());
            } else if (qName.equalsIgnoreCase("Stored_Procedures_Ref")) {
                this.tempEntity.addStoredProcedureRef(this.getText());
            } else if (qName.equalsIgnoreCase("Functions_Ref")) {
                this.tempEntity.addFunctionRef(this.getText());
            } else if (this.stack.search("Attributes_Order_Ref_Array") != -1) {
                if (qName.equalsIgnoreCase("Attributes_Order_Ref")) {
                    this.tempEntity.getAttributesOrder().add(this.getText());
                }
            } else if (this.stack.search("Columns_Order_Ref_Array") != -1) {
                if (qName.equalsIgnoreCase("Columns_Order_Ref")) {
                    this.tempEntity.getColumnsOrder().add(this.getText());
                }
            } else if (qName.equalsIgnoreCase("UDP_Instance")) {
                this.tempUDPInstance.setValue(this.getText());
                this.tempEntity.getUDPInstances().add(this.tempUDPInstance);
            }
        } else if (qName.equalsIgnoreCase("Attribute")) {
            this.tempEntity.addAttribute(this.tempAttribute);
        } else if (this.stack.search("AttributeProps") != -1) {
            if (qName.equalsIgnoreCase("Physical_Name")) {
                this.tempAttribute.setPhysicalName(this.getText());
            } else if (qName.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempAttribute.setHideInLogical(this.getText());
            } else if (qName.equalsIgnoreCase("Hide_In_Physical")) {
                this.tempAttribute.setHideInPhysical(this.getText());
            } else if (qName.equalsIgnoreCase("Parent_Attribute_Ref")) {
                this.tempAttribute.setParentAttrRef(this.getText());
            } else if (qName.equalsIgnoreCase("Parent_Relationship_Ref")) {
                this.tempAttribute.setParentRelRef(this.getText());
            } else if (qName.equalsIgnoreCase("Logical_Lead_Attribute_Ref")) {
                this.tempAttribute.setLogicalRef(this.getText());
            } else if (qName.equalsIgnoreCase("Physical_Lead_Attribute_Ref")) {
                this.tempAttribute.setPhysicalRef(this.getText());
            } else if (qName.equalsIgnoreCase("Parent_Domain_Ref")) {
                this.tempAttribute.setParentDomRef(this.getText());
            } else if (qName.equalsIgnoreCase("Logical_Data_Type")) {
                this.tempAttribute.setLogicalDataType(this.getText());
            } else if (qName.equalsIgnoreCase("Physical_Data_Type")) {
                this.tempAttribute.setPhysicalDataType(this.getText());
            } else if (qName.equalsIgnoreCase("Definition")) {
                this.tempAttribute.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Null_Option_Type")) {
                this.tempAttribute.setNullOptionType(this.getText());
            } else if (qName.equalsIgnoreCase("Validation_Rule_Ref")) {
                this.tempAttribute.setValidRuleRef(this.getText());
            } else if (qName.equalsIgnoreCase("Default")) {
                this.tempAttribute.setDefaultRef(this.getText());
            } else if (qName.equalsIgnoreCase("Font_Ref")) {
                this.tempAttribute.setFontRef(this.getText());
            } else if (qName.equalsIgnoreCase("Font_Color")) {
                this.tempAttribute.setFontColor(this.getText());
            } else if (qName.equalsIgnoreCase("Comment") || qName.equalsIgnoreCase("Note")) {
                this.tempAttribute.setComment(this.getText());
            } else if (qName.equalsIgnoreCase("Source_Of_Transforms_Ref")) {
                this.tempAttribute.addSourceOfTransform(this.getText());
            } else if (qName.equalsIgnoreCase("Target_Of_Transforms_Ref")) {
                this.tempAttribute.addTargetOfTransform(this.getText());
            } else if (qName.equalsIgnoreCase("View_Expression")) {
                this.tempAttribute.setViewExpression(this.getText());
            } else if (qName.equalsIgnoreCase("UDP_Instance")) {
                this.tempUDPInstance.setValue(this.getText());
                this.tempAttribute.getUDPInstances().add(this.tempUDPInstance);
            }
        } else if (qName.equalsIgnoreCase("Key_Group")) {
            this.tempEntity.addKey(this.tempKey);
        } else if (this.stack.search("Key_GroupProps") != -1) {
            if (qName.equalsIgnoreCase("Physical_Name")) {
                this.tempKey.setPhysicalName(this.getText());
            } else if (qName.equalsIgnoreCase("Key_Group_Type")) {
                this.tempKey.setType(this.getText());
            } else if (qName.equalsIgnoreCase("Definition")) {
                this.tempKey.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Relationship_Ref")) {
                String relID = this.getText();
                this.relationKey.put(relID, this.tempKey);
            }
        } else if (qName.equalsIgnoreCase("Key_Group_Member")) {
            this.tempKey.addKeyMember(this.tempKeyMember);
        } else if (this.stack.search("Key_Group_MemberProps") != -1) {
            if (qName.equalsIgnoreCase("Attribute_Ref")) {
                this.tempKeyMember.setAttributeRef(this.getText());
            } else if (qName.equalsIgnoreCase("Key_Group_Sort_Order")) {
                this.tempKeyMember.setSortOrder(this.getText());
            }
        } else if (qName.equalsIgnoreCase("Oracle_Physical_Storage") && this.stack.search("Oracle_Partition_Description") == -1) {
            this.tempEntity.addPhysicalStorage(this.tempPhysicalStorage);
        } else if (this.stack.search("Oracle_Physical_StorageProps") != -1 && this.stack.search("Oracle_Partition_Description") == -1) {
            if (qName.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPhysicalStorage.setTablespaceRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Buffer_Pool")) {
                this.tempPhysicalStorage.setBufferPool(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Free_List_Groups")) {
                this.tempPhysicalStorage.setFreeListGroups(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Free_Lists")) {
                this.tempPhysicalStorage.setFreeLists(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Initial_Extent_Size")) {
                this.tempPhysicalStorage.setInitialExtentSize(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Initial_Transactions")) {
                this.tempPhysicalStorage.setInitialTransactions(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Max_Extent_Type")) {
                this.tempPhysicalStorage.setMaxExtentType(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Max_Extents")) {
                this.tempPhysicalStorage.setMaxExtents(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Min_Extents")) {
                this.tempPhysicalStorage.setMinExtents(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Next_Extent_Size")) {
                this.tempPhysicalStorage.setNextExtentSize(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_No_Logging")) {
                this.tempPhysicalStorage.setNoLogging(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Percent_Free")) {
                this.tempPhysicalStorage.setPercentIncrease(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Percent_Increase")) {
                this.tempPhysicalStorage.setPercentIncrease(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Percent_Used")) {
                this.tempPhysicalStorage.setPercentIncrease(this.getText());
            }
        } else if (qName.equalsIgnoreCase("Trigger")) {
            this.tempEntity.addTrigger(this.tempTableTrigger);
        } else if (this.stack.search("TriggerProps") != -1) {
            if (qName.equalsIgnoreCase("Definition")) {
                this.tempTableTrigger.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Schema_Name")) {
                this.tempTableTrigger.setSchemaName(this.getText());
            } else if (qName.equalsIgnoreCase("Type")) {
                this.tempTableTrigger.setType(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Status")) {
                this.tempTableTrigger.setStatus(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Fire_Type")) {
                this.tempTableTrigger.setFireType(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Scope")) {
                this.tempTableTrigger.setScope(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Old")) {
                this.tempTableTrigger.setOldAs(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_New")) {
                this.tempTableTrigger.setNewAs(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Body")) {
                this.tempTableTrigger.setBody(this.getText());
            } else if (qName.equalsIgnoreCase("When_Clause")) {
                this.tempTableTrigger.setWhen(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Update_Columns_Ref")) {
                this.tempTableTrigger.addColumnRef(this.getText());
            }
        } else if (qName.equalsIgnoreCase("Oracle_Range_Partition")) {
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_Range_Partition") != -1) {
            if (qName.equalsIgnoreCase("Columns_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Range_Partition_Info")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (qName.equalsIgnoreCase("Partition_Values")) {
                this.tempPartitionInfo.addPartitionValue(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            }
        } else if (qName.equalsIgnoreCase("Oracle_List_Partition")) {
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_List_Partition") != -1) {
            if (qName.equalsIgnoreCase("Column_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_List_Partition_Info")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (qName.equalsIgnoreCase("Partition_Values")) {
                this.tempPartitionInfo.addPartitionValue(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            }
        } else if (qName.equalsIgnoreCase("Oracle_Hash_Partition")) {
            if ("1".equalsIgnoreCase(this.tempPartition.getHashType())) {
                this.tempPartitionInfoID = this.tempPartitionID.replace("+00000000", "+00000001");
                this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, this.tempPartition.getName());
                this.tempPartitionInfo.setTablespaceRefs(this.tempPartition.getTablespaceRefs());
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            }
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_Hash_Partition") != -1) {
            if (qName.equalsIgnoreCase("Columns_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Hash_Partition_Type")) {
                this.tempPartition.setHashType(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Hash_Partition_Quantity")) {
                this.tempPartition.setHashQuantity(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Tablespaces_Ref")) {
                this.tempPartition.addTablespaceRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Individual_Hash_Partition")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (qName.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            }
        } else if (qName.equalsIgnoreCase("Oracle_Composite_Partition")) {
            this.tempEntity.setCompositeType(this.tempPartition.getCompositePartitionType());
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_Composite_Partition") != -1) {
            if (qName.equalsIgnoreCase("Columns_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Composite_Subpartition_Type")) {
                this.tempPartition.setCompositePartitionType(this.getText());
            } else if (qName.equalsIgnoreCase("Column_Ref")) {
                this.tempPartition.setCompositeListColumnRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Hash_Columns_Ref")) {
                this.tempPartition.addHashColumnRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Range_Partition_Info")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (qName.equalsIgnoreCase("Oracle_Subpartition_Spec")) {
                this.tempPartitionInfo.addSubPartitionInfo(this.tempSubPartitionInfo);
            } else if (qName.equalsIgnoreCase("Oracle_Hash_Partition_Quantity") && this.stack.search("Oracle_Range_Partition_Info") == -1) {
                this.tempPartition.setHashQuantity(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Hash_Partition_Quantity") && this.stack.search("Oracle_Range_Partition_Info") != -1) {
                this.tempPartitionInfo.setPartHashQuantity(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Tablespaces_Ref") && this.stack.search("Oracle_Range_Partition_Info") == -1) {
                this.tempPartition.addTablespaceRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Tablespaces_Ref") && this.stack.search("Oracle_Range_Partition_Info") != -1) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            } else if (qName.equalsIgnoreCase("Partition_Values") && this.stack.search("Oracle_Subpartition_Spec") == -1) {
                this.tempPartitionInfo.addPartitionValue(this.getText());
            } else if (qName.equalsIgnoreCase("Partition_Values") && this.stack.search("Oracle_Subpartition_Spec") != -1) {
                this.tempSubPartitionInfo.addSubPartitionValue(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Tablespace_Ref") && this.stack.search("Oracle_Subpartition_Spec") == -1) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Tablespace_Ref") && this.stack.search("Oracle_Subpartition_Spec") != -1) {
                this.tempSubPartitionInfo.setSubTablespaceRef(this.getText());
            }
        }
    }

    private void orderContainer(ContainerObject cont, List<String> list, Map map) {
        Iterator<String> it = list.iterator();
        int ind = 0;
        while (it.hasNext()) {
            String id = it.next();
            ContainedObject co = (ContainedObject)map.get(id);
            if (co == null || co.getContainer() != cont) continue;
            cont.moveToIndex(co, ind);
            ++ind;
        }
    }

    private void parseEntity() {
        if (this.createLogical && !"true".equalsIgnoreCase(this.tempEntity.getPhysicalOnly()) && !"true".equalsIgnoreCase(this.tempEntity.getHideInLogical()) && this.tempEntity.getTargetOfTransforms().isEmpty() && !"".equalsIgnoreCase(this.tempEntity.getName())) {
            if ("17".equalsIgnoreCase(this.tempEntity.getType())) {
                EntityView entityView = this.logical.getEntityViewSet().createEntityView(this.deriveObjectID(ID_PREFIX_ENTITY_VIEW, this.tempEntityID));
                entityView.setName(this.tempEntity.getName());
                this.logicalObjects.put(this.tempEntityID, entityView);
                if (!"".equals(this.tempEntity.getDefinition())) {
                    entityView.setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    entityView.setNotes(this.tempEntity.getComment());
                }
                this.setFontAndColor(entityView, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                this.logicalViews.add(this.tempEntity);
            } else {
                Entity entity = this.logical.getEntitySet().createEntity(this.deriveObjectID(ID_PREFIX_ENTITY, this.tempEntityID));
                entity.setName(this.tempEntity.getName());
                this.logicalObjects.put(this.tempEntityID, entity);
                if (!"".equals(this.tempEntity.getDefinition())) {
                    entity.setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    entity.setNotes(this.tempEntity.getComment());
                }
                this.parseAttributes(this.tempEntity, entity);
                this.parseKeys(this.tempEntity, entity);
                this.setFontAndColor(entity, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                List<TempUDPInstance> udpInstances = this.tempEntity.getUDPInstances();
                for (int i = 0; i < udpInstances.size(); ++i) {
                    TempUDPInstance udpInstance = udpInstances.get(i);
                    if (!udpInstance.validForClass(Entity.class)) continue;
                    entity.setProperty(udpInstance.getName(), udpInstance.getValue());
                }
                if (this.createLogical && this.createRelational) {
                    for (String srcRef : this.tempEntity.getSourceOfTransforms()) {
                        this.transformWaitingList.add(new TransformWaitingListEntry(true, srcRef, this.tempEntityID));
                    }
                }
                this.orderContainer(entity, this.tempEntity.getAttributesOrder(), this.logicalObjects);
            }
        }
        if (this.createRelational && !"true".equalsIgnoreCase(this.tempEntity.getLogicalOnly()) && !"true".equalsIgnoreCase(this.tempEntity.getHideInPhysical()) && this.tempEntity.getSourceOfTransforms().isEmpty() && !"".equalsIgnoreCase(this.tempEntity.getName())) {
            String name = this.tempEntity.getName();
            if (!"".equalsIgnoreCase(this.tempEntity.getPhysicalName())) {
                name = this.tempEntity.getPhysicalName();
            }
            if ("17".equalsIgnoreCase(this.tempEntity.getType())) {
                TableViewProxyOracle viewProxy;
                TableView tableView = this.relational.getTableViewSet().createTableView(this.deriveObjectID(ID_PREFIX_TABLE_VIEW, this.tempEntityID));
                tableView.setName(name);
                this.relationalObjects.put(this.tempEntityID, tableView);
                if (!"".equals(this.tempEntity.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), tableView));
                }
                if (!"".equals(this.tempEntity.getDefinition())) {
                    tableView.setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    tableView.setNotes(this.tempEntity.getComment());
                }
                this.setFontAndColor(tableView, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                this.relationalViews.add(this.tempEntity);
                if (this.oracleStorage != null && (viewProxy = (TableViewProxyOracle)this.oracleStorage.getTableViewProxySet().getProxy(tableView.getObjectID())) != null && !"".equals(this.tempEntity.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), viewProxy));
                }
            } else {
                TableProxyOracle proxy;
                Table table = this.relational.getTableSet().createTable(this.deriveObjectID(ID_PREFIX_TABLE, this.tempEntityID));
                table.setName(name);
                this.relationalObjects.put(this.tempEntityID, table);
                if (!"".equals(this.tempEntity.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), table));
                }
                if (!"".equals(this.tempEntity.getDefinition())) {
                    table.setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    table.setNotes(this.tempEntity.getComment());
                }
                this.parseColumns(this.tempEntity, table);
                this.parseIndexes(this.tempEntity, table);
                for (String vrID : this.tempEntity.getValidRuleRefs()) {
                    if (this.validationRules.isEmpty()) {
                        this.validationRuleWaitingList.add(new ValidationRuleWaitingListEntry(table, vrID, true));
                        continue;
                    }
                    ValidationRuleHolder vrh = (ValidationRuleHolder)this.validationRules.get(vrID);
                    if (vrh == null || vrh.getType() != 0) continue;
                    TableLevelConstraint constraint = table.createCheckConstraint(vrh.getName(), vrh.getRule());
                    table.addCheckConstraint(constraint);
                }
                this.setFontAndColor(table, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                this.orderContainer(table, this.tempEntity.getColumnsOrder(), this.relationalObjects);
                List<TempUDPInstance> udpInstances = this.tempEntity.getUDPInstances();
                for (int i = 0; i < udpInstances.size(); ++i) {
                    TempUDPInstance udpInstance = udpInstances.get(i);
                    if (!udpInstance.validForClass(Table.class)) continue;
                    table.setProperty(udpInstance.getName(), udpInstance.getValue());
                }
                if (this.createLogical && this.createRelational) {
                    for (String tgtRef : this.tempEntity.getTargetOfTransforms()) {
                        this.transformWaitingList.add(new TransformWaitingListEntry(false, tgtRef, this.tempEntityID));
                    }
                }
                if (this.oracleStorage != null && (proxy = (TableProxyOracle)this.oracleStorage.getTableProxySet().getProxy(table.getObjectID())) != null) {
                    for (TempPhysicalStorage phys : this.tempEntity.getPhysicalStorages()) {
                        proxy.setSegment(this.parseSegment(phys));
                        if (phys.noLogging()) {
                            proxy.setLogging("NOLOGGING");
                        } else {
                            proxy.setLogging("LOGGING");
                        }
                        if ("".equals(phys.getTablespaceRef())) continue;
                        this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(phys.getTablespaceRef(), proxy));
                    }
                    if (!"".equals(this.tempEntity.getSchemaName())) {
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), proxy));
                    }
                    if ("918".equalsIgnoreCase(this.tempEntity.getCompressType()) || "919".equalsIgnoreCase(this.tempEntity.getCompressType())) {
                        proxy.setDataSegmentCompression("919".equalsIgnoreCase(this.tempEntity.getCompressType()) ? "YES" : "NO");
                    }
                    for (TempTrigger tempTrig : this.tempEntity.getTriggers()) {
                        TriggerOracle trig = this.oracleStorage.getTriggerSet().createTrigger(this.deriveObjectID(ID_PREFIX_TRIGGER, tempTrig.getID()));
                        trig.setName(tempTrig.getName());
                        trig.setTable(proxy);
                        this.parseTrigger(tempTrig, trig);
                        if ("".equals(tempTrig.getSchemaName())) continue;
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(tempTrig.getSchemaName(), trig));
                    }
                    for (String procRef : this.tempEntity.getStoredProcedureRefs()) {
                        this.storedProcedureWaitingList.add(new StoredProcedureWaitingListEntry(procRef, proxy));
                    }
                    for (String funcRef : this.tempEntity.getFunctionRefs()) {
                        this.functionWaitingList.add(new FunctionWaitingListEntry(funcRef, proxy));
                    }
                    if (!"".equals(this.tempEntity.getPartitionType())) {
                        this.parseTablePartition(proxy);
                    }
                }
            }
        }
    }

    private void parseSchema(String schemaName, DesignObject desObj) {
        if (desObj instanceof Table) {
            ((Table)desObj).setSchema(schemaName);
            ((Table)desObj).getSchemaObject().getTables().add(desObj);
        } else if (desObj instanceof TableView) {
            ((TableView)desObj).setSchema(schemaName);
            ((TableView)desObj).getSchemaObject().getViews().add(desObj);
        } else if (desObj instanceof Index) {
            ((Index)desObj).setSchema(schemaName);
            ((Index)desObj).getSchemaObject().getIndexes().add(desObj);
        }
    }

    private void parseProxySchema(String userName, RelationalObjectProxy proxy) {
        SchemaObjectSet schemaSet;
        SchemaObject so;
        UserOracle user = (UserOracle)((StorageDesignOracle)proxy.getStorageDesign()).getUserSet().getByName(userName);
        if (user == null) {
            user = (UserOracle)((StorageDesignOracle)proxy.getStorageDesign()).getUserSet().createElement(null);
            user.setName(userName);
        }
        if ((so = (SchemaObject)(schemaSet = this.relational.getSchemaObjectSet()).getByName(userName)) == null && !userName.trim().equalsIgnoreCase("")) {
            so = schemaSet.createSchemaObject(null);
            so.setName(userName);
        }
        if (user != null) {
            if (user.getSchemaObject() == null) {
                user.setSchemaObject(so);
            }
            if (user.getSchemaObject() != so) {
                if (proxy instanceof TableProxyOracle) {
                    ((TableProxyOracle)proxy).setUser(user);
                } else if (proxy instanceof TableViewProxyOracle) {
                    ((TableViewProxyOracle)proxy).setUser(user);
                } else if (proxy instanceof IndexProxyOracle) {
                    ((IndexProxyOracle)proxy).setUser(user);
                }
            }
        }
    }

    private void parseStorageSchema(String schemaName, StorageObject storObj) {
        UserOracle user = this.createUser(schemaName);
        if (storObj instanceof SequenceOracle) {
            ((SequenceOracle)storObj).setUser(user);
        } else if (storObj instanceof TriggerOracle) {
            ((TriggerOracle)storObj).setOwner(user);
        } else if (storObj instanceof StoredProcedureOracle) {
            ((StoredProcedureOracle)storObj).setOwner(user);
        } else if (storObj instanceof PackageOracle) {
            ((PackageOracle)storObj).setOwner(user);
        } else if (storObj instanceof FunctionOracle) {
            ((FunctionOracle)storObj).setOwner(user);
        }
    }

    private UserOracle createUser(String schemaName) {
        UserOracle user = (UserOracle)this.oracleStorage.getUserSet().getByName(schemaName);
        if (user == null) {
            user = this.oracleStorage.getUserSet().createUser();
            user.setName(schemaName);
        }
        return user;
    }

    private SegmentOracle parseSegment(TempPhysicalStorage phys) {
        SegmentOracle segment = this.oracleStorage.getSegmentSet().createSegment();
        segment.setName(phys.getName());
        segment.setInitrans(phys.getInitialTransactions());
        segment.setPCTFree(phys.getPercentFree());
        segment.setPCTUsed(phys.getPercentUsed());
        segment.setSCBufferPool(phys.getBufferPool());
        segment.setSCFreeLists(phys.getFreeLists());
        segment.setSCFreelistGroups(phys.getFreeListGroups());
        segment.setSCInitialExtent(phys.getInitialExtentSize());
        segment.setSCMinExtents(phys.getMinExtents());
        segment.setSCNextExtent(phys.getNextExtentSize());
        segment.setSCPctIncrease(phys.getPercentIncrease());
        if ("900".equalsIgnoreCase(phys.getBufferPool())) {
            segment.setSCBufferPool("KEEP");
        } else if ("901".equalsIgnoreCase(phys.getBufferPool())) {
            segment.setSCBufferPool("RECYCLE");
        } else if ("902".equalsIgnoreCase(phys.getBufferPool())) {
            segment.setSCBufferPool("DEFAULT");
        }
        if ("0".equalsIgnoreCase(phys.getMaxExtentType())) {
            segment.setSCMaxExtents("0");
        } else if ("1".equalsIgnoreCase(phys.getMaxExtentType())) {
            segment.setSCMaxExtents(String.valueOf(phys.getMaxExtents()));
        }
        return this.oracleStorage.getSegmentSet().findEqual(segment);
    }

    private void parseAttributes(TempEntity tempEnt, Entity entity) {
        for (TempAttribute tempAttr : tempEnt.getAttributes()) {
            String tempAttrID = tempAttr.getID();
            if ("true".equalsIgnoreCase(tempAttr.getHideInLogical()) || !tempAttr.getTargetOfTransforms().isEmpty()) continue;
            if (!"".equals(tempAttr.getParentAttrRef()) && !"".equals(tempAttr.getParentRelRef())) {
                FKElement fke = new FKElement(tempAttrID, tempAttr.getParentAttrRef(), tempAttr.getParentRelRef());
                fke.setLogicalRef(tempAttr.getLogicalRef());
                fke.setPhysicalRef(tempAttr.getPhysicalRef());
                this.logicalFKElements.add(fke);
            }
            Attribute attr = entity.createAttribute(tempAttr.getName());
            attr.setObjectID(this.deriveObjectID(ID_PREFIX_ATTRIBUTE, tempAttrID));
            this.logicalObjects.put(tempAttrID, attr);
            if (!"".equals(tempAttr.getDefinition())) {
                attr.setComment(tempAttr.getDefinition());
            }
            if (!"".equals(tempAttr.getComment())) {
                attr.setNotes(tempAttr.getComment());
            }
            if ("0".equals(tempAttr.getNullOptionType())) {
                attr.setNullsAllowed(true);
            } else {
                attr.setNullsAllowed(false);
            }
            boolean dtOK = false;
            if (!"".equals(tempAttr.getLogicalDataType())) {
                dtOK = this.parseDataType(attr, tempAttr.getLogicalDataType());
            }
            if (tempAttr.dataTypeDerived && !"".equals(tempAttr.getParentDomRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry(attr, tempAttr.getParentDomRef(), dtOK));
                } else {
                    Domain dom = (Domain)this.domains.get(tempAttr.getParentDomRef());
                    if (!(dom == null || dom.getName().equalsIgnoreCase("<root>") || dom.getName().equalsIgnoreCase("<default>") || dom.getName().equalsIgnoreCase("<unknown>") || dom.getName().equalsIgnoreCase("Unknown") || !this.isDomainFor(dom, attr))) {
                        attr.setDomain(dom);
                        attr.setUse((short)0);
                        if (!this.usedDomains.contains(dom.getObjectID())) {
                            this.usedDomains.add(dom.getObjectID());
                        }
                    }
                }
            }
            if (!"".equals(tempAttr.getValidRuleRef())) {
                if (this.validationRules.isEmpty()) {
                    this.validationRuleWaitingList.add(new ValidationRuleWaitingListEntry(attr, tempAttr.getValidRuleRef(), false));
                } else {
                    attr.setUseDomainConstraints(false);
                    this.applyValidationRule(attr, tempAttr.getValidRuleRef());
                }
            }
            if (!"".equals(tempAttr.getDefaultRef())) {
                if (this.defaultValues.isEmpty()) {
                    this.defaultValueWaitingList.add(new DefaultValueWaitingListEntry(attr, tempAttr.getDefaultRef()));
                } else {
                    String def = (String)this.defaultValues.get(tempAttr.getDefaultRef());
                    if (def != null) {
                        attr.setUsesDefaultValue(true);
                        attr.setDefaultValue(def);
                    }
                }
            }
            this.setAttributeFontAndColor(entity, tempAttr.getFontRef(), tempAttr.getFontColor(), true);
            List<TempUDPInstance> udpInstances = tempAttr.getUDPInstances();
            for (int i = 0; i < udpInstances.size(); ++i) {
                TempUDPInstance udpInstance = udpInstances.get(i);
                if (!udpInstance.validForClass(Attribute.class)) continue;
                attr.setProperty(udpInstance.getName(), udpInstance.getValue());
            }
        }
    }

    private void parseKeys(TempEntity tempEnt, Entity entity) {
        for (TempKey entKey : tempEnt.getKeys()) {
            String entKeyID = entKey.getID();
            String entKeyType = entKey.getType();
            if (entKeyType.toUpperCase().startsWith("IF") || entKey.getKeyMembers().size() <= 0) continue;
            CandidateKey key = entity.createCandidateKey(this.deriveObjectID(ID_PREFIX_CANDIDATE_KEY, entKeyID));
            key.setName(entKey.getName());
            this.logicalObjects.put(entKeyID, key);
            if (!"".equals(entKey.getDefinition())) {
                key.setComment(entKey.getDefinition());
            }
            for (TempKeyMember member : entKey.getKeyMembers()) {
                String attrRef = member.getAttributeRef();
                Attribute attrObj = (Attribute)this.logicalObjects.get(attrRef);
                if (attrObj == null) continue;
                key.add(attrObj);
            }
            if (!entKeyType.equalsIgnoreCase("PK")) continue;
            key.makePK();
        }
    }

    private void parseColumns(TempEntity tempEnt, Table table) {
        for (TempAttribute tempAttr : tempEnt.getAttributes()) {
            String tempAttrID = tempAttr.getID();
            if (!tempAttr.getSourceOfTransforms().isEmpty()) continue;
            String colName = tempAttr.getName();
            if (!"".equals(tempAttr.getPhysicalName())) {
                colName = tempAttr.getPhysicalName();
            }
            if (!"".equals(tempAttr.getParentAttrRef()) && !"".equals(tempAttr.getParentRelRef())) {
                FKElement fke = new FKElement(tempAttrID, tempAttr.getParentAttrRef(), tempAttr.getParentRelRef());
                fke.setLogicalRef(tempAttr.getLogicalRef());
                fke.setPhysicalRef(tempAttr.getPhysicalRef());
                this.relationalFKElements.add(fke);
            }
            if ("true".equalsIgnoreCase(tempAttr.getHideInPhysical())) continue;
            Column col = table.createColumn(colName, this.deriveObjectID(ID_PREFIX_COLUMN, tempAttrID));
            this.relationalObjects.put(tempAttrID, col);
            if (!"".equals(tempAttr.getDefinition())) {
                col.setComment(tempAttr.getDefinition());
            }
            if (!"".equals(tempAttr.getComment())) {
                col.setNotes(tempAttr.getComment());
            }
            if ("0".equals(tempAttr.getNullOptionType())) {
                col.setNullsAllowed(true);
            } else {
                col.setNullsAllowed(false);
            }
            boolean dtOK = false;
            if (!"".equals(tempAttr.getPhysicalDataType())) {
                dtOK = this.parsePhysicalDataType(col, tempAttr.getPhysicalDataType());
            }
            if (!dtOK && !"".equals(tempAttr.getLogicalDataType())) {
                dtOK = this.parseDataType(col, tempAttr.getLogicalDataType());
            }
            if (tempAttr.dataTypeDerived && !"".equals(tempAttr.getParentDomRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry(col, tempAttr.getParentDomRef(), dtOK));
                } else {
                    Domain dom = (Domain)this.domains.get(tempAttr.getParentDomRef());
                    if (!(dom == null || dom.getName().equalsIgnoreCase("<root>") || dom.getName().equalsIgnoreCase("<default>") || dom.getName().equalsIgnoreCase("<unknown>") || dom.getName().equalsIgnoreCase("Unknown") || !this.isDomainFor(dom, col))) {
                        col.setDomain(dom);
                        col.setUse((short)0);
                        if (!this.usedDomains.contains(dom.getObjectID())) {
                            this.usedDomains.add(dom.getObjectID());
                        }
                    }
                }
            }
            if (!"".equals(tempAttr.getValidRuleRef())) {
                if (this.validationRules.isEmpty()) {
                    this.validationRuleWaitingList.add(new ValidationRuleWaitingListEntry(col, tempAttr.getValidRuleRef(), false));
                } else {
                    col.setUseDomainConstraints(false);
                    this.applyValidationRule(col, tempAttr.getValidRuleRef());
                }
            }
            if (!"".equals(tempAttr.getDefaultRef())) {
                if (this.defaultValues.isEmpty()) {
                    this.defaultValueWaitingList.add(new DefaultValueWaitingListEntry(col, tempAttr.getDefaultRef()));
                } else {
                    String def = (String)this.defaultValues.get(tempAttr.getDefaultRef());
                    if (def != null) {
                        col.setUsesDefaultValue(true);
                        col.setDefaultValue(def);
                    }
                }
            }
            this.setAttributeFontAndColor(table, tempAttr.getFontRef(), tempAttr.getFontColor(), false);
            List<TempUDPInstance> udpInstances = tempAttr.getUDPInstances();
            for (int i = 0; i < udpInstances.size(); ++i) {
                TempUDPInstance udpInstance = udpInstances.get(i);
                if (!udpInstance.validForClass(Column.class)) continue;
                col.setProperty(udpInstance.getName(), udpInstance.getValue());
            }
        }
    }

    private void parseIndexes(TempEntity tempEnt, Table table) {
        for (TempKey entKey : tempEnt.getKeys()) {
            IndexProxyOracle indexProxy;
            String entKeyID = entKey.getID();
            String entKeyType = entKey.getType();
            if (entKeyType.toUpperCase().startsWith("IF") || entKey.getKeyMembers().size() <= 0) continue;
            String idxName = entKey.getName();
            if (!"".equals(entKey.getPhysicalName())) {
                idxName = entKey.getPhysicalName();
            }
            String idxID = this.deriveObjectID(ID_PREFIX_INDEX, entKeyID);
            if (entKeyType.equalsIgnoreCase("PK")) {
                idxID = this.deriveObjectID(ID_PREFIX_PK_INDEX, entKeyID);
            }
            Index idx = table.createIndex(idxID);
            idx.setName(idxName);
            this.relationalObjects.put(entKeyID, idx);
            if (!"".equals(tempEnt.getSchemaName())) {
                this.schemaWaitingList.add(new SchemaWaitingListEntry(tempEnt.getSchemaName(), idx));
            }
            if (!"".equals(entKey.getDefinition())) {
                idx.setComment(entKey.getDefinition());
            }
            for (TempKeyMember member : entKey.getKeyMembers()) {
                String attrRef = member.getAttributeRef();
                Column attrObj = (Column)this.relationalObjects.get(attrRef);
                if (attrObj == null) continue;
                idx.add(attrObj);
                if (!"ASC".equalsIgnoreCase(member.getSortOrder()) && !"DESC".equalsIgnoreCase(member.getSortOrder())) continue;
                idx.setColumnSortOrder(attrObj, member.getSortOrder().toUpperCase());
            }
            if (entKeyType.equalsIgnoreCase("PK")) {
                idx.makePK();
            } else if (entKeyType.toUpperCase().startsWith("AK")) {
                idx.setIndexState("Unique Constraint");
            }
            if (this.oracleStorage == null || (indexProxy = (IndexProxyOracle)this.oracleStorage.getIndexProxySet().getProxy(idx.getObjectID())) == null) continue;
            indexProxy.setName(idxName);
            if (!"".equals(tempEnt.getSchemaName())) {
                this.schemaWaitingList.add(new SchemaWaitingListEntry(tempEnt.getSchemaName(), indexProxy));
            }
            for (TempPhysicalStorage phys : tempEnt.getPhysicalStorages()) {
                if ("".equals(phys.getTablespaceRef())) continue;
                this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(phys.getTablespaceRef(), indexProxy));
            }
        }
    }

    private void parseEntityViews() {
        for (TempEntity tempEnt : this.logicalViews) {
            String tempEntID = tempEnt.getID();
            EntityView view = (EntityView)this.logicalObjects.get(tempEntID);
            if (view == null) continue;
            this.parseViewAttributes(tempEnt, view);
        }
    }

    private void parseTableViews() {
        for (TempEntity tempEnt : this.relationalViews) {
            String tempEntID = tempEnt.getID();
            TableView view = (TableView)this.relationalObjects.get(tempEntID);
            if (view == null) continue;
            this.parseViewColumns(tempEnt, view);
        }
    }

    private void parseViewAttributes(TempEntity tempEnt, EntityView view) {
        for (TempAttribute tempAttr : tempEnt.getAttributes()) {
            Attribute attr;
            String tempAttrID = tempAttr.getID();
            if ("true".equalsIgnoreCase(tempAttr.getHideInLogical())) continue;
            AttributeView attrView = (AttributeView)view.createContainedObject(this.deriveObjectID(ID_PREFIX_ATTRIBUTE_VIEW, tempAttrID));
            attrView.setName(tempAttr.getName());
            if (!"".equals(tempAttr.getViewExpression())) {
                attrView.setExpression(tempAttr.getViewExpression());
                attrView.setEntityAlias(view.getName());
            } else if (!"".equals(tempAttr.getParentAttrRef()) && (attr = (Attribute)this.logicalObjects.get(tempAttr.getParentAttrRef())) != null) {
                attrView.setReferencedAttribute(attr);
                attrView.setDataType(attr.getDataType().toString());
                attrView.setEntity((Entity)attr.getContainer());
                view.addToContainers(attr.getContainer(), attr.getContainer().getName());
            }
            this.setAttributeFontAndColor(view, tempAttr.getFontRef(), tempAttr.getFontColor(), true);
        }
    }

    private void parseViewColumns(TempEntity tempEnt, TableView view) {
        for (TempAttribute tempAttr : tempEnt.getAttributes()) {
            Column col;
            String tempAttrID = tempAttr.getID();
            if ("true".equalsIgnoreCase(tempAttr.getHideInPhysical())) continue;
            ColumnView colView = (ColumnView)view.createContainedObject(this.deriveObjectID(ID_PREFIX_COLUMN_VIEW, tempAttrID));
            if (!"".equals(tempAttr.getPhysicalName())) {
                colView.setName(tempAttr.getPhysicalName());
            } else {
                colView.setName(tempAttr.getName());
            }
            if (!"".equals(tempAttr.getViewExpression())) {
                colView.setExpression(tempAttr.getViewExpression());
                colView.setTableAlias(view.getName());
            } else if (!"".equals(tempAttr.getParentAttrRef()) && (col = (Column)this.relationalObjects.get(tempAttr.getParentAttrRef())) != null) {
                colView.setReferencedColumn(col);
                colView.setDataType(col.getDataType().toString());
                colView.setTable((Table)col.getContainer());
                view.addToContainers(col.getContainer(), col.getContainer().getName());
            }
            this.setAttributeFontAndColor(view, tempAttr.getFontRef(), tempAttr.getFontColor(), false);
        }
    }

    private void parseTrigger(TempTrigger tempTrig, TriggerOracle trig) {
        if (!"".equals(tempTrig.getDefinition())) {
            trig.setComment(tempTrig.getDefinition());
        }
        if (!"".equals(tempTrig.getType())) {
            try {
                int type = Integer.parseInt(tempTrig.getType());
                if ((type & 1) == 1) {
                    trig.setActions("UPDATE");
                }
                if ((type & 2) == 2) {
                    trig.setActions("INSERT");
                }
                if ((type & 4) == 4) {
                    trig.setActions("DELETE");
                }
            }
            catch (NumberFormatException type) {
                // empty catch block
            }
        }
        if ("0".equalsIgnoreCase(tempTrig.getFireType())) {
            trig.setTriggerTime("AFTER");
        } else if ("1".equalsIgnoreCase(tempTrig.getFireType())) {
            trig.setTriggerTime("BEFORE");
        } else if ("4".equalsIgnoreCase(tempTrig.getFireType())) {
            trig.setTriggerTime("INSTEAD OF");
        }
        if ("1".equalsIgnoreCase(tempTrig.getScope())) {
            trig.setScope(TriggerOracle.SCOPE_TYPES[0]);
        } else {
            trig.setScope(TriggerOracle.SCOPE_TYPES[1]);
        }
        if (!"".equals(tempTrig.getOldAs())) {
            trig.setRef_OLD_AS(tempTrig.getOldAs());
        }
        if (!"".equals(tempTrig.getNewAs())) {
            trig.setRef_NEW_AS(tempTrig.getNewAs());
        }
        if (!"".equals(tempTrig.getStatus())) {
            if ("0".equalsIgnoreCase(tempTrig.getStatus())) {
                trig.setState("ENABLE");
            } else if ("1".equalsIgnoreCase(tempTrig.getStatus())) {
                trig.setState("DISABLE");
            }
        }
        if (!"".equals(tempTrig.getBody())) {
            String body = tempTrig.getBody().trim();
            if (body.toUpperCase().startsWith("CREATE")) {
                int declarePos = body.toUpperCase().indexOf("DECLARE");
                int beginPos = body.toUpperCase().indexOf("BEGIN");
                if (declarePos != -1 && declarePos < beginPos) {
                    beginPos = declarePos;
                }
                if (beginPos > 0) {
                    body = body.substring(beginPos).trim();
                }
            }
            trig.setBody(body);
        }
        if (!"".equals(tempTrig.getWhen())) {
            trig.setCondition(tempTrig.getWhen());
        }
        for (String colRef : tempTrig.getColumnRefs()) {
            Column colObj = (Column)this.relationalObjects.get(colRef);
            if (colObj == null) continue;
            trig.setColumns(colObj.getObjectID());
        }
    }

    private void parseTablePartition(TableProxyOracle proxy) {
        for (TempPartition part : this.tempEntity.getPartitions()) {
            Column listColObj;
            PartitionListOracle partList = this.oracleStorage.getPartitionListSet().createPartitionList(this.deriveObjectID(ID_PREFIX_PARTITION, part.getID()));
            partList.setName(part.getName());
            String partType = "RANGE";
            if ("1".equalsIgnoreCase(part.getPartitionType())) {
                partType = "RANGE";
            } else if ("2".equalsIgnoreCase(part.getPartitionType())) {
                partType = "LIST";
            } else if ("3".equalsIgnoreCase(part.getPartitionType())) {
                if ("0".equalsIgnoreCase(part.getHashType())) {
                    partType = "HASH BY LIST OF PARTITIONS";
                } else if ("1".equalsIgnoreCase(part.getHashType())) {
                    partType = "HASH BY QUANTITY";
                    if (part.getHashQuantity() > 0) {
                        partList.setHashPQuantity(part.getHashQuantity());
                    }
                } else if ("".equalsIgnoreCase(part.getHashType())) {
                    partType = "HASH BY QUANTITY";
                }
            } else if ("4".equalsIgnoreCase(part.getPartitionType())) {
                if ("0".equalsIgnoreCase(part.getCompositePartitionType())) {
                    partType = "COMPOSITE BY LIST";
                } else if ("1".equalsIgnoreCase(part.getCompositePartitionType())) {
                    partType = "COMPOSITE BY HASH";
                    if (part.getHashQuantity() > 0) {
                        partList.setSubPartitionsQuantity(part.getHashQuantity());
                    }
                }
            }
            partList.setPartitionType(partType);
            proxy.setPartitionList(partList);
            for (String colRef : part.getColumnRefs()) {
                Column colObj = (Column)this.relationalObjects.get(colRef);
                if (colObj == null) continue;
                partList.setColumnIDs(colObj.getObjectID());
            }
            if (!"".equals(part.getCompositeListColumnRef()) && (listColObj = (Column)this.relationalObjects.get(part.getCompositeListColumnRef())) != null) {
                partList.setSubPartitionsColumnIDs(listColObj.getObjectID());
            }
            for (String hashColRef : part.getHashColumnRefs()) {
                Column hashColObj = (Column)this.relationalObjects.get(hashColRef);
                if (hashColObj == null) continue;
                partList.setSubPartitionsColumnIDs(hashColObj.getObjectID());
            }
            for (String partTabSpace : part.getTablespaceRefs()) {
                this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(partTabSpace, partList));
            }
            for (TempPartitionInfo info : part.getPartitionInfos()) {
                StringBuffer partBuffer = new StringBuffer();
                Iterator itv = info.getPartitionValues().iterator();
                while (itv.hasNext()) {
                    partBuffer.append((String)itv.next()).append(",");
                }
                String partValues = partBuffer.toString();
                String partID = this.deriveObjectID(ID_PREFIX_PARTITION, info.getID());
                AbstractStorageObjectOracle partObj = null;
                if ("LIST".equalsIgnoreCase(partList.getPartitionType())) {
                    partObj = this.oracleStorage.getListPartitionSet().createListPartition(partID);
                    partObj.setPartitionList(partList);
                    if (!"".equals(partValues)) {
                        partObj.setColumns(partValues.substring(0, partValues.length() - 1));
                    }
                } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partList.getPartitionType()) || "HASH BY QUANTITY".equalsIgnoreCase(partList.getPartitionType())) {
                    partObj = this.oracleStorage.getHashPartitionSet().createHashPartition(partID);
                    ((HashPartitionOracle)partObj).setPartitionList(partList);
                } else {
                    partObj = this.oracleStorage.getPartitionSet().createPartition(partID);
                    ((PartitionOracle)partObj).setPartitionList(partList);
                    if (!"".equals(partValues)) {
                        ((PartitionOracle)partObj).setValueList(partValues.substring(0, partValues.length() - 1));
                    }
                    if (info.getPartHashQuantity() > 0) {
                        ((PartitionOracle)partObj).setSubPartitionsQuantity(info.getPartHashQuantity());
                    }
                }
                partObj.setName(info.getName());
                for (String infoTabSpace : info.getTablespaceRefs()) {
                    this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(infoTabSpace, partObj));
                }
                for (TempSubPartitionInfo subInfo : info.getSubPartitionInfos()) {
                    Object subValues = "";
                    for (String subVal : subInfo.getSubPartitionValues()) {
                        subValues = (String)subValues + subVal + ",";
                    }
                    String subPartID = this.deriveObjectID(ID_PREFIX_PARTITION, subInfo.getID());
                    AbstractStorageObjectOracle subPartObj = null;
                    if ("LIST".equalsIgnoreCase(partList.getPartitionType()) || "COMPOSITE BY LIST".equalsIgnoreCase(partList.getPartitionType())) {
                        subPartObj = this.oracleStorage.getListStorageTemplatePartitionSet().createListStorageTemplatePartition(subPartID);
                        ((ListStorageTemplatePartitionOracle)subPartObj).setSubPartitionOf(partObj);
                        if (!"".equals(subValues)) {
                            ((ListStorageTemplatePartitionOracle)subPartObj).setValueList(((String)subValues).substring(0, ((String)subValues).length() - 1));
                        }
                    } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partList.getPartitionType()) || "HASH BY QUANTITY".equalsIgnoreCase(partList.getPartitionType()) || "COMPOSITE BY HASH".equalsIgnoreCase(partList.getPartitionType())) {
                        subPartObj = this.oracleStorage.getHashPartitionSet().createHashPartition(partID);
                        ((HashPartitionOracle)subPartObj).setSubPartitionOf(partObj);
                    } else if ("RANGE".equalsIgnoreCase(partList.getPartitionType()) && partObj instanceof PartitionOraclev11g) {
                        subPartObj = this.oracleStorage.getPartitionSet().createPartition(subPartID);
                        ((PartitionOraclev11g)subPartObj).setSubPartitionOf(partObj);
                        if (!"".equals(subValues)) {
                            ((PartitionOraclev11g)subPartObj).setValueList(((String)subValues).substring(0, ((String)subValues).length() - 1));
                        }
                    }
                    if (subPartObj == null) continue;
                    subPartObj.setName(subInfo.getName());
                    if ("".equals(subInfo.getSubTablespaceRef())) continue;
                    this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(subInfo.getSubTablespaceRef(), subPartObj));
                }
            }
        }
    }

    private void setScratchFontAndColor(DesignObject designObject) {
        this.setFontAndColor(designObject, "", "", "", "");
    }

    private void setFontAndColor(DesignObject designObject, String bgColorVal, String outlineColorVal, String nameFontID, String nameColorVal) {
        int bgColorInt = -1;
        try {
            if (!"".equals(bgColorVal)) {
                bgColorInt = Integer.parseInt(bgColorVal);
            } else if (!"".equals(this.defaultFillColor)) {
                bgColorInt = Integer.parseInt(this.defaultFillColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bgColorInt >= 0) {
            Color bgColor = new Color(bgColorInt);
            designObject.setUseDefaultColor(false);
            designObject.setBackgroundColor(bgColor);
        }
        int outlineColorInt = -1;
        try {
            if (!"".equals(outlineColorVal)) {
                outlineColorInt = Integer.parseInt(outlineColorVal);
            } else if (!"".equals(this.defaultOutlineColor)) {
                outlineColorInt = Integer.parseInt(this.defaultOutlineColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (outlineColorInt >= 0) {
            Color outlineColor = new Color(outlineColorInt);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor(outlineColor);
        }
        int nameColorInt = -1;
        try {
            if (!"".equals(nameColorVal)) {
                nameColorInt = Integer.parseInt(nameColorVal);
            } else if (!"".equals(this.defaultNameColor)) {
                nameColorInt = Integer.parseInt(this.defaultNameColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (nameColorInt >= 0) {
            Color nameColor = new Color(nameColorInt);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor(nameColor);
        }
        if (!this.isUTFString(designObject.getName())) {
            if (this.fonts.isEmpty()) {
                this.fontWaitingList.add(new FontWaitingListEntry(designObject, nameFontID, EditableFonts.FO_TITLE, false));
            } else {
                Font font = null;
                if (!"".equals(nameFontID)) {
                    font = (Font)this.fonts.get(nameFontID);
                } else if (!"".equals(this.defaultNameFontID)) {
                    font = (Font)this.fonts.get(this.defaultNameFontID);
                }
                if (font != null && designObject instanceof EditableFonts) {
                    TopView tv = designObject.getTopView();
                    tv.setUseCustomFormat(true);
                    FontObject fo = tv.getFontObject(EditableFonts.FO_TITLE);
                    fo.setFont(font);
                }
            }
        } else if (designObject instanceof EditableFonts) {
            TopView tv = designObject.getTopView();
            tv.setUseCustomFormat(true);
            FontObject fo = tv.getFontObject(EditableFonts.FO_TITLE);
            fo.setFont(new Font("Dialog", fo.getFont().getStyle(), fo.getFont().getSize()));
        }
    }

    private void setScratchAttributeFontAndColor(DesignObject designObject, boolean logicalDP) {
        this.setAttributeFontAndColor(designObject, "", "", logicalDP);
    }

    private void setAttributeFontAndColor(DesignObject designObject, String attributeFontID, String attributeColorVal, boolean logicalDP) {
        FontObject fo;
        TopView tv;
        String type = logicalDP ? EditableFonts.FO_ATTRIBUTE : EditableFonts.FO_COLUMN;
        int attributeColorInt = -1;
        try {
            if (attributeColorVal != null) {
                attributeColorInt = Integer.parseInt(attributeColorVal);
            } else if (!"".equals(this.defaultAttributeColor)) {
                attributeColorInt = Integer.parseInt(this.defaultAttributeColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (attributeColorInt >= 0 && designObject instanceof EditableFonts) {
            Color fontColor = new Color(attributeColorInt);
            tv = designObject.getTopView();
            tv.setUseCustomFormat(true);
            fo = tv.getFontObject(type);
            fo.setColor(fontColor);
        }
        if (!this.isUTFString(designObject.getName())) {
            if (this.fonts.isEmpty()) {
                this.fontWaitingList.add(new FontWaitingListEntry(designObject, attributeFontID, type, true));
            } else {
                Font font = null;
                if (attributeFontID != null) {
                    font = (Font)this.fonts.get(attributeFontID);
                } else if (!"".equals(this.defaultAttributeFontID)) {
                    font = (Font)this.fonts.get(this.defaultAttributeFontID);
                }
                if (font != null && designObject instanceof EditableFonts) {
                    tv = designObject.getTopView();
                    tv.setUseCustomFormat(true);
                    fo = tv.getFontObject(type);
                    fo.setFont(font);
                }
            }
        } else if (designObject instanceof EditableFonts) {
            TopView tv2 = designObject.getTopView();
            tv2.setUseCustomFormat(true);
            FontObject fo2 = tv2.getFontObject(EditableFonts.FO_TITLE);
            fo2.setFont(new Font("Dialog", fo2.getFont().getStyle(), fo2.getFont().getSize()));
        }
    }

    private void startDomains(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Domain_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportDomains"), PROGRESS_INCREMENT);
            this.domains = new TreeMap();
            this.childDomains = new TreeMap();
            this.usedDomains = new ArrayList();
        } else if (qName.equalsIgnoreCase("Domain")) {
            this.tempDomainID = attributes.getValue("id");
            this.tempDomain = new TempDomain(this.tempDomainID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Logical_Data_Type") && attributes.getLength() > 0 && attributes.getIndex("Derived") > -1 && this.tempDomain != null) {
            attributes.getValue("Derived");
        }
    }

    private void startAttributes(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Logical_Data_Type") && attributes.getLength() > 0 && attributes.getIndex("Derived") > -1 && this.tempDomain != null) {
            attributes.getValue("Derived");
        }
    }

    private void endDomains(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Domain_Groups")) {
            this.parseChildDomains();
        } else if (qName.equalsIgnoreCase("Domain")) {
            this.parseDomain();
        } else if (qName.equalsIgnoreCase("Logical_Data_Type")) {
            this.tempDomain.setLogicalDatatype(this.getText());
        } else if (qName.equalsIgnoreCase("Physical_Data_Type")) {
            this.tempDomain.setPhysicalDatatype(this.getText());
        } else if (qName.equalsIgnoreCase("Parent_Domain_Ref")) {
            this.tempDomain.setParentDomainRef(this.getText());
        } else if (qName.equalsIgnoreCase("Validation_Rule_Ref")) {
            this.tempDomain.setValidationRuleRef(this.getText());
        }
    }

    private void parseDomain() {
        Domain dom = null;
        String domainName = this.tempDomain.getName();
        if (domainName.equalsIgnoreCase("<unknown>")) {
            dom = this.design.getDomainSet().getDefaultDomain();
        }
        if (dom == null) {
            dom = (Domain)this.design.getDomainSet().getByName(domainName);
        }
        if (dom == null) {
            dom = this.design.getDomainSet().createDomain(this.deriveObjectID(ID_PREFIX_DOMAIN, this.tempDomainID));
            dom.setName(domainName);
            dom.setFileName("ERwin_domains");
        }
        boolean dtOK = false;
        if (!"".equals(this.tempDomain.getLogicalDatatype())) {
            dtOK = this.parseDataType(dom, this.tempDomain.getLogicalDatatype());
        }
        if (!"".equals(this.tempDomain.getPhysicalDatatype())) {
            dtOK = this.parsePhysicalDataType(dom, this.tempDomain.getPhysicalDatatype());
        }
        if (!dtOK && !"".equals(this.tempDomain.getParentDomainRef())) {
            this.childDomains.put(this.tempDomainID, this.tempDomain.getParentDomainRef());
        }
        if (!"".equals(this.tempDomain.getValidationRuleRef())) {
            this.applyValidationRule(dom, this.tempDomain.getValidationRuleRef());
        }
        this.domains.put(this.tempDomainID, dom);
    }

    private void parseChildDomains() {
        Object[] keys = this.childDomains.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Domain parent;
            Object key = keys[i];
            Object value = this.childDomains.get(key);
            while (this.childDomains.get(value) != null) {
                value = this.childDomains.get(value);
            }
            Domain child = (Domain)this.domains.get(key);
            if (child == null || (parent = (Domain)this.domains.get(value)) == null) continue;
            child.setLogicalDatatype(parent.getLogicalDatatype());
            child.setDataTypeParameter("size", parent.getDataTypeParameter("size"));
            child.setDataTypeParameter("precision", parent.getDataTypeParameter("precision"));
            child.setDataTypeParameter("scale", parent.getDataTypeParameter("scale"));
        }
    }

    private boolean parseDataType(DesignObject object, String datatype) {
        if (!(object instanceof Domain || object instanceof Attribute || object instanceof Column)) {
            return false;
        }
        String dtName = datatype.trim();
        String size = "0";
        String precision = "0";
        String scale = "0";
        int pos = datatype.indexOf(40);
        if (pos > -1) {
            dtName = datatype.substring(0, pos).trim();
            String params = datatype.substring(pos + 1, datatype.trim().length() - 1).trim();
            int comma = params.indexOf(44);
            if (comma > -1) {
                precision = params.substring(0, comma).trim();
                scale = params.substring(comma + 1).trim();
            } else {
                size = params;
            }
        }
        String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(dtName);
        String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(nameDatatype);
        LogicalDatatype logDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(nameLogDT);
        if (logDatatype != null) {
            String[] params = logDatatype.getRequiredParameters();
            if (object instanceof Domain) {
                Domain dom = (Domain)object;
                dom.setLogicalDatatype(logDatatype);
                for (int i = 0; i < params.length; ++i) {
                    if ("size".equalsIgnoreCase(params[i])) {
                        if ("0".equalsIgnoreCase(size)) continue;
                        dom.setDataTypeParameter("size", size);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(params[i])) {
                        if (!"0".equalsIgnoreCase(size)) {
                            dom.setDataTypeParameter("precision", size);
                            continue;
                        }
                        dom.setDataTypeParameter("precision", precision);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(params[i])) continue;
                    dom.setDataTypeParameter("scale", scale);
                }
            } else if (object instanceof Attribute) {
                Attribute attr = (Attribute)object;
                attr.setUse((short)1);
                attr.setLogicalDatatype(logDatatype);
                attr.setUseDomainConstraints(false);
                for (int i = 0; i < params.length; ++i) {
                    if ("size".equalsIgnoreCase(params[i])) {
                        if ("0".equalsIgnoreCase(size)) continue;
                        attr.setDataTypeParameter("size", size);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(params[i])) {
                        if (!"0".equalsIgnoreCase(size)) {
                            attr.setDataTypeParameter("precision", size);
                            continue;
                        }
                        attr.setDataTypeParameter("precision", precision);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(params[i])) continue;
                    attr.setDataTypeParameter("scale", scale);
                }
            } else if (object instanceof Column) {
                Column col = (Column)object;
                col.setUse((short)1);
                col.setLogicalDatatype(logDatatype);
                col.setUseDomainConstraints(false);
                for (int i = 0; i < params.length; ++i) {
                    if ("size".equalsIgnoreCase(params[i])) {
                        if ("0".equalsIgnoreCase(size)) continue;
                        col.setDataTypeParameter("size", size);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(params[i])) {
                        if (!"0".equalsIgnoreCase(size)) {
                            col.setDataTypeParameter("precision", size);
                            continue;
                        }
                        col.setDataTypeParameter("precision", precision);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(params[i])) continue;
                    col.setDataTypeParameter("scale", scale);
                }
            }
            return true;
        }
        String msg = "Unable to find Logical DataType for: " + nameDatatype;
        this.importLog.addWarning(msg);
        LOGGER.warn(msg);
        return false;
    }

    private boolean parsePhysicalDataType(DesignObject object, String datatype) {
        if (!(object instanceof Domain) && !(object instanceof Column)) {
            return false;
        }
        String dtName = datatype.trim();
        String size = "0";
        String precision = "0";
        String scale = "0";
        int pos = datatype.indexOf(40);
        if (pos > -1) {
            dtName = datatype.substring(0, pos).trim();
            String params = datatype.substring(pos + 1, datatype.trim().length() - 1).trim();
            int comma = params.indexOf(44);
            if (comma > -1) {
                precision = params.substring(0, comma).trim();
                scale = params.substring(comma + 1).trim();
            } else {
                size = params;
            }
        }
        String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(dtName);
        String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(nameDatatype);
        LogicalDatatype logDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(nameLogDT);
        if (logDatatype == null && (nameLogDT = MappingDatatypeNameLogicalDataType.getERWinMappedName(dtName)) != null) {
            logDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(nameLogDT);
        }
        if (logDatatype != null) {
            String[] params = logDatatype.getRequiredParameters();
            if (object instanceof Domain) {
                Domain dom = (Domain)object;
                dom.setLogicalDatatype(logDatatype);
                for (int i = 0; i < params.length; ++i) {
                    if ("size".equalsIgnoreCase(params[i])) {
                        if ("0".equalsIgnoreCase(size)) continue;
                        dom.setDataTypeParameter("size", size);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(params[i])) {
                        if (!"0".equalsIgnoreCase(size)) {
                            dom.setDataTypeParameter("precision", size);
                            continue;
                        }
                        dom.setDataTypeParameter("precision", precision);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(params[i])) continue;
                    dom.setDataTypeParameter("scale", scale);
                }
            } else if (object instanceof Column) {
                Column col = (Column)object;
                col.setUse((short)1);
                col.setLogicalDatatype(logDatatype);
                for (int i = 0; i < params.length; ++i) {
                    if ("size".equalsIgnoreCase(params[i])) {
                        if ("0".equalsIgnoreCase(size)) continue;
                        col.setDataTypeParameter("size", size);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(params[i])) {
                        if (!"0".equalsIgnoreCase(size)) {
                            col.setDataTypeParameter("precision", size);
                            continue;
                        }
                        col.setDataTypeParameter("precision", precision);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(params[i])) continue;
                    col.setDataTypeParameter("scale", scale);
                }
            }
            return true;
        }
        String msg = "Unable to parse Physical DataType: " + datatype;
        this.importLog.addWarning(msg);
        LOGGER.warn(msg);
        return false;
    }

    private void startOracleTablespaces(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Oracle_Tablespace_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportOracleTablespaces"), PROGRESS_INCREMENT);
            this.tablespaces = new TreeMap();
        } else if (qName.equalsIgnoreCase("Oracle_Tablespace")) {
            this.tempOracleTablespaceID = attributes.getValue("id");
            this.tempOracleTablespace = new TempOracleTablespace(this.tempOracleTablespaceID, attributes.getValue("name"));
        }
    }

    private void endOracleTablespaces(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Oracle_Tablespace")) {
            if (this.oracleStorage != null) {
                this.parseOracleTablespace();
            }
        } else if (this.stack.search("Oracle_TablespaceProps") != -1) {
            if (qName.equalsIgnoreCase("Definition")) {
                this.tempOracleTablespace.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Can_Flashback")) {
                this.tempOracleTablespace.setCanFlashback(this.getText());
            } else if (qName.equalsIgnoreCase("Compress_Type")) {
                this.tempOracleTablespace.setCompressType(this.getText());
            } else if (qName.equalsIgnoreCase("Data_Block_Size")) {
                this.tempOracleTablespace.setDataBlockSize(this.getText());
            } else if (qName.equalsIgnoreCase("Extent_Management_Type")) {
                this.tempOracleTablespace.setExtentManagementType(this.getText());
            } else if (qName.equalsIgnoreCase("Extent_Size")) {
                this.tempOracleTablespace.setExtentSize(this.getText());
            } else if (qName.equalsIgnoreCase("Force_Logging")) {
                this.tempOracleTablespace.setForceLogging(this.getText());
            } else if (qName.equalsIgnoreCase("Is_Read_Only")) {
                this.tempOracleTablespace.setIsReadOnly(this.getText());
            } else if (qName.equalsIgnoreCase("Local_Extent_Management_Type")) {
                this.tempOracleTablespace.setLocalExtentManagementType(this.getText());
            } else if (qName.equalsIgnoreCase("Minimum_Extent")) {
                this.tempOracleTablespace.setMinimumExtent(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Initial_Extent_Size")) {
                this.tempOracleTablespace.setInitialExtentSize(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Is_Offline")) {
                this.tempOracleTablespace.setIsOffline(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Max_Extent_Type")) {
                this.tempOracleTablespace.setMaxExtentType(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Max_Extents")) {
                this.tempOracleTablespace.setMaxExtents(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Min_Extents")) {
                this.tempOracleTablespace.setMinExtents(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Next_Extent_Size")) {
                this.tempOracleTablespace.setNextExtentSize(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_No_Logging")) {
                this.tempOracleTablespace.setNoLogging(this.getText());
            } else if (qName.equalsIgnoreCase("Oracle_Percent_Increase")) {
                this.tempOracleTablespace.setPercentIncrease(this.getText());
            } else if (qName.equalsIgnoreCase("Retention_Guarantee")) {
                this.tempOracleTablespace.setRetentionGuarantee(this.getText());
            } else if (qName.equalsIgnoreCase("Segment_Management_Type")) {
                this.tempOracleTablespace.setSegmentManagementType(this.getText());
            } else if (qName.equalsIgnoreCase("Storage_File_Type")) {
                this.tempOracleTablespace.setStorageFileType(this.getText());
            } else if (qName.equalsIgnoreCase("Tablespace_System_Type")) {
                this.tempOracleTablespace.setSystemType(this.getText());
            } else if (qName.equalsIgnoreCase("Tablespace_Type")) {
                this.tempOracleTablespace.setType(this.getText());
            }
        }
    }

    private void parseOracleTablespace() {
        TableSpaceOracle oraTS = this.oracleStorage.getTableSpaceSet().createTableSpace(this.deriveObjectID(ID_PREFIX_TABLESPACE, this.tempOracleTablespaceID));
        if (oraTS != null) {
            oraTS.setName(this.tempOracleTablespace.getName());
            if (!"".equals(this.tempOracleTablespace.getDefinition())) {
                oraTS.setComment(this.tempOracleTablespace.getDefinition());
            }
            if ("2".equalsIgnoreCase(this.tempOracleTablespace.getType())) {
                oraTS.setContents("PERMANENT");
            } else if ("1".equalsIgnoreCase(this.tempOracleTablespace.getType())) {
                oraTS.setContents("TEMPORARY");
            } else if ("0".equalsIgnoreCase(this.tempOracleTablespace.getType())) {
                oraTS.setContents("UNDO");
            }
            if (this.tempOracleTablespace.isOffline()) {
                oraTS.setStatus("OFFLINE");
            } else {
                oraTS.setStatus("ONLINE");
            }
            if (this.tempOracleTablespace.noLogging()) {
                oraTS.setLogging("NOLOGGING");
            } else {
                oraTS.setLogging("LOGGING");
            }
            if ("920".equalsIgnoreCase(this.tempOracleTablespace.getLocalExtentManagementType())) {
                oraTS.setEMLocalSubtype("AUTOALLOCATE");
            } else if ("921".equalsIgnoreCase(this.tempOracleTablespace.getLocalExtentManagementType())) {
                oraTS.setEMLocalSubtype("UNIFORM");
                oraTS.setEMUniformSize(this.tempOracleTablespace.getExtentSize());
            } else if ("903".equalsIgnoreCase(this.tempOracleTablespace.getLocalExtentManagementType())) {
                oraTS.setEMLocalSubtype("DEFAULT");
            }
            if ("922".equalsIgnoreCase(this.tempOracleTablespace.getExtentManagementType())) {
                oraTS.setExtentManagement("DICTIONARY");
            } else if ("923".equalsIgnoreCase(this.tempOracleTablespace.getExtentManagementType())) {
                oraTS.setExtentManagement("LOCAL");
            }
            oraTS.setMinExtLen(this.tempOracleTablespace.getMinimumExtent());
            oraTS.setDSInitialExtent(this.tempOracleTablespace.getInitialExtentSize());
            oraTS.setDSNextExtent(this.tempOracleTablespace.getNextExtentSize());
            oraTS.setDSMinExtents(this.tempOracleTablespace.getMinExtents());
            oraTS.setDSPctIncrease(this.tempOracleTablespace.getPercentIncrease());
            if ("0".equalsIgnoreCase(this.tempOracleTablespace.getMaxExtentType())) {
                oraTS.setDSMaxExtents("0");
            } else if ("1".equalsIgnoreCase(this.tempOracleTablespace.getMaxExtentType())) {
                oraTS.setDSMaxExtents(String.valueOf(this.tempOracleTablespace.getMaxExtents()));
            }
            if (oraTS instanceof TableSpaceOraclev10g) {
                ((TableSpaceOraclev10g)oraTS).setBlockSize(this.tempOracleTablespace.getDataBlockSize());
                if (this.tempOracleTablespace.forceLogging()) {
                    ((TableSpaceOraclev10g)oraTS).setForceLogging("YES");
                } else {
                    ((TableSpaceOraclev10g)oraTS).setForceLogging("NO");
                }
                if ("926".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev10g)oraTS).setSegmentManagement("AUTO");
                } else if ("927".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev10g)oraTS).setSegmentManagement("MANUAL");
                }
                if ("0".equalsIgnoreCase(this.tempOracleTablespace.getStorageFileType())) {
                    ((TableSpaceOraclev10g)oraTS).setFileType("BIGFILE");
                } else if ("1".equalsIgnoreCase(this.tempOracleTablespace.getStorageFileType())) {
                    ((TableSpaceOraclev10g)oraTS).setFileType("SMALLFILE");
                }
                if (this.tempOracleTablespace.canFlashback()) {
                    ((TableSpaceOraclev10g)oraTS).setFlashBack("ON");
                } else {
                    ((TableSpaceOraclev10g)oraTS).setFlashBack("OFF");
                }
            } else if (oraTS instanceof TableSpaceOraclev9i) {
                ((TableSpaceOraclev9i)oraTS).setBlockSize(this.tempOracleTablespace.getDataBlockSize());
                if (this.tempOracleTablespace.forceLogging()) {
                    ((TableSpaceOraclev9i)oraTS).setForceLogging("YES");
                } else {
                    ((TableSpaceOraclev9i)oraTS).setForceLogging("NO");
                }
                if ("926".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev9i)oraTS).setSegmentManagement("AUTO");
                } else if ("927".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev9i)oraTS).setSegmentManagement("MANUAL");
                }
            }
            this.tablespaces.put(this.tempOracleTablespaceID, oraTS);
        }
    }

    private int calculateSize(String valueCode) {
        int size = 0;
        try {
            int len = valueCode.length();
            if (len > 1) {
                String code = valueCode.substring(len - 1);
                int value = Integer.valueOf(valueCode.substring(0, len - 1));
                size = "K".equalsIgnoreCase(code) ? value * 1024 : ("M".equalsIgnoreCase(code) ? value * 1024 * 1024 : ("G".equalsIgnoreCase(code) ? value * 1024 * 1024 * 1024 : ("T".equalsIgnoreCase(code) ? value * 1024 * 1024 * 1024 * 1024 : Integer.valueOf(valueCode))));
            } else {
                size = Integer.valueOf(valueCode);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return size;
    }

    private void startSubjectAreas(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Subject_Area_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportSubjectAreas"), PROGRESS_INCREMENT);
            this.subjectAreas = new ArrayList();
            this.isMainLogical = true;
            this.isMainRelational = true;
        } else if (qName.equalsIgnoreCase("Subject_Area")) {
            this.tempSubjectAreaID = attributes.getValue("id");
            this.tempSubjectArea = new TempSubjectArea(this.tempSubjectAreaID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Stored_Display")) {
            this.tempStoredDisplayID = attributes.getValue("id");
            this.tempStoredDisplay = new TempStoredDisplay(this.tempStoredDisplayID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Drawing_Object_Entity")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Entity");
        } else if (qName.equalsIgnoreCase("Drawing_Object_Relationship")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Relationship");
        } else if (qName.equalsIgnoreCase("Drawing_Object_View")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("View");
        } else if (qName.equalsIgnoreCase("Drawing_Object_Rectangle")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Rectangle");
        } else if (qName.equalsIgnoreCase("Drawing_Object_Ellipse")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Ellipse");
        } else if (qName.equalsIgnoreCase("Transform_Scratch_Object")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Scratch");
        }
    }

    private void endSubjectAreas(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Subject_Area")) {
            this.subjectAreas.add(this.tempSubjectArea);
        } else if (qName.equalsIgnoreCase("Is_Main_Subject_Area")) {
            this.tempSubjectArea.setIsMain(this.getText());
        } else if (qName.equalsIgnoreCase("Stored_Display")) {
            this.tempSubjectArea.addStoredDisplay(this.tempStoredDisplay);
        } else if (qName.equalsIgnoreCase("Drawing_Object_Entity")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (qName.equalsIgnoreCase("Drawing_Object_Relationship")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (qName.equalsIgnoreCase("Drawing_Object_View")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (qName.equalsIgnoreCase("Drawing_Object_Rectangle")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (qName.equalsIgnoreCase("Drawing_Object_Ellipse")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (qName.equalsIgnoreCase("Transform_Scratch_Object")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (this.stack.search("Drawing_Object_EntityProps") != -1 || this.stack.search("Drawing_Object_RelationshipProps") != -1 || this.stack.search("Drawing_Object_ViewProps") != -1 || this.stack.search("Drawing_Object_RectangleProps") != -1 || this.stack.search("Drawing_Object_EllipseProps") != -1 || this.stack.search("Transform_Scratch_ObjectProps") != -1) {
            if (qName.equalsIgnoreCase("Model_Object_Ref") || qName.equalsIgnoreCase("Scratch_Model_Object_Ref")) {
                this.tempDrawingObject.setModelObjectRef(this.getText());
            } else if (qName.equalsIgnoreCase("Location_Rectangle")) {
                this.tempDrawingObject.setLocationRectangle(this.getText());
            } else if (qName.equalsIgnoreCase("Anchor_Point")) {
                this.tempDrawingObject.setAnchorPoint(this.getText());
            } else if (qName.equalsIgnoreCase("Fixed_Size_Point")) {
                this.tempDrawingObject.setFixedSizePoint(this.getText());
            } else if (qName.equalsIgnoreCase("Text")) {
                this.tempDrawingObject.setText(this.getText());
            } else if (qName.equalsIgnoreCase("Font_Ref")) {
                this.tempDrawingObject.setFontRef(this.getText());
            } else if (qName.equalsIgnoreCase("Font_Color")) {
                this.tempDrawingObject.setFontColor(this.getText());
            } else if (qName.equalsIgnoreCase("Fill_Color")) {
                this.tempDrawingObject.setFillColor(this.getText());
            } else if (qName.equalsIgnoreCase("Outline_Color")) {
                this.tempDrawingObject.setOutlineColor(this.getText());
            } else if (qName.equalsIgnoreCase("Outline_Style")) {
                this.tempDrawingObject.setOutlineStyle(this.getText());
            } else if (qName.equalsIgnoreCase("Relationship_Coordinates")) {
                this.tempDrawingObject.addPathCoordinate(this.getText());
            }
        }
    }

    private void parseSubjectArea(TempSubjectArea area) {
        DesignPartView mainLogDisplay = null;
        DesignPartView mainRelDisplay = null;
        for (TempStoredDisplay dis : area.getTempStoredDisplays()) {
            DesignPartView dpv;
            if (area.isMain()) {
                DesignPartView dpv2;
                if (this.createLogical) {
                    if (this.isMainLogical) {
                        this.parseDisplay(dis, this.logical.getMainView(), false);
                        mainLogDisplay = this.logical.getMainView();
                        this.isMainLogical = false;
                    } else {
                        dpv2 = this.logical.getMainView().addSubordinateView();
                        this.logical.getMainView().copyToDPV(dpv2, false);
                        dpv2.setName(dis.getName());
                        this.parseDisplay(dis, dpv2, false);
                    }
                }
                if (!this.createRelational) continue;
                if (this.isMainRelational) {
                    this.parseDisplay(dis, this.relational.getMainView(), false);
                    mainRelDisplay = this.relational.getMainView();
                    this.isMainRelational = false;
                    continue;
                }
                dpv2 = this.relational.getMainView().addSubordinateView();
                this.relational.getMainView().copyToDPV(dpv2, false);
                dpv2.setName(dis.getName());
                this.parseDisplay(dis, dpv2, false);
                continue;
            }
            if (this.createLogical) {
                DesignPartView dpvLSV = this.logical.getSubViewByName(area.getName());
                if (dpvLSV == null) {
                    dpvLSV = this.logical.createDesignPartSubView();
                    dpvLSV.setName(area.getName());
                    this.parseDisplay(dis, dpvLSV, true);
                    mainLogDisplay = dpvLSV;
                } else {
                    dpv = dpvLSV.addSubordinateView();
                    dpvLSV.copyToDPV(dpv, false);
                    dpv.setName(dis.getName());
                    this.parseDisplay(dis, dpv, false);
                }
            }
            if (!this.createRelational) continue;
            DesignPartView dpvRSV = this.relational.getSubViewByName(area.getName());
            if (dpvRSV == null) {
                dpvRSV = this.relational.createDesignPartSubView();
                dpvRSV.setName(area.getName());
                this.parseDisplay(dis, dpvRSV, true);
                mainRelDisplay = dpvRSV;
                continue;
            }
            dpv = dpvRSV.addSubordinateView();
            dpvRSV.copyToDPV(dpv, false);
            dpv.setName(dis.getName());
            this.parseDisplay(dis, dpv, false);
        }
        if (mainLogDisplay != null) {
            String mainLogID = mainLogDisplay.getDPVId();
            Component[] logComps = mainLogDisplay.getTabbedPane().getComponents();
            for (int i = 0; i < logComps.length; ++i) {
                if (!(logComps[i] instanceof DPVMainPanel) || !mainLogID.equals(((DPVMainPanel)logComps[i]).getDesignPartView().getDPVId())) continue;
                mainLogDisplay.getTabbedPane().setSelectedComponent(logComps[i]);
                break;
            }
        }
        if (mainRelDisplay != null) {
            String mainRelID = mainRelDisplay.getDPVId();
            Component[] relComps = mainRelDisplay.getTabbedPane().getComponents();
            for (int j = 0; j < relComps.length; ++j) {
                if (!(relComps[j] instanceof DPVMainPanel) || !mainRelID.equals(((DPVMainPanel)relComps[j]).getDesignPartView().getDPVId())) continue;
                mainRelDisplay.getTabbedPane().setSelectedComponent(relComps[j]);
                break;
            }
        }
    }

    private void parseDisplay(TempStoredDisplay dis, DesignPartView dpv, boolean isSubView) {
        dpv.setAutoRoute(false);
        dpv.setBoxInBox(false);
        dpv.setVisible(true);
        dpv.getWorkSpace().updateSettings();
        if (dpv.getDesignPart() instanceof RelationalDesign) {
            ArrayList<TempDrawingObject> extras = new ArrayList<TempDrawingObject>();
            for (TempDrawingObject mtmObj : dis.getDrawingObjects()) {
                DesignObject parTab;
                String modObjID = mtmObj.getModelObjectRef();
                if (!"Relationship".equalsIgnoreCase(mtmObj.getType()) || !this.manyToManyTables.contains(modObjID)) continue;
                String mtmDisID = mtmObj.getID();
                TempDrawingObject mtmRel1 = new TempDrawingObject(mtmDisID.replace("+00000000", "+00000001"), mtmObj.getName());
                mtmRel1.copyFrom(mtmObj);
                mtmRel1.setType("Relationship");
                mtmRel1.setModelObjectRef(modObjID.replace("+00000000", "+00000001"));
                this.setManyToManyPoints(mtmRel1);
                extras.add(mtmRel1);
                TempDrawingObject mtmRel2 = new TempDrawingObject(mtmDisID.replace("+00000000", "+00000002"), mtmObj.getName());
                mtmRel2.copyFrom(mtmObj);
                mtmRel2.setType("Relationship");
                mtmRel2.setModelObjectRef(modObjID.replace("+00000000", "+00000002"));
                this.setManyToManyPoints(mtmRel2);
                extras.add(mtmRel2);
                mtmObj.setType("Entity");
                this.setManyToManyLocation(mtmObj);
                String parRelID = mtmRel1.getModelObjectRef();
                DesignObject parRel = (DesignObject)this.relationalObjects.get(parRelID);
                if (parRel == null || !(parRel instanceof FKIndexAssociation) || (parTab = ((FKIndexAssociation)parRel).getSourceObject()) == null || !(parTab instanceof Table)) continue;
                String parTabID = parTab.getObjectID();
                this.setScratchFontAndColor(dis, mtmObj, parTabID);
            }
            for (int i = 0; i < extras.size(); ++i) {
                dis.addDrawingObject((TempDrawingObject)extras.get(i));
            }
        }
        for (TempDrawingObject drawObj : dis.getDrawingObjects()) {
            TopView topView;
            DesignObject desObj = null;
            if ("Scratch".equalsIgnoreCase(drawObj.getType()) && (desObj = dpv.getDesignPart() instanceof LogicalDesign ? (DesignObject)this.logicalObjects.get(drawObj.getModelObjectRef()) : (DesignObject)this.relationalObjects.get(drawObj.getModelObjectRef())) != null) {
                this.setScratchLocation(dis, drawObj);
                if (desObj instanceof Entity || desObj instanceof Table) {
                    drawObj.setType("Entity");
                } else if (desObj instanceof Relation || desObj instanceof FKIndexAssociation) {
                    drawObj.setType("Relationship");
                }
            }
            if ("Entity".equalsIgnoreCase(drawObj.getType()) || "View".equalsIgnoreCase(drawObj.getType())) {
                desObj = dpv.getDesignPart() instanceof LogicalDesign ? (DesignObject)this.logicalObjects.get(drawObj.getModelObjectRef()) : (DesignObject)this.relationalObjects.get(drawObj.getModelObjectRef());
                if (desObj == null) continue;
                this.setDrawingObjectFontAndColor(desObj, drawObj.getFillColor(), drawObj.getOutlineColor(), drawObj.getOutlineStyle(), drawObj.getFontRef(), drawObj.getFontColor());
                topView = null;
                if (isSubView) {
                    topView = ((ContainerView)desObj.getTopView()).createViewSynonim(dpv);
                    if (topView == null) continue;
                    if (topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(drawObj.getLocationRectangle());
                    } else {
                        topView.setBounds(drawObj.getLocationRectangle());
                    }
                    if (dpv.getDesignPart() instanceof LogicalDesign) {
                        if (topView instanceof TVEntity) {
                            ((TVEntity)topView).addTVRelations();
                        }
                        ((ContainerView)topView).addTVTypeSubstitutions();
                        dpv.synchronizeSynonymWithDisplays(topView);
                        continue;
                    }
                    if (topView instanceof TVTable) {
                        ((TVTable)topView).addTVFKRelations();
                    }
                    ((ContainerView)topView).addTVTypeSubstitutions();
                    dpv.synchronizeSynonymWithDisplays(topView);
                    continue;
                }
                topView = (ContainerView)desObj.getFirstViewForDPV(dpv);
                if (topView == null || topView.getCellView() == null) continue;
                topView.getCellView().setNewBounds(drawObj.getLocationRectangle());
                continue;
            }
            if ("Relationship".equalsIgnoreCase(drawObj.getType())) {
                desObj = dpv.getDesignPart() instanceof LogicalDesign ? (Relation)this.logicalObjects.get(drawObj.getModelObjectRef()) : (FKIndexAssociation)this.relationalObjects.get(drawObj.getModelObjectRef());
                if (desObj == null || (topView = (TVConnector)desObj.getFirstViewForDPV(dpv)) == null) continue;
                try {
                    EdgeView edge = (EdgeView)topView.getCellView();
                    if (edge == null && ((TVConnector)topView).getEdge() != null) {
                        edge = (EdgeView)((TVConnector)topView).getEdge().getCellView();
                    }
                    if (edge == null) continue;
                    List points = this.getPoints(drawObj.getPathCoordinates());
                    for (Point p : points) {
                        ((TVConnector)topView).getEdgePoints().add(DiagramConstants.createPoint(p));
                    }
                    dpv.getWorkSpace().addPoints((DefaultEdge)edge.getCell(), ((TVConnector)topView).getEdgePoints());
                    edge.update();
                }
                catch (Exception edge) {}
                continue;
            }
            if (!"Rectangle".equalsIgnoreCase(drawObj.getType()) && !"Ellipse".equalsIgnoreCase(drawObj.getType())) continue;
            Note note = dpv.getDesignPart().createNote();
            note.setText(drawObj.getText());
            TopView topView2 = note.getFirstViewForDPV(dpv);
            if (topView2 == null) {
                topView2 = dpv.createTopViewFor(note);
            }
            Rectangle rec = drawObj.getLocationRectangle();
            if (topView2 == null) continue;
            if (topView2.getCellView() != null) {
                topView2.getCellView().setNewBounds(rec);
            } else {
                topView2.setBounds(rec);
            }
            this.setDrawingObjectFontAndColor(note, drawObj.getFillColor(), drawObj.getOutlineColor(), drawObj.getOutlineStyle(), drawObj.getFontRef(), drawObj.getFontColor());
            this.setFontAndColor(note, drawObj.getFillColor(), drawObj.getOutlineColor(), drawObj.getFontRef(), drawObj.getFontColor());
            if (topView2.getCellView() != null) continue;
            dpv.add(topView2, topView2.getBounds());
            dpv.synchronizeSynonymWithDisplays(topView2);
        }
    }

    private void setDrawingObjectFontAndColor(DesignObject designObject, String bgColorVal, String outlineColorVal, String outlineStyle, String nameFontID, String nameColorVal) {
        FontObject fo;
        TopView tv;
        try {
            if (!"".equals(bgColorVal)) {
                int bgColor = Integer.parseInt(bgColorVal);
                if (designObject instanceof EditableFonts) {
                    designObject.setUseDefaultColor(false);
                    designObject.setBackgroundColor(this.reverseRGB(bgColor));
                }
            }
        }
        catch (NumberFormatException bgColor) {
            // empty catch block
        }
        try {
            if (!"".equals(outlineColorVal)) {
                int outlineColor = Integer.parseInt(outlineColorVal);
                if ("0".equalsIgnoreCase(outlineStyle)) {
                    designObject.setUseDefaultColor(false);
                    designObject.setForegroundColor(this.reverseRGB(outlineColor));
                }
            }
        }
        catch (NumberFormatException outlineColor) {
            // empty catch block
        }
        try {
            if (!"".equals(nameColorVal)) {
                int nameColor = Integer.parseInt(nameColorVal);
                if (designObject instanceof EditableFonts) {
                    tv = designObject.getTopView();
                    tv.setUseCustomFormat(true);
                    fo = tv.getFontObject(EditableFonts.FO_TITLE);
                    fo.setColor(this.reverseRGB(nameColor));
                }
            }
        }
        catch (NumberFormatException nameColor) {
            // empty catch block
        }
        if (this.fonts.isEmpty()) {
            this.fontWaitingList.add(new FontWaitingListEntry(designObject, nameFontID, EditableFonts.FO_TITLE, true));
        } else {
            Font font = null;
            if (!"".equals(nameFontID)) {
                font = (Font)this.fonts.get(nameFontID);
            } else if (!"".equals(this.defaultAttributeFontID)) {
                font = (Font)this.fonts.get(this.defaultAttributeFontID);
            }
            if (font != null && designObject instanceof EditableFonts) {
                tv = designObject.getTopView();
                tv.setUseCustomFormat(true);
                fo = tv.getFontObject(EditableFonts.FO_TITLE);
                fo.setFont(font);
            }
        }
    }

    private Color reverseRGB(int rgb) {
        int r = rgb >> 0 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 16 & 0xFF;
        return new Color(r, g, b);
    }

    private Rectangle parseCoordinates(String coordinates) {
        Rectangle rec = new Rectangle();
        if (!"".equals(coordinates)) {
            StringTokenizer st = new StringTokenizer(coordinates, " ");
            int[] values = new int[4];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int number;
                    values[i] = number = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("ERSAXParser.parseCoordinates(): Unable to parse location coordinates", e);
                }
                ++i;
            }
            rec.x = values[0];
            rec.y = values[1];
            rec.width = values[2] - values[0];
            rec.height = values[3] - values[1];
        }
        return rec;
    }

    private List getPoints(List coordinates) {
        ArrayList<Point> list = new ArrayList<Point>();
        String previous = "";
        for (int i = 1; i < coordinates.size() - 2; ++i) {
            String coord = (String)coordinates.get(i);
            if (previous.equalsIgnoreCase(coord)) continue;
            previous = coord;
            String xx = coord.substring(0, coord.indexOf(32));
            String yy = coord.substring(coord.indexOf(32) + 1);
            try {
                int x = Integer.parseInt(xx);
                int y = Integer.parseInt(yy);
                Point p = new Point(x, y);
                list.add(p);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return list;
    }

    private Point getPoint(String coordinate) {
        int x = 0;
        int y = 0;
        if (!"".equals(coordinate)) {
            String xx = coordinate.substring(0, coordinate.indexOf(32));
            String yy = coordinate.substring(coordinate.indexOf(32) + 1);
            try {
                x = Integer.parseInt(xx);
                y = Integer.parseInt(yy);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Point(x, y);
    }

    private void setScratchFontAndColor(TempStoredDisplay dis, TempDrawingObject drawObj, String tabID) {
        for (int i = 0; i < dis.getDrawingObjects().size(); ++i) {
            TempDrawingObject obj = dis.getDrawingObject(i);
            DesignObject modObj = (DesignObject)this.relationalObjects.get(obj.getModelObjectRef());
            if (modObj == null || !modObj.getObjectID().equalsIgnoreCase(tabID)) continue;
            drawObj.setFillColor(obj.getFillColor());
            drawObj.setFontColor(obj.getFontColor());
            drawObj.setFontRef(obj.getFontRef());
            drawObj.setOutlineColor(obj.getOutlineColor());
            drawObj.setOutlineStyle(obj.getOutlineStyle());
            return;
        }
    }

    private void setScratchLocation(TempStoredDisplay dis, TempDrawingObject drawObj) {
        Rectangle scratchRectangle = drawObj.getLocationRectangle();
        if (scratchRectangle.getWidth() == 0.0 || scratchRectangle.getHeight() == 0.0) {
            String modObjRef = drawObj.getModelObjectRef();
            for (TransformWaitingListEntry entry : this.transformWaitingList) {
                if (!entry.getScratchObjectRef().equalsIgnoreCase(modObjRef)) continue;
                String desObjRef = entry.getDesignObjectRef();
                for (int i = 0; i < dis.getDrawingObjects().size(); ++i) {
                    TempDrawingObject obj = dis.getDrawingObject(i);
                    if (!obj.getModelObjectRef().equalsIgnoreCase(desObjRef)) continue;
                    scratchRectangle.setBounds(obj.getLocationRectangle());
                    return;
                }
            }
            if (!"".equals(drawObj.getAnchorPoint())) {
                Point anchor = this.getPoint(drawObj.getAnchorPoint());
                Double axx = anchor.getX();
                Double ayy = anchor.getY();
                int ax = axx.intValue();
                int ay = ayy.intValue();
                int w = DO_SCRATCH_ENTITY_WIDTH;
                int h = DO_SCRATCH_ENTITY_HEIGHT;
                if (!"".equals(drawObj.getFixedSizePoint())) {
                    Point fixed = this.getPoint(drawObj.getFixedSizePoint());
                    Double fx = fixed.getX();
                    Double fy = fixed.getY();
                    w = fx.intValue();
                    h = fy.intValue();
                }
                int x = ax - w / 2 > 0 ? ax - w / 2 : 0;
                int y = ay - h / 2 > 0 ? ay - h / 2 : 0;
                scratchRectangle.setBounds(x, y, w, h);
            }
        }
    }

    private void setManyToManyLocation(TempDrawingObject drawObj) {
        Rectangle scratchRectangle = drawObj.getLocationRectangle();
        if (scratchRectangle.getWidth() > (double)DO_MTM_ENTITY_WIDTH || scratchRectangle.getHeight() > (double)DO_MTM_ENTITY_HEIGHT) {
            Double rx = scratchRectangle.getX();
            Double rw = scratchRectangle.getWidth();
            int x = rx.intValue();
            int w = rw.intValue();
            if (w > DO_MTM_ENTITY_WIDTH) {
                x += (w - DO_MTM_ENTITY_WIDTH) / 2;
                w = DO_MTM_ENTITY_WIDTH;
            }
            Double ry = scratchRectangle.getY();
            Double rh = scratchRectangle.getHeight();
            int y = ry.intValue();
            int h = rh.intValue();
            if (h > DO_MTM_ENTITY_HEIGHT) {
                y += (h - DO_MTM_ENTITY_HEIGHT) / 2;
                h = DO_MTM_ENTITY_HEIGHT;
            }
            scratchRectangle.setBounds(x, y, w, h);
        }
    }

    private void setManyToManyPoints(TempDrawingObject drawObj) {
        drawObj.initPathCoordinates();
    }

    private void startRelationships(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Relationship_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportRelationships"), PROGRESS_INCREMENT);
            this.inheritanceObjects = new ArrayList();
            this.replacedAttributes = new ArrayList();
            this.manyToManyTables = new ArrayList();
        } else if (qName.equalsIgnoreCase("Relationship")) {
            this.tempRelationshipID = attributes.getValue("id");
            this.tempRelationship = new TempRelationship(this.tempRelationshipID, attributes.getValue("name"));
        }
    }

    private void endRelationships(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Relationship_Groups")) {
            if (this.createLogical && this.createRelational) {
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
            }
            this.parseInheritanceRelations();
        } else if (qName.equalsIgnoreCase("Relationship")) {
            this.parseRelationship();
        } else if (qName.equalsIgnoreCase("Physical_Name")) {
            this.tempRelationship.setPhysicalName(this.getText());
        } else if (qName.equalsIgnoreCase("Type")) {
            this.tempRelationship.setType(this.getText());
        } else if (qName.equalsIgnoreCase("Parent_Entity_Ref")) {
            this.tempRelationship.setParentEntityRef(this.getText());
        } else if (qName.equalsIgnoreCase("Child_Entity_Ref")) {
            this.tempRelationship.setChildEntityRef(this.getText());
        } else if (qName.equalsIgnoreCase("Parent_To_Child_Verb_Phrase")) {
            this.tempRelationship.setParentToChildVerbPhrase(this.getText());
        } else if (qName.equalsIgnoreCase("Child_To_Parent_Verb_Phrase")) {
            this.tempRelationship.setChildToParentVerbPhrase(this.getText());
        } else if (qName.equalsIgnoreCase("Hide_In_Logical")) {
            this.tempRelationship.setHideInLogical(this.getText());
        } else if (qName.equalsIgnoreCase("Hide_In_Physical")) {
            this.tempRelationship.setHideInPhysical(this.getText());
        } else if (qName.equalsIgnoreCase("Cardinality")) {
            this.tempRelationship.setCardinality(this.getText());
        } else if (qName.equalsIgnoreCase("Comment") || qName.equalsIgnoreCase("Note")) {
            this.tempRelationship.setComment(this.getText());
        } else if (qName.equalsIgnoreCase("Null_Option_Type")) {
            this.tempRelationship.setNullOptionType(this.getText());
        } else if (qName.equalsIgnoreCase("Parent_Delete_Rule")) {
            this.tempRelationship.setParentDeleteRule(this.getText());
        } else if (qName.equalsIgnoreCase("Key_Group_Ref")) {
            this.tempRelationship.setRefKey(this.getText());
        }
    }

    private void parseRelationship() {
        String relationshipType = this.tempRelationship.getType();
        if ("9".equalsIgnoreCase(relationshipType)) {
            IHObject inheritObj = new IHObject(this.tempRelationshipID, this.tempRelationship.getName(), this.tempRelationship.getParentEntityRef(), this.tempRelationship.getChildEntityRef());
            if (!"".equals(this.tempRelationship.getPhysicalName())) {
                inheritObj.setPhysicalName(this.tempRelationship.getPhysicalName());
            }
            if (!"".equals(this.tempRelationship.getParentDeleteRule())) {
                inheritObj.setParentDeleteRule(this.tempRelationship.getParentDeleteRule());
            }
            if (!"".equals(this.tempRelationship.getComment())) {
                inheritObj.setComment(this.tempRelationship.getComment());
            }
            this.inheritanceObjects.add(inheritObj);
        } else {
            if (this.createLogical && !"true".equalsIgnoreCase(this.tempRelationship.getHideInLogical())) {
                this.parseRelation();
            }
            if (this.createRelational && !"true".equalsIgnoreCase(this.tempRelationship.getHideInPhysical())) {
                if ("4".equalsIgnoreCase(relationshipType)) {
                    this.parseRelationalManyToMany();
                } else {
                    this.parseForeignKey();
                }
            }
        }
    }

    private void parseRelation() {
        DesignObject parent = (DesignObject)this.logicalObjects.get(this.tempRelationship.getParentEntityRef());
        DesignObject child = (DesignObject)this.logicalObjects.get(this.tempRelationship.getChildEntityRef());
        if (parent != null && child != null && parent instanceof Entity && child instanceof Entity) {
            TVRelation tvr;
            Relation relation = this.logical.getRelationSet().createRelation(this.deriveObjectID(ID_PREFIX_RELATION, this.tempRelationshipID));
            relation.setUseSurrogateKey(false);
            if (!"".equals(this.tempRelationship.getName())) {
                relation.setName(this.tempRelationship.getName());
            }
            if (!"".equals(this.tempRelationship.getComment())) {
                relation.setComment(this.tempRelationship.getComment());
            }
            for (FKElement fkElement : this.logicalFKElements) {
                if (!fkElement.getParentRelationshipID().equalsIgnoreCase(this.tempRelationshipID)) continue;
                Attribute attr = (Attribute)this.logicalObjects.get(fkElement.getID());
                Attribute refAttr = (Attribute)this.logicalObjects.get(fkElement.getParentAttributeID());
                if (attr == null || refAttr == null) continue;
                attr.setReferedAttribute(refAttr.getObjectID());
                attr.setGeneratorID(relation.getObjectID());
                this.replacedAttributes.add(attr);
            }
            DesignObject key = (DesignObject)this.logicalObjects.get(this.tempRelationship.getRefKey());
            relation.setFireCardinalityChange(false);
            if (key != null && key instanceof CandidateKey) {
                relation.setSourcePk((CandidateKey)key);
            }
            relation.setSourceEntity((Entity)parent);
            relation.setTargetEntity((Entity)child);
            boolean identifying = false;
            boolean sourceOptional = true;
            boolean targetOptional = true;
            int cardNum = -5;
            try {
                cardNum = Integer.parseInt(this.tempRelationship.getCardinality());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int sourceCardinality = 1;
            int targetCardinality = 1;
            if (!"".equals(this.tempRelationship.getType()) && !"".equals(this.tempRelationship.getCardinality())) {
                if ("7".equals(this.tempRelationship.getType())) {
                    identifying = false;
                    targetOptional = !"101".equals(this.tempRelationship.getNullOptionType());
                    sourceOptional = !"-2".equals(this.tempRelationship.getCardinality()) && cardNum <= 0;
                    sourceCardinality = 1;
                    targetCardinality = "-1".equals(this.tempRelationship.getCardinality()) ? 1 : 0;
                } else if ("2".equals(this.tempRelationship.getType())) {
                    identifying = true;
                    sourceOptional = !"-2".equals(this.tempRelationship.getCardinality()) && cardNum <= 0;
                    targetOptional = false;
                    sourceCardinality = 1;
                    targetCardinality = "-1".equals(this.tempRelationship.getCardinality()) || cardNum == 1 ? 1 : 0;
                } else if ("4".equals(this.tempRelationship.getType())) {
                    identifying = false;
                    sourceOptional = true;
                    targetOptional = true;
                    sourceCardinality = 0;
                    targetCardinality = 0;
                }
                if (sourceCardinality == 1 && targetCardinality == 1) {
                    relation.setDominantRole((Entity)parent);
                }
                relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[sourceCardinality]);
                relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[targetCardinality]);
                relation.setOptionalSource(sourceOptional);
                relation.setOptionalTarget(targetOptional);
                relation.setIdentifying(identifying);
                relation.setFireCardinalityChange(true);
                relation.setTargetCardinality(relation.getTargetCardinality());
                relation.setNameOnSource(this.tempRelationship.getParentToChildVerbPhrase());
                relation.setNameOnTarget(this.tempRelationship.getChildToParentVerbPhrase());
            }
            if ((tvr = (TVRelation)relation.getTopView()) != null) {
                tvr.addConnection();
                tvr.resetEdgeParams();
            }
            this.logicalObjects.put(this.tempRelationshipID, relation);
        }
    }

    private void parseRelationalManyToMany() {
        DesignObject parent = (DesignObject)this.relationalObjects.get(this.tempRelationship.getParentEntityRef());
        DesignObject child = (DesignObject)this.relationalObjects.get(this.tempRelationship.getChildEntityRef());
        if (parent != null && child != null && parent instanceof Table && child instanceof Table) {
            KeyObject childPK;
            String relName = this.tempRelationship.getName();
            if (!"".equals(this.tempRelationship.getPhysicalName())) {
                relName = this.tempRelationship.getPhysicalName();
            }
            Table mtmTable = this.relational.getTableSet().createTable(this.deriveObjectID(ID_PREFIX_TABLE, this.tempRelationshipID));
            mtmTable.setName(relName);
            this.relationalObjects.put(this.tempRelationshipID, mtmTable);
            this.manyToManyTables.add(this.tempRelationshipID);
            if (!"".equals(this.tempRelationship.getComment())) {
                mtmTable.setNotes(this.tempRelationship.getComment());
            }
            Index mtmPKIndex = mtmTable.createIndex(this.deriveObjectID(ID_PREFIX_PK_INDEX, this.tempRelationshipID));
            mtmPKIndex.setName(ID_PREFIX_PK_INDEX + relName);
            KeyObject parentPK = ((Table)parent).getPK();
            if (parentPK != null) {
                FKIndexAssociation relParentFK = mtmTable.addFK(parentPK);
                relParentFK.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, this.tempRelationshipID));
                for (int p = 0; p < parentPK.getElements().length; ++p) {
                    Column pCol = (Column)parentPK.getElement(p);
                    Column fpCol = mtmTable.createColumn(pCol.getName());
                    pCol.copy(fpCol);
                    fpCol.addFKAssociation(pCol, relParentFK);
                    relParentFK.getLocalFKIndex().add(fpCol);
                    mtmPKIndex.add(fpCol);
                }
                this.relationalObjects.put(this.tempRelationshipID.replace("+00000000", "+00000001"), relParentFK);
            }
            if ((childPK = ((Table)child).getPK()) != null) {
                FKIndexAssociation relChildFK = mtmTable.addFK(childPK);
                relChildFK.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION2, this.tempRelationshipID));
                for (int c = 0; c < childPK.getElements().length; ++c) {
                    Column cCol = (Column)childPK.getElement(c);
                    Column fcCol = mtmTable.createColumn(cCol.getName());
                    cCol.copy(fcCol);
                    fcCol.addFKAssociation(cCol, relChildFK);
                    relChildFK.getLocalFKIndex().add(fcCol);
                    mtmPKIndex.add(fcCol);
                }
                this.relationalObjects.put(this.tempRelationshipID.replace("+00000000", "+00000002"), relChildFK);
            }
            mtmPKIndex.makePK();
            this.relationalObjects.put(this.tempRelationshipID.replace("+00000000", "+00000003"), mtmPKIndex);
        }
    }

    private void parseForeignKey() {
        KeyObject pk;
        DesignObject parent = (DesignObject)this.relationalObjects.get(this.tempRelationship.getParentEntityRef());
        DesignObject child = (DesignObject)this.relationalObjects.get(this.tempRelationship.getChildEntityRef());
        if (parent != null && child != null && parent instanceof Table && child instanceof Table && (pk = (KeyObject)this.relationalObjects.get(this.tempRelationship.getRefKey())) != null) {
            List fkelements = this.getFKElements(this.relationalFKElements, this.tempRelationshipID);
            FKElement[] elems = fkelements.toArray(new FKElement[0]);
            fkelements.clear();
            TempKey tkey = (TempKey)this.relationKey.get(this.tempRelationship.getID());
            block0: for (TempKeyMember km : tkey.getKeyMembers()) {
                for (int i = 0; i < elems.length; ++i) {
                    if (!elems[i].id.equals(km.getAttributeRef())) continue;
                    fkelements.add(elems[i]);
                    continue block0;
                }
            }
            HashMap<String, Column> map = new HashMap<String, Column>();
            for (FKElement fkElement : fkelements) {
                if (!fkElement.getParentRelationshipID().equalsIgnoreCase(this.tempRelationshipID)) continue;
                Column col = (Column)this.relationalObjects.get(fkElement.getID());
                if (col == null && fkElement.getPhysicalRef() != null) {
                    col = (Column)this.relationalObjects.get(fkElement.getPhysicalRef());
                }
                Column refCol = (Column)this.relationalObjects.get(fkElement.getParentAttributeID());
                if (col == null || refCol == null) continue;
                map.put(refCol.getObjectID(), col);
            }
            boolean fkOK = true;
            for (Column pkCol : pk.getElementsCollection()) {
                if (map.get(pkCol.getObjectID()) != null) continue;
                fkOK = false;
                break;
            }
            if (fkOK) {
                FKIndexAssociation fk = ((Table)child).addFK(pk);
                fk.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, this.tempRelationshipID));
                if (!"".equals(this.tempRelationship.getPhysicalName())) {
                    fk.setName(this.tempRelationship.getPhysicalName());
                } else if (!"".equals(this.tempRelationship.getName())) {
                    fk.setName(this.tempRelationship.getName());
                }
                if (!"".equals(this.tempRelationship.getComment())) {
                    fk.setComment(this.tempRelationship.getComment());
                }
                if (!"".equals(this.tempRelationship.getParentDeleteRule())) {
                    if ("10005".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                        fk.setDeleteRule("CASCADE");
                    } else if ("9999".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                        fk.setDeleteRule("NO ACTION");
                    } else if ("10004".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                        fk.setDeleteRule("RESTRICT");
                    } else if ("10006".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                        fk.setDeleteRule("SET NULL");
                    }
                }
                for (Column refCol : pk.getElementsCollection()) {
                    Column col = (Column)map.get(refCol.getObjectID());
                    col.addFKAssociation(refCol, fk);
                    fk.getLocalFKIndex().add(col);
                }
                fk.resetMandatoryUsingColumns();
                this.relationalObjects.put(this.tempRelationshipID, fk);
            } else {
                String msg = "Foreign Key Column missing : FK " + this.tempRelationship.getName() + " not created";
                this.importLog.addWarning(msg);
                LOGGER.warn(msg);
            }
        }
    }

    private List getFKColumnNames(List fkElements, String rsID) {
        ArrayList<String> list = new ArrayList<String>();
        for (FKElement fkElement : fkElements) {
            Column column;
            if (!fkElement.getParentRelationshipID().equalsIgnoreCase(rsID) || (column = (Column)this.relationalObjects.get(fkElement.getParentAttributeID())) == null) continue;
            list.add(column.getName());
        }
        return list;
    }

    private List getFKElements(List fkElements, String rsID) {
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (FKElement fkElement : fkElements) {
            if (!fkElement.getParentRelationshipID().equalsIgnoreCase(rsID)) continue;
            list.add(fkElement);
        }
        return list;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames_No_ColumnOrder(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames_No_ColumnOrder(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames_No_ColumnOrder(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            boolean found = false;
            for (int j = 0; j < names.size(); ++j) {
                if (!columns[i].getName().equalsIgnoreCase((String)names.get(j))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void parseInheritanceRelations() {
        for (int i = this.inheritanceObjects.size() - 1; i >= 0; --i) {
            Table childTab;
            Entity child;
            IHObject ihObject = (IHObject)this.inheritanceObjects.get(i);
            String ihObjectID = ihObject.getID();
            String parentID = ihObject.getParentID();
            String childID = ihObject.getChildID();
            boolean remove = false;
            if (this.createLogical && (child = (Entity)this.logicalObjects.get(childID)) != null) {
                Entity parent = this.getParentEntity(parentID);
                if (parent != null) {
                    child.setHierarchicalParent(parent);
                    Relation relation = child.getInheritanceRelation();
                    relation.setObjectID(this.deriveObjectID(ID_PREFIX_INHERITANCE_RELATION, ihObjectID));
                    if (!"".equals(ihObject.getComment())) {
                        relation.setComment(ihObject.getComment());
                    }
                    this.logicalObjects.put(ihObjectID, relation);
                }
                remove = true;
            }
            if (this.createRelational && (childTab = (Table)this.relationalObjects.get(childID)) != null) {
                Index pk;
                Table parentTab = this.getParentTable(parentID);
                if (parentTab != null && (pk = this.getUniqueIndexForColumnNames(parentTab, this.getFKColumnNames(this.relationalFKElements, ihObjectID))) != null) {
                    FKIndexAssociation fk = childTab.addFK(pk);
                    fk.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, ihObjectID));
                    if (!"".equals(ihObject.getPhysicalName())) {
                        fk.setName(ihObject.getPhysicalName());
                    } else if (!"".equals(ihObject.getName())) {
                        fk.setName(ihObject.getName());
                    }
                    if (!"".equals(ihObject.getComment())) {
                        fk.setComment(ihObject.getComment());
                    }
                    if (!"".equals(ihObject.getParentDeleteRule())) {
                        if ("10005".equalsIgnoreCase(ihObject.getParentDeleteRule())) {
                            fk.setDeleteRule("CASCADE");
                        } else if ("9999".equalsIgnoreCase(ihObject.getParentDeleteRule())) {
                            fk.setDeleteRule("NO ACTION");
                        } else if ("10004".equalsIgnoreCase(ihObject.getParentDeleteRule())) {
                            fk.setDeleteRule("RESTRICT");
                        } else if ("10006".equalsIgnoreCase(ihObject.getParentDeleteRule())) {
                            fk.setDeleteRule("SET NULL");
                        }
                    }
                    for (FKElement fkElement : this.relationalFKElements) {
                        if (!fkElement.getParentRelationshipID().equalsIgnoreCase(ihObjectID)) continue;
                        Column col = (Column)this.relationalObjects.get(fkElement.getID());
                        Column refCol = (Column)this.relationalObjects.get(fkElement.getParentAttributeID());
                        if (col == null || refCol == null) continue;
                        col.addFKAssociation(refCol, fk);
                        fk.getLocalFKIndex().add(col);
                    }
                    this.relationalObjects.put(ihObjectID, fk);
                }
                remove = true;
            }
            if (!remove) continue;
            this.inheritanceObjects.remove(ihObject);
        }
    }

    private Entity getParentEntity(String parentID) {
        for (IHObject ihObject : this.inheritanceObjects) {
            if (!ihObject.getChildID().equalsIgnoreCase(parentID)) continue;
            return (Entity)this.logicalObjects.get(ihObject.getParentID());
        }
        return null;
    }

    private Table getParentTable(String parentID) {
        for (IHObject ihObject : this.inheritanceObjects) {
            if (!ihObject.getChildID().equalsIgnoreCase(parentID)) continue;
            return (Table)this.relationalObjects.get(ihObject.getParentID());
        }
        return null;
    }

    private void startDefaultValues(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Default_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportDefaults"), PROGRESS_INCREMENT);
            this.defaultValues = new TreeMap();
        } else if (qName.equalsIgnoreCase("Default")) {
            this.tempDefaultValueID = attributes.getValue("id");
            this.tempDefaultValue = new TempDefaultValue(this.tempDefaultValueID, attributes.getValue("name"));
        }
    }

    private void endDefaultValues(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Default")) {
            this.defaultValues.put(this.tempDefaultValueID, this.tempDefaultValue);
        } else if (qName.equalsIgnoreCase("Built_In_Id")) {
            try {
                this.tempDefaultValue.setBuiltIn(Integer.parseInt(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (qName.equalsIgnoreCase("Server_Value")) {
            this.tempDefaultValue.setServerValue(this.getText());
        }
    }

    private void startValidationRules(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Validation_Rule_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportValidationRules"), PROGRESS_INCREMENT);
            this.validationRules = new TreeMap();
        } else if (qName.equalsIgnoreCase("Validation_Rule")) {
            this.tempValidationRuleID = attributes.getValue("id");
            this.tempValidationRule = new TempValidationRule(this.tempValidationRuleID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Valid_Value_Groups")) {
            this.tempValidationRule.initValidValues();
        } else if (qName.equalsIgnoreCase("Valid_Value")) {
            this.tempValidationRule.addValidValueName(attributes.getValue("name"));
            this.tempValidationRule.addValidValueDefinition("");
        }
    }

    private void endValidationRules(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Validation_Rule")) {
            this.validationRules.put(this.tempValidationRuleID, this.tempValidationRule);
        } else if (qName.equalsIgnoreCase("Definition") && this.stack.search("Valid_Value") == -1) {
            this.tempValidationRule.setDefinition(this.getText());
        } else if (qName.equalsIgnoreCase("Type")) {
            try {
                this.tempValidationRule.setType(Integer.parseInt(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (qName.equalsIgnoreCase("Logical_User_Rule")) {
            this.tempValidationRule.setUserRule(this.getText());
        } else if (qName.equalsIgnoreCase("Min_Value")) {
            this.tempValidationRule.setMinValue(this.getText());
        } else if (qName.equalsIgnoreCase("Max_Value")) {
            this.tempValidationRule.setMaxValue(this.getText());
        } else if (qName.equalsIgnoreCase("Definition") && this.stack.search("Valid_Value") != -1) {
            this.tempValidationRule.setValidValueDefinition(this.getText());
        }
    }

    private void applyValidationRule(ConstrainedObject constrainedObject, String validationRuleRef) {
        ValidationRuleHolder vrh = (ValidationRuleHolder)this.validationRules.get(validationRuleRef);
        if (vrh != null) {
            switch (vrh.getType()) {
                case 0: {
                    CheckConstraint check = new CheckConstraint();
                    check.setDesign(this.design);
                    check.add(new GenericConstraint(), vrh.getRule());
                    constrainedObject.setCheck(check);
                    break;
                }
                case 1: {
                    AVT avt = new AVT();
                    avt.setBeginValue(vrh.getMinValue());
                    avt.setEndValue(vrh.getMaxValue());
                    avt.setDescription(vrh.getDefinition());
                    constrainedObject.addAVT(avt);
                    break;
                }
                case 2: {
                    for (Object key : vrh.getValueList().keySet()) {
                        Object value = vrh.getValueList().get(key);
                        if (constrainedObject.getValueList() == null) {
                            ConstraintEnumeration valueList = new ConstraintEnumeration();
                            constrainedObject.setValueList(valueList);
                        }
                        constrainedObject.getValueList().add(key, (String)value);
                    }
                    break;
                }
            }
        }
    }

    private void startStoredProcedures(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Stored_Procedure_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportStoredProcedures"), PROGRESS_INCREMENT);
        } else if (qName.equalsIgnoreCase("Stored_Procedure")) {
            this.tempStoredProcedureID = attributes.getValue("id");
            this.tempStoredProcedure = new TempPLSQLSource(this.tempStoredProcedureID, attributes.getValue("name"));
        }
    }

    private void endStoredProcedures(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Stored_Procedure")) {
            if (this.oracleStorage != null) {
                this.parseStoredProcedure();
            }
        } else if (qName.equalsIgnoreCase("Definition")) {
            this.tempStoredProcedure.setDefinition(this.getText());
        } else if (qName.equalsIgnoreCase("Schema_Name")) {
            this.tempStoredProcedure.setSchemaName(this.getText());
        } else if (qName.equalsIgnoreCase("Type")) {
            this.tempStoredProcedure.setType(this.getText());
        } else if (qName.equalsIgnoreCase("Template_Code")) {
            this.tempStoredProcedure.setCodeKeyword("PROCEDURE");
            this.tempStoredProcedure.setTemplateCode(this.getText());
        }
    }

    private void parseStoredProcedure() {
        StoredProcedureOracle storProc = this.oracleStorage.getStoredProcedureSet().createStoredProcedure(this.deriveObjectID(ID_PREFIX_STORED_PROCEDURE, this.tempStoredProcedureID));
        if (!"".equals(this.tempStoredProcedure.getTemplateCode())) {
            storProc.setSource(this.tempStoredProcedure.getTemplateCode());
        }
        storProc.setName(this.tempStoredProcedure.getName());
        if (!"".equals(this.tempStoredProcedure.getDefinition())) {
            storProc.setComment(this.tempStoredProcedure.getDefinition());
        }
        if (!"".equals(this.tempStoredProcedure.getSchemaName())) {
            this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempStoredProcedure.getSchemaName(), storProc));
        }
        this.storedProcedures.put(this.tempStoredProcedureID, storProc);
    }

    private void startManyToManyTransforms(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Many_To_Many_Transform_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportManyToManyTransforms"), PROGRESS_INCREMENT);
        } else if (qName.equalsIgnoreCase("Many_To_Many_Transform")) {
            this.tempMTMTransformID = attributes.getValue("id");
            this.tempMTMTransform = new TempMTMTransform(this.tempMTMTransformID, attributes.getValue("name"));
        }
    }

    private void endManyToManyTransforms(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Many_To_Many_Transform")) {
            if (this.createLogical && this.createRelational) {
                this.parseMTMTransform();
            }
        } else if (qName.equalsIgnoreCase("Many_To_Many_Association_Table_Ref")) {
            this.tempMTMTransform.setAssociationTableRef(this.getText());
        } else if (qName.equalsIgnoreCase("Relationship_1_Ref")) {
            this.tempMTMTransform.setRelationshipRef_1(this.getText());
        } else if (qName.equalsIgnoreCase("Relationship_2_Ref")) {
            this.tempMTMTransform.setRelationshipRef_2(this.getText());
        }
    }

    private void parseMTMTransform() {
        Table tab = (Table)this.relationalObjects.get(this.tempMTMTransform.getAssociationTableRef());
        Relation rel_1 = (Relation)this.logicalObjects.get(this.tempMTMTransform.getRelationshipRef_1());
        Relation rel_2 = (Relation)this.logicalObjects.get(this.tempMTMTransform.getRelationshipRef_2());
        if (rel_1 != null && tab != null) {
            XtdMapping map_1 = this.design.getExtendedMap().createMapping(rel_1, tab);
            map_1.setRealSourceEntityID(rel_1.getSourceEntity().getObjectID());
            map_1.setRealTargetEntityID(rel_1.getTargetEntity().getObjectID());
            tab.setGeneratorID(rel_1.getObjectID());
            map_1.setCreationTime(System.currentTimeMillis());
        }
        if (rel_2 != null && tab != null) {
            XtdMapping map_2 = this.design.getExtendedMap().createMapping(rel_2, tab);
            map_2.setRealSourceEntityID(rel_2.getSourceEntity().getObjectID());
            map_2.setRealTargetEntityID(rel_2.getTargetEntity().getObjectID());
            tab.setGeneratorID(rel_2.getObjectID());
            map_2.setCreationTime(System.currentTimeMillis());
        }
    }

    private void startRollUpTransforms(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Supertype_Subtype_Roll_Up_Transform_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportRollUpTransforms"), PROGRESS_INCREMENT);
        } else if (qName.equalsIgnoreCase("Supertype_Subtype_Roll_Up_Transform")) {
            this.tempRollUpTransformID = attributes.getValue("id");
            this.tempRollUpTransform = new TempRollUpTransform(this.tempRollUpTransformID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Roll_Up_Subtransform")) {
            this.tempRollUpSubTransformID = attributes.getValue("id");
            this.tempRollUpSubTransform = new TempRollUpSubTransform(this.tempRollUpSubTransformID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Association")) {
            this.tempSourceObjectRef = "";
            this.tempTargetObjectRef = "";
        }
    }

    private void endRollUpTransforms(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Supertype_Subtype_Roll_Up_Transform")) {
            if (this.createLogical && this.createRelational) {
                this.rollUpTransforms.put(this.tempRollUpTransformID, this.tempRollUpTransform);
                this.updateTransformWaitingList();
            }
        } else if (qName.equalsIgnoreCase("Parent_Table_Ref")) {
            this.tempRollUpTransform.setParentTableRef(this.getText());
        } else if (qName.equalsIgnoreCase("Scratch_Parent_Table_Ref")) {
            this.tempRollUpTransform.setScratchParentTableRef(this.getText());
        } else if (qName.equalsIgnoreCase("Denormalized_Table_In_Roll_Up_Ref")) {
            this.tempRollUpTransform.setDenormalizedTableRef(this.getText());
        } else if (qName.equalsIgnoreCase("Scratch_Denormalized_Table_In_Roll_Up_Ref")) {
            this.tempRollUpTransform.setScratchDenormalizedTableRef(this.getText());
        } else if (qName.equalsIgnoreCase("Roll_Up_Subtransform")) {
            this.tempRollUpTransform.addTempRollUpSubTransform(this.tempRollUpSubTransform);
        } else if (qName.equalsIgnoreCase("Association")) {
            if (this.stack.search("Roll_Up_Subtransform") == -1) {
                this.tempRollUpTransform.addSourceAssociation(this.tempSourceObjectRef);
                this.tempRollUpTransform.addTargetAssociation(this.tempTargetObjectRef);
            } else {
                this.tempRollUpSubTransform.addSubSourceAssociation(this.tempSourceObjectRef);
                this.tempRollUpSubTransform.addSubTargetAssociation(this.tempTargetObjectRef);
            }
        } else if (qName.equalsIgnoreCase("Child_Table_Ref")) {
            this.tempRollUpSubTransform.setChildTableRef(this.getText());
        } else if (qName.equalsIgnoreCase("Scratch_Child_Table_Ref")) {
            this.tempRollUpSubTransform.setScratchChildTableRef(this.getText());
        } else if (qName.equalsIgnoreCase("Source_Object_Ref")) {
            this.tempSourceObjectRef = this.getText();
        } else if (qName.equalsIgnoreCase("Target_Object_Ref")) {
            this.tempTargetObjectRef = this.getText();
        }
    }

    private void updateTransformWaitingList() {
        String srcRef = this.tempRollUpTransform.getParentTableRef();
        String tgtRef = this.tempRollUpTransform.getDenormalizedTableRef();
        Entity srcEnt = (Entity)this.logicalObjects.get(srcRef);
        Table tgtTab = (Table)this.relationalObjects.get(tgtRef);
        if (srcEnt != null && tgtTab == null && !"".equals(this.tempRollUpTransform.getScratchDenormalizedTableRef()) || srcEnt == null && tgtTab != null && !"".equals(this.tempRollUpTransform.getScratchParentTableRef())) {
            for (TransformWaitingListEntry trf : this.transformWaitingList) {
                if (!this.tempRollUpTransformID.equalsIgnoreCase(trf.getTransformRef())) continue;
                if (trf.isSourceOfTransform() && srcRef.equalsIgnoreCase(trf.getDesignObjectRef())) {
                    trf.setScratchObjectRef(this.tempRollUpTransform.getScratchDenormalizedTableRef());
                    continue;
                }
                if (trf.isSourceOfTransform() || !tgtRef.equalsIgnoreCase(trf.getDesignObjectRef())) continue;
                trf.setScratchObjectRef(this.tempRollUpTransform.getScratchParentTableRef());
            }
        }
    }

    private void parseRollUpTransform(TempRollUpTransform transform, String parentEntRef, String denormalizedTabRef, boolean srcOfTransform) {
        Entity parentEnt = (Entity)this.logicalObjects.get(parentEntRef);
        Table denormalizedTab = (Table)this.relationalObjects.get(denormalizedTabRef);
        if (parentEnt != null && denormalizedTab != null) {
            if (this.design.getExtendedMap().getMapping(parentEnt, denormalizedTab) == null) {
                XtdMapping map = this.design.getExtendedMap().createMapping(parentEnt, denormalizedTab);
                denormalizedTab.setGeneratorID(parentEnt.getObjectID());
                map.setCreationTime(System.currentTimeMillis());
            }
            KeyObject entityPK = parentEnt.getPK();
            KeyObject tablePK = denormalizedTab.getPK();
            if (entityPK != null && tablePK != null && this.design.getExtendedMap().getMapping(entityPK, tablePK) == null) {
                XtdMapping mapping = this.design.getExtendedMap().createMapping(entityPK, tablePK);
                tablePK.setGeneratorID(entityPK.getObjectID());
                mapping.setCreationTime(System.currentTimeMillis());
            }
        }
        if (transform.getSourceAssociations().size() == transform.getTargetAssociations().size()) {
            for (int i = 0; i < transform.getSourceAssociations().size(); ++i) {
                String sourceObjID = transform.getSourceAssociation(i);
                String targetObjID = transform.getTargetAssociation(i);
                DesignObject sourceObj = (DesignObject)this.logicalObjects.get(sourceObjID);
                DesignObject targetObj = (DesignObject)this.relationalObjects.get(targetObjID);
                if (sourceObj == null || targetObj == null || this.design.getExtendedMap().getMapping(sourceObj, targetObj) != null || this.isDeleted(sourceObj) || this.isDeleted(targetObj)) continue;
                XtdMapping subMap = this.design.getExtendedMap().createMapping(sourceObj, targetObj);
                targetObj.setGeneratorID(sourceObjID);
                subMap.setCreationTime(System.currentTimeMillis());
            }
        }
        for (TempRollUpSubTransform subTransform : transform.getTempRollUpSubTransforms()) {
            String childEntRef = srcOfTransform ? subTransform.getChildTableRef() : subTransform.getScratchChildTableRef();
            Entity childEnt = (Entity)this.logicalObjects.get(childEntRef);
            if (childEnt != null && denormalizedTab != null) {
                if (this.design.getExtendedMap().getMapping(childEnt, denormalizedTab) == null) {
                    XtdMapping map = this.design.getExtendedMap().createMapping(childEnt, denormalizedTab);
                    denormalizedTab.setGeneratorID(childEnt.getObjectID());
                    map.setCreationTime(System.currentTimeMillis());
                }
                KeyObject entityPK = childEnt.getPK();
                KeyObject tablePK = denormalizedTab.getPK();
                if (entityPK != null && tablePK != null && this.design.getExtendedMap().getMapping(entityPK, tablePK) == null) {
                    XtdMapping mapping = this.design.getExtendedMap().createMapping(entityPK, tablePK);
                    tablePK.setGeneratorID(entityPK.getObjectID());
                    mapping.setCreationTime(System.currentTimeMillis());
                }
            }
            if (subTransform.getSubSourceAssociations().size() != subTransform.getSubTargetAssociations().size()) continue;
            for (int i = 0; i < subTransform.getSubSourceAssociations().size(); ++i) {
                String subSourceObjID = subTransform.getSubSourceAssociation(i);
                String subTargetObjID = subTransform.getSubTargetAssociation(i);
                DesignObject subSourceObj = (DesignObject)this.logicalObjects.get(subSourceObjID);
                DesignObject subTargetObj = (DesignObject)this.relationalObjects.get(subTargetObjID);
                if (subSourceObj == null || subTargetObj == null || this.design.getExtendedMap().getMapping(subSourceObj, subTargetObj) != null || this.isDeleted(subSourceObj) || this.isDeleted(subTargetObj)) continue;
                XtdMapping subMap = this.design.getExtendedMap().createMapping(subSourceObj, subTargetObj);
                subTargetObj.setGeneratorID(subSourceObjID);
                subMap.setCreationTime(System.currentTimeMillis());
            }
        }
    }

    private void startViews(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("View_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportViews"), PROGRESS_INCREMENT);
            this.logicalViews2 = new ArrayList();
            this.relationalViews2 = new ArrayList();
        } else if (qName.equalsIgnoreCase("View")) {
            this.tempViewID = attributes.getValue("id");
            this.tempView = new TempView(this.tempViewID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Attribute")) {
            this.tempViewAttributeID = attributes.getValue("id");
            this.tempViewAttribute = new TempViewAttribute(this.tempViewAttributeID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("Trigger_Groups")) {
            this.tempView.initViewTriggers();
        } else if (qName.equalsIgnoreCase("Trigger")) {
            this.tempViewTriggerID = attributes.getValue("id");
            this.tempViewTrigger = new TempTrigger(this.tempViewTriggerID, attributes.getValue("name"));
        } else if (qName.equalsIgnoreCase("UDP_Instance")) {
            this.tempUDPInstanceID = attributes.getValue("id");
            this.tempUDPInstance = new TempUDPInstance(this.tempUDPInstanceID, attributes.getValue("name"));
        }
    }

    private void endViews(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("View_Groups")) {
            if (this.createLogical) {
                this.parseEntityViews2();
            }
            if (this.createRelational) {
                this.parseTableViews2();
            }
        } else if (qName.equalsIgnoreCase("View")) {
            this.parseView();
        } else if (this.stack.search("ViewProps") != -1) {
            if (qName.equalsIgnoreCase("Type")) {
                this.tempView.setType(this.getText());
            } else if (qName.equalsIgnoreCase("Physical_Name")) {
                this.tempView.setPhysicalName(this.getText());
            } else if (qName.equalsIgnoreCase("Schema_Name")) {
                this.tempView.setSchemaName(this.getText());
            } else if (qName.equalsIgnoreCase("Is_Physical_Only")) {
                this.tempView.setPhysicalOnly(this.getText());
            } else if (qName.equalsIgnoreCase("Is_Logical_Only")) {
                this.tempView.setLogicalOnly(this.getText());
            } else if (qName.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempView.setHideInLogical(this.getText());
            } else if (qName.equalsIgnoreCase("Hide_In_Physical")) {
                this.tempView.setHideInPhysical(this.getText());
            } else if (qName.equalsIgnoreCase("Definition")) {
                this.tempView.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Fill_Color")) {
                this.tempView.setBgColorVal(this.getText());
            } else if (qName.equalsIgnoreCase("Outline_Color")) {
                this.tempView.setOutlineColorVal(this.getText());
            } else if (qName.equalsIgnoreCase("Default_Entity_Name_Font_Ref")) {
                this.tempView.setNameFontID(this.getText());
            } else if (qName.equalsIgnoreCase("Default_Entity_Name_Color")) {
                this.tempView.setNameColorVal(this.getText());
            } else if (qName.equalsIgnoreCase("Comment") || qName.equalsIgnoreCase("Note")) {
                this.tempView.setComment(this.getText());
            } else if (qName.equalsIgnoreCase("SQL")) {
                this.tempView.setSQL(this.getText());
            } else if (qName.equalsIgnoreCase("Stored_Procedures_Ref")) {
                this.tempView.addStoredProcedureRef(this.getText());
            } else if (qName.equalsIgnoreCase("Functions_Ref")) {
                this.tempView.addFunctionRef(this.getText());
            } else if (qName.equalsIgnoreCase("UDP_Instance")) {
                this.tempUDPInstance.setValue(this.getText());
                this.tempView.getUDPInstances().add(this.tempUDPInstance);
            }
        } else if (qName.equalsIgnoreCase("Attribute")) {
            this.tempView.addViewAttribute(this.tempViewAttribute);
        } else if (this.stack.search("AttributeProps") != -1) {
            if (qName.equalsIgnoreCase("Type")) {
                this.tempViewAttribute.setType(this.getText());
            } else if (qName.equalsIgnoreCase("Physical_Name")) {
                this.tempViewAttribute.setPhysicalName(this.getText());
            } else if (qName.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempViewAttribute.setHideInLogical(this.getText());
            } else if (qName.equalsIgnoreCase("Parent_Attribute_Ref")) {
                this.tempViewAttribute.setParentAttrRef(this.getText());
            } else if (qName.equalsIgnoreCase("Parent_Relationship_Ref")) {
                this.tempViewAttribute.setParentRelRef(this.getText());
            } else if (qName.equalsIgnoreCase("Parent_Domain_Ref")) {
                this.tempViewAttribute.setParentDomRef(this.getText());
            } else if (qName.equalsIgnoreCase("Logical_Data_Type")) {
                this.tempViewAttribute.setLogicalDatatype(this.getText());
            } else if (qName.equalsIgnoreCase("Physical_Data_Type")) {
                this.tempViewAttribute.setPhysicalDatatype(this.getText());
            } else if (qName.equalsIgnoreCase("Definition")) {
                this.tempViewAttribute.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Null_Option_Type")) {
                this.tempViewAttribute.setNullOptionType(this.getText());
            } else if (qName.equalsIgnoreCase("Font_Ref")) {
                this.tempViewAttribute.setFontRef(this.getText());
            } else if (qName.equalsIgnoreCase("Font_Color")) {
                this.tempViewAttribute.setFontColor(this.getText());
            } else if (qName.equalsIgnoreCase("Comment") || qName.equalsIgnoreCase("Note")) {
                this.tempViewAttribute.setComment(this.getText());
            } else if (qName.equalsIgnoreCase("View_Expression")) {
                this.tempViewAttribute.setViewExpression(this.getText());
            }
        } else if (qName.equalsIgnoreCase("Trigger")) {
            this.tempView.addViewTrigger(this.tempViewTrigger);
        } else if (this.stack.search("TriggerProps") != -1) {
            if (qName.equalsIgnoreCase("Definition")) {
                this.tempViewTrigger.setDefinition(this.getText());
            } else if (qName.equalsIgnoreCase("Schema_Name")) {
                this.tempViewTrigger.setSchemaName(this.getText());
            } else if (qName.equalsIgnoreCase("Type")) {
                this.tempViewTrigger.setType(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Status")) {
                this.tempViewTrigger.setStatus(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Fire_Type")) {
                this.tempViewTrigger.setFireType(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Scope")) {
                this.tempViewTrigger.setScope(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Old")) {
                this.tempViewTrigger.setOldAs(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_New")) {
                this.tempViewTrigger.setNewAs(this.getText());
            } else if (qName.equalsIgnoreCase("Trigger_Body")) {
                this.tempViewTrigger.setBody(this.getText());
            }
        }
    }

    private void parseView() {
        if (this.createLogical && !"true".equalsIgnoreCase(this.tempView.getPhysicalOnly()) && !"true".equalsIgnoreCase(this.tempView.getHideInLogical()) && !"".equalsIgnoreCase(this.tempView.getName()) && "17".equalsIgnoreCase(this.tempView.getType())) {
            EntityView entityView = this.logical.getEntityViewSet().createEntityView(this.deriveObjectID(ID_PREFIX_ENTITY_VIEW, this.tempViewID));
            entityView.setName(this.tempView.getName());
            this.logicalObjects.put(this.tempViewID, entityView);
            if (!"".equals(this.tempView.getDefinition())) {
                entityView.setComment(this.tempView.getDefinition());
            }
            if (!"".equals(this.tempView.getComment())) {
                entityView.setNotes(this.tempView.getComment());
            }
            this.setFontAndColor(entityView, this.tempView.getBgColorVal(), this.tempView.getOutlineColorVal(), this.tempView.getNameFontID(), this.tempView.getNameColorVal());
            List<TempUDPInstance> udpInstances = this.tempView.getUDPInstances();
            for (int i = 0; i < udpInstances.size(); ++i) {
                TempUDPInstance udpInstance = udpInstances.get(i);
                if (!udpInstance.validForClass(EntityView.class)) continue;
                entityView.setProperty(udpInstance.getName(), udpInstance.getValue());
            }
            this.logicalViews2.add(this.tempView);
        }
        if (this.createRelational && !"true".equalsIgnoreCase(this.tempView.getLogicalOnly()) && !"true".equalsIgnoreCase(this.tempView.getHideInPhysical()) && !"".equalsIgnoreCase(this.tempView.getName())) {
            String name = this.tempView.getName();
            if (!"".equalsIgnoreCase(this.tempView.getPhysicalName())) {
                name = this.tempView.getPhysicalName();
            }
            if ("17".equalsIgnoreCase(this.tempView.getType())) {
                TableView tableView = this.relational.getTableViewSet().createTableView(this.deriveObjectID(ID_PREFIX_TABLE_VIEW, this.tempViewID));
                tableView.setName(name);
                this.relationalObjects.put(this.tempViewID, tableView);
                if (!"".equals(this.tempView.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempView.getSchemaName(), tableView));
                }
                if (!"".equals(this.tempView.getDefinition())) {
                    tableView.setComment(this.tempView.getDefinition());
                }
                if (!"".equals(this.tempView.getComment())) {
                    tableView.setNotes(this.tempView.getComment());
                }
                if (!"".equals(this.tempView.getSQL())) {
                    tableView.setUserDefinedSQL(this.tempView.getSQL());
                }
                this.setFontAndColor(tableView, this.tempView.getBgColorVal(), this.tempView.getOutlineColorVal(), this.tempView.getNameFontID(), this.tempView.getNameColorVal());
                this.relationalViews2.add(this.tempView);
                if (this.oracleStorage != null) {
                    TableViewProxyOracle viewProxy = (TableViewProxyOracle)this.oracleStorage.getTableViewProxySet().getProxy(tableView.getObjectID());
                    if (viewProxy != null && !"".equals(this.tempView.getSchemaName())) {
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempView.getSchemaName(), viewProxy));
                    }
                    for (TempTrigger tempTrig : this.tempView.getViewTriggers()) {
                        TriggerOracle trig = this.oracleStorage.getTriggerSet().createTrigger(this.deriveObjectID(ID_PREFIX_TRIGGER, tempTrig.getID()));
                        trig.setName(tempTrig.getName());
                        trig.setView(viewProxy);
                        this.parseTrigger(tempTrig, trig);
                        if ("".equals(tempTrig.getSchemaName())) continue;
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(tempTrig.getSchemaName(), trig));
                    }
                    for (String procRef : this.tempView.getStoredProcedureRefs()) {
                        this.storedProcedureWaitingList.add(new StoredProcedureWaitingListEntry(procRef, viewProxy));
                    }
                    for (String funcRef : this.tempView.getFunctionRefs()) {
                        this.functionWaitingList.add(new FunctionWaitingListEntry(funcRef, viewProxy));
                    }
                }
                List<TempUDPInstance> udpInstances = this.tempView.getUDPInstances();
                for (int i = 0; i < udpInstances.size(); ++i) {
                    TempUDPInstance udpInstance = udpInstances.get(i);
                    if (!udpInstance.validForClass(TableView.class)) continue;
                    tableView.setProperty(udpInstance.getName(), udpInstance.getValue());
                }
            }
        }
    }

    private void parseEntityViews2() {
        for (TempView logView : this.logicalViews2) {
            String logViewID = logView.getID();
            EntityView view = (EntityView)this.logicalObjects.get(logViewID);
            if (view == null) continue;
            this.parseViewAttributes2(logView, view);
        }
    }

    private void parseTableViews2() {
        for (TempView relView : this.relationalViews2) {
            String relViewID = relView.getID();
            TableView view = (TableView)this.relationalObjects.get(relViewID);
            if (view == null) continue;
            this.parseViewColumns2(relView, view);
        }
    }

    private void parseViewAttributes2(TempView logView, EntityView entView) {
        for (TempViewAttribute tempAttr : logView.getViewAttributes()) {
            Attribute attr;
            String tempAttrID = tempAttr.getID();
            if ("true".equalsIgnoreCase(tempAttr.getHideInLogical())) continue;
            AttributeView attrView = (AttributeView)entView.createContainedObject(this.deriveObjectID(ID_PREFIX_ATTRIBUTE_VIEW, tempAttrID));
            attrView.setName(tempAttr.getName());
            if (!"".equals(tempAttr.getViewExpression())) {
                attrView.setExpression(tempAttr.getViewExpression());
                attrView.setEntityAlias(entView.getName());
            } else if (!"".equals(tempAttr.getParentAttrRef()) && (attr = (Attribute)this.logicalObjects.get(tempAttr.getParentAttrRef())) != null) {
                attrView.setReferencedAttribute(attr);
                attrView.setDataType(attr.getDataType().toString());
                attrView.setEntity((Entity)attr.getContainer());
                entView.addToContainers(attr.getContainer(), attr.getContainer().getName());
            }
            this.setAttributeFontAndColor(entView, tempAttr.getFontRef(), tempAttr.getFontColor(), true);
        }
    }

    private void parseViewColumns2(TempView relView, TableView tabView) {
        for (TempViewAttribute tempAttr : relView.getViewAttributes()) {
            Column col;
            String tempAttrID = tempAttr.getID();
            if ("true".equalsIgnoreCase(tempAttr.getHideInPhysical())) continue;
            ColumnView colView = (ColumnView)tabView.createContainedObject(this.deriveObjectID(ID_PREFIX_COLUMN_VIEW, tempAttrID));
            if (!"".equals(tempAttr.getPhysicalName())) {
                colView.setName(tempAttr.getPhysicalName());
            } else {
                colView.setName(tempAttr.getName());
            }
            if (!"".equals(tempAttr.getViewExpression())) {
                colView.setExpression(tempAttr.getViewExpression());
                colView.setTableAlias(tabView.getName());
            } else if (!"".equals(tempAttr.getParentAttrRef()) && (col = (Column)this.relationalObjects.get(tempAttr.getParentAttrRef())) != null) {
                colView.setReferencedColumn(col);
                colView.setDataType(col.getDataType().toString());
                colView.setTable((Table)col.getContainer());
                tabView.addToContainers(col.getContainer(), col.getContainer().getName());
            }
            this.setAttributeFontAndColor(tabView, tempAttr.getFontRef(), tempAttr.getFontColor(), false);
        }
    }

    private void startSequences(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Sequence_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportSequences"), PROGRESS_INCREMENT);
        } else if (qName.equalsIgnoreCase("Sequence")) {
            this.tempSequenceID = attributes.getValue("id");
            this.tempSequence = new TempSequence(this.tempSequenceID, attributes.getValue("name"));
        }
    }

    private void endSequences(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Sequence")) {
            if (this.createRelational) {
                this.parseSequence();
            }
        } else if (qName.equalsIgnoreCase("Schema_Name")) {
            this.tempSequence.setSchemaName(this.getText());
        } else if (qName.equalsIgnoreCase("Definition")) {
            this.tempSequence.setDefinition(this.getText());
        } else if (qName.equalsIgnoreCase("Increment_By")) {
            this.tempSequence.setIncrementBy(this.getText());
        } else if (qName.equalsIgnoreCase("Cache_Capacity")) {
            this.tempSequence.setCacheCapacity(this.getText());
        } else if (qName.equalsIgnoreCase("Is_Cache_On")) {
            this.tempSequence.setIsCacheOn(this.getText());
        } else if (qName.equalsIgnoreCase("Is_Cycle_On")) {
            this.tempSequence.setIsCycleOn(this.getText());
        } else if (qName.equalsIgnoreCase("Is_Max")) {
            this.tempSequence.setIsMax(this.getText());
        } else if (qName.equalsIgnoreCase("Is_Min")) {
            this.tempSequence.setIsMin(this.getText());
        } else if (qName.equalsIgnoreCase("Max_Value")) {
            this.tempSequence.setMaxValue(this.getText());
        } else if (qName.equalsIgnoreCase("Min_Value")) {
            this.tempSequence.setMinValue(this.getText());
        } else if (qName.equalsIgnoreCase("Order_On")) {
            this.tempSequence.setOrderOn(this.getText());
        } else if (qName.equalsIgnoreCase("Starting_Value")) {
            this.tempSequence.setStartingValue(this.getText());
        }
    }

    private void parseSequence() {
        if (this.oracleStorage != null) {
            SequenceOracle seq = this.oracleStorage.getSequenceSet().createSequence(this.deriveObjectID(ID_PREFIX_SEQUENCE, this.tempSequenceID));
            seq.setName(this.tempSequence.getName());
            if (!"".equals(this.tempSequence.getDefinition())) {
                seq.setComment(this.tempSequence.getDefinition());
            }
            if (!"".equals(this.tempSequence.getStartingValue())) {
                seq.setStartWith(this.tempSequence.getStartingValue());
            }
            if (!"".equals(this.tempSequence.getIncrementBy())) {
                seq.setIncrementBy(this.tempSequence.getIncrementBy());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsMax()) && !"".equals(this.tempSequence.getMaxValue())) {
                seq.setMaxValue(this.tempSequence.getMaxValue());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsMin()) && !"".equals(this.tempSequence.getMinValue())) {
                seq.setMinValue(this.tempSequence.getMinValue());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsCycleOn())) {
                seq.setCycle("YES");
            } else {
                seq.setCycle("NO");
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsCacheOn())) {
                seq.setNoCache("NO");
            } else {
                seq.setNoCache("YES");
            }
            if (!"".equals(this.tempSequence.getCacheCapacity())) {
                seq.setCache(this.tempSequence.getCacheCapacity());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getOrderOn())) {
                seq.setOrder("YES");
            } else {
                seq.setOrder("NO");
            }
            if (!"".equals(this.tempSequence.getSchemaName())) {
                this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempSequence.getSchemaName(), seq));
            }
        }
    }

    private void startFonts(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Font_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportFonts"), PROGRESS_INCREMENT);
            this.fonts = new TreeMap();
        } else if (qName.equalsIgnoreCase("Font")) {
            this.tempFontID = attributes.getValue("id");
            this.tempFont = new TempFont(this.tempFontID, attributes.getValue("name"));
        }
    }

    private void endFonts(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Font")) {
            Font font = new Font(this.tempFont.getName(), this.tempFont.getStyle(), this.tempFont.getSize());
            this.fonts.put(this.tempFontID, font);
        } else if (qName.equalsIgnoreCase("Font_Size")) {
            try {
                this.tempFont.setSize(Integer.parseInt(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (qName.equalsIgnoreCase("Is_Font_Bold")) {
            if ("true".equalsIgnoreCase(this.getText())) {
                this.tempFont.setStyle(this.tempFont.getStyle() | 1);
            }
        } else if (qName.equalsIgnoreCase("Is_Font_Italic") && "true".equalsIgnoreCase(this.getText())) {
            this.tempFont.setStyle(this.tempFont.getStyle() | 2);
        }
    }

    private void startDefaultFontsAndColors(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Default_Fonts_And_Colors_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportDefaultFontsAndColors"), PROGRESS_INCREMENT);
        } else if (qName.equalsIgnoreCase("Default_Fonts_And_Colors")) {
            this.defaultNameFontID = "";
            this.defaultNameColor = "";
            this.defaultFillColor = "";
            this.defaultOutlineColor = "";
            this.defaultAttributeFontID = "";
            this.defaultAttributeColor = "";
        }
    }

    private void endDefaultFontsAndColors(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Default_Entity_Name_Font_Ref")) {
            this.defaultNameFontID = this.getText();
        } else if (qName.equalsIgnoreCase("Default_Entity_Name_Color")) {
            this.defaultNameColor = this.getText();
        } else if (qName.equalsIgnoreCase("Default_Entity_Fill_Color")) {
            this.defaultFillColor = this.getText();
        } else if (qName.equalsIgnoreCase("Default_Entity_Outline_Color")) {
            this.defaultOutlineColor = this.getText();
        } else if (qName.equalsIgnoreCase("Default_Owned_Attribute_Font_Ref")) {
            this.defaultAttributeFontID = this.getText();
        } else if (qName.equalsIgnoreCase("Default_Owned_Attribute_Color")) {
            this.defaultAttributeColor = this.getText();
        }
    }

    private void startOraclePackages(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Oracle_Package_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportOraclePackages"), PROGRESS_INCREMENT);
        } else if (qName.equalsIgnoreCase("Oracle_Package")) {
            this.tempOraclePackageID = attributes.getValue("id");
            this.tempOraclePackage = new TempPLSQLSource(this.tempOraclePackageID, attributes.getValue("name"));
        }
    }

    private void endOraclePackages(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Oracle_Package")) {
            if (this.oracleStorage != null) {
                this.parseOraclePackage();
            }
        } else if (qName.equalsIgnoreCase("Definition")) {
            this.tempOraclePackage.setDefinition(this.getText());
        } else if (qName.equalsIgnoreCase("Schema_Name")) {
            this.tempOraclePackage.setSchemaName(this.getText());
        } else if (qName.equalsIgnoreCase("Type")) {
            this.tempOraclePackage.setType(this.getText());
        } else if (qName.equalsIgnoreCase("Template_Code")) {
            this.tempOraclePackage.setCodeKeyword("PACKAGE BODY");
            this.tempOraclePackage.setTemplateCode(this.getText());
        } else if (qName.equalsIgnoreCase("Template_Specification")) {
            this.tempOraclePackage.setSpecKeyword("PACKAGE");
            this.tempOraclePackage.setTemplateSpec(this.getText());
        }
    }

    private void parseOraclePackage() {
        PackageOracle pack = (PackageOracle)this.oracleStorage.getPackageSet().createElement(this.deriveObjectID(ID_PREFIX_PACKAGE, this.tempOraclePackageID));
        if (!"".equals(this.tempOraclePackage.getTemplateSpec())) {
            pack.setSource(this.tempOraclePackage.getTemplateSpec());
        }
        if (!"".equals(this.tempOraclePackage.getTemplateCode())) {
            pack.setBodySource(this.tempOraclePackage.getTemplateCode());
        }
        pack.setName(this.tempOraclePackage.getName());
        if (!"".equals(this.tempOraclePackage.getDefinition())) {
            pack.setComment(this.tempOraclePackage.getDefinition());
        }
        if (!"".equals(this.tempOraclePackage.getSchemaName())) {
            this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempOraclePackage.getSchemaName(), pack));
        }
    }

    private void startFunctions(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Function_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportFunctions"), PROGRESS_INCREMENT);
        } else if (qName.equalsIgnoreCase("Function")) {
            this.tempFunctionID = attributes.getValue("id");
            this.tempFunction = new TempPLSQLSource(this.tempFunctionID, attributes.getValue("name"));
        }
    }

    private void endFunctions(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Function")) {
            if (this.oracleStorage != null) {
                this.parseFunction();
            }
        } else if (qName.equalsIgnoreCase("Definition")) {
            this.tempFunction.setDefinition(this.getText());
        } else if (qName.equalsIgnoreCase("Schema_Name")) {
            this.tempFunction.setSchemaName(this.getText());
        } else if (qName.equalsIgnoreCase("Type")) {
            this.tempFunction.setType(this.getText());
        } else if (qName.equalsIgnoreCase("Template_Code")) {
            this.tempFunction.setCodeKeyword("FUNCTION");
            this.tempFunction.setTemplateCode(this.getText());
        }
    }

    private void parseFunction() {
        FunctionOracle func = (FunctionOracle)this.oracleStorage.getFunctionSet().createElement(this.deriveObjectID(ID_PREFIX_FUNCTION, this.tempFunctionID));
        if (!"".equals(this.tempFunction.getTemplateCode())) {
            func.setSource(this.tempFunction.getTemplateCode());
        }
        func.setName(this.tempFunction.getName());
        if (!"".equals(this.tempFunction.getDefinition())) {
            func.setComment(this.tempFunction.getDefinition());
        }
        if (!"".equals(this.tempFunction.getSchemaName())) {
            this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempFunction.getSchemaName(), func));
        }
        this.functions.put(this.tempFunctionID, func);
    }

    private void startTransformScratchObjects(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Transform_Scratch_Object_Groups")) {
            if (this.scratchGroupStack.isEmpty()) {
                this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportTransformScratchObjects"), PROGRESS_INCREMENT);
            }
            this.scratchGroupStack.push(attributes.getValue("id"));
        } else if (qName.equalsIgnoreCase("Transform_Scratch_Object")) {
            this.tempScratchObjectID = attributes.getValue("id");
            this.tempScratchObject = new TempScratchObject(this.tempScratchObjectID, attributes.getValue("name"));
            if (!this.scratchObjectStack.isEmpty()) {
                String parentID = (String)this.scratchObjectStack.peek();
                this.tempScratchObject.setParentRef(parentID);
                TempScratchObject parent = (TempScratchObject)this.scratchObjects.get(parentID);
                parent.addChildRef(this.tempScratchObjectID);
            }
            this.scratchObjects.put(this.tempScratchObjectID, this.tempScratchObject);
            this.scratchObjectStack.push(this.tempScratchObjectID);
        }
    }

    private void endTransformScratchObjects(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Transform_Scratch_Object_Groups")) {
            this.scratchGroupStack.pop();
            if (this.scratchGroupStack.isEmpty()) {
                this.parseInheritanceRelations();
            }
        } else if (qName.equalsIgnoreCase("Transform_Scratch_Object")) {
            Domain domObj;
            if (this.tempScratchObject.getName().equalsIgnoreCase("%AttDomain") && !"".equals(this.tempScratchObject.getParentDomainRef()) && !this.domains.isEmpty() && (domObj = (Domain)this.domains.get(this.tempScratchObject.getParentDomainRef())) != null) {
                this.tempScratchObject.setName(domObj.getName());
            }
            if (this.tempScratchObject.getSourceOfTransforms().isEmpty() && this.tempScratchObject.getTargetOfTransforms().isEmpty()) {
                this.scratchObjects.remove(this.tempScratchObjectID);
            }
            this.scratchObjectStack.pop();
            if (this.scratchObjectStack.isEmpty()) {
                this.parseScratchObject(this.tempScratchObject);
            } else {
                this.tempScratchObjectID = (String)this.scratchObjectStack.peek();
                this.tempScratchObject = (TempScratchObject)this.scratchObjects.get(this.tempScratchObjectID);
            }
        } else if (qName.equalsIgnoreCase("Source_Of_Transforms_Ref")) {
            this.tempScratchObject.addSourceOfTransform(this.getText());
        } else if (qName.equalsIgnoreCase("Target_Of_Transforms_Ref")) {
            this.tempScratchObject.addTargetOfTransform(this.getText());
        } else if (qName.equalsIgnoreCase("Type")) {
            this.tempScratchObject.setType(this.getText());
        } else if (qName.equalsIgnoreCase("Physical_Name")) {
            this.tempScratchObject.setPhysicalName(this.getText());
        } else if (qName.equalsIgnoreCase("Parent_To_Child_Verb_Phrase")) {
            this.tempScratchObject.setParentToChildVerbPhrase(this.getText());
        } else if (qName.equalsIgnoreCase("Child_To_Parent_Verb_Phrase")) {
            this.tempScratchObject.setChildToParentVerbPhrase(this.getText());
        } else if (qName.equalsIgnoreCase("Cardinality")) {
            this.tempScratchObject.setCardinality(this.getText());
        } else if (qName.equalsIgnoreCase("Null_Option_Type")) {
            this.tempScratchObject.setNullOptionType(this.getText());
        } else if (qName.equalsIgnoreCase("Logical_Data_Type")) {
            this.tempScratchObject.setLogicalDataType(this.getText());
        } else if (qName.equalsIgnoreCase("Physical_Data_Type")) {
            this.tempScratchObject.setPhysicalDataType(this.getText());
        } else if (qName.equalsIgnoreCase("Parent_Domain_Ref")) {
            this.tempScratchObject.setParentDomainRef(this.getText());
        } else if (qName.equalsIgnoreCase("Parent_Entity_Ref")) {
            this.tempScratchObject.setParentEntityRef(this.getText());
        } else if (qName.equalsIgnoreCase("Child_Entity_Ref")) {
            this.tempScratchObject.setChildEntityRef(this.getText());
        } else if (qName.equalsIgnoreCase("Key_Group_Ref")) {
            this.tempScratchObject.setKeyGroupRef(this.getText());
        } else if (qName.equalsIgnoreCase("Scratch_Parent_Entity_Ref")) {
            this.tempScratchObject.setScratchParentEntityRef(this.getText());
        } else if (qName.equalsIgnoreCase("Scratch_Child_Entity_Ref")) {
            this.tempScratchObject.setScratchChildEntityRef(this.getText());
        } else if (qName.equalsIgnoreCase("Scratch_Key_Group_Ref")) {
            this.tempScratchObject.setScratchKeyGroupRef(this.getText());
        } else if (qName.equalsIgnoreCase("Key_Group_Type")) {
            this.tempScratchObject.setKeyGroupType(this.getText());
        }
    }

    private void parseScratchObject(TempScratchObject scratchObj) {
        boolean tgtOfTransform;
        boolean srcOfTransform = !scratchObj.getSourceOfTransforms().isEmpty();
        boolean bl = tgtOfTransform = !scratchObj.getTargetOfTransforms().isEmpty();
        if (srcOfTransform || tgtOfTransform) {
            if ("9".equalsIgnoreCase(scratchObj.getType())) {
                String parentRef = scratchObj.getScratchParentEntityRef();
                String childRef = scratchObj.getScratchChildEntityRef();
                if (!"".equals(parentRef) && !"".equals(childRef)) {
                    IHObject inheritObj = new IHObject(scratchObj.getID(), scratchObj.getName(), parentRef, childRef);
                    if (!"".equals(scratchObj.getPhysicalName())) {
                        inheritObj.setPhysicalName(scratchObj.getPhysicalName());
                    }
                    this.inheritanceObjects.add(inheritObj);
                }
            } else if ("2".equalsIgnoreCase(scratchObj.getType()) || "4".equalsIgnoreCase(scratchObj.getType()) || "7".equalsIgnoreCase(scratchObj.getType())) {
                if (srcOfTransform) {
                    this.createRelationFromScratch(scratchObj);
                } else {
                    this.createForeignKeyFromScratch(scratchObj);
                }
            } else if (!"3".equalsIgnoreCase(scratchObj.getType()) && "".equals(scratchObj.getType())) {
                if (srcOfTransform) {
                    this.createEntityFromScratch(scratchObj);
                } else {
                    this.createTableFromScratch(scratchObj);
                }
            }
        }
    }

    private void createEntityFromScratch(TempScratchObject scratchObj) {
        if (this.createLogical) {
            Entity ent = this.logical.getEntitySet().createEntity(this.deriveObjectID(ID_PREFIX_ENTITY, scratchObj.getID()));
            ent.setName(scratchObj.getName());
            this.logicalObjects.put(scratchObj.getID(), ent);
            this.createAttributesFromScratch(scratchObj, ent);
            this.createKeysFromScratch(scratchObj, ent);
            this.setScratchFontAndColor(ent);
        }
    }

    private void createAttributesFromScratch(TempScratchObject scratchObj, Entity ent) {
        for (String childID : scratchObj.getChildRefs()) {
            TempScratchObject childObj = (TempScratchObject)this.scratchObjects.get(childID);
            if (childObj == null || "".equals(childObj.getType()) || "1".equalsIgnoreCase(childObj.getType())) continue;
            Attribute attr = ent.createAttribute(childObj.getName());
            attr.setObjectID(this.deriveObjectID(ID_PREFIX_ATTRIBUTE, childObj.getID()));
            this.logicalObjects.put(childObj.getID(), attr);
            boolean dtOK = false;
            if (!"".equals(childObj.getLogicalDataType())) {
                dtOK = this.parseDataType(attr, childObj.getLogicalDataType());
            }
            if (!"".equals(childObj.getParentDomainRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry(attr, childObj.getParentDomainRef(), dtOK));
                } else {
                    Domain dom = (Domain)this.domains.get(childObj.getParentDomainRef());
                    if (!(dom == null || dom.getName().equalsIgnoreCase("<root>") || dom.getName().equalsIgnoreCase("<default>") || dom.getName().equalsIgnoreCase("<unknown>") || dom.getName().equalsIgnoreCase("Unknown") || !this.isDomainFor(dom, attr))) {
                        attr.setDomain(dom);
                        attr.setUse((short)0);
                        if (!this.usedDomains.contains(dom.getObjectID())) {
                            this.usedDomains.add(dom.getObjectID());
                        }
                    }
                }
            }
            this.setScratchAttributeFontAndColor(attr, true);
        }
    }

    private void createKeysFromScratch(TempScratchObject scratchObj, Entity ent) {
        for (String keyID : scratchObj.getChildRefs()) {
            TempScratchObject keyObj = (TempScratchObject)this.scratchObjects.get(keyID);
            if (keyObj == null || "".equals(keyObj.getKeyGroupType()) || keyObj.getKeyGroupType().toUpperCase().startsWith("IF")) continue;
            CandidateKey key = ent.createCandidateKey(this.deriveObjectID(ID_PREFIX_CANDIDATE_KEY, keyID));
            key.setName(keyObj.getName());
            this.logicalObjects.put(keyID, key);
            for (String childID : scratchObj.getChildRefs()) {
                Attribute attrKY;
                TempScratchObject childObj = (TempScratchObject)this.scratchObjects.get(childID);
                if (childObj == null) continue;
                if ("0".equals(childObj.getType()) && keyObj.getKeyGroupType().equalsIgnoreCase("PK")) {
                    Attribute attrPK = (Attribute)this.logicalObjects.get(childID);
                    if (attrPK == null) continue;
                    key.add(attrPK);
                    continue;
                }
                if (!"100".equals(childObj.getType()) || keyObj.getKeyGroupType().equalsIgnoreCase("PK") || (attrKY = (Attribute)this.logicalObjects.get(childID)) == null) continue;
                key.add(attrKY);
            }
            if (!keyObj.getKeyGroupType().equalsIgnoreCase("PK")) continue;
            key.makePK();
        }
    }

    private void createTableFromScratch(TempScratchObject scratchObj) {
        if (this.createRelational) {
            Table tab = this.relational.getTableSet().createTable(this.deriveObjectID(ID_PREFIX_TABLE, scratchObj.getID()));
            tab.setName(scratchObj.getName());
            this.relationalObjects.put(scratchObj.getID(), tab);
            this.createColumnsFromScratch(scratchObj, tab);
            this.createIndexesFromScratch(scratchObj, tab);
            this.setScratchFontAndColor(tab);
        }
    }

    private void createColumnsFromScratch(TempScratchObject scratchObj, Table tab) {
        for (String childID : scratchObj.getChildRefs()) {
            TempScratchObject childObj = (TempScratchObject)this.scratchObjects.get(childID);
            if (childObj == null || "".equals(childObj.getType()) || "1".equalsIgnoreCase(childObj.getType())) continue;
            Column col = tab.createColumn(childObj.getName(), this.deriveObjectID(ID_PREFIX_COLUMN, childObj.getID()));
            this.relationalObjects.put(childObj.getID(), col);
            boolean dtOK = false;
            if (!"".equals(childObj.getPhysicalDataType())) {
                dtOK = this.parsePhysicalDataType(col, childObj.getPhysicalDataType());
            }
            if (!dtOK && !"".equals(childObj.getLogicalDataType())) {
                dtOK = this.parseDataType(col, childObj.getLogicalDataType());
            }
            if (!"".equals(childObj.getParentDomainRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry(col, childObj.getParentDomainRef(), dtOK));
                } else {
                    Domain dom = (Domain)this.domains.get(childObj.getParentDomainRef());
                    if (!(dom == null || dom.getName().equalsIgnoreCase("<root>") || dom.getName().equalsIgnoreCase("<default>") || dom.getName().equalsIgnoreCase("<unknown>") || dom.getName().equalsIgnoreCase("Unknown") || !this.isDomainFor(dom, col))) {
                        col.setDomain(dom);
                        col.setUse((short)0);
                        if (!this.usedDomains.contains(dom.getObjectID())) {
                            this.usedDomains.add(dom.getObjectID());
                        }
                    }
                }
            }
            this.setScratchAttributeFontAndColor(col, false);
        }
    }

    private void createIndexesFromScratch(TempScratchObject scratchObj, Table tab) {
        for (String idxID : scratchObj.getChildRefs()) {
            IndexProxyOracle indexProxy;
            TempScratchObject idxObj = (TempScratchObject)this.scratchObjects.get(idxID);
            if (idxObj == null || "".equals(idxObj.getKeyGroupType()) || idxObj.getKeyGroupType().toUpperCase().startsWith("IF")) continue;
            Index idx = tab.createIndex(this.deriveObjectID(ID_PREFIX_INDEX, idxID));
            idx.setName(idxObj.getName());
            this.relationalObjects.put(idxID, idx);
            for (String childID : scratchObj.getChildRefs()) {
                Column colKY;
                TempScratchObject childObj = (TempScratchObject)this.scratchObjects.get(childID);
                if (childObj == null) continue;
                if ("0".equals(childObj.getType()) && idxObj.getKeyGroupType().equalsIgnoreCase("PK")) {
                    Column colPK = (Column)this.relationalObjects.get(childID);
                    if (colPK == null) continue;
                    idx.add(colPK);
                    continue;
                }
                if (!"100".equals(childObj.getType()) || idxObj.getKeyGroupType().equalsIgnoreCase("PK") || (colKY = (Column)this.relationalObjects.get(childID)) == null) continue;
                idx.add(colKY);
            }
            if (idxObj.getKeyGroupType().equalsIgnoreCase("PK")) {
                idx.makePK();
            } else if (idxObj.getKeyGroupType().toUpperCase().startsWith("AK")) {
                idx.setIndexState("Unique Constraint");
            }
            if (this.oracleStorage == null || (indexProxy = (IndexProxyOracle)this.oracleStorage.getIndexProxySet().getProxy(idx.getObjectID())) == null) continue;
            indexProxy.setName(idxObj.getName());
        }
    }

    private void createRelationFromScratch(TempScratchObject scratchObj) {
        if (this.createLogical) {
            String parentRef = !"".equals(scratchObj.getParentEntityRef()) ? scratchObj.getParentEntityRef() : scratchObj.getScratchParentEntityRef();
            String childRef = !"".equals(scratchObj.getChildEntityRef()) ? scratchObj.getChildEntityRef() : scratchObj.getScratchChildEntityRef();
            DesignObject parent = (DesignObject)this.logicalObjects.get(parentRef);
            DesignObject child = (DesignObject)this.logicalObjects.get(childRef);
            if (parent != null && child != null && parent instanceof Entity && child instanceof Entity) {
                TVRelation tvr;
                Relation relation = this.logical.getRelationSet().createRelation(this.deriveObjectID(ID_PREFIX_RELATION, scratchObj.getID()));
                if (!"".equals(scratchObj.getName())) {
                    relation.setName(scratchObj.getName());
                }
                relation.setSourceEntity((Entity)parent);
                relation.setTargetEntity((Entity)child);
                boolean identifying = false;
                boolean sourceOptional = true;
                boolean targetOptional = true;
                int sourceCardinality = 1;
                int targetCardinality = 1;
                if (!"".equals(scratchObj.getType()) && !"".equals(scratchObj.getCardinality())) {
                    if ("7".equals(scratchObj.getType())) {
                        identifying = false;
                        targetOptional = !"101".equals(scratchObj.getNullOptionType());
                        sourceOptional = !"-2".equals(scratchObj.getCardinality());
                        sourceCardinality = 1;
                        targetCardinality = "-1".equals(scratchObj.getCardinality()) ? 1 : 0;
                    } else if ("2".equals(scratchObj.getType())) {
                        identifying = true;
                        sourceOptional = false;
                        targetOptional = !"-2".equals(scratchObj.getCardinality());
                        sourceCardinality = 1;
                        targetCardinality = "-1".equals(scratchObj.getCardinality()) ? 1 : 0;
                    } else if ("4".equals(scratchObj.getType())) {
                        identifying = false;
                        sourceOptional = true;
                        targetOptional = true;
                        sourceCardinality = 0;
                        targetCardinality = 0;
                    }
                    relation.setIdentifying(identifying);
                    relation.setOptionalSource(sourceOptional);
                    relation.setOptionalTarget(targetOptional);
                    relation.setFireCardinalityChange(false);
                    relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[sourceCardinality]);
                    relation.setFireCardinalityChange(true);
                    relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[targetCardinality]);
                    relation.setNameOnSource(scratchObj.getParentToChildVerbPhrase());
                    relation.setNameOnTarget(scratchObj.getChildToParentVerbPhrase());
                }
                if ((tvr = (TVRelation)relation.getTopView()) != null) {
                    tvr.addConnection();
                    tvr.resetEdgeParams();
                }
                this.logicalObjects.put(scratchObj.getID(), relation);
            }
        }
    }

    private void createForeignKeyFromScratch(TempScratchObject scratchObj) {
        if (this.createRelational) {
            String pkRef;
            KeyObject pk;
            String parentRef = !"".equals(scratchObj.getParentEntityRef()) ? scratchObj.getParentEntityRef() : scratchObj.getScratchParentEntityRef();
            String childRef = !"".equals(scratchObj.getChildEntityRef()) ? scratchObj.getChildEntityRef() : scratchObj.getScratchChildEntityRef();
            DesignObject parent = (DesignObject)this.relationalObjects.get(parentRef);
            DesignObject child = (DesignObject)this.relationalObjects.get(childRef);
            if (parent != null && child != null && parent instanceof Table && child instanceof Table && (pk = (KeyObject)this.relationalObjects.get(pkRef = !"".equals(scratchObj.getKeyGroupRef()) ? scratchObj.getKeyGroupRef() : scratchObj.getScratchKeyGroupRef())) != null) {
                FKIndexAssociation fk = ((Table)child).addFK(pk);
                fk.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, scratchObj.getID()));
                if (!"".equals(scratchObj.getPhysicalName())) {
                    fk.setName(scratchObj.getPhysicalName());
                } else if (!"".equals(scratchObj.getName())) {
                    fk.setName(scratchObj.getName());
                }
                this.relationalObjects.put(scratchObj.getID(), fk);
            }
        }
    }

    private void initWaitingLists() {
        this.domainWaitingList = new ArrayList();
        this.schemaWaitingList = new ArrayList();
        this.storedProcedureWaitingList = new ArrayList();
        this.functionWaitingList = new ArrayList();
        this.tablespaceWaitingList = new ArrayList();
        this.defaultValueWaitingList = new ArrayList();
        this.validationRuleWaitingList = new ArrayList();
        this.fontWaitingList = new ArrayList();
        this.transformWaitingList = new ArrayList();
    }

    private void resolveWaitingLists() {
        this.resolveDomainWaitingList();
        this.resolveSchemaWaitingList();
        this.resolveStoredProcedureWaitingList();
        this.resolveFunctionWaitingList();
        this.resolveTablespaceWaitingList();
        this.resolveDefaultValueWaitingList();
        this.resolveValidationRuleWaitingList();
        this.resolveFontWaitingList();
        this.resolveTransformWaitingList();
    }

    private void resolveDomainWaitingList() {
        for (DomainWaitingListEntry entry : this.domainWaitingList) {
            ContainedObjectWithDomain obj;
            Domain dom = (Domain)this.domains.get(entry.getParentDomainRef());
            if (dom == null || dom.getName().equalsIgnoreCase("<root>") || dom.getName().equalsIgnoreCase("<default>") || dom.getName().equalsIgnoreCase("<unknown>") || dom.getName().equalsIgnoreCase("Unknown") || !this.isDomainFor(dom, obj = (ContainedObjectWithDomain)entry.getDesignObject())) continue;
            obj.setDomain(dom);
            obj.setUse((short)0);
            if (this.usedDomains.contains(dom.getObjectID())) continue;
            this.usedDomains.add(dom.getObjectID());
        }
        for (Domain domain : this.domains.values()) {
            if (this.usedDomains.contains(domain.getObjectID())) continue;
            this.design.getDomainSet().remove(domain);
        }
    }

    private boolean isDomainFor(Domain dom, ContainedObjectWithDomain obj) {
        return obj.getLogicalDatatype() == dom.getLogicalDatatype() && obj.getDataTypePrecision().equals(dom.getDataTypePrecision()) && obj.getDataTypeScale().equals(dom.getDataTypeScale()) && obj.getDataTypeSize().equals(dom.getDataTypeSize());
    }

    private void resolveSchemaWaitingList() {
        for (SchemaWaitingListEntry entry : this.schemaWaitingList) {
            DesignObject desObj = entry.getDesignObject();
            if (desObj == null || !(desObj instanceof Table) && !(desObj instanceof TableView) && !(desObj instanceof Index)) continue;
            this.parseSchema(entry.getSchemaName(), desObj);
        }
        for (SchemaWaitingListEntry proxy : this.schemaWaitingList) {
            RelationalObjectProxy proxyObj = proxy.getProxyObject();
            if (proxyObj == null || !(proxyObj instanceof TableProxyOracle) && !(proxyObj instanceof TableViewProxyOracle) && !(proxyObj instanceof IndexProxyOracle)) continue;
            this.parseProxySchema(proxy.getSchemaName(), proxyObj);
        }
        for (SchemaWaitingListEntry entry : this.schemaWaitingList) {
            StorageObject storObj = entry.getStorageObject();
            if (storObj == null || !(storObj instanceof SequenceOracle) && !(storObj instanceof TriggerOracle) && !(storObj instanceof StoredProcedureOracle) && !(storObj instanceof PackageOracle) && !(storObj instanceof FunctionOracle)) continue;
            this.parseStorageSchema(entry.getSchemaName(), storObj);
        }
    }

    private void resolveStoredProcedureWaitingList() {
        for (StoredProcedureWaitingListEntry entry : this.storedProcedureWaitingList) {
            StoredProcedureOracle storProc = (StoredProcedureOracle)this.storedProcedures.get(entry.getStoredProcedureRef());
            RelationalObjectProxy proxy = entry.getObjectProxy();
            if (storProc != null && proxy != null && !(proxy instanceof TableProxyOracle) && !(proxy instanceof TableViewProxyOracle)) continue;
        }
    }

    private void resolveFunctionWaitingList() {
        for (FunctionWaitingListEntry entry : this.functionWaitingList) {
            FunctionOracle func = (FunctionOracle)this.functions.get(entry.getFunctionRef());
            RelationalObjectProxy proxy = entry.getObjectProxy();
            if (func != null && proxy != null && !(proxy instanceof TableProxyOracle) && !(proxy instanceof TableViewProxyOracle)) continue;
        }
    }

    private void resolveTablespaceWaitingList() {
        for (TablespaceWaitingListEntry entry : this.tablespaceWaitingList) {
            PartitionListOracle pl;
            ListStorageTemplatePartitionOracle sl;
            ListPartitionOracle lp;
            HashPartitionOracle hp;
            PartitionOracle pa;
            IndexProxyOracle ip;
            TableSpaceOracle ts = (TableSpaceOracle)this.tablespaces.get(entry.getTablespaceRef());
            if (ts == null) continue;
            TableProxyOracle tp = entry.getTableProxy();
            if (tp != null) {
                tp.setTableSpace(ts);
                ts.addTable(tp);
            }
            if ((ip = entry.getIndexProxy()) != null) {
                ip.setTableSpace(ts);
            }
            if ((pa = entry.getPartition()) != null) {
                pa.setTableSpace(ts);
            }
            if ((hp = entry.getHashPartition()) != null) {
                hp.setTableSpace(ts);
            }
            if ((lp = entry.getListPartition()) != null) {
                lp.setTablespace(ts);
            }
            if ((sl = entry.getSubListPartition()) != null) {
                sl.setTablespace(ts);
            }
            if ((pl = entry.getPartitionList()) == null) continue;
            if ("HASH BY QUANTITY".equalsIgnoreCase(pl.getPartitionType())) {
                pl.setHashPTableSpaces(ts.getObjectID());
                continue;
            }
            pl.setSubPartitionsTableSpaces(ts.getObjectID());
        }
    }

    private void resolveDefaultValueWaitingList() {
        for (DefaultValueWaitingListEntry entry : this.defaultValueWaitingList) {
            String def = (String)this.defaultValues.get(entry.getDefaultValueRef());
            if (def == null) continue;
            ContainedObjectWithDomain obj = (ContainedObjectWithDomain)entry.getDesignObject();
            obj.setUsesDefaultValue(true);
            obj.setDefaultValue(def);
        }
    }

    private void resolveValidationRuleWaitingList() {
        for (ValidationRuleWaitingListEntry entry : this.validationRuleWaitingList) {
            if (entry.isTableLevel()) {
                ValidationRuleHolder vrh = (ValidationRuleHolder)this.validationRules.get(entry.getValidationRuleRef());
                if (vrh == null || vrh.getType() != 0) continue;
                Table table = (Table)entry.getDesignObject();
                TableLevelConstraint constraint = table.createCheckConstraint(vrh.getName(), vrh.getRule());
                table.addCheckConstraint(constraint);
                continue;
            }
            ((ContainedObjectWithDomain)entry.getDesignObject()).setUseDomainConstraints(false);
            this.applyValidationRule((ConstrainedObject)((Object)entry.getDesignObject()), entry.getValidationRuleRef());
        }
    }

    private void resolveFontWaitingList() {
        for (FontWaitingListEntry entry : this.fontWaitingList) {
            Font font = null;
            if (!"".equals(entry.getFontRef())) {
                font = (Font)this.fonts.get(entry.getFontRef());
            } else {
                String defaultFontID = "";
                defaultFontID = entry.isAttribute() ? this.defaultAttributeFontID : this.defaultNameFontID;
                if (!"".equals(defaultFontID)) {
                    font = (Font)this.fonts.get(defaultFontID);
                }
            }
            if (font == null || !(entry.getDesignObject() instanceof EditableFonts)) continue;
            TopView tv = entry.getDesignObject().getTopView();
            tv.setUseCustomFormat(true);
            FontObject fo = tv.getFontObject(entry.getFontType());
            fo.setFont(font);
        }
    }

    private void resolveTransformWaitingList() {
        for (TransformWaitingListEntry entry : this.transformWaitingList) {
            TempRollUpTransform transform = (TempRollUpTransform)this.rollUpTransforms.get(entry.getTransformRef());
            if (transform == null) continue;
            boolean sourceOfTransform = entry.isSourceOfTransform();
            String parentEntRef = sourceOfTransform ? entry.getDesignObjectRef() : entry.getScratchObjectRef();
            String denormalizedTabRef = sourceOfTransform ? entry.getScratchObjectRef() : entry.getDesignObjectRef();
            this.parseRollUpTransform(transform, parentEntRef, denormalizedTabRef, sourceOfTransform);
        }
    }

    private void resolveSubjectAreas() {
        for (TempSubjectArea area : this.subjectAreas) {
            this.parseSubjectArea(area);
        }
    }

    private void resolveDesignModels() {
        DataTypesDesign dtd = this.design.getDataTypesDesign();
        if (dtd != null && dtd.getMainView() != null) {
            dtd.getMainView().setName(dtd.getName());
        }
    }

    private class TransformWaitingListEntry {
        private boolean sourceOfTransform;
        private String transformRef;
        private String designObjectRef;
        private String scratchObjectRef;

        public TransformWaitingListEntry(boolean sourceOfTransform, String transformRef, String designObjectRef) {
            this.sourceOfTransform = sourceOfTransform;
            this.transformRef = transformRef;
            this.designObjectRef = designObjectRef;
            this.scratchObjectRef = "";
        }

        public boolean isSourceOfTransform() {
            return this.sourceOfTransform;
        }

        public String getTransformRef() {
            return this.transformRef;
        }

        public String getDesignObjectRef() {
            return this.designObjectRef;
        }

        public void setScratchObjectRef(String scratchObjectRef) {
            this.scratchObjectRef = scratchObjectRef;
        }

        public String getScratchObjectRef() {
            return this.scratchObjectRef;
        }
    }

    private class FontWaitingListEntry {
        private DesignObject designObject;
        private String fontRef;
        private String fontType;
        private boolean isAttribute;

        public FontWaitingListEntry(DesignObject designObject, String fontRef, String fontType, boolean isAttribute) {
            this.designObject = designObject;
            this.fontRef = fontRef;
            this.fontType = fontType;
            this.isAttribute = isAttribute;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public String getFontType() {
            return this.fontType;
        }

        public boolean isAttribute() {
            return this.isAttribute;
        }
    }

    private class ValidationRuleWaitingListEntry {
        private DesignObject designObject;
        private String validationRuleRef;
        private boolean isTableLevel;

        public ValidationRuleWaitingListEntry(DesignObject designObject, String validationRuleRef, boolean isTableLevel) {
            this.designObject = designObject;
            this.validationRuleRef = validationRuleRef;
            this.isTableLevel = isTableLevel;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getValidationRuleRef() {
            return this.validationRuleRef;
        }

        public boolean isTableLevel() {
            return this.isTableLevel;
        }
    }

    private class DefaultValueWaitingListEntry {
        private DesignObject designObject;
        private String defaultValueRef;

        public DefaultValueWaitingListEntry(DesignObject designObject, String defaultValueRef) {
            this.designObject = designObject;
            this.defaultValueRef = defaultValueRef;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getDefaultValueRef() {
            return this.defaultValueRef;
        }
    }

    private class TablespaceWaitingListEntry {
        private String tablespaceRef;
        private TableProxyOracle tableProxy;
        private IndexProxyOracle indexProxy;
        private PartitionOracle partition;
        private HashPartitionOracle hashPartition;
        private ListPartitionOracle listPartition;
        private ListStorageTemplatePartitionOracle subListPartition;
        private PartitionListOracle partitionList;

        public TablespaceWaitingListEntry(String tablespaceRef, Object object) {
            this.tablespaceRef = tablespaceRef;
            if (object instanceof TableProxyOracle) {
                this.tableProxy = (TableProxyOracle)object;
            } else if (object instanceof IndexProxyOracle) {
                this.indexProxy = (IndexProxyOracle)object;
            } else if (object instanceof PartitionOracle) {
                this.partition = (PartitionOracle)object;
            } else if (object instanceof HashPartitionOracle) {
                this.hashPartition = (HashPartitionOracle)object;
            } else if (object instanceof ListPartitionOracle) {
                this.listPartition = (ListPartitionOracle)object;
            } else if (object instanceof ListStorageTemplatePartitionOracle) {
                this.subListPartition = (ListStorageTemplatePartitionOracle)object;
            } else if (object instanceof PartitionListOracle) {
                this.partitionList = (PartitionListOracle)object;
            }
        }

        public String getTablespaceRef() {
            return this.tablespaceRef;
        }

        public TableProxyOracle getTableProxy() {
            return this.tableProxy;
        }

        public IndexProxyOracle getIndexProxy() {
            return this.indexProxy;
        }

        public PartitionOracle getPartition() {
            return this.partition;
        }

        public HashPartitionOracle getHashPartition() {
            return this.hashPartition;
        }

        public ListPartitionOracle getListPartition() {
            return this.listPartition;
        }

        public ListStorageTemplatePartitionOracle getSubListPartition() {
            return this.subListPartition;
        }

        public PartitionListOracle getPartitionList() {
            return this.partitionList;
        }
    }

    private class FunctionWaitingListEntry {
        private String functionRef;
        private RelationalObjectProxy objectProxy;

        public FunctionWaitingListEntry(String functionRef, RelationalObjectProxy objectProxy) {
            this.functionRef = functionRef;
            this.objectProxy = objectProxy;
        }

        public String getFunctionRef() {
            return this.functionRef;
        }

        public RelationalObjectProxy getObjectProxy() {
            return this.objectProxy;
        }
    }

    private class StoredProcedureWaitingListEntry {
        private String storedProcedureRef;
        private RelationalObjectProxy objectProxy;

        public StoredProcedureWaitingListEntry(String storedProcedureRef, RelationalObjectProxy objectProxy) {
            this.storedProcedureRef = storedProcedureRef;
            this.objectProxy = objectProxy;
        }

        public String getStoredProcedureRef() {
            return this.storedProcedureRef;
        }

        public RelationalObjectProxy getObjectProxy() {
            return this.objectProxy;
        }
    }

    private class SchemaWaitingListEntry {
        private String schemaName;
        private Object object;

        public SchemaWaitingListEntry(String schemaName, Object object) {
            this.schemaName = schemaName;
            this.object = object;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public DesignObject getDesignObject() {
            if (this.object instanceof DesignObject) {
                return (DesignObject)this.object;
            }
            return null;
        }

        public RelationalObjectProxy getProxyObject() {
            if (this.object instanceof RelationalObjectProxy) {
                return (RelationalObjectProxy)this.object;
            }
            return null;
        }

        public StorageObject getStorageObject() {
            if (this.object instanceof StorageObject) {
                return (StorageObject)this.object;
            }
            return null;
        }
    }

    private class DomainWaitingListEntry {
        private DesignObject designObject;
        private String parentDomainRef;
        private boolean datatypeOK;

        public DomainWaitingListEntry(DesignObject designObject, String parentDomainRef, boolean datatypeOK) {
            this.designObject = designObject;
            this.parentDomainRef = parentDomainRef;
            this.datatypeOK = datatypeOK;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getParentDomainRef() {
            return this.parentDomainRef;
        }

        public boolean isDatatypeOK() {
            return this.datatypeOK;
        }
    }

    private class TempScratchObject {
        private String id;
        private String name;
        private String parentRef;
        private String type;
        private String physicalName;
        private String parentToChildVerbPhrase;
        private String childToParentVerbPhrase;
        private String cardinality;
        private String nullOptionType;
        private String logicalDataType;
        private String physicalDataType;
        private String parentDomainRef;
        private String parentEntityRef;
        private String childEntityRef;
        private String keyGroupRef;
        private String scratchParentEntityRef;
        private String scratchChildEntityRef;
        private String scratchKeyGroupRef;
        private String keyGroupType;
        private List sourceOfTransforms;
        private List targetOfTransforms;
        private List childRefs;

        public TempScratchObject(String id, String name) {
            this.id = id;
            this.name = name;
            this.parentRef = "";
            this.type = "";
            this.physicalName = "";
            this.parentToChildVerbPhrase = "";
            this.childToParentVerbPhrase = "";
            this.cardinality = "";
            this.nullOptionType = "";
            this.logicalDataType = "";
            this.physicalDataType = "";
            this.parentDomainRef = "";
            this.parentEntityRef = "";
            this.childEntityRef = "";
            this.keyGroupRef = "";
            this.scratchParentEntityRef = "";
            this.scratchChildEntityRef = "";
            this.scratchKeyGroupRef = "";
            this.keyGroupType = "";
            this.sourceOfTransforms = new ArrayList();
            this.targetOfTransforms = new ArrayList();
            this.childRefs = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setParentRef(String parentRef) {
            this.parentRef = parentRef;
        }

        public String getParentRef() {
            return this.parentRef;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String physicalName) {
            if (!physicalName.startsWith("%")) {
                this.physicalName = physicalName;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setParentToChildVerbPhrase(String parentToChildVerbPhrase) {
            this.parentToChildVerbPhrase = parentToChildVerbPhrase;
        }

        public String getParentToChildVerbPhrase() {
            return this.parentToChildVerbPhrase;
        }

        public void setChildToParentVerbPhrase(String childToParentVerbPhrase) {
            this.childToParentVerbPhrase = childToParentVerbPhrase;
        }

        public String getChildToParentVerbPhrase() {
            return this.childToParentVerbPhrase;
        }

        public void setCardinality(String cardinality) {
            this.cardinality = cardinality;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public void setNullOptionType(String nullOptionType) {
            this.nullOptionType = nullOptionType;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setLogicalDataType(String logicalDataType) {
            this.logicalDataType = logicalDataType;
        }

        public String getLogicalDataType() {
            return this.logicalDataType;
        }

        public void setPhysicalDataType(String physicalDataType) {
            this.physicalDataType = physicalDataType;
        }

        public String getPhysicalDataType() {
            return this.physicalDataType;
        }

        public void setParentDomainRef(String parentDomainRef) {
            this.parentDomainRef = parentDomainRef;
        }

        public String getParentDomainRef() {
            return this.parentDomainRef;
        }

        public void setParentEntityRef(String parentEntityRef) {
            this.parentEntityRef = parentEntityRef;
        }

        public String getParentEntityRef() {
            return this.parentEntityRef;
        }

        public void setChildEntityRef(String childEntityRef) {
            this.childEntityRef = childEntityRef;
        }

        public String getChildEntityRef() {
            return this.childEntityRef;
        }

        public void setKeyGroupRef(String keyGroupRef) {
            this.keyGroupRef = keyGroupRef;
        }

        public String getKeyGroupRef() {
            return this.keyGroupRef;
        }

        public void setScratchParentEntityRef(String scratchParentEntityRef) {
            this.scratchParentEntityRef = scratchParentEntityRef;
        }

        public String getScratchParentEntityRef() {
            return this.scratchParentEntityRef;
        }

        public void setScratchChildEntityRef(String scratchChildEntityRef) {
            this.scratchChildEntityRef = scratchChildEntityRef;
        }

        public String getScratchChildEntityRef() {
            return this.scratchChildEntityRef;
        }

        public void setScratchKeyGroupRef(String scratchKeyGroupRef) {
            this.scratchKeyGroupRef = scratchKeyGroupRef;
        }

        public String getScratchKeyGroupRef() {
            return this.scratchKeyGroupRef;
        }

        public void setKeyGroupType(String keyGroupType) {
            this.keyGroupType = keyGroupType;
        }

        public String getKeyGroupType() {
            return this.keyGroupType;
        }

        public void initSourceOfTransforms() {
            this.sourceOfTransforms = new ArrayList();
        }

        public List getSourceOfTransforms() {
            return this.sourceOfTransforms;
        }

        public String getSourceOfTransform(int index) {
            return (String)this.sourceOfTransforms.get(index);
        }

        public void addSourceOfTransform(String sourceOfTransform) {
            this.sourceOfTransforms.add(sourceOfTransform);
        }

        public void initTargetOfTransforms() {
            this.targetOfTransforms = new ArrayList();
        }

        public List getTargetOfTransforms() {
            return this.targetOfTransforms;
        }

        public String getTargetOfTransform(int index) {
            return (String)this.targetOfTransforms.get(index);
        }

        public void addTargetOfTransform(String targetOfTransform) {
            this.targetOfTransforms.add(targetOfTransform);
        }

        public void initChildRefs() {
            this.childRefs = new ArrayList();
        }

        public List getChildRefs() {
            return this.childRefs;
        }

        public String getChildRef(int index) {
            return (String)this.childRefs.get(index);
        }

        public void addChildRef(String childRef) {
            this.childRefs.add(childRef);
        }
    }

    private class TempFont {
        private String id;
        private String name;
        private int style;
        private int size;

        public TempFont(String elmID, String elmName) {
            this.id = elmID;
            this.name = elmName;
            this.style = 0;
            this.size = 10;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int elmStyle) {
            this.style = elmStyle;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int elmSize) {
            this.size = elmSize;
        }
    }

    private class TempSequence {
        private String id;
        private String name;
        private String schemaName;
        private String definition;
        private String cacheCapacity;
        private String startingValue;
        private String incrementBy;
        private String maxValue;
        private String minValue;
        private String isCacheOn;
        private String isCycleOn;
        private String isMax;
        private String isMin;
        private String orderOn;

        public TempSequence(String sequenceID, String sequenceName) {
            this.id = sequenceID;
            this.name = sequenceName;
            this.schemaName = "";
            this.definition = "";
            this.cacheCapacity = "";
            this.startingValue = "";
            this.incrementBy = "";
            this.maxValue = "";
            this.minValue = "";
            this.isCacheOn = "";
            this.isCycleOn = "";
            this.isMax = "";
            this.isMin = "";
            this.orderOn = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setCacheCapacity(String cacheCapacity) {
            this.cacheCapacity = cacheCapacity;
        }

        public String getCacheCapacity() {
            return this.cacheCapacity;
        }

        public void setStartingValue(String startingValue) {
            this.startingValue = startingValue;
        }

        public String getStartingValue() {
            return this.startingValue;
        }

        public void setIncrementBy(String incrementBy) {
            this.incrementBy = incrementBy;
        }

        public String getIncrementBy() {
            return this.incrementBy;
        }

        public void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setIsCacheOn(String isCacheOn) {
            this.isCacheOn = isCacheOn;
        }

        public String getIsCacheOn() {
            return this.isCacheOn;
        }

        public void setIsCycleOn(String isCycleOn) {
            this.isCycleOn = isCycleOn;
        }

        public String getIsCycleOn() {
            return this.isCycleOn;
        }

        public void setIsMax(String isMax) {
            this.isMax = isMax;
        }

        public String getIsMax() {
            return this.isMax;
        }

        public void setIsMin(String isMin) {
            this.isMin = isMin;
        }

        public String getIsMin() {
            return this.isMin;
        }

        public void setOrderOn(String orderOn) {
            this.orderOn = orderOn;
        }

        public String getOrderOn() {
            return this.orderOn;
        }
    }

    private class TempViewAttribute {
        private String id;
        private String name;
        private String type;
        private String physicalName;
        private String hideInLogical;
        private String hideInPhysical;
        private String parentAttrRef;
        private String parentRelRef;
        private String parentDomRef;
        private String logicalDatatype;
        private String physicalDatatype;
        private String definition;
        private String nullOptionType;
        private String fontRef;
        private String fontColor;
        private String comment;
        private String viewExpression;

        public TempViewAttribute(String attributeID, String attributeName) {
            this.id = attributeID;
            this.name = attributeName;
            this.type = "";
            this.physicalName = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.parentAttrRef = "";
            this.parentRelRef = "";
            this.parentDomRef = "";
            this.logicalDatatype = "";
            this.physicalDatatype = "";
            this.definition = "";
            this.nullOptionType = "";
            this.fontRef = "";
            this.fontColor = "";
            this.comment = "";
            this.viewExpression = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String physicalName) {
            if (!physicalName.startsWith("%")) {
                this.physicalName = physicalName;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setHideInLogical(String hideInLogical) {
            this.hideInLogical = hideInLogical;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String hideInPhysical) {
            this.hideInPhysical = hideInPhysical;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setParentAttrRef(String parentAttrRef) {
            this.parentAttrRef = parentAttrRef;
        }

        public String getParentAttrRef() {
            return this.parentAttrRef;
        }

        public void setParentRelRef(String parentRelRef) {
            this.parentRelRef = parentRelRef;
        }

        public String getParentRelRef() {
            return this.parentRelRef;
        }

        public void setParentDomRef(String parentDomRef) {
            this.parentDomRef = parentDomRef;
        }

        public String getParentDomRef() {
            return this.parentDomRef;
        }

        public void setLogicalDatatype(String logicalDatatype) {
            this.logicalDatatype = logicalDatatype;
        }

        public String getLogicalDatatype() {
            return this.logicalDatatype;
        }

        public void setPhysicalDatatype(String physicalDatatype) {
            this.physicalDatatype = physicalDatatype;
        }

        public String getPhysicalDatatype() {
            return this.physicalDatatype;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setNullOptionType(String nullOptionType) {
            this.nullOptionType = nullOptionType;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setFontRef(String fontRef) {
            this.fontRef = fontRef;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setComment(String comment) {
            this.comment = "".equals(this.comment) ? comment : this.comment.concat(StringUtilities.NEWLINE).concat(comment);
        }

        public String getComment() {
            return this.comment;
        }

        public void setViewExpression(String viewExpression) {
            this.viewExpression = viewExpression;
        }

        public String getViewExpression() {
            return this.viewExpression;
        }
    }

    private class TempView {
        private String id;
        private String name;
        private String type;
        private String physicalName;
        private String schemaName;
        private String physicalOnly;
        private String logicalOnly;
        private String hideInLogical;
        private String hideInPhysical;
        private String definition;
        private String bgColorVal;
        private String outlineColorVal;
        private String nameFontID;
        private String nameColorVal;
        private String comment;
        private String sql;
        private List viewAttributes;
        private List viewTriggers;
        private List storedProcedureRefs;
        private List functionRefs;
        private List<TempUDPInstance> udpInstances = new ArrayList<TempUDPInstance>();

        public TempView(String entityID, String entityName) {
            this.id = entityID;
            this.name = entityName;
            this.type = "";
            this.physicalName = "";
            this.schemaName = "";
            this.physicalOnly = "";
            this.logicalOnly = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.definition = "";
            this.bgColorVal = "";
            this.outlineColorVal = "";
            this.nameFontID = "";
            this.nameColorVal = "";
            this.comment = "";
            this.sql = "";
            this.viewAttributes = new ArrayList();
            this.viewTriggers = new ArrayList();
            this.storedProcedureRefs = new ArrayList();
            this.functionRefs = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String physicalName) {
            if (!physicalName.startsWith("%")) {
                this.physicalName = physicalName;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setPhysicalOnly(String physicalOnly) {
            this.physicalOnly = physicalOnly;
        }

        public String getPhysicalOnly() {
            return this.physicalOnly;
        }

        public void setLogicalOnly(String logicalOnly) {
            this.logicalOnly = logicalOnly;
        }

        public String getLogicalOnly() {
            return this.logicalOnly;
        }

        public void setHideInLogical(String hideInLogical) {
            this.hideInLogical = hideInLogical;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String hideInPhysical) {
            this.hideInPhysical = hideInPhysical;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setBgColorVal(String bgColorVal) {
            this.bgColorVal = bgColorVal;
        }

        public String getBgColorVal() {
            return this.bgColorVal;
        }

        public void setOutlineColorVal(String outlineColorVal) {
            this.outlineColorVal = outlineColorVal;
        }

        public String getOutlineColorVal() {
            return this.outlineColorVal;
        }

        public void setNameFontID(String nameFontID) {
            this.nameFontID = nameFontID;
        }

        public String getNameFontID() {
            return this.nameFontID;
        }

        public void setNameColorVal(String nameColorVal) {
            this.nameColorVal = nameColorVal;
        }

        public String getNameColorVal() {
            return this.nameColorVal;
        }

        public void setComment(String comment) {
            this.comment = "".equals(this.comment) ? comment : this.comment.concat(StringUtilities.NEWLINE).concat(comment);
        }

        public String getComment() {
            return this.comment;
        }

        public void setSQL(String sql) {
            this.sql = sql;
        }

        public String getSQL() {
            return this.sql;
        }

        public void initViewAttributes() {
            this.viewAttributes = new ArrayList();
        }

        public List getViewAttributes() {
            return this.viewAttributes;
        }

        public TempViewAttribute getViewAttribute(int index) {
            return (TempViewAttribute)this.viewAttributes.get(index);
        }

        public void addViewAttribute(TempViewAttribute tempViewAttribute) {
            this.viewAttributes.add(tempViewAttribute);
        }

        public void initViewTriggers() {
            this.viewTriggers = new ArrayList();
        }

        public List getViewTriggers() {
            return this.viewTriggers;
        }

        public TempTrigger getViewTrigger(int index) {
            return (TempTrigger)this.viewTriggers.get(index);
        }

        public void addViewTrigger(TempTrigger tempViewTrigger) {
            this.viewTriggers.add(tempViewTrigger);
        }

        public void initStoredProcedureRefs() {
            this.storedProcedureRefs = new ArrayList();
        }

        public List getStoredProcedureRefs() {
            return this.storedProcedureRefs;
        }

        public String getStoredProcedureRef(int index) {
            return (String)this.storedProcedureRefs.get(index);
        }

        public void addStoredProcedureRef(String storedProcedureRef) {
            this.storedProcedureRefs.add(storedProcedureRef);
        }

        public void initFunctionRefs() {
            this.functionRefs = new ArrayList();
        }

        public List getFunctionRefs() {
            return this.functionRefs;
        }

        public String getFunctionRef(int index) {
            return (String)this.functionRefs.get(index);
        }

        public void addFunctionRef(String functionRef) {
            this.functionRefs.add(functionRef);
        }

        public List<TempUDPInstance> getUDPInstances() {
            return this.udpInstances;
        }
    }

    private class TempRollUpSubTransform {
        private String id;
        private String name;
        private String childTableRef;
        private String scratchChildTableRef;
        private List subSourceAssociations;
        private List subTargetAssociations;

        public TempRollUpSubTransform(String elmID, String elmName) {
            this.id = elmID;
            this.name = elmName;
            this.childTableRef = "";
            this.scratchChildTableRef = "";
            this.subSourceAssociations = new ArrayList();
            this.subTargetAssociations = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getChildTableRef() {
            return this.childTableRef;
        }

        public void setChildTableRef(String childTableRef) {
            this.childTableRef = childTableRef;
        }

        public String getScratchChildTableRef() {
            return this.scratchChildTableRef;
        }

        public void setScratchChildTableRef(String scratchChildTableRef) {
            this.scratchChildTableRef = scratchChildTableRef;
        }

        public void initSubSourceAssociations() {
            this.subSourceAssociations = new ArrayList();
        }

        public List getSubSourceAssociations() {
            return this.subSourceAssociations;
        }

        public String getSubSourceAssociation(int index) {
            return (String)this.subSourceAssociations.get(index);
        }

        public void addSubSourceAssociation(String association) {
            this.subSourceAssociations.add(association);
        }

        public void initSubTargetAssociations() {
            this.subTargetAssociations = new ArrayList();
        }

        public List getSubTargetAssociations() {
            return this.subTargetAssociations;
        }

        public String getSubTargetAssociation(int index) {
            return (String)this.subTargetAssociations.get(index);
        }

        public void addSubTargetAssociation(String association) {
            this.subTargetAssociations.add(association);
        }
    }

    private class TempRollUpTransform {
        private String id;
        private String name;
        private String parentTableRef;
        private String scratchParentTableRef;
        private String denormalizedTableRef;
        private String scratchDenormalizedTableRef;
        private List sourceAssociations;
        private List targetAssociations;
        private List tempRollUpSubTransforms;

        public TempRollUpTransform(String elmID, String elmName) {
            this.id = elmID;
            this.name = elmName;
            this.parentTableRef = "";
            this.scratchParentTableRef = "";
            this.denormalizedTableRef = "";
            this.scratchDenormalizedTableRef = "";
            this.sourceAssociations = new ArrayList();
            this.targetAssociations = new ArrayList();
            this.tempRollUpSubTransforms = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getParentTableRef() {
            return this.parentTableRef;
        }

        public void setParentTableRef(String parentTableRef) {
            this.parentTableRef = parentTableRef;
        }

        public String getScratchParentTableRef() {
            return this.scratchParentTableRef;
        }

        public void setScratchParentTableRef(String scratchParentTableRef) {
            this.scratchParentTableRef = scratchParentTableRef;
        }

        public String getDenormalizedTableRef() {
            return this.denormalizedTableRef;
        }

        public void setDenormalizedTableRef(String denormalizedTableRef) {
            this.denormalizedTableRef = denormalizedTableRef;
        }

        public String getScratchDenormalizedTableRef() {
            return this.scratchDenormalizedTableRef;
        }

        public void setScratchDenormalizedTableRef(String scratchDenormalizedTableRef) {
            this.scratchDenormalizedTableRef = scratchDenormalizedTableRef;
        }

        public void initSourceAssociations() {
            this.sourceAssociations = new ArrayList();
        }

        public List getSourceAssociations() {
            return this.sourceAssociations;
        }

        public String getSourceAssociation(int index) {
            return (String)this.sourceAssociations.get(index);
        }

        public void addSourceAssociation(String association) {
            this.sourceAssociations.add(association);
        }

        public void initTargetAssociations() {
            this.targetAssociations = new ArrayList();
        }

        public List getTargetAssociations() {
            return this.targetAssociations;
        }

        public String getTargetAssociation(int index) {
            return (String)this.targetAssociations.get(index);
        }

        public void addTargetAssociation(String association) {
            this.targetAssociations.add(association);
        }

        public void initTempRollUpSubTransforms() {
            this.tempRollUpSubTransforms = new ArrayList();
        }

        public List getTempRollUpSubTransforms() {
            return this.tempRollUpSubTransforms;
        }

        public TempRollUpSubTransform getTempRollUpSubTransform(int index) {
            return (TempRollUpSubTransform)this.tempRollUpSubTransforms.get(index);
        }

        public void addTempRollUpSubTransform(TempRollUpSubTransform tempRollUpSubTransform) {
            this.tempRollUpSubTransforms.add(tempRollUpSubTransform);
        }
    }

    private class TempMTMTransform {
        private String id;
        private String name;
        private String associationTableRef;
        private String relationshipRef_1;
        private String relationshipRef_2;

        public TempMTMTransform(String elmID, String elmName) {
            this.id = elmID;
            this.name = elmName;
            this.associationTableRef = "";
            this.relationshipRef_1 = "";
            this.relationshipRef_2 = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getAssociationTableRef() {
            return this.associationTableRef;
        }

        public void setAssociationTableRef(String associationTableRef) {
            this.associationTableRef = associationTableRef;
        }

        public String getRelationshipRef_1() {
            return this.relationshipRef_1;
        }

        public void setRelationshipRef_1(String relationshipRef_1) {
            this.relationshipRef_1 = relationshipRef_1;
        }

        public String getRelationshipRef_2() {
            return this.relationshipRef_2;
        }

        public void setRelationshipRef_2(String relationshipRef_2) {
            this.relationshipRef_2 = relationshipRef_2;
        }
    }

    private class TempPLSQLSource {
        private String id;
        private String name;
        private String definition;
        private String type;
        private String schemaName;
        private String codeKeyword;
        private String specKeyword;
        private String templateCode;
        private String templateSpec;

        public TempPLSQLSource(String ID, String Name2) {
            this.id = ID;
            this.name = Name2;
            this.definition = "";
            this.type = "";
            this.schemaName = "";
            this.codeKeyword = "";
            this.specKeyword = "";
            this.templateCode = "";
            this.templateSpec = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String elmDefinition) {
            this.definition = elmDefinition;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setCodeKeyword(String codeKeyword) {
            this.codeKeyword = codeKeyword;
        }

        public String getCodeKeyword() {
            return this.codeKeyword;
        }

        public void setSpecKeyword(String specKeyword) {
            this.specKeyword = specKeyword;
        }

        public String getSpecKeyword() {
            return this.specKeyword;
        }

        public void setTemplateCode(String templateCode) {
            this.templateCode = templateCode;
        }

        public String getTemplateCode() {
            return this.templateCode;
        }

        public String getTemplateCodeBody() {
            return this.trimSource(this.templateCode, this.codeKeyword);
        }

        public void setTemplateSpec(String templateSpec) {
            this.templateSpec = templateSpec;
        }

        public String getTemplateSpec() {
            return this.templateSpec;
        }

        public String getTemplateSpecBody() {
            return this.trimSource(this.templateSpec, this.specKeyword);
        }

        private String trimSource(String source, String keyword) {
            String code = source.trim();
            if (code.toUpperCase().startsWith("CREATE")) {
                code = code.substring(6).trim();
            }
            if (code.toUpperCase().startsWith("OR")) {
                code = code.substring(2).trim();
            }
            if (code.toUpperCase().startsWith("REPLACE")) {
                code = code.substring(7).trim();
            }
            return code;
        }
    }

    private class TempValidationRule {
        private String id;
        private String name;
        private String definition;
        private String userRule;
        private String minValue;
        private String maxValue;
        private int type;
        private List validValueNames;
        private List validValueDefinitions;

        public TempValidationRule(String elmID, String elmName) {
            this.id = elmID;
            this.name = elmName;
            this.definition = "";
            this.userRule = "";
            this.minValue = "";
            this.maxValue = "";
            this.type = 0;
            this.validValueNames = new ArrayList();
            this.validValueDefinitions = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String elmDefinition) {
            this.definition = elmDefinition;
        }

        public String getUserRule() {
            return this.userRule;
        }

        public void setUserRule(String elmUserRule) {
            this.userRule = elmUserRule;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setMinValue(String elmMinValue) {
            this.minValue = elmMinValue;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(String elmMaxValue) {
            this.maxValue = elmMaxValue;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int elmType) {
            this.type = elmType;
        }

        public String getValidValueName(int index) {
            return (String)this.validValueNames.get(index);
        }

        public void addValidValueName(String elmValidValueName) {
            this.validValueNames.add(elmValidValueName);
        }

        public String getValidValueDefinition(int index) {
            return (String)this.validValueDefinitions.get(index);
        }

        public void addValidValueDefinition(String elmValidValueDefinition) {
            this.validValueDefinitions.add(elmValidValueDefinition);
        }

        public void setValidValueDefinition(String elmValidValueDefinition) {
            this.validValueDefinitions.set(this.getValidValuesSize() - 1, elmValidValueDefinition);
        }

        public void initValidValues() {
            this.validValueNames = new ArrayList();
            this.validValueDefinitions = new ArrayList();
        }

        public int getValidValuesSize() {
            return this.validValueNames.size();
        }
    }

    private class ValidationRuleHolder {
        private int type = 0;
        private String rule;
        private String minValue;
        private String maxValue;
        private String definition;
        private String name;
        private Map valueList = new TreeMap();

        public ValidationRuleHolder(int type) {
            this.type = type;
            this.rule = "";
            this.minValue = "";
            this.maxValue = "";
            this.definition = "";
            this.name = "";
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public int getType() {
            return this.type;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map getValueList() {
            return this.valueList;
        }

        public void addValue(String value, String description) {
            this.valueList.put(value, description);
        }
    }

    private class TempDefaultValue {
        private String id;
        private String name;
        private int builtIn;
        private String serverValue;

        public TempDefaultValue(String elmID, String elmName) {
            this.id = elmID;
            this.name = elmName;
            this.builtIn = 0;
            this.serverValue = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getBuiltIn() {
            return this.builtIn;
        }

        public void setBuiltIn(int elmBuiltIn) {
            this.builtIn = elmBuiltIn;
        }

        public String getServerValue() {
            return this.serverValue;
        }

        public void setServerValue(String elmServerValue) {
            this.serverValue = elmServerValue;
        }
    }

    private class TempRelationship {
        private String id;
        private String name;
        private String physicalName;
        private String hideInLogical;
        private String hideInPhysical;
        private String parentEntityRef;
        private String childEntityRef;
        private String parentToChildVerbPhrase;
        private String childToParentVerbPhrase;
        private String type;
        private String cardinality;
        private String nullOptionType;
        private String parentDeleteRule;
        private String comment;
        private String refKey;

        public TempRelationship(String relationshipID, String relationshipName) {
            this.id = relationshipID;
            this.name = relationshipName;
            this.physicalName = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.parentEntityRef = "";
            this.childEntityRef = "";
            this.parentToChildVerbPhrase = "";
            this.childToParentVerbPhrase = "";
            this.type = "";
            this.cardinality = "";
            this.nullOptionType = "";
            this.parentDeleteRule = "";
            this.comment = "";
            this.refKey = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPhysicalName(String physicalName) {
            if (!physicalName.startsWith("%")) {
                this.physicalName = physicalName;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setHideInLogical(String hideInLogical) {
            this.hideInLogical = hideInLogical;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String hideInPhysical) {
            this.hideInPhysical = hideInPhysical;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setParentEntityRef(String parentEntityRef) {
            this.parentEntityRef = parentEntityRef;
        }

        public String getParentEntityRef() {
            return this.parentEntityRef;
        }

        public void setChildEntityRef(String childEntityRef) {
            this.childEntityRef = childEntityRef;
        }

        public String getChildEntityRef() {
            return this.childEntityRef;
        }

        public void setParentToChildVerbPhrase(String parentToChildVerbPhrase) {
            this.parentToChildVerbPhrase = parentToChildVerbPhrase;
        }

        public String getParentToChildVerbPhrase() {
            return this.parentToChildVerbPhrase;
        }

        public void setChildToParentVerbPhrase(String childToParentVerbPhrase) {
            this.childToParentVerbPhrase = childToParentVerbPhrase;
        }

        public String getChildToParentVerbPhrase() {
            return this.childToParentVerbPhrase;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setCardinality(String cardinality) {
            this.cardinality = cardinality;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public void setNullOptionType(String nullOptionType) {
            this.nullOptionType = nullOptionType;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setParentDeleteRule(String parentDeleteRule) {
            this.parentDeleteRule = parentDeleteRule;
        }

        public String getParentDeleteRule() {
            return this.parentDeleteRule;
        }

        public void setComment(String comment) {
            this.comment = "".equals(this.comment) ? comment : this.comment.concat(StringUtilities.NEWLINE).concat(comment);
        }

        public String getComment() {
            return this.comment;
        }

        public String getRefKey() {
            return this.refKey;
        }

        public void setRefKey(String refKey) {
            this.refKey = refKey;
        }
    }

    protected class IHObject {
        private String id;
        private String name;
        private String parentID;
        private String childID;
        private String physicalName;
        private String parentDeleteRule;
        private String comment;

        public IHObject(String objectID, String name, String parentID, String childID) {
            this.id = objectID;
            this.name = name;
            this.parentID = parentID;
            this.childID = childID;
            this.physicalName = "";
            this.parentDeleteRule = "";
            this.comment = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getChildID() {
            return this.childID;
        }

        public String getParentID() {
            return this.parentID;
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setPhysicalName(String physicalName) {
            this.physicalName = physicalName;
        }

        public String getParentDeleteRule() {
            return this.parentDeleteRule;
        }

        public void setParentDeleteRule(String parentDeleteRule) {
            this.parentDeleteRule = parentDeleteRule;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    private class TempDrawingObject {
        private String id;
        private String name;
        private String type;
        private String modelObjectRef;
        private Rectangle locationRectangle;
        private String anchorPoint;
        private String fixedSizePoint;
        private String text;
        private String fontRef;
        private String fontColor;
        private String fillColor;
        private String outlineColor;
        private String outlineStyle;
        private List pathCoordinates;

        public TempDrawingObject(String drawingObjectID, String drawingObjectName) {
            this.id = drawingObjectID;
            this.name = drawingObjectName;
            this.type = "";
            this.modelObjectRef = "";
            this.locationRectangle = new Rectangle();
            this.anchorPoint = "";
            this.fixedSizePoint = "";
            this.text = "";
            this.fontRef = "";
            this.fontColor = "";
            this.fillColor = "";
            this.outlineColor = "";
            this.outlineStyle = "";
            this.pathCoordinates = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setModelObjectRef(String modelObjectRef) {
            this.modelObjectRef = modelObjectRef;
        }

        public String getModelObjectRef() {
            return this.modelObjectRef;
        }

        public void setLocationRectangle(String coordinates) {
            this.locationRectangle = ERSAXParserv7x.this.parseCoordinates(coordinates);
        }

        public Rectangle getLocationRectangle() {
            return this.locationRectangle;
        }

        public void setAnchorPoint(String anchorPoint) {
            this.anchorPoint = anchorPoint;
        }

        public String getAnchorPoint() {
            return this.anchorPoint;
        }

        public void setFixedSizePoint(String fixedSizePoint) {
            this.fixedSizePoint = fixedSizePoint;
        }

        public String getFixedSizePoint() {
            return this.fixedSizePoint;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setFontRef(String fontRef) {
            this.fontRef = fontRef;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setFillColor(String fillColor) {
            this.fillColor = fillColor;
        }

        public String getFillColor() {
            return this.fillColor;
        }

        public void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        public String getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineStyle(String outlineStyle) {
            this.outlineStyle = outlineStyle;
        }

        public String getOutlineStyle() {
            return this.outlineStyle;
        }

        public void initPathCoordinates() {
            this.pathCoordinates = new ArrayList();
        }

        public List getPathCoordinates() {
            return this.pathCoordinates;
        }

        public String getPathCoordinate(int index) {
            return (String)this.pathCoordinates.get(index);
        }

        public void addPathCoordinate(String pathCoordinate) {
            this.pathCoordinates.add(pathCoordinate);
        }

        public void copyFrom(TempDrawingObject tdo) {
            this.type = tdo.getType();
            this.modelObjectRef = tdo.getModelObjectRef();
            this.locationRectangle = tdo.getLocationRectangle();
            this.anchorPoint = tdo.getAnchorPoint();
            this.fixedSizePoint = tdo.getFixedSizePoint();
            this.text = tdo.getText();
            this.fontRef = tdo.getFontRef();
            this.fontColor = tdo.getFontColor();
            this.fillColor = tdo.getFillColor();
            this.outlineColor = tdo.getOutlineColor();
            this.outlineStyle = tdo.getOutlineStyle();
            this.pathCoordinates = tdo.getPathCoordinates();
        }
    }

    private class TempStoredDisplay {
        private String id;
        private String name;
        private List drawingObjects;

        public TempStoredDisplay(String storedDisplayID, String storedDisplayName) {
            this.id = storedDisplayID;
            this.name = storedDisplayName;
            this.drawingObjects = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void initDrawingObjects() {
            this.drawingObjects = new ArrayList();
        }

        public List getDrawingObjects() {
            return this.drawingObjects;
        }

        public TempDrawingObject getDrawingObject(int index) {
            return (TempDrawingObject)this.drawingObjects.get(index);
        }

        public void addDrawingObject(TempDrawingObject drawingObject) {
            this.drawingObjects.add(drawingObject);
        }
    }

    private class TempSubjectArea {
        private String id;
        private String name;
        private boolean isMain;
        private List storedDisplays;

        public TempSubjectArea(String subjectAreaID, String subjectAreaName) {
            this.id = subjectAreaID;
            this.name = subjectAreaName;
            this.isMain = false;
            this.storedDisplays = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setIsMain(String isMain) {
            this.isMain = "true".equalsIgnoreCase(isMain);
        }

        public boolean isMain() {
            return this.isMain;
        }

        public void initTempStoredDisplays() {
            this.storedDisplays = new ArrayList();
        }

        public List getTempStoredDisplays() {
            return this.storedDisplays;
        }

        public TempStoredDisplay getStoredDisplay(int index) {
            return (TempStoredDisplay)this.storedDisplays.get(index);
        }

        public void addStoredDisplay(TempStoredDisplay storedDisplay) {
            this.storedDisplays.add(storedDisplay);
        }
    }

    private class TempOracleTablespace {
        private String id;
        private String name;
        private String type;
        private String systemType;
        private String compressType;
        private String extentManagementType;
        private String localExtentManagementType;
        private String segmentManagementType;
        private String storageFileType;
        private String maxExtentType;
        private String definition;
        private int dataBlockSize;
        private int extentSize;
        private int initialExtentSize;
        private int nextExtentSize;
        private int minimumExtent;
        private int minExtents;
        private int maxExtents;
        private int percentIncrease;
        private boolean isOffline;
        private boolean isReadOnly;
        private boolean noLogging;
        private boolean forceLogging;
        private boolean canFlashback;
        private boolean retentionGuarantee;

        public TempOracleTablespace(String tablespaceID, String tablespaceName) {
            this.id = tablespaceID;
            this.name = tablespaceName;
            this.type = "";
            this.systemType = "";
            this.compressType = "";
            this.extentManagementType = "";
            this.localExtentManagementType = "";
            this.segmentManagementType = "";
            this.storageFileType = "";
            this.maxExtentType = "";
            this.definition = "";
            this.dataBlockSize = 0;
            this.extentSize = 0;
            this.initialExtentSize = 0;
            this.nextExtentSize = 0;
            this.minimumExtent = 0;
            this.minExtents = 0;
            this.maxExtents = 0;
            this.percentIncrease = 0;
            this.isOffline = false;
            this.isReadOnly = false;
            this.noLogging = false;
            this.forceLogging = false;
            this.canFlashback = false;
            this.retentionGuarantee = false;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setSystemType(String systemType) {
            this.systemType = systemType;
        }

        public String getSystemType() {
            return this.systemType;
        }

        public void setCompressType(String compressType) {
            this.compressType = compressType;
        }

        public String getCompressType() {
            return this.compressType;
        }

        public void setExtentManagementType(String extentManagementType) {
            this.extentManagementType = extentManagementType;
        }

        public String getExtentManagementType() {
            return this.extentManagementType;
        }

        public void setLocalExtentManagementType(String localExtentManagementType) {
            this.localExtentManagementType = localExtentManagementType;
        }

        public String getLocalExtentManagementType() {
            return this.localExtentManagementType;
        }

        public void setSegmentManagementType(String segmentManagementType) {
            this.segmentManagementType = segmentManagementType;
        }

        public String getSegmentManagementType() {
            return this.segmentManagementType;
        }

        public void setStorageFileType(String storageFileType) {
            this.storageFileType = storageFileType;
        }

        public String getStorageFileType() {
            return this.storageFileType;
        }

        public void setMaxExtentType(String maxExtentType) {
            this.maxExtentType = maxExtentType;
        }

        public String getMaxExtentType() {
            return this.maxExtentType;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDataBlockSize(String dataBlockSize) {
            this.dataBlockSize = ERSAXParserv7x.this.calculateSize(dataBlockSize);
        }

        public int getDataBlockSize() {
            return this.dataBlockSize;
        }

        public void setExtentSize(String extentSize) {
            this.extentSize = ERSAXParserv7x.this.calculateSize(extentSize);
        }

        public int getExtentSize() {
            return this.extentSize;
        }

        public void setInitialExtentSize(String initialExtentSize) {
            this.initialExtentSize = ERSAXParserv7x.this.calculateSize(initialExtentSize);
        }

        public int getInitialExtentSize() {
            return this.initialExtentSize;
        }

        public void setNextExtentSize(String nextExtentSize) {
            this.nextExtentSize = ERSAXParserv7x.this.calculateSize(nextExtentSize);
        }

        public int getNextExtentSize() {
            return this.nextExtentSize;
        }

        public void setMinimumExtent(String minimumExtent) {
            this.minimumExtent = ERSAXParserv7x.this.calculateSize(minimumExtent);
        }

        public int getMinimumExtent() {
            return this.minimumExtent;
        }

        public void setMinExtents(String minExtents) {
            try {
                this.minExtents = Integer.valueOf(minExtents);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMinExtents() {
            return this.minExtents;
        }

        public void setMaxExtents(String maxExtents) {
            try {
                this.maxExtents = Integer.valueOf(maxExtents);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMaxExtents() {
            return this.maxExtents;
        }

        public void setPercentIncrease(String percentIncrease) {
            try {
                this.percentIncrease = Integer.valueOf(percentIncrease);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentIncrease() {
            return this.percentIncrease;
        }

        public void setIsOffline(String isOffline) {
            this.isOffline = "true".equalsIgnoreCase(isOffline);
        }

        public boolean isOffline() {
            return this.isOffline;
        }

        public void setIsReadOnly(String isReadOnly) {
            this.isReadOnly = "true".equalsIgnoreCase(isReadOnly);
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public void setNoLogging(String noLogging) {
            this.noLogging = "true".equalsIgnoreCase(noLogging);
        }

        public boolean noLogging() {
            return this.noLogging;
        }

        public void setForceLogging(String forceLogging) {
            this.forceLogging = "true".equalsIgnoreCase(forceLogging);
        }

        public boolean forceLogging() {
            return this.forceLogging;
        }

        public void setCanFlashback(String canFlashback) {
            this.canFlashback = "true".equalsIgnoreCase(canFlashback);
        }

        public boolean canFlashback() {
            return this.canFlashback;
        }

        public void setRetentionGuarantee(String retentionGuarantee) {
            this.retentionGuarantee = "true".equalsIgnoreCase(retentionGuarantee);
        }

        public boolean retentionGuarantee() {
            return this.retentionGuarantee;
        }
    }

    private class TempDomain {
        private String id;
        private String name;
        private String logicalDatatype;
        private String physicalDatatype;
        private String parentDomainRef;
        private String validationRuleRef;

        public TempDomain(String domainID, String domainName) {
            this.id = domainID;
            this.name = domainName;
            this.logicalDatatype = "";
            this.physicalDatatype = "";
            this.parentDomainRef = "";
            this.validationRuleRef = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setLogicalDatatype(String logicalDatatype) {
            this.logicalDatatype = logicalDatatype;
        }

        public String getLogicalDatatype() {
            return this.logicalDatatype;
        }

        public void setPhysicalDatatype(String physicalDatatype) {
            this.physicalDatatype = physicalDatatype;
        }

        public String getPhysicalDatatype() {
            return this.physicalDatatype;
        }

        public void setParentDomainRef(String parentDomainRef) {
            this.parentDomainRef = parentDomainRef;
        }

        public String getParentDomainRef() {
            return this.parentDomainRef;
        }

        public void setValidationRuleRef(String validationRuleRef) {
            this.validationRuleRef = validationRuleRef;
        }

        public String getValidationRuleRef() {
            return this.validationRuleRef;
        }
    }

    private class TempSubPartitionInfo {
        private String id;
        private String name;
        private String subTablespaceRef;
        private List subPartitionValues;

        public TempSubPartitionInfo(String attributeID, String attributeName) {
            this.id = attributeID;
            this.name = attributeName;
            this.subTablespaceRef = "";
            this.subPartitionValues = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setSubTablespaceRef(String subTablespaceRef) {
            this.subTablespaceRef = subTablespaceRef;
        }

        public String getSubTablespaceRef() {
            return this.subTablespaceRef;
        }

        public void initSubPartitionValues() {
            this.subPartitionValues = new ArrayList();
        }

        public List getSubPartitionValues() {
            return this.subPartitionValues;
        }

        public String getSubPartitionValue(int index) {
            return (String)this.subPartitionValues.get(index);
        }

        public void addSubPartitionValue(String subPartitionValue) {
            this.subPartitionValues.add(subPartitionValue);
        }
    }

    private class TempPartitionInfo {
        private String id;
        private String name;
        private int partHashQuantity;
        private List partitionValues;
        private List tablespaceRefs;
        private List subPartitionInfos;

        public TempPartitionInfo(String attributeID, String attributeName) {
            this.id = attributeID;
            this.name = attributeName;
            this.partHashQuantity = 0;
            this.partitionValues = new ArrayList();
            this.tablespaceRefs = new ArrayList();
            this.subPartitionInfos = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPartHashQuantity(String partHashQuantity) {
            try {
                this.partHashQuantity = Integer.valueOf(partHashQuantity);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPartHashQuantity() {
            return this.partHashQuantity;
        }

        public void initPartitionValues() {
            this.partitionValues = new ArrayList();
        }

        public List getPartitionValues() {
            return this.partitionValues;
        }

        public String getPartitionValue(int index) {
            return (String)this.partitionValues.get(index);
        }

        public void addPartitionValue(String partitionValue) {
            this.partitionValues.add(partitionValue);
        }

        public void initTablespaceRefs() {
            this.tablespaceRefs = new ArrayList();
        }

        public List getTablespaceRefs() {
            return this.tablespaceRefs;
        }

        public String getTablespaceRef(int index) {
            return (String)this.tablespaceRefs.get(index);
        }

        public void addTablespaceRef(String tablespaceRef) {
            this.tablespaceRefs.add(tablespaceRef);
        }

        public void setTablespaceRefs(List tablespaceRefs) {
            this.tablespaceRefs = tablespaceRefs;
        }

        public void initSubPartitionInfos() {
            this.subPartitionInfos = new ArrayList();
        }

        public List getSubPartitionInfos() {
            return this.subPartitionInfos;
        }

        public TempSubPartitionInfo getSubPartitionInfo(int index) {
            return (TempSubPartitionInfo)this.subPartitionInfos.get(index);
        }

        public void addSubPartitionInfo(TempSubPartitionInfo subPartitionInfo) {
            this.subPartitionInfos.add(subPartitionInfo);
        }
    }

    private class TempPartition {
        private String id;
        private String name;
        private String partitionType;
        private String compositePartitionType;
        private String compositeListColumnRef;
        private String hashType;
        private int hashQuantity;
        private List columnRefs;
        private List hashColumnRefs;
        private List tablespaceRefs;
        private List partitionInfos;

        public TempPartition(String attributeID, String attributeName, String partitionType) {
            this.id = attributeID;
            this.name = attributeName;
            this.partitionType = partitionType;
            this.compositePartitionType = "";
            this.compositeListColumnRef = "";
            this.hashType = "";
            this.hashQuantity = 0;
            this.columnRefs = new ArrayList();
            this.hashColumnRefs = new ArrayList();
            this.tablespaceRefs = new ArrayList();
            this.partitionInfos = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPartitionType() {
            return this.partitionType;
        }

        public void setCompositePartitionType(String compositePartitionType) {
            this.compositePartitionType = compositePartitionType;
        }

        public String getCompositePartitionType() {
            return this.compositePartitionType;
        }

        public void setCompositeListColumnRef(String compositeListColumnRef) {
            this.compositeListColumnRef = compositeListColumnRef;
        }

        public String getCompositeListColumnRef() {
            return this.compositeListColumnRef;
        }

        public void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public String getHashType() {
            return this.hashType;
        }

        public void setHashQuantity(String hashQuantity) {
            try {
                this.hashQuantity = Integer.valueOf(hashQuantity);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getHashQuantity() {
            return this.hashQuantity;
        }

        public void initColumnRefs() {
            this.columnRefs = new ArrayList();
        }

        public List getColumnRefs() {
            return this.columnRefs;
        }

        public String getColumnRef(int index) {
            return (String)this.columnRefs.get(index);
        }

        public void addColumnRef(String columnRef) {
            this.columnRefs.add(columnRef);
        }

        public void initHashColumnRefs() {
            this.hashColumnRefs = new ArrayList();
        }

        public List getHashColumnRefs() {
            return this.hashColumnRefs;
        }

        public String getHashColumnRef(int index) {
            return (String)this.hashColumnRefs.get(index);
        }

        public void addHashColumnRef(String hashColumnRef) {
            this.hashColumnRefs.add(hashColumnRef);
        }

        public void initTablespaceRefs() {
            this.tablespaceRefs = new ArrayList();
        }

        public List getTablespaceRefs() {
            return this.tablespaceRefs;
        }

        public String getTablespaceRef(int index) {
            return (String)this.tablespaceRefs.get(index);
        }

        public void addTablespaceRef(String tablespaceRef) {
            this.tablespaceRefs.add(tablespaceRef);
        }

        public void initPartitionInfos() {
            this.partitionInfos = new ArrayList();
        }

        public List getPartitionInfos() {
            return this.partitionInfos;
        }

        public TempPartitionInfo getPartitionInfo(int index) {
            return (TempPartitionInfo)this.partitionInfos.get(index);
        }

        public void addPartitionInfo(TempPartitionInfo partitionInfo) {
            this.partitionInfos.add(partitionInfo);
        }
    }

    private class TempTrigger {
        private String id;
        private String name;
        private String definition;
        private String schemaName;
        private String type;
        private String status;
        private String fireType;
        private String scope;
        private String oldAs;
        private String newAs;
        private String body;
        private String when;
        private List columnRefs;

        public TempTrigger(String attributeID, String attributeName) {
            this.id = attributeID;
            this.name = attributeName;
            this.definition = "";
            this.schemaName = "";
            this.type = "";
            this.status = "";
            this.fireType = "";
            this.scope = "";
            this.oldAs = "";
            this.newAs = "";
            this.body = "";
            this.when = "";
            this.columnRefs = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setFireType(String fireType) {
            this.fireType = fireType;
        }

        public String getFireType() {
            return this.fireType;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getScope() {
            return this.scope;
        }

        public void setOldAs(String oldAs) {
            this.oldAs = oldAs;
        }

        public String getOldAs() {
            return this.oldAs;
        }

        public void setNewAs(String newAs) {
            this.newAs = newAs;
        }

        public String getNewAs() {
            return this.newAs;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getBody() {
            return this.body;
        }

        public void setWhen(String when) {
            this.when = when;
        }

        public String getWhen() {
            return this.when;
        }

        public void initColumnRefs() {
            this.columnRefs = new ArrayList();
        }

        public List getColumnRefs() {
            return this.columnRefs;
        }

        public String getColumnRef(int index) {
            return (String)this.columnRefs.get(index);
        }

        public void addColumnRef(String columnRef) {
            this.columnRefs.add(columnRef);
        }
    }

    private class TempPhysicalStorage {
        private String id;
        private String name;
        private String tablespaceRef;
        private String bufferPool;
        private String maxExtentType;
        private int initialExtentSize;
        private int nextExtentSize;
        private int freeListGroups;
        private int freeLists;
        private int initialTransactions;
        private int maxExtents;
        private int minExtents;
        private int percentFree;
        private int percentIncrease;
        private int percentUsed;
        private boolean noLogging;

        public TempPhysicalStorage(String attributeID, String attributeName) {
            this.id = attributeID;
            this.name = attributeName;
            this.tablespaceRef = "";
            this.bufferPool = "";
            this.maxExtentType = "";
            this.initialExtentSize = 0;
            this.nextExtentSize = 0;
            this.freeListGroups = 0;
            this.freeLists = 0;
            this.initialTransactions = 0;
            this.maxExtents = 0;
            this.minExtents = 0;
            this.percentFree = 0;
            this.percentIncrease = 0;
            this.percentUsed = 0;
            this.noLogging = false;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setTablespaceRef(String tablespaceRef) {
            this.tablespaceRef = tablespaceRef;
        }

        public String getTablespaceRef() {
            return this.tablespaceRef;
        }

        public void setBufferPool(String bufferPool) {
            this.bufferPool = bufferPool;
        }

        public String getBufferPool() {
            return this.bufferPool;
        }

        public void setMaxExtentType(String maxExtentType) {
            this.maxExtentType = maxExtentType;
        }

        public String getMaxExtentType() {
            return this.maxExtentType;
        }

        public void setInitialExtentSize(String initialExtentSize) {
            this.initialExtentSize = ERSAXParserv7x.this.calculateSize(initialExtentSize);
        }

        public int getInitialExtentSize() {
            return this.initialExtentSize;
        }

        public void setNextExtentSize(String nextExtentSize) {
            this.nextExtentSize = ERSAXParserv7x.this.calculateSize(nextExtentSize);
        }

        public int getNextExtentSize() {
            return this.nextExtentSize;
        }

        public void setFreeListGroups(String freeListGroups) {
            try {
                this.freeListGroups = Integer.valueOf(freeListGroups);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getFreeListGroups() {
            return this.freeListGroups;
        }

        public void setFreeLists(String freeLists) {
            try {
                this.freeLists = Integer.valueOf(freeLists);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getFreeLists() {
            return this.freeLists;
        }

        public void setInitialTransactions(String initialTransactions) {
            try {
                this.initialTransactions = Integer.valueOf(initialTransactions);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getInitialTransactions() {
            return this.initialTransactions;
        }

        public void setMaxExtents(String maxExtents) {
            try {
                this.maxExtents = Integer.valueOf(maxExtents);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMaxExtents() {
            return this.maxExtents;
        }

        public void setMinExtents(String minExtents) {
            try {
                this.minExtents = Integer.valueOf(minExtents);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMinExtents() {
            return this.minExtents;
        }

        public void setPercentFree(String percentFree) {
            try {
                this.percentFree = Integer.valueOf(percentFree);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentFree() {
            return this.percentFree;
        }

        public void setPercentIncrease(String percentIncrease) {
            try {
                this.percentIncrease = Integer.valueOf(percentIncrease);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentIncrease() {
            return this.percentIncrease;
        }

        public void setPercentUsed(String percentUsed) {
            try {
                this.percentUsed = Integer.valueOf(percentUsed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentUsed() {
            return this.percentUsed;
        }

        public void setNoLogging(String noLogging) {
            this.noLogging = "true".equalsIgnoreCase(noLogging);
        }

        public boolean noLogging() {
            return this.noLogging;
        }
    }

    private class TempKeyMember {
        private String id;
        private String name;
        private String attributeRef;
        private String sortOrder;

        public TempKeyMember(String memberID, String memberName) {
            this.id = memberID;
            this.name = memberName;
            this.attributeRef = "";
            this.sortOrder = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setAttributeRef(String attributeRef) {
            this.attributeRef = attributeRef;
        }

        public String getAttributeRef() {
            return this.attributeRef;
        }

        public void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }
    }

    private class TempKey {
        private String id;
        private String name;
        private String physicalName;
        private String type;
        private String definition;
        private List keyMembers;

        public TempKey(String keyID, String keyName) {
            this.id = keyID;
            this.name = keyName;
            this.physicalName = "";
            this.type = "";
            this.definition = "";
            this.keyMembers = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPhysicalName(String physicalName) {
            if (!physicalName.startsWith("%")) {
                this.physicalName = physicalName;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void initKeyMembers() {
            this.keyMembers = new ArrayList();
        }

        public List getKeyMembers() {
            return this.keyMembers;
        }

        public TempKeyMember getKeyMember(int index) {
            return (TempKeyMember)this.keyMembers.get(index);
        }

        public void addKeyMember(TempKeyMember keyMember) {
            this.keyMembers.add(keyMember);
        }
    }

    private class TempAttribute {
        private String id;
        private String name;
        private String physicalName;
        private String hideInLogical;
        private String hideInPhysical;
        private String parentAttrRef;
        private String parentRelRef;
        private String parentDomRef;
        private String logicalDataType;
        private String physicalDataType;
        private String definition;
        private String nullOptionType;
        private String validRuleRef;
        private String defaultRef;
        private String fontRef;
        private String fontColor;
        private String comment;
        private List sourceOfTransforms;
        private List targetOfTransforms;
        private String viewExpression;
        private String logicalRef;
        private String physicalRef;
        private boolean dataTypeDerived = false;
        private List<TempUDPInstance> udpInstances = new ArrayList<TempUDPInstance>();

        public TempAttribute(String attributeID, String attributeName) {
            this.id = attributeID;
            this.name = attributeName;
            this.physicalName = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.parentAttrRef = "";
            this.parentRelRef = "";
            this.parentDomRef = "";
            this.logicalDataType = "";
            this.physicalDataType = "";
            this.definition = "";
            this.nullOptionType = "";
            this.validRuleRef = "";
            this.defaultRef = "";
            this.fontRef = "";
            this.fontColor = "";
            this.comment = "";
            this.viewExpression = "";
            this.sourceOfTransforms = new ArrayList();
            this.targetOfTransforms = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPhysicalName(String physicalName) {
            if (!physicalName.startsWith("%")) {
                this.physicalName = physicalName;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setHideInLogical(String hideInLogical) {
            this.hideInLogical = hideInLogical;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String hideInPhysical) {
            this.hideInPhysical = hideInPhysical;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setParentAttrRef(String parentAttrRef) {
            this.parentAttrRef = parentAttrRef;
        }

        public String getParentAttrRef() {
            return this.parentAttrRef;
        }

        public void setParentRelRef(String parentRelRef) {
            this.parentRelRef = parentRelRef;
        }

        public String getParentRelRef() {
            return this.parentRelRef;
        }

        public void setParentDomRef(String parentDomRef) {
            this.parentDomRef = parentDomRef;
        }

        public String getParentDomRef() {
            return this.parentDomRef;
        }

        public void setLogicalDataType(String logicalDataType) {
            this.logicalDataType = logicalDataType;
        }

        public String getLogicalDataType() {
            return this.logicalDataType;
        }

        public void setPhysicalDataType(String physicalDataType) {
            this.physicalDataType = physicalDataType;
        }

        public String getPhysicalDataType() {
            return this.physicalDataType;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setNullOptionType(String nullOptionType) {
            this.nullOptionType = nullOptionType;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setValidRuleRef(String validRuleRef) {
            this.validRuleRef = validRuleRef;
        }

        public String getValidRuleRef() {
            return this.validRuleRef;
        }

        public void setDefaultRef(String defaultRef) {
            this.defaultRef = defaultRef;
        }

        public String getDefaultRef() {
            return this.defaultRef;
        }

        public void setFontRef(String fontRef) {
            this.fontRef = fontRef;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setComment(String comment) {
            this.comment = "".equals(this.comment) ? comment : this.comment.concat(StringUtilities.NEWLINE).concat(comment);
        }

        public String getComment() {
            return this.comment;
        }

        public void setViewExpression(String viewExpression) {
            this.viewExpression = viewExpression;
        }

        public String getViewExpression() {
            return this.viewExpression;
        }

        public void initSourceOfTransforms() {
            this.sourceOfTransforms = new ArrayList();
        }

        public List getSourceOfTransforms() {
            return this.sourceOfTransforms;
        }

        public String getSourceOfTransform(int index) {
            return (String)this.sourceOfTransforms.get(index);
        }

        public void addSourceOfTransform(String sourceOfTransform) {
            this.sourceOfTransforms.add(sourceOfTransform);
        }

        public void initTargetOfTransforms() {
            this.targetOfTransforms = new ArrayList();
        }

        public List getTargetOfTransforms() {
            return this.targetOfTransforms;
        }

        public String getTargetOfTransform(int index) {
            return (String)this.targetOfTransforms.get(index);
        }

        public void addTargetOfTransform(String targetOfTransform) {
            this.targetOfTransforms.add(targetOfTransform);
        }

        public String getLogicalRef() {
            return this.logicalRef;
        }

        public void setLogicalRef(String logicalRef) {
            this.logicalRef = logicalRef;
        }

        public String getPhysicalRef() {
            return this.physicalRef;
        }

        public void setPhysicalRef(String physicalRef) {
            this.physicalRef = physicalRef;
        }

        public List<TempUDPInstance> getUDPInstances() {
            return this.udpInstances;
        }
    }

    private class TempEntity {
        private String id;
        private String name;
        private String type;
        private String physicalName;
        private String schemaName;
        private String physicalOnly;
        private String logicalOnly;
        private String hideInLogical;
        private String hideInPhysical;
        private String definition;
        private String bgColorVal;
        private String outlineColorVal;
        private String nameFontID;
        private String nameColorVal;
        private String compressType;
        private String comment;
        private String partitionType;
        private String compositeType;
        private List sourceOfTransforms;
        private List targetOfTransforms;
        private List attributes;
        private List keys;
        private List validRuleRefs;
        private List physicalStorages;
        private List triggers;
        private List storedProcedureRefs;
        private List functionRefs;
        private List partitions;
        private List<String> columnsOrder = new ArrayList<String>();
        private List<String> attributesOrder = new ArrayList<String>();
        private List<TempUDPInstance> udpInstances = new ArrayList<TempUDPInstance>();

        public TempEntity(String entityID, String entityName) {
            this.id = entityID;
            this.name = entityName;
            this.type = "";
            this.physicalName = "";
            this.schemaName = "";
            this.physicalOnly = "";
            this.logicalOnly = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.definition = "";
            this.bgColorVal = "";
            this.outlineColorVal = "";
            this.nameFontID = "";
            this.nameColorVal = "";
            this.compressType = "";
            this.comment = "";
            this.partitionType = "";
            this.compositeType = "";
            this.sourceOfTransforms = new ArrayList();
            this.targetOfTransforms = new ArrayList();
            this.attributes = new ArrayList();
            this.keys = new ArrayList();
            this.validRuleRefs = new ArrayList();
            this.physicalStorages = new ArrayList();
            this.triggers = new ArrayList();
            this.storedProcedureRefs = new ArrayList();
            this.functionRefs = new ArrayList();
            this.partitions = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String physicalName) {
            if (!physicalName.startsWith("%")) {
                this.physicalName = physicalName;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setPhysicalOnly(String physicalOnly) {
            this.physicalOnly = physicalOnly;
        }

        public String getPhysicalOnly() {
            return this.physicalOnly;
        }

        public void setLogicalOnly(String logicalOnly) {
            this.logicalOnly = logicalOnly;
        }

        public String getLogicalOnly() {
            return this.logicalOnly;
        }

        public void setHideInLogical(String hideInLogical) {
            this.hideInLogical = hideInLogical;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String hideInPhysical) {
            this.hideInPhysical = hideInPhysical;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setBgColorVal(String bgColorVal) {
            this.bgColorVal = bgColorVal;
        }

        public String getBgColorVal() {
            return this.bgColorVal;
        }

        public void setOutlineColorVal(String outlineColorVal) {
            this.outlineColorVal = outlineColorVal;
        }

        public String getOutlineColorVal() {
            return this.outlineColorVal;
        }

        public void setNameFontID(String nameFontID) {
            this.nameFontID = nameFontID;
        }

        public String getNameFontID() {
            return this.nameFontID;
        }

        public void setNameColorVal(String nameColorVal) {
            this.nameColorVal = nameColorVal;
        }

        public String getNameColorVal() {
            return this.nameColorVal;
        }

        public void setCompressType(String compressType) {
            this.compressType = compressType;
        }

        public String getCompressType() {
            return this.compressType;
        }

        public void setComment(String comment) {
            this.comment = "".equals(this.comment) ? comment : this.comment.concat(StringUtilities.NEWLINE).concat(comment);
        }

        public String getComment() {
            return this.comment;
        }

        public void setPartitionType(String partitionType) {
            this.partitionType = partitionType;
        }

        public String getPartitionType() {
            return this.partitionType;
        }

        public void setCompositeType(String compositeType) {
            this.compositeType = compositeType;
        }

        public String getCompositeType() {
            return this.compositeType;
        }

        public void initSourceOfTransforms() {
            this.sourceOfTransforms = new ArrayList();
        }

        public List getSourceOfTransforms() {
            return this.sourceOfTransforms;
        }

        public String getSourceOfTransform(int index) {
            return (String)this.sourceOfTransforms.get(index);
        }

        public void addSourceOfTransform(String sourceOfTransform) {
            this.sourceOfTransforms.add(sourceOfTransform);
        }

        public void initTargetOfTransforms() {
            this.targetOfTransforms = new ArrayList();
        }

        public List getTargetOfTransforms() {
            return this.targetOfTransforms;
        }

        public String getTargetOfTransform(int index) {
            return (String)this.targetOfTransforms.get(index);
        }

        public void addTargetOfTransform(String targetOfTransform) {
            this.targetOfTransforms.add(targetOfTransform);
        }

        public void initAttributes() {
            this.attributes = new ArrayList();
        }

        public List getAttributes() {
            return this.attributes;
        }

        public TempAttribute getAttribute(int index) {
            return (TempAttribute)this.attributes.get(index);
        }

        public void addAttribute(TempAttribute tempAttribute) {
            this.attributes.add(tempAttribute);
        }

        public void initKeys() {
            this.keys = new ArrayList();
        }

        public List getKeys() {
            return this.keys;
        }

        public TempKey getKey(int index) {
            return (TempKey)this.keys.get(index);
        }

        public void addKey(TempKey tempKey) {
            this.keys.add(tempKey);
        }

        public void initValidRuleRefs() {
            this.validRuleRefs = new ArrayList();
        }

        public List getValidRuleRefs() {
            return this.validRuleRefs;
        }

        public String getValidRuleRef(int index) {
            return (String)this.validRuleRefs.get(index);
        }

        public void addValidRuleRef(String validRuleRef) {
            this.validRuleRefs.add(validRuleRef);
        }

        public void initPhysicalStorages() {
            this.physicalStorages = new ArrayList();
        }

        public List getPhysicalStorages() {
            return this.physicalStorages;
        }

        public TempPhysicalStorage getPhysicalStorage(int index) {
            return (TempPhysicalStorage)this.physicalStorages.get(index);
        }

        public void addPhysicalStorage(TempPhysicalStorage tempPhysicalStorage) {
            this.physicalStorages.add(tempPhysicalStorage);
        }

        public void initTriggers() {
            this.triggers = new ArrayList();
        }

        public List getTriggers() {
            return this.triggers;
        }

        public TempTrigger getTrigger(int index) {
            return (TempTrigger)this.triggers.get(index);
        }

        public void addTrigger(TempTrigger tempTrigger) {
            this.triggers.add(tempTrigger);
        }

        public void initStoredProcedureRefs() {
            this.storedProcedureRefs = new ArrayList();
        }

        public List getStoredProcedureRefs() {
            return this.storedProcedureRefs;
        }

        public String getStoredProcedureRef(int index) {
            return (String)this.storedProcedureRefs.get(index);
        }

        public void addStoredProcedureRef(String storedProcedureRef) {
            this.storedProcedureRefs.add(storedProcedureRef);
        }

        public void initFunctionRefs() {
            this.functionRefs = new ArrayList();
        }

        public List getFunctionRefs() {
            return this.functionRefs;
        }

        public String getFunctionRef(int index) {
            return (String)this.functionRefs.get(index);
        }

        public void addFunctionRef(String functionRef) {
            this.functionRefs.add(functionRef);
        }

        public void initPartitions() {
            this.partitions = new ArrayList();
        }

        public List getPartitions() {
            return this.partitions;
        }

        public TempPartition getPartition(int index) {
            return (TempPartition)this.partitions.get(index);
        }

        public void addPartition(TempPartition tempPartition) {
            this.partitions.add(tempPartition);
        }

        public List<String> getColumnsOrder() {
            return this.columnsOrder;
        }

        public List<String> getAttributesOrder() {
            return this.attributesOrder;
        }

        public List<TempUDPInstance> getUDPInstances() {
            return this.udpInstances;
        }
    }

    private class FKElement {
        private String id;
        private String parentAttributeID;
        private String parentRelationshipID;
        private String logicalRef;
        private String physicalRef;

        public FKElement(String id, String parentAttributeID, String parentRelationshipID) {
            this.id = id;
            this.parentAttributeID = parentAttributeID;
            this.parentRelationshipID = parentRelationshipID;
        }

        public String getID() {
            return this.id;
        }

        public String getParentAttributeID() {
            return this.parentAttributeID;
        }

        public String getParentRelationshipID() {
            return this.parentRelationshipID;
        }

        public String getLogicalRef() {
            return this.logicalRef;
        }

        public void setLogicalRef(String logicalRef) {
            this.logicalRef = logicalRef;
        }

        public String getPhysicalRef() {
            return this.physicalRef;
        }

        public void setPhysicalRef(String physicalRef) {
            this.physicalRef = physicalRef;
        }
    }

    private class TempUDPInstance {
        private String id;
        private String name;
        private String value;

        public TempUDPInstance(String udpID, String udpName) {
            this.id = udpID;
            this.name = udpName;
            this.value = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String udpValue) {
            UserDefinedProperty udpObj = (UserDefinedProperty)ERSAXParserv7x.this.UDPMap.get(this.getID());
            if (udpObj != null) {
                if (udpObj.getType().equals(UserDefinedProperty.NUMBER)) {
                    try {
                        if (!"".equals(udpValue)) {
                            Double v = Double.valueOf(udpValue);
                            this.value = udpValue;
                        }
                    }
                    catch (NumberFormatException v) {}
                } else if (udpObj.getType().equals(UserDefinedProperty.DATE)) {
                    try {
                        Integer v = Integer.valueOf(udpValue);
                        if (v > 0) {
                            Calendar cal = Calendar.getInstance();
                            cal.set(1900, 0, 1);
                            cal.add(5, v - 1);
                            Date dat = cal.getTime();
                            SimpleDateFormat dateFormat = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get("dateonlyformat"));
                            this.value = dateFormat.format(dat);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    this.value = udpValue;
                }
            } else {
                this.value = udpValue;
            }
        }

        public String getValue() {
            return this.value;
        }

        public boolean validForClass(Class udpClass) {
            if (ERSAXParserv7x.this.UDPMap.containsKey(this.getID())) {
                UserDefinedProperty udpObject = (UserDefinedProperty)ERSAXParserv7x.this.UDPMap.get(this.getID());
                LinkedHashMap<Class, Boolean> udpObjectMap = udpObject.getObjectsVisibilityMap();
                return udpObjectMap.containsKey(udpClass);
            }
            return false;
        }
    }

    private class TempUDP {
        private String id;
        private String name;
        private String definition;
        private String dataType;
        private String defaultValue;
        private String valuesList;
        private boolean isLogical;
        private boolean isPhysical;
        private String defGroup;

        public TempUDP(String udpID, String udpName) {
            this.id = udpID;
            this.name = udpName;
            this.definition = "";
            this.dataType = "";
            this.defaultValue = "";
            this.valuesList = "";
            this.isLogical = false;
            this.isPhysical = false;
            this.defGroup = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getUDPType() {
            String dt = this.getDataType();
            if (dt.equals("1")) {
                return UserDefinedProperty.NUMBER;
            }
            if (dt.equals("2")) {
                return UserDefinedProperty.TEXT;
            }
            if (dt.equals("3")) {
                return UserDefinedProperty.DATE;
            }
            if (dt.equals("4")) {
                return UserDefinedProperty.TEXT;
            }
            if (dt.equals("5")) {
                return UserDefinedProperty.NUMBER;
            }
            if (dt.equals("6")) {
                return UserDefinedProperty.LIST;
            }
            return UserDefinedProperty.TEXT;
        }

        public void setDefaultValue(String defaultValue) {
            if (this.getUDPType().equals(UserDefinedProperty.NUMBER)) {
                try {
                    if (!"".equals(defaultValue)) {
                        Double v = Double.valueOf(defaultValue);
                        this.defaultValue = defaultValue;
                    }
                }
                catch (NumberFormatException v) {}
            } else if (this.getUDPType().equals(UserDefinedProperty.DATE)) {
                try {
                    Integer v = Integer.valueOf(defaultValue);
                    if (v > 0) {
                        Calendar cal = Calendar.getInstance();
                        cal.set(1900, 0, 1);
                        cal.add(5, v - 1);
                        String yyyy = String.valueOf(cal.get(1));
                        Object mm = String.valueOf(cal.get(2) + 1);
                        Object dd = String.valueOf(cal.get(5));
                        if (((String)mm).length() < 2) {
                            mm = "0" + (String)mm;
                        }
                        if (((String)dd).length() < 2) {
                            dd = "0" + (String)dd;
                        }
                        this.defaultValue = yyyy + "-" + (String)mm + "-" + (String)dd;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.defaultValue = defaultValue;
            }
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setValuesList(String valuesList) {
            this.valuesList = valuesList;
        }

        public String getValuesList() {
            return this.valuesList;
        }

        public LinkedHashMap<String, Boolean> getLOVMap() {
            LinkedHashMap<String, Boolean> lovMap = new LinkedHashMap<String, Boolean>();
            String defVal = this.getDefaultValue();
            String valList = this.getValuesList();
            if (!"".equals(valList)) {
                StringTokenizer st = new StringTokenizer(valList, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    lovMap.put(token, token.equals(defVal));
                }
            } else if (!"".equals(defVal)) {
                lovMap.put(defVal, true);
            }
            return lovMap;
        }

        public void setIsLogical(String logical) {
            this.isLogical = logical.equalsIgnoreCase("true");
        }

        public boolean hasIsLogical() {
            return this.isLogical;
        }

        public void setIsPhysical(String physical) {
            this.isPhysical = physical.equalsIgnoreCase("true");
        }

        public boolean hasIsPhysical() {
            return this.isPhysical;
        }

        public void setDefGroup(String defGroup) {
            this.defGroup = defGroup;
        }

        public String getDefGroup() {
            return this.defGroup;
        }

        public Class getUDPLogicalClass() {
            if (this.hasIsLogical()) {
                String group = this.getDefGroup();
                if (group.equalsIgnoreCase("Attribute_Groups")) {
                    return Attribute.class;
                }
                if (group.equalsIgnoreCase("Entity_Groups")) {
                    return Entity.class;
                }
                if (group.equalsIgnoreCase("View_Groups")) {
                    return EntityView.class;
                }
            }
            return null;
        }

        public Class getUDPPhysicalClass() {
            if (this.hasIsPhysical()) {
                String group = this.getDefGroup();
                if (group.equalsIgnoreCase("Attribute_Groups")) {
                    return Column.class;
                }
                if (group.equalsIgnoreCase("Entity_Groups")) {
                    return Table.class;
                }
                if (group.equalsIgnoreCase("View_Groups")) {
                    return TableView.class;
                }
            }
            return null;
        }
    }
}

