/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ImportTypeSelector
extends CustomDialog
implements ActionListener {
    public static final String SINGLE_LABEL = Messages.getString("ImportTypeSelector.ImportSingleModel");
    public static final String DOUBLE_LABEL = Messages.getString("ImportTypeSelector.ImportMappedModels");
    public static final int SINGLE_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    private int dbType = 1;
    private JComboBox jcomboBox;
    private JDialog dialog;
    private int result = 2;
    private JButton bnOK;
    private JCheckBox chbImportProcess;

    public ImportTypeSelector(ApplicationView appView) {
        super(appView);
        String[] items;
        this.setLayout(new BorderLayout());
        JPanel pnCenter = new JPanel(new BorderLayout());
        pnCenter.setBorder(BorderFactory.createEtchedBorder());
        JRadioButton singleButton = new JRadioButton(SINGLE_LABEL);
        singleButton.setMnemonic(83);
        singleButton.setActionCommand(SINGLE_LABEL);
        singleButton.setSelected(true);
        JRadioButton doubleButton = new JRadioButton(DOUBLE_LABEL);
        doubleButton.setMnemonic(84);
        doubleButton.setActionCommand(DOUBLE_LABEL);
        ButtonGroup group = new ButtonGroup();
        group.add(singleButton);
        group.add(doubleButton);
        singleButton.addActionListener(this);
        doubleButton.addActionListener(this);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridLayout(0, 1));
        radioPanel.add(singleButton);
        radioPanel.add(doubleButton);
        radioPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pnCenter.add((Component)radioPanel, "North");
        JPanel jpanel = new JPanel(new BorderLayout(0, 5));
        JPanel jpanel2 = new JPanel(new FlowLayout(0));
        this.chbImportProcess = new JCheckBox(Messages.getString("ImportTypeSelector.ImportProcessModel"));
        jpanel.add((Component)this.chbImportProcess, "North");
        jpanel.add((Component)new JLabel(Messages.getString("ImportTypeSelector.SelectVARType")), "Center");
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            doubleButton.setEnabled(false);
            items = new String[]{"Sterling Bsnteam V7.2", "Cayenne Bsnteam V7.2"};
        } else {
            items = new String[]{"Sterling COOL:DBA V2.1", "Sterling Bsnteam V7.2", "Cayenne Bsnteam V7.2"};
        }
        this.jcomboBox = new JComboBox<String>(items);
        this.jcomboBox.setPreferredSize(new Dimension(250, 23));
        jpanel.add((Component)this.jcomboBox, "South");
        jpanel2.add(jpanel);
        pnCenter.add((Component)jpanel2, "Center");
        this.add((Component)pnCenter, "Center");
        JPanel pnButtons = new JPanel();
        this.bnOK = new JButton(Messages.getString("ImportTypeSelector.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTypeSelector.this.result = 0;
                ImportTypeSelector.this.close();
            }
        });
        JButton bnCancel = new JButton(Messages.getString("ImportTypeSelector.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTypeSelector.this.result = 2;
                ImportTypeSelector.this.close();
            }
        });
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnOK);
        pnButtons.add(bnCancel);
        pnButtons.add(bnHelp);
        this.add((Component)pnButtons, "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        this.getDialog().show();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ImportTypeSelector.SelectTheTypeOfImport"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_VAR_FILES_DIALOG";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(SINGLE_LABEL)) {
            this.dbType = 1;
        } else if (e.getActionCommand().equalsIgnoreCase(DOUBLE_LABEL)) {
            this.dbType = 2;
        }
    }

    public int getdbType() {
        return this.dbType;
    }

    public int getComboIndex() {
        return this.jcomboBox.getSelectedIndex();
    }

    public int getResult() {
        return this.result;
    }

    public boolean importProcessModel() {
        return this.chbImportProcess.isSelected();
    }
}

