/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;

public class RHFKPoints
extends RowHandler {
    public static final String OBJECT_TYPE = "POINT";
    private Fields constants;
    List lines = new ArrayList();
    List fkList;
    List assList;

    public RHFKPoints(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
        this.constants = constants;
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.collectLines(line);
            this.removeSelectedLine(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void collectLines(VarFileLine line) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool != 1000 && !this.lines.contains(line)) {
            this.lines.add(line);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    public void processPointsForPhysical(List aFKList, List anAssList) {
        this.fkList = aFKList;
        this.assList = anAssList;
        String diagramID = this.constants.getPhysicalDesignID();
        for (VarFileLine line : this.fkList) {
            String assId;
            String fkId = this.getField(line, "general_id");
            FKIndexAssociation fk = (FKIndexAssociation)this.getAllCreatedObjects().get(fkId);
            if (fk == null || (assId = this.getAssId(fkId, diagramID)) == null) continue;
            List points = this.getAssPoints(assId);
            this.addFKPoints(fk, points, fk.getDesignPart().getMainView());
        }
    }

    public void processPointsForPhysicalSubViews(List aFKList, List anAssList, Map diagramsMap) {
        this.fkList = aFKList;
        this.assList = anAssList;
        String defPhysDigramID = this.constants.getPhysicalDesignID();
        Set diagramCol = diagramsMap.keySet();
        for (String diagramID : diagramCol) {
            DesignPartView dpv;
            if (defPhysDigramID.equalsIgnoreCase(diagramID) || (dpv = (DesignPartView)diagramsMap.get(diagramID)) == null) continue;
            dpv.setVisible(true);
            for (VarFileLine line : this.fkList) {
                String assId;
                String fkId = this.getField(line, "general_id");
                FKIndexAssociation fk = (FKIndexAssociation)this.getAllCreatedObjects().get(fkId);
                if (fk == null || (assId = this.getAssId(fkId, diagramID)) == null) continue;
                List points = this.getAssPoints(assId);
                this.addFKPoints(fk, points, dpv);
            }
        }
    }

    private void addFKPoints(FKIndexAssociation fk, List points, DesignPartView dpv) {
        if (points.size() > 1) {
            TVFKRelation tvfk;
            if (points.size() > 2) {
                TVFKRelation tvfk2 = (TVFKRelation)fk.getViewFor(dpv);
                if (tvfk2 != null) {
                    EdgeView edge = (EdgeView)tvfk2.getCellView();
                    for (int i = 1; i < points.size() - 1; ++i) {
                        Point p = (Point)points.get(i);
                        tvfk2.getEdgePoints().add(DiagramConstants.createPoint(p));
                    }
                    if (edge != null) {
                        tvfk2.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvfk2.getEdgePoints());
                        edge.update();
                    }
                }
            } else if (points.size() == 2 && (tvfk = (TVFKRelation)fk.getViewFor(dpv)) != null) {
                Point p1 = (Point)points.get(0);
                Point p2 = (Point)points.get(1);
                if (p1.x == p2.x) {
                    int y = (p1.y + p2.y) / 2;
                    tvfk.getEdgePoints().add(DiagramConstants.createPoint(new Point(p1.x, y)));
                    EdgeView edge = (EdgeView)tvfk.getCellView();
                    if (edge != null) {
                        tvfk.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvfk.getEdgePoints());
                        edge.update();
                    }
                } else if (p1.y == p2.y) {
                    int x = (p1.x + p2.x) / 2;
                    tvfk.getEdgePoints().add(DiagramConstants.createPoint(new Point(x, p1.y)));
                    EdgeView edge = (EdgeView)tvfk.getCellView();
                    if (edge != null) {
                        tvfk.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvfk.getEdgePoints());
                        edge.update();
                    }
                }
            }
        }
    }

    private String getAssId(String fkId, String dId) {
        for (VarFileLine line : this.assList) {
            if (!dId.equalsIgnoreCase(this.getField(line, "POINT_CDBA_ASS_DIAGRAMID")) || !fkId.equalsIgnoreCase(this.getField(line, "POINT_CDBA_ASS_FKID"))) continue;
            return this.getField(line, "general_id");
        }
        return null;
    }

    private List getAssPoints(String assId) {
        ArrayList<Object> pl = new ArrayList<Object>();
        for (VarFileLine line : this.lines) {
            if (!assId.equalsIgnoreCase(this.getField(line, "POINT_CDBA_ASSID"))) continue;
            int px = Integer.parseInt(this.getField(line, "POINT_CDBA_X"));
            int py = Integer.parseInt(this.getField(line, "POINT_CDBA_Y"));
            int ordnum = Integer.parseInt(this.getField(line, "POINT_CDBA_ORDNUM"));
            pl.add(new HelpPoint(px, py, ordnum));
        }
        if (pl.size() > 0) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.addAll(pl);
            pl.clear();
            block1: for (int i = 0; i < temp.size(); ++i) {
                for (int j = 0; j < temp.size(); ++j) {
                    HelpPoint p = (HelpPoint)temp.get(j);
                    if (p.ord != i) continue;
                    pl.add(new Point(p.x, p.y));
                    continue block1;
                }
            }
        }
        return pl;
    }

    class HelpPoint {
        int x;
        int y;
        int ord;

        HelpPoint() {
        }

        HelpPoint(int x, int y, int ordnum) {
            this.x = x;
            this.y = y;
            this.ord = ordnum;
        }
    }
}

