/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.util.logging.Logger;

public class RHAgent
extends RowHandler {
    public static final String OBJECT_TYPE = "EXTERNAL_AGENT";
    private static final String TYPE_SYSTEM = "1";
    private static final String TYPE_ROLE = "2";
    private static final String TYPE_ORGANIZATIONAL_UNIT = "3";
    private static final String TYPE_OTHER = "4";
    private static final Logger LOGGER = new Logger(RHAgent.class);

    public RHAgent(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createAgent(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createAgent(VarFileLine line) {
        try {
            DataFlowDesign diagram;
            String agentID = this.getField(line, "general_id");
            String agentName = this.getField(line, "EXTERNAL_AGENT_NAME");
            String diagramID = this.getField(line, "EXTERNAL_AGENT_PMID");
            DesignObject agent = null;
            if (!"".equalsIgnoreCase(diagramID) && (diagram = (DataFlowDesign)this.getAllCreatedObjects().get(diagramID)) != null) {
                agent = diagram.createExternalAgent();
                ((DPVProcess)diagram.getMainView()).createViewSynonim(agent);
            }
            if (agent != null) {
                agent.setName(agentName);
                String comment = this.getComment(line);
                agent.setComment(comment);
                ((AbstractProcessObject)agent).setSynonym(this.getSynonym(line));
                agent.setNotes(this.getNotes(line, "NOTE_AGENT_ID"));
                String type = this.getField(line, "EXTERNAL_AGENT_TYPE");
                if (TYPE_ORGANIZATIONAL_UNIT.equalsIgnoreCase(type)) {
                    ((ExternalAgent)agent).setType(0);
                } else if (TYPE_SYSTEM.equalsIgnoreCase(type)) {
                    ((ExternalAgent)agent).setType(1);
                } else if (TYPE_ROLE.equalsIgnoreCase(type)) {
                    ((ExternalAgent)agent).setType(2);
                } else if (TYPE_OTHER.equalsIgnoreCase(type)) {
                    ((ExternalAgent)agent).setType(3);
                }
                this.addCreatedObject(agentID, agent);
                this.removeSelectedLine(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in RHAgent.createAgent()", e);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "EXTERNAL_AGENT_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("EXTERNAL_AGENTSYNO") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }
}

