/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.DataTypeListener;

public abstract class MDExplicitSized
extends AbstractDataType {
    protected String size;
    private Set listeners;

    @Override
    public void setSize(String size) {
        this.size = "".equals(size) ? "" : (!"".equals(size) && !size.substring(0, 1).equals("-") ? size.trim() : this.getMaxSize());
    }

    @Override
    public String getSize() {
        if (this.size == null) {
            return this.getMaxSize();
        }
        String numeric = this.size;
        if (numeric != null && numeric.indexOf(32) > 0) {
            String[] parts_n = numeric.split(" ");
            numeric = parts_n[0];
            return numeric;
        }
        return this.size;
    }

    public abstract String getMaxSize();

    @Override
    public String getSQL() {
        StringBuffer b = new StringBuffer();
        this.appendTo(b);
        return b.toString();
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        String numeric = this.getSize();
        if (numeric != null && numeric.indexOf(32) > 0) {
            String[] parts_n = numeric.split(" ");
            numeric = parts_n[0];
        }
        if (numeric == null || "".equalsIgnoreCase(numeric) || "0".equalsIgnoreCase(numeric)) {
            buffer.append(this.getName());
        } else {
            buffer.append(this.getName());
            buffer.append(" (");
            buffer.append(numeric);
            buffer.append(')');
        }
    }

    @Override
    public void addDataTypeListener(DataTypeListener listener) {
        this.getListeners().add(listener);
    }

    @Override
    public void removeDataTypeListener(DataTypeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireSizeChange() {
        if (this.listeners != null) {
            Iterator it = this.getListeners().iterator();
            while (it.hasNext()) {
                ((DataTypeListener)it.next()).changed(this);
            }
        }
    }

    protected Set getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        return this.listeners;
    }
}

