/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle.v9i;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDDayToSecondOraclev9i
extends MDPackedSized {
    private String name = "INTERVAL DAY TO SECOND";

    public MDDayToSecondOraclev9i() {
        this.precision = 2;
        this.scale = 6;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    @Override
    public MDDataType deepCopy() {
        MDDayToSecondOraclev9i copy = new MDDayToSecondOraclev9i();
        copy.setPrecision(this.getPrecision());
        return copy;
    }

    @Override
    public void setPrecision(int precision) {
        if (precision >= 0 && precision <= 9) {
            this.precision = precision;
            this.precisionStr = String.valueOf(precision);
            this.fireSizeChange();
        }
    }

    public void setPrecision(String precision) {
        try {
            int pr = Integer.parseInt(precision);
            if (pr >= 0 && pr <= 9) {
                this.precision = pr;
            }
        }
        catch (NumberFormatException e) {
            this.precision = 2;
        }
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        buffer.append("INTERVAL DAY");
        if (this.precision != 2) {
            buffer.append(" (");
            buffer.append(this.precision);
            buffer.append(')');
        }
        buffer.append(" TO SECOND");
        if (this.scale != 6) {
            buffer.append(" (");
            buffer.append(this.scale);
            buffer.append(')');
        }
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDDayToSecondOracle.FractionalSecondsPrecision");
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDDayToSecondOracle.DayPrecision");
    }

    @Override
    public boolean hasScale() {
        return true;
    }
}

