/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDataTypeStrings;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.util.string.StringUtilities;

public class DomainFactory
implements SectionConstants,
LogicalDataTypeStrings {
    private Map domainMap = new HashMap();
    public static String DOOMAIN_FILE_SUFIX = "_Domains";

    public Domain getInstance(Design design, LogicalDatatype logDatatype, MDDataType dataType, int section, String[] parameters, String domainName) {
        String nameDomain = domainName != null ? domainName : DomainFactory.createDomainName(logDatatype, parameters);
        Domain domain = (Domain)this.domainMap.get(nameDomain);
        if (domain == null) {
            DomainSet domSet = design.getDomainSet();
            Domain newDomain = domSet.createDomain();
            newDomain.setName(nameDomain);
            if (logDatatype != null) {
                newDomain.setLogicalDatatype(logDatatype);
            } else {
                LogicalDatatype newLogicDT = design.getLogicalDatatypeSet().createLogicalDatatype(null);
                newDomain.setLogicalDatatype(newLogicDT);
            }
            if (dataType != null) {
                newDomain.setDataType(dataType);
            }
            switch (section) {
                case 0: {
                    newDomain.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                case 1: {
                    newDomain.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                case 2: {
                    newDomain.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                case 3: {
                    newDomain.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                default: {
                    newDomain.setFileName("wrongFileName");
                }
            }
            newDomain.setOwnerDesignName(design.getFileName());
            this.setParameters(newDomain, parameters);
            this.domainMap.put(nameDomain, newDomain);
            return newDomain;
        }
        return domain;
    }

    public static String createDomainName(LogicalDatatype logDatatype, String[] parameters) {
        StringBuffer result = new StringBuffer();
        if (logDatatype != null) {
            result.append(logDatatype.getName());
        } else {
            result.append("UNKNOWN");
        }
        if (parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (StringUtilities.isNotEmpty(parameters[i])) {
                    result.append("_" + parameters[i]);
                    continue;
                }
                result.append("_0");
            }
        }
        return result.toString();
    }

    private void setParameters(Domain domain, String[] parameters) {
        LogicalDatatype logDT = domain.getLogicalDatatype();
        if (logDT != null) {
            domain.setDataTypeParameter("size", parameters[2]);
            domain.setDataTypeParameter("scale", parameters[1]);
            domain.setDataTypeParameter("precision", parameters[0]);
        }
    }
}

