/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.options.Settings;

public abstract class PropertiesComparator
extends PropertyNames {
    private ModelIDObject left_do;
    private ModelIDObject right_do;
    protected List propertiesList = new ArrayList();
    protected List dynamicPropertiesList = new ArrayList();
    protected StorageTemplateComparator templateComparator = null;
    private StoragePropertiesComparator physicalPropertiesComparator = null;
    protected boolean isDroped = false;
    private Design design;
    protected Settings settings = null;
    protected boolean caseSensitive = false;
    protected boolean useSchema = true;
    protected boolean useColumnsOrder = true;
    protected boolean useDataTypeKind = false;
    protected boolean includeSystemNames = true;
    protected boolean useGenInDDL = true;
    private CompareObjectSelection selectionObject;
    public static boolean DDL_ONLY = false;
    public static boolean REDSHIFT = false;
    public static boolean HIVE_DATA_TYPES = false;
    protected static String SYSTEM_NAME_PREFIX = "SYS_";
    private static final String TOKEN_SEPARATORS = " ()";

    public PropertiesComparator(ModelIDObject left_do, ModelIDObject right_do) {
        Design oldDesign;
        this.left_do = left_do;
        this.right_do = right_do;
        this.settings = ApplicationView.getInstance().getSettings();
        this.design = null;
        if (left_do != null) {
            this.design = left_do.getDesign();
        } else if (right_do != null) {
            this.design = right_do.getDesign();
        }
        if (this.design != null && (oldDesign = this.design.getOldDesign()) != null) {
            this.design = oldDesign;
        }
        if (this.settings != null) {
            this.caseSensitive = this.settings.isCaseSensitiveNamesInCompare();
            if (left_do != null) {
                boolean bl = this.caseSensitive = this.caseSensitive || left_do.getNameHasQuotes();
            }
            if (right_do != null) {
                this.caseSensitive = this.caseSensitive || right_do.getNameHasQuotes();
            }
            this.useSchema = this.settings.isUseSchemaPropertyInCompare();
            this.useColumnsOrder = this.settings.isUseColumnsOrderPropertyInCompare();
            this.useDataTypeKind = this.settings.isUseDataTypeKindInCompare();
            this.includeSystemNames = this.settings.isIncludeSystemNamesInCompare();
            if (DDL_ONLY) {
                this.useGenInDDL = this.settings.isUseGenInDDLInCompare();
            }
        }
    }

    public Design getDesign() {
        if (this.design == null) {
            if (this.left_do != null) {
                this.design = this.left_do.getDesign();
            }
            if (this.right_do != null) {
                this.design = this.right_do.getDesign();
            }
        }
        return this.design;
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public boolean isEqualClearLine(String line1, String line2) {
        if ((line1 = line1.trim()).equals(line2 = line2.trim())) {
            return true;
        }
        return this.reformat(line1).equals(this.reformat(line2));
    }

    private String reformat(String inputString) {
        String clearLine = inputString.replaceAll("[ \t\n\f\r\u000b]+", " ");
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(clearLine, TOKEN_SEPARATORS, true);
        while (tokens.hasMoreTokens()) {
            String tokenOrSep = tokens.nextToken();
            if (tokenOrSep.equals(" ")) continue;
            buffer.append(tokenOrSep).append(' ');
        }
        return buffer.toString();
    }

    public List getPropertiesList() {
        return this.propertiesList;
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
    }

    protected void setPhysicalPropertiesComparator(StoragePropertiesComparator physicalPropertiesComparator) {
        this.physicalPropertiesComparator = physicalPropertiesComparator;
    }

    public StoragePropertiesComparator getPhysicalPropertiesComparator() {
        return this.physicalPropertiesComparator;
    }

    public List getPhysicalPropertiesList() {
        if (this.physicalPropertiesComparator != null) {
            return this.physicalPropertiesComparator.getPropertiesList();
        }
        return Collections.EMPTY_LIST;
    }

    public List getStoragePropertiesList() {
        if (this.templateComparator != null) {
            return this.templateComparator.getPropertiesList();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isStoragePropertiesListActive() {
        return this.templateComparator != null;
    }

    protected StorageTemplateComparator getTemplateComparator() {
        return this.templateComparator;
    }

    public List getPropertiesFilterList() {
        if (this.design != null) {
            return this.design.getPropertiesFilterList(this.getClass(), true);
        }
        return new ArrayList();
    }

    public List getDynamicPropertiesFilterList() {
        if (this.design != null) {
            return this.design.getDynamicPropertiesFilterList(this.getClass().getName(), true);
        }
        return new ArrayList();
    }

    public void resetDynamicPropertiesFilterList() {
        this.initDynamicPropertiesFilterList();
    }

    public List getStoragePropertiesFilterList() {
        if (this.design != null) {
            return this.design.getStoragePropertiesFilterList(this.getClass(), true);
        }
        return new ArrayList();
    }

    protected void initPropertiesFilterList() {
        EngPropertyHolder ph;
        int j;
        TreeMap<String, Boolean> fm = new TreeMap<String, Boolean>();
        List propertiesFilterList = this.getPropertiesFilterList();
        for (int i = 0; i < propertiesFilterList.size(); ++i) {
            PropertyFilter fe = (PropertyFilter)propertiesFilterList.get(i);
            fm.put(fe.getName(), fe.isSelected());
        }
        if (propertiesFilterList.size() != this.propertiesList.size()) {
            propertiesFilterList.clear();
            for (j = 0; j < this.propertiesList.size(); ++j) {
                ph = (EngPropertyHolder)this.propertiesList.get(j);
                PropertyFilter pf = new PropertyFilter(ph.getName());
                if (fm.containsKey(pf.getName())) {
                    pf.setSelected((Boolean)fm.get(pf.getName()));
                    if (!pf.isSelected()) {
                        ph.setFiltered(true);
                        ph.setEditable(false);
                        ph.setExcluded(true);
                        ph.setModified(false);
                        ph.setSelected(false);
                    }
                }
                propertiesFilterList.add(pf);
            }
        } else {
            for (j = 0; j < this.propertiesList.size(); ++j) {
                ph = (EngPropertyHolder)this.propertiesList.get(j);
                Boolean sel = (Boolean)fm.get(ph.getName());
                if (sel == null || sel.booleanValue()) continue;
                ph.setFiltered(true);
                ph.setEditable(false);
                ph.setExcluded(true);
                ph.setModified(false);
                ph.setSelected(false);
            }
        }
        this.initDynamicPropertiesFilterList();
    }

    protected void initStoragePropertiesFilterList() {
        List storagePropertiesList = this.getStoragePropertiesList();
        if (this.getStoragePropertiesFilterList().size() != storagePropertiesList.size()) {
            TreeMap<String, Boolean> fm = new TreeMap<String, Boolean>();
            for (int i = 0; i < this.getStoragePropertiesFilterList().size(); ++i) {
                PropertyFilter fe = (PropertyFilter)this.getStoragePropertiesFilterList().get(i);
                fm.put(fe.getName(), fe.isSelected());
            }
            this.getStoragePropertiesFilterList().clear();
            for (int j = 0; j < storagePropertiesList.size(); ++j) {
                EngPropertyHolder ph = (EngPropertyHolder)storagePropertiesList.get(j);
                PropertyFilter pf = new PropertyFilter(ph.getName());
                if (fm.containsKey(pf.getName())) {
                    pf.setSelected((Boolean)fm.get(pf.getName()));
                }
                this.getStoragePropertiesFilterList().add(pf);
            }
        }
    }

    protected void initDynamicPropertiesFilterList() {
        EngPropertyHolder ph;
        int j;
        TreeMap<String, Boolean> fm = new TreeMap<String, Boolean>();
        List propertiesFilterList = this.getDynamicPropertiesFilterList();
        for (int i = 0; i < propertiesFilterList.size(); ++i) {
            PropertyFilter fe = (PropertyFilter)propertiesFilterList.get(i);
            fm.put(fe.getName(), fe.isSelected());
        }
        if (propertiesFilterList.size() != this.dynamicPropertiesList.size()) {
            for (j = 0; j < this.dynamicPropertiesList.size(); ++j) {
                ph = (EngPropertyHolder)this.dynamicPropertiesList.get(j);
                PropertyFilter pf = new PropertyFilter(ph.getName());
                if (fm.containsKey(pf.getName())) {
                    pf.setSelected((Boolean)fm.get(pf.getName()));
                    if (pf.isSelected()) continue;
                    ph.setFiltered(true);
                    ph.setEditable(false);
                    ph.setExcluded(true);
                    ph.setModified(false);
                    ph.setSelected(false);
                    continue;
                }
                propertiesFilterList.add(pf);
            }
        } else {
            for (j = 0; j < this.dynamicPropertiesList.size(); ++j) {
                ph = (EngPropertyHolder)this.dynamicPropertiesList.get(j);
                Boolean sel = (Boolean)fm.get(ph.getName());
                if (sel == null || sel.booleanValue()) continue;
                ph.setFiltered(true);
                ph.setEditable(false);
                ph.setExcluded(true);
                ph.setModified(false);
                ph.setSelected(false);
            }
        }
    }

    public List getOrderedPropertiesList() {
        return this.getOrderedPropertiesList(this.propertiesList);
    }

    public List getOrderedPropertiesList(List propertiesList) {
        EngPropertyHolder ph;
        int j;
        ArrayList<EngPropertyHolder> result = propertiesList;
        ArrayList<EngPropertyHolder> orderedPropertiesList = null;
        ArrayList<EngPropertyHolder> excludedPropertiesList = null;
        for (j = 0; j < propertiesList.size(); ++j) {
            ph = (EngPropertyHolder)propertiesList.get(j);
            if (ph.isModified()) {
                if (orderedPropertiesList == null) {
                    orderedPropertiesList = new ArrayList(propertiesList.size());
                }
                orderedPropertiesList.add(ph);
                continue;
            }
            if (!ph.isExcluded()) continue;
            if (excludedPropertiesList == null) {
                excludedPropertiesList = new ArrayList<EngPropertyHolder>();
            }
            excludedPropertiesList.add(ph);
        }
        if (excludedPropertiesList != null) {
            if (orderedPropertiesList == null) {
                orderedPropertiesList = new ArrayList<EngPropertyHolder>(propertiesList.size());
            }
            orderedPropertiesList.addAll(excludedPropertiesList);
        }
        if (orderedPropertiesList != null) {
            for (j = 0; j < propertiesList.size(); ++j) {
                ph = (EngPropertyHolder)propertiesList.get(j);
                if (ph.isModified() || ph.isExcluded()) continue;
                orderedPropertiesList.add(ph);
            }
            result = orderedPropertiesList;
        }
        return result;
    }

    protected boolean isExcludedFromComparison(String propertyName) {
        if (this instanceof StoragePropertiesComparator) {
            boolean includeInCompare;
            boolean bl = includeInCompare = this instanceof StorageTemplateComparator ? this.settings.isIncludeStoragePropertiesInCompare() : this.settings.isIncludePhysicalPropertiesInCompare();
            if (!includeInCompare) {
                return true;
            }
        }
        List propertiesFilterList = this.getPropertiesFilterList();
        for (int i = 0; i < propertiesFilterList.size(); ++i) {
            PropertyFilter pf = (PropertyFilter)propertiesFilterList.get(i);
            if (!propertyName.equalsIgnoreCase(pf.getName())) continue;
            return !pf.isSelected();
        }
        return false;
    }

    public abstract void copySelectedProperties();

    public ModelIDObject getLeftObject() {
        return this.left_do;
    }

    public ModelIDObject getRightObject() {
        return this.right_do;
    }

    public String getLeftName() {
        if (this.left_do != null) {
            return this.left_do.getName();
        }
        return "";
    }

    public String getRightName() {
        if (this.right_do != null) {
            return this.right_do.getName();
        }
        return "";
    }

    protected void initNameProperty() {
        PropertyHolder ph = new PropertyHolder(NAME);
        ph.setLeftValue(this.left_do != null ? this.left_do.getName() : "");
        ph.setRightValue(this.right_do != null ? this.right_do.getName() : "");
        if (this.isExcludedFromComparison(NAME) || this.isExcludeNamesFromComparison(ph)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected boolean isExcludeNamesFromComparison(EngPropertyHolder ph) {
        return (ph.getLeftValue().toUpperCase().startsWith(SYSTEM_NAME_PREFIX) || ph.getRightValue().toUpperCase().startsWith(SYSTEM_NAME_PREFIX)) && !this.includeSystemNames;
    }

    protected void initCommentsAndNotes() {
        this.initCommentsAndNotes(true);
    }

    protected void initCommentsAndNotes(boolean initRDBMS) {
        PropertyHolder ph;
        if (!DDL_ONLY) {
            ph = new PropertyHolder(COMMENT);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_do != null ? this.left_do.getComment() : "");
            ph.setRightValue(this.right_do != null ? this.right_do.getComment() : "");
            if (this.isExcludedFromComparison(COMMENT)) {
                ph.setExcluded(true);
            } else if (this.left_do != null && this.right_do != null && !this.isEqualClearLine(this.left_do.getComment(), this.right_do.getComment())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (initRDBMS) {
            ph = new PropertyHolder(COMMENT_IN_RDBMS);
            ph.setDDLHolder(true);
            ph.setLeftValue(this.left_do != null ? this.left_do.getCommentInRDBMS() : "");
            ph.setRightValue(this.right_do != null ? this.right_do.getCommentInRDBMS() : "");
            if (this.isExcludedFromComparison(COMMENT_IN_RDBMS)) {
                ph.setExcluded(true);
            } else if (this.left_do != null && this.right_do != null && !this.isEqualClearLine(this.left_do.getCommentInRDBMS(), this.right_do.getCommentInRDBMS())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (!DDL_ONLY) {
            ph = new PropertyHolder(NOTES);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_do != null ? this.left_do.getNotes() : "");
            ph.setRightValue(this.right_do != null ? this.right_do.getNotes() : "");
            if (this.isExcludedFromComparison(NOTES)) {
                ph.setExcluded(true);
            } else if (this.left_do != null && this.right_do != null && !this.isEqualClearLine(this.left_do.getNotes(), this.right_do.getNotes())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    protected void copyPropertiesFromLeftToRight() {
        if (this.left_do != null && this.right_do != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    this.right_do.setName(this.left_do.getName());
                    this.right_do.setNameHasQuotes(this.left_do.getNameHasQuotes());
                    continue;
                }
                if (ph.getName().equals(COMMENT)) {
                    this.right_do.setComment(this.left_do.getComment());
                    continue;
                }
                if (ph.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_do.setCommentInRDBMS(this.left_do.getCommentInRDBMS());
                    continue;
                }
                if (ph.getName().equals(NOTES)) {
                    this.right_do.setNotes(this.left_do.getNotes());
                    continue;
                }
                if (!ph.getName().equals(INDEX_FUNCTION_EXPRESSION)) continue;
                ((Index)this.right_do).setIndexExpression(((Index)this.left_do).getIndexExpression());
            }
            this.copySelectedDynamicProperties();
            if (this.isDirty()) {
                this.right_do.setDirty(true);
            }
        }
    }

    public void copySelectedDynamicProperties() {
        for (EngPropertyHolder ph : this.dynamicPropertiesList) {
            if (!ph.isSelected()) continue;
            String propName = ph.getName();
            String value = ph.getLeftValue();
            if (value == null) {
                value = "";
            }
            if (value == null) continue;
            this.right_do.setProperty(propName, value);
        }
    }

    public boolean isModified() {
        if (this.left_do != null && this.right_do == null) {
            return true;
        }
        return this.isMainDetailsModified() || this.isPhysicalDetailsModified() || this.isStorageDetailsModified() || this.isDynamicPropertiesModified();
    }

    public boolean isMainDetailsModified() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isModified() || ph.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicPropertiesModified() {
        for (EngPropertyHolder ph : this.getDynamicPropertiesList()) {
            if (!ph.isModified() || ph.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public boolean isPhysicalDetailsModified() {
        StoragePropertiesComparator storagePropertiesComparator = this.getPhysicalPropertiesComparator();
        if (storagePropertiesComparator != null) {
            return storagePropertiesComparator.isMainDetailsModified();
        }
        return false;
    }

    public boolean isStorageDetailsModified() {
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.isModified() || st_ph.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public String getID() {
        if (this.left_do != null && this.right_do != null) {
            return this.left_do.getObjectID() + this.right_do.getObjectID();
        }
        if (this.left_do != null) {
            return this.left_do.getObjectID();
        }
        if (this.right_do != null) {
            return this.right_do.getObjectID();
        }
        return "null";
    }

    protected boolean hasToBeRename() {
        return false;
    }

    protected boolean hasToBeRenameOnly() {
        return false;
    }

    protected boolean hasToBeDrop() {
        return false;
    }

    protected boolean isDirty() {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.isModified() || !ph.isSelected()) continue;
            return true;
        }
        for (EngPropertyHolder st_ph : this.dynamicPropertiesList) {
            if (!st_ph.isModified() || !st_ph.isSelected()) continue;
            return true;
        }
        return false;
    }

    public CompareObjectSelection getLeftSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareObjectSelection selectionObject) {
        this.selectionObject = selectionObject;
    }

    public String getChoosedPropertyValue(String propertyName) {
        return this.getChoosedPropertyValue(propertyName, true);
    }

    public boolean isTargetSelected(String propertyName) {
        return this.isTargetSelected(propertyName, true);
    }

    public boolean isTargetSelected(String propertyName, boolean leftSelected) {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.getName().equals(propertyName)) continue;
            if (!leftSelected) {
                return true;
            }
            if (this.left_do == null) {
                return true;
            }
            if (this.right_do == null) {
                return false;
            }
            return !ph.isSelected();
        }
        for (EngPropertyHolder ph_ph : this.getPhysicalPropertiesList()) {
            if (!ph_ph.getName().equals(propertyName)) continue;
            if (!leftSelected) {
                return true;
            }
            if (this.left_do == null) {
                return true;
            }
            if (this.right_do == null) {
                return false;
            }
            return !ph_ph.isSelected();
        }
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.getName().equals(propertyName)) continue;
            if (!leftSelected) {
                return true;
            }
            if (this.left_do == null) {
                return true;
            }
            if (this.right_do == null) {
                return false;
            }
            return !st_ph.isSelected();
        }
        return true;
    }

    public String getChoosedPropertyValue(String propertyName, boolean selected) {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.getName().equals(propertyName)) continue;
            if (!selected) {
                return ph.getRightValue();
            }
            if (this.left_do == null) {
                return ph.getRightValue();
            }
            if (this.right_do == null) {
                return ph.getLeftValue();
            }
            if (ph.isSelected()) {
                return ph.getLeftValue();
            }
            return ph.getRightValue();
        }
        for (EngPropertyHolder ph_ph : this.getPhysicalPropertiesList()) {
            if (!ph_ph.getName().equals(propertyName)) continue;
            if (!selected) {
                return ph_ph.getRightValue();
            }
            if (this.left_do == null) {
                return ph_ph.getRightValue();
            }
            if (this.right_do == null) {
                return ph_ph.getLeftValue();
            }
            if (ph_ph.isSelected()) {
                return ph_ph.getLeftValue();
            }
            return ph_ph.getRightValue();
        }
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.getName().equals(propertyName)) continue;
            if (!selected) {
                return st_ph.getRightValue();
            }
            if (this.left_do == null) {
                return st_ph.getRightValue();
            }
            if (this.right_do == null) {
                return st_ph.getLeftValue();
            }
            if (st_ph.isSelected()) {
                return st_ph.getLeftValue();
            }
            return st_ph.getRightValue();
        }
        return "";
    }

    public EngPropertyHolder getPropertyHolderByName(String name) {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.getName().equals(name)) continue;
            return ph;
        }
        for (EngPropertyHolder ph_ph : this.getPhysicalPropertiesList()) {
            if (!ph_ph.getName().equals(name)) continue;
            return ph_ph;
        }
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.getName().equals(name)) continue;
            return st_ph;
        }
        return null;
    }

    public boolean isDDLModified() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isSelected() || !ph.isDDLHolder() || ph.isFiltered()) continue;
            return true;
        }
        for (EngPropertyHolder ph_ph : this.getPhysicalPropertiesList()) {
            if (!ph_ph.isSelected() || !ph_ph.isDDLHolder() || ph_ph.isFiltered()) continue;
            return true;
        }
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.isSelected() || !st_ph.isDDLHolder() || st_ph.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public List getAllSelectedPH() {
        ArrayList<PropertyHolder> list = new ArrayList<PropertyHolder>();
        for (PropertyHolder ph : this.propertiesList) {
            if (!ph.isSelected()) continue;
            list.add(ph);
        }
        for (PropertyHolder ph_ph : this.getPhysicalPropertiesList()) {
            if (!ph_ph.isSelected()) continue;
            list.add(ph_ph);
        }
        for (PropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.isSelected()) continue;
            list.add(st_ph);
        }
        return list;
    }

    protected void initDynamicProperties() {
        if (!DDL_ONLY || HIVE_DATA_TYPES || REDSHIFT) {
            PropertyHolder ph;
            String rvalue;
            String name;
            Iterator it;
            HashMap<String, String> leftMap = new HashMap<String, String>();
            if (this.left_do != null) {
                it = this.left_do.getPropertyNames();
                while (it.hasNext()) {
                    name = (String)it.next();
                    String value = this.left_do.getProperty(name);
                    if (value == null) {
                        value = "";
                    }
                    leftMap.put(name, value);
                    rvalue = null;
                    if (this.right_do != null) {
                        rvalue = this.right_do.getProperty(name);
                    }
                    if (rvalue == null) {
                        rvalue = "";
                    }
                    ph = new PropertyHolder(name);
                    ph.setLeftValue(value);
                    ph.setRightValue(rvalue);
                    if (!value.equals(rvalue)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    }
                    this.dynamicPropertiesList.add(ph);
                }
            }
            if (this.right_do != null) {
                it = this.right_do.getPropertyNames();
                while (it.hasNext()) {
                    name = (String)it.next();
                    String val = (String)leftMap.get(name);
                    if (val != null) continue;
                    rvalue = this.right_do.getProperty(name);
                    if (rvalue == null) {
                        rvalue = "";
                    }
                    String value = null;
                    if (this.left_do != null) {
                        value = this.left_do.getProperty(name);
                    }
                    if (value == null) {
                        value = "";
                    }
                    ph = new PropertyHolder(name);
                    ph.setLeftValue(value);
                    ph.setRightValue(rvalue);
                    if (!value.equals(rvalue)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    }
                    this.dynamicPropertiesList.add(ph);
                }
            }
        }
    }

    public List getDynamicPropskeys(ModelIDObject obj) {
        ArrayList<String> list = new ArrayList<String>();
        if (obj != null) {
            Iterator it = obj.getPropertyNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                list.add(key);
            }
        }
        return list;
    }

    public String getDynamicPropertiesAsString(ModelIDObject obj) {
        Object res = "";
        if (obj != null) {
            Iterator it = obj.getPropertyNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = obj.getProperty(key);
                if (value == null) continue;
                if ("".equals(res)) {
                    res = key + "/" + value;
                    continue;
                }
                res = (String)res + "\n" + key + "/" + value;
            }
        }
        return res;
    }

    protected boolean hasCreateProperties() {
        for (EngPropertyHolder ph : this.getStoragePropertiesList()) {
            if (ph.isSelected() && this.settings == null) continue;
        }
        return false;
    }

    protected static String removeColon(String messageText) {
        if (messageText.endsWith(":")) {
            messageText = messageText.substring(0, messageText.length() - 1);
        }
        return messageText;
    }

    public List getDynamicPropertiesList() {
        return this.dynamicPropertiesList;
    }

    public void updateStoragePropertiesExcludeFlag() {
        ModelIDObject obj;
        boolean exclude = false;
        ModelIDObject modelIDObject = obj = this.left_do != null ? this.left_do : this.right_do;
        if (obj != null) {
            if (obj instanceof DesignObject) {
                DesignObject dobj = (DesignObject)obj;
                if (dobj.isCopyForIncrementalDDL()) {
                    exclude = true;
                }
                if (dobj instanceof ContainedObject) {
                    if (((ContainedObject)dobj).getContainer().isCopyForIncrementalDDL()) {
                        exclude = true;
                    }
                } else if (dobj instanceof KeyObject && ((KeyObject)dobj).getContainerObject().isCopyForIncrementalDDL()) {
                    exclude = true;
                }
            } else if (obj instanceof RelationalObjectProxy) {
                // empty if block
            }
        }
        if (exclude) {
            // empty if block
        }
    }

    public Map<String, EngPropertyHolder> getPropertiesMap() {
        TreeMap<String, EngPropertyHolder> propMap = new TreeMap<String, EngPropertyHolder>();
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isSelected() || !ph.isModified() || !ph.isDDLHolder() || ph.isExcluded() || ph.isFiltered()) continue;
            propMap.put(ph.getName(), ph);
        }
        return propMap;
    }
}

