/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBIndex;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBAlterIndex
extends AbstractCSSBOracle {
    CSSBDropIndex dropIndex;
    private CSSBIndex cssbIndex = new CSSBIndex();
    Map fkMap;
    private PKProxyOraclev9i pk = null;
    private StorageDesignOracle storageDesign;
    private CompareObjectSelection tableObj;

    public CSSBAlterIndex(Map fkMap) {
        this.fkMap = fkMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        this.tableObj = (CompareObjectSelection)((CompareObjectSelection)obj.getParent()).getParent();
        Table table = (Table)this.tableObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
        if (!obj.canBeCreate()) {
            boolean dropAndRecreate = false;
            String formattedNewName = null;
            String formattedOldName = null;
            for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
                if (!ph.isSelected()) continue;
                String propertyName = ph.getName();
                if (propertyName.equals(PropertiesComparator.NAME)) {
                    formattedNewName = this.storageDesign.getFormatedName(obj.getObject());
                    formattedOldName = this.storageDesign.getFormatedName(obj.getCorrespondentNode().getObject());
                    continue;
                }
                if (!propertyName.equals(PropertiesComparator.COLUMNS) && !propertyName.equals(PropertiesComparator.INDEX_FUNCTION_EXPRESSION) && !propertyName.equals(PropertiesComparator.INDEX_STATUS)) continue;
                dropAndRecreate = true;
            }
            if (!dropAndRecreate) {
                for (EngPropertyHolder ph : obj.getPropertiesComparator().getStoragePropertiesList()) {
                    if (!ph.isSelected()) continue;
                    dropAndRecreate = true;
                    break;
                }
            }
            if (dropAndRecreate) {
                this.dropIndex = new CSSBDropIndex(this.fkMap);
                this.dropIndex.doAppend(oldbuffer, object, prettyPrint);
            } else {
                if (formattedNewName != null) {
                    Index oldIndex = (Index)obj.getCorrespondentNode().getObject();
                    if (oldIndex.isPK() || oldIndex.isUnique()) {
                        this.renameConstraint(oldbuffer, formattedOldName, formattedNewName, prettyPrint);
                    } else {
                        this.renameIndex(oldbuffer, oldIndex, formattedNewName, prettyPrint);
                    }
                }
                return;
            }
        }
        this.appendAddIndex(oldbuffer, obj, prettyPrint);
    }

    private void renameIndex(StringBuffer oldbuffer, Index oldIndex, String formattedNewName, boolean prettyPrint) {
        RDBMSSite site;
        Table oldTable = oldIndex.getTable();
        Design design = oldTable.getDesign();
        StorageDesign targetStorageDesign = design.getStorageDesign(site = oldTable.getSelectedRDBMSSite(), oldTable);
        IndexProxyOracle indexProxy = (IndexProxyOracle)targetStorageDesign.getIndexProxySet().getProxy(oldIndex.getObjectID());
        if (indexProxy != null) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterIndex.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterIndex.appendStringWithSpace(buffer, "INDEX");
            CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
            CSSBAlterIndex.appendStringWithSpace(buffer, "RENAME");
            CSSBAlterIndex.appendStringWithSpace(buffer, "TO");
            CSSBAlterIndex.appendStringWithSpace(buffer, formattedNewName);
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterIndex.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterIndex();
        }
    }

    private void renameConstraint(StringBuffer oldbuffer, String formattedOldName, String formattedNewName, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBAlterIndex.appendStringWithSpace(buffer, "ALTER");
        CSSBAlterIndex.appendStringWithSpace(buffer, "TABLE");
        CSSBAlterIndex.appendStringWithSpace(buffer, CSSBAlterIndex.getFormattedTableName(this.tableObj, this.storageDesign));
        String advancedComment = buffer.toString() + "RENAME CONSTRAINT " + formattedOldName;
        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterIndex.appendStringWithSpace(buffer, "RENAME");
        CSSBAlterIndex.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBAlterIndex.appendStringWithSpace(buffer, formattedOldName);
        CSSBAlterIndex.appendStringWithSpace(buffer, "TO");
        CSSBAlterIndex.appendStringWithSpace(buffer, formattedNewName);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBAlterIndex.appendLineFinisher(buffer, prettyPrint);
        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendAddIndex(StringBuffer oldbuffer, CompareObjectSelection obj, boolean prettyPrint) {
        Table table = (Table)this.tableObj.getObject();
        TableProxyOraclev9i tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null) {
            this.appendIndexDefinition(oldbuffer, obj, prettyPrint);
            this.appendPKDefinition(oldbuffer, tableProxy, obj, prettyPrint);
            this.appendUniqueDefinition(oldbuffer, tableProxy, obj, prettyPrint);
        }
    }

    private void appendIndexDefinition(StringBuffer oldbuffer, CompareObjectSelection indexObj, boolean prettyPrint) {
        if (this.cssbIndex.canHandle(indexObj.getObject())) {
            StringBuffer columnList = this.getColumnsForRestore(indexObj, prettyPrint, true);
            this.cssbIndex.setRestoredColumns(columnList);
            this.cssbIndex.setRestoredExpression(indexObj.getChoosedPropertyValue(PropertiesComparator.INDEX_FUNCTION_EXPRESSION));
            this.cssbIndex.setTableName(CSSBAlterIndex.getFormattedTableName(this.tableObj, this.storageDesign));
            this.cssbIndex.doAppend(oldbuffer, indexObj.getObject(), prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Index;
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, CompareObjectSelection indexObj, boolean prettyPrint) {
        if (tableProxy != null) {
            Index pkInd = (Index)indexObj.getObject();
            this.pk = (PKProxyOraclev9i)this.storageDesign.getPKProxySet().getProxy(pkInd.getObjectID());
            if (this.pk != null && pkInd.shouldBeMerge()) {
                if (!"".equalsIgnoreCase(this.pk.getColumns())) {
                    StringBuffer columnList = this.getColumnsForRestore(indexObj, prettyPrint, false);
                    if (this.isNotEmpty(columnList.toString())) {
                        if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                            this.appendComment(oldbuffer, this.pk);
                        } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                            this.appendComment(oldbuffer, this.pk.getObject());
                        }
                        StringBuffer buffer = new StringBuffer();
                        CSSBAlterIndex.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterIndex.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterIndex.appendStringWithSpace(buffer, CSSBAlterIndex.getFormattedTableName(this.tableObj, this.storageDesign));
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterIndex.appendStringWithSpace(buffer, "ADD");
                        if (!this.pk.getName().startsWith("SYS_")) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "CONSTRAINT");
                            CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.pk));
                        }
                        String advancedComment = buffer.toString();
                        CSSBAlterIndex.appendStringWithSpace(buffer, "PRIMARY KEY");
                        CSSBAlterIndex.appendStringWithSpace(buffer, '(');
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                        this.appendStringWithSpace(buffer, columnList);
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterIndex.appendStringWithSpace(buffer, ')');
                        if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "DEFERRABLE");
                            if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "INITIALLY");
                                CSSBAlterIndex.appendStringWithSpace(buffer, "DEFERRED");
                            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "INITIALLY");
                                CSSBAlterIndex.appendStringWithSpace(buffer, "IMMEDIATE");
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "NOT");
                            CSSBAlterIndex.appendStringWithSpace(buffer, "DEFERRABLE");
                        }
                        if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                            this.appendUsingIndex(buffer, this.pk, prettyPrint);
                        }
                        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            if ("YES".equalsIgnoreCase(this.pk.getEnable())) {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "ENABLE");
                            } else {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "DISABLE");
                            }
                            if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "VALIDATE");
                            } else {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "NOVALIDATE");
                            }
                        } else {
                            if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "DISABLE");
                                if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                                    CSSBAlterIndex.appendStringWithSpace(buffer, "VALIDATE");
                                }
                            }
                            if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                                CSSBAlterIndex.appendStringWithSpace(buffer, "NOVALIDATE");
                            }
                        }
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        CSSBAlterIndex.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    }
                } else {
                    this.appendError(oldbuffer, prettyPrint, "Index " + this.pk.getLongNameDDL() + " without columns");
                }
            }
        }
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterIndex.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = pkProxy.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && pkProxy.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(pkProxy.getIndex(), true)) {
                CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            CSSBAlterIndex.appendStringWithSpace(buffer, '(');
            CSSBAlterIndex.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            CSSBAlterIndex.appendStringWithSpace(buffer, ')');
        } else {
            TableProxyOracle tableProxy = (TableProxyOracle)pkProxy.getTableProxy();
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "LOCAL");
                } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)pkProxy.getIndexSegment(), prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "LOGGING");
                            CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBAlterIndex.appendStringWithSpace(buffer, "NOSORT");
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "SORT");
                }
                CSSBAlterIndex.appendStringWithSpace(buffer, "REVERSE");
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBAlterIndex.appendStringWithSpace(buffer, "SORT");
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            }
            if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBAlterIndex.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndex.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndex.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndex.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndex.appendStringWithSpace(buffer, "RANGE");
            CSSBAlterIndex.appendStringWithSpace(buffer, '(');
            CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBAlterIndex.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, pkProxy, prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        this.cssbIndex.appendGlobalPartitions(buffer, indexProxy, prettyPrint);
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev9i segment, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null) {
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    CSSBAlterIndex.appendStringWithSpace(buffer, "PCTFREE");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                        CSSBAlterIndex.appendStringWithSpace(buffer, "INITRANS");
                        CSSBAlterIndex.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                        CSSBAlterIndex.appendStringWithSpace(buffer, "INITRANS");
                        CSSBAlterIndex.appendStringWithSpace(buffer, "1");
                    }
                    if (segment.getMaxTrans() > 1) {
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                        CSSBAlterIndex.appendStringWithSpace(buffer, "MAXTRANS");
                        CSSBAlterIndex.appendStringWithSpace(buffer, segment.getMaxTrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                        CSSBAlterIndex.appendStringWithSpace(buffer, "MAXTRANS");
                        CSSBAlterIndex.appendStringWithSpace(buffer, "255");
                    }
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    CSSBAlterIndex.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    CSSBAlterIndex.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                CSSBAlterIndex.appendStringWithSpace(buffer, "STORAGE");
                CSSBAlterIndex.appendStringWithSpace(buffer, '(');
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "INITIAL");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "NEXT");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "PCTINCREASE");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "MINEXTENTS");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "FREELISTS");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "FREELIST");
                    CSSBAlterIndex.appendStringWithSpace(buffer, "GROUPS");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBAlterIndex.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, CompareObjectSelection indexObj, boolean prettyPrint) {
        UniqueOraclev9i unique = (UniqueOraclev9i)this.storageDesign.getUniqueSet().getProxy(indexObj.getObject().getObjectID());
        if (unique != null && unique.shouldBeMerge()) {
            StringBuffer columnList = this.getColumnsForRestore(indexObj, prettyPrint, false);
            if (this.isNotEmpty(columnList.toString())) {
                if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
                    this.appendComment(oldbuffer, unique);
                } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
                    this.appendComment(oldbuffer, unique.getObject());
                }
                StringBuffer buffer = new StringBuffer();
                CSSBAlterIndex.appendStringWithSpace(buffer, "ALTER");
                CSSBAlterIndex.appendStringWithSpace(buffer, "TABLE");
                CSSBAlterIndex.appendStringWithSpace(buffer, CSSBAlterIndex.getFormattedTableName(this.tableObj, this.storageDesign));
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndex.appendStringWithSpace(buffer, "ADD");
                if (!unique.getName().startsWith("SYS_")) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
                }
                String advancedComment = buffer.toString();
                CSSBAlterIndex.appendStringWithSpace(buffer, "UNIQUE");
                CSSBAlterIndex.appendStringWithSpace(buffer, '(');
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                this.appendString(buffer, columnList);
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterIndex.appendStringWithSpace(buffer, ')');
                if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBAlterIndex.appendStringWithSpace(buffer, "DEFERRED");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBAlterIndex.appendStringWithSpace(buffer, "IMMEDIATE");
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "NOT");
                    CSSBAlterIndex.appendStringWithSpace(buffer, "DEFERRABLE");
                }
                if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
                    this.appendUniqueUsingIndex(buffer, unique, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(unique.getEnable())) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(unique.getValidate())) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(unique.getValidate())) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBAlterIndex.appendLineFinisher(buffer, prettyPrint);
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
            } else {
                this.appendError(oldbuffer, prettyPrint, "Index " + unique.getLongNameDDL() + " without columns");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterIndex.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = unique.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && unique.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(unique.getIndex(), true)) {
                CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            CSSBAlterIndex.appendStringWithSpace(buffer, '(');
            CSSBAlterIndex.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            CSSBAlterIndex.appendStringWithSpace(buffer, ')');
        } else {
            TableProxyOracle tableProxy = (TableProxyOracle)unique.getTableProxy();
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(unique.getUsingIndex())) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "LOCAL");
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                    this.appendUniqueGlobalIndex(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)unique.getIndexSegment(), prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBAlterIndex.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "LOGGING");
                            CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            CSSBAlterIndex.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBAlterIndex.appendStringWithSpace(buffer, "NOSORT");
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBAlterIndex.appendStringWithSpace(buffer, "SORT");
                }
                CSSBAlterIndex.appendStringWithSpace(buffer, "REVERSE");
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBAlterIndex.appendStringWithSpace(buffer, "SORT");
                CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            }
            if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBAlterIndex.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBAlterIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterIndex.appendStringWithSpace(buffer, "GLOBAL");
            CSSBAlterIndex.appendStringWithSpace(buffer, "PARTITION");
            CSSBAlterIndex.appendStringWithSpace(buffer, "BY");
            CSSBAlterIndex.appendStringWithSpace(buffer, "RANGE");
            CSSBAlterIndex.appendStringWithSpace(buffer, '(');
            CSSBAlterIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBAlterIndex.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, unique, prettyPrint);
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection indexObj, boolean prettyPrint, boolean getColumnSortOrder) {
        Index index = (Index)indexObj.getObject();
        CompareObjectSelection tableObj = (CompareObjectSelection)((CompareObjectSelection)indexObj.getParent()).getParent();
        StringBuffer columnList = new StringBuffer();
        boolean notFirst = false;
        List sourceColumns = tableObj.getChildObjects(0);
        block0: for (Column indexCol : index.getElementsCollection()) {
            for (CompareObjectSelection tableCol : sourceColumns) {
                ModelIDObject column = tableCol.getObject();
                if (column == null || !column.equals(indexCol)) continue;
                if (tableCol.canBeCreate() && !tableCol.isSelected() || tableCol.canBeDrop() && tableCol.getCorrespondentNode().isSelected()) continue block0;
                if (notFirst) {
                    columnList.append(',');
                    CSSBAlterIndex.appendNewLine(columnList, prettyPrint, 1);
                    columnList.append(' ');
                }
                String formattedColumnName = tableCol.isSelected() ? CSSBAlterIndex.getFormattedSelectedName(tableCol, this.storageDesign) : this.storageDesign.getFormatedName(tableCol.getCorrespondentNode().getObject());
                CSSBAlterIndex.appendStringWithSpace(columnList, formattedColumnName);
                if (getColumnSortOrder) {
                    CSSBAlterIndex.appendStringWithSpace(columnList, index.getColumnSortOrder(tableCol.getObject()));
                }
                notFirst = true;
                continue block0;
            }
        }
        return columnList;
    }

    private void appendError(StringBuffer oldbuffer, boolean prettyPrint, String errorMsg) {
        CSSBAlterIndex.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBAlterIndex.appendStringWithSpace(oldbuffer, "--  ERROR: ");
        CSSBAlterIndex.appendString(oldbuffer, errorMsg);
        CSSBAlterIndex.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementErrors();
    }
}

