/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class SnapshotComparator
extends StoragePropertiesComparator {
    public static final String ALIAS = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.Alias");
    public static final String IMPLEMENTS_TABLE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.ImplementsTable");
    public static final String ON_PREBUILT_TABLE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.OnPrebuildTable");
    public static final String USER = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.User");
    public static final String LOGGING = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.Logging");
    public static final String PARALLEL_CLAUSE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.ParalelClause");
    public static final String DEGREE = SnapshotComparator.getPropertyNameOracle("TablePropertyDialogOracle.Degree");
    public static final String BUILD = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.Build");
    public static final String REDUCED_PRECISION = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.ReducedPrecision");
    public static final String FOR_UPDATE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.ForUpdate");
    public static final String QUERY_REWRITE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.QueryRewrite");
    public static final String USE_INDEX = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.UseIndex");
    public static final String INDEX_TABLESPACE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.IndexTablespace");
    public static final String INDEX_STORAGE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOraclev9i.IndexSegment");
    public static final String PARTITIONED = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.Partitioned");
    public static final String PARTITIONING_COLUMNS = SnapshotComparator.getPropertyNameOracle("PartitionPropertyTabOraclev10g.PartitioningColumns");
    public static final String SUBPART_COLUMNS = SnapshotComparator.getPropertyNameOracle("PartitionPropertyTabOraclev10g.SubPartColumns");
    public static final String CLUSTER = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.Cluster");
    public static final String CLUSTER_COLUMNS = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.ClusterColumns");
    public static final String REFRESH = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.Refresh");
    public static final String REFRESH_TYPE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.RefreshType");
    public static final String ACTION = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.Action");
    public static final String START_DATE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.StartDate");
    public static final String NEXT_DATE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.NextDate");
    public static final String WITH = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.With");
    public static final String DEFAULT_STORAGE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.DefaultSegment");
    public static final String STORAGE_TYPE = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.SegmentType");
    public static final String ROLLBACK_SEGMENT = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOracle.RollbackSegment");
    public static final String USING_CONSTRAINT = SnapshotComparator.getPropertyNameOracle("SnapshotPropertyDialogOraclev10g.UsingConstraint");
    private SnapshotOracle sourceSnapshot;
    private SnapshotOracle targetSnapshot;
    private Map objectsMap;

    public SnapshotComparator(StorageObject sourceSnapshot, StorageObject targetSnapshot, Map objectsMap) {
        super(sourceSnapshot, targetSnapshot);
        this.sourceSnapshot = (SnapshotOracle)sourceSnapshot;
        this.targetSnapshot = (SnapshotOracle)targetSnapshot;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initStoragePropertiesList();
        this.initPropertiesFilterList();
        this.initStoragePropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        StorageDesign storageDesign = null;
        if (this.sourceSnapshot != null) {
            storageDesign = this.sourceSnapshot.getStorageDesign();
        } else if (this.targetSnapshot != null) {
            storageDesign = this.targetSnapshot.getStorageDesign();
        }
        this.initNameProperty();
        this.initCommentProperty();
        this.initCommentInRDBMSProperty();
        this.initNotesProperty();
        if (!DDL_ONLY) {
            this.initProperty(ALIAS, "alias");
        }
        this.initProperty(IMPLEMENTS_TABLE, "implementedTable", null);
        this.initProperty(ON_PREBUILT_TABLE, "onPrebuiltTable");
        this.initBodyProperty();
        this.initProperty(USER, "user");
        this.initProperty(LOGGING, "logging");
        this.initProperty(PARALLEL_CLAUSE, "parallelClause");
        this.initProperty(DEGREE, "degree");
        this.initProperty(BUILD, "build");
        this.initProperty(REDUCED_PRECISION, "reducedPrecision");
        this.initProperty(FOR_UPDATE, "forUpdate");
        this.initProperty(QUERY_REWRITE, "queryRewrite");
        this.initProperty(USE_INDEX, "useIndex");
        this.initProperty(INDEX_TABLESPACE, "indexTablespace");
        this.initProperty(INDEX_STORAGE, "indexSegment");
        this.initProperty(CACHE, "cache");
        this.initProperty(PARTITIONED, "partitioned").setDDLHolder(false);
        this.initProperty(PARTITIONING_COLUMNS, "columns").setDDLHolder(false);
        this.initProperty(SUBPART_COLUMNS, "subPartColumns").setDDLHolder(false);
        this.initProperty(CLUSTER, "cluster");
        this.initProperty(CLUSTER_COLUMNS, "clustercolumns");
        this.initProperty(REFRESH, "refresh");
        this.initProperty(REFRESH_TYPE, "refreshType");
        this.initProperty(ACTION, "action");
        this.initProperty(START_DATE, "startDate");
        this.initProperty(NEXT_DATE, "nextDate");
        this.initProperty(WITH, "with");
        this.initProperty(DEFAULT_STORAGE, "defaultSegment");
        this.initProperty(STORAGE_TYPE, "segmentType");
        this.initProperty(ROLLBACK_SEGMENT, "rollbackSegment");
        if (storageDesign instanceof StorageDesignOraclev10g) {
            this.initProperty(USING_CONSTRAINT, "usingConstraint");
        }
    }

    private void initBodyProperty() {
        PropertyHolder ph = new PropertyHolder(BODY);
        ph.setLeftValue(this.sourceSnapshot != null ? this.sourceSnapshot.getSubquery() : "");
        ph.setRightValue(this.targetSnapshot != null ? this.targetSnapshot.getSubquery() : "");
        if (this.isExcludedFromComparison(BODY)) {
            ph.setExcluded(true);
        } else if (this.sourceSnapshot != null && this.targetSnapshot != null && !ph.getLeftValue().equals(ph.getRightValue()) && (this.sourceSnapshot.isSubqueryChanged() || this.targetSnapshot.isSubqueryChanged())) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("subquery");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    public List<ClassDescription.PropertyDescription> getPropsToMerge() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            TableProxyOracle tpr;
            DesignObject sourceTable;
            ModelIDObject targetTable;
            TableProxyOracle sourceTableProxy;
            if (!ph.isSelected() || !ph.getName().equals(IMPLEMENTS_TABLE)) continue;
            TableProxyOracle originalTableProxy = this.targetSnapshot.getImplementedTable();
            if (originalTableProxy != null) {
                originalTableProxy.setSnapshot(null);
            }
            if ((sourceTableProxy = this.sourceSnapshot.getImplementedTable()) == null || (targetTable = (ModelIDObject)this.objectsMap.get((sourceTable = sourceTableProxy.getObject()).getObjectID())) == null || (tpr = (TableProxyOracle)this.targetSnapshot.getStorageDesign().getStorageObject(targetTable.getObjectID())) == null) continue;
            tpr.setSnapshot(this.targetSnapshot);
        }
        List<ClassDescription.PropertyDescription> propsList = super.getPropsToMerge();
        if (this.getChoosedPropertyValue(PARTITIONED).equalsIgnoreCase(YES) && this.classDescr != null) {
            ClassDescription.PropertyDescription partListPD = this.classDescr.getPropertyDescriptionByName("partitionList");
            propsList.add(partListPD);
        }
        return propsList;
    }

    protected void initStoragePropertiesList() {
        SegmentOracle sourceSegment = null;
        SegmentOracle targetSegment = null;
        TableSpaceOracle sourceTableSpace = null;
        TableSpaceOracle targetTableSpace = null;
        Method templateSetter = null;
        Method tablespaceSetter = null;
        boolean needTemplateComparator = false;
        if (this.sourceSnapshot != null) {
            sourceSegment = this.sourceSnapshot.getSegment();
            sourceTableSpace = this.sourceSnapshot.getTablespace();
            if (sourceTableSpace != null || sourceSegment != null) {
                needTemplateComparator = true;
            }
            try {
                templateSetter = SnapshotOracle.class.getMethod("setSegment", SegmentOracle.class);
                tablespaceSetter = SnapshotOracle.class.getMethod("setTablespace", TableSpaceOracle.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.targetSnapshot != null) {
            targetSegment = this.targetSnapshot.getSegment();
            targetTableSpace = this.targetSnapshot.getTablespace();
            if (targetTableSpace != null || targetSegment != null) {
                needTemplateComparator = true;
            }
        }
        if (needTemplateComparator) {
            this.templateComparator = new StorageTemplateComparator(this.sourceSnapshot, this.targetSnapshot, sourceSegment, targetSegment, sourceTableSpace, targetTableSpace, templateSetter, tablespaceSetter);
            this.templateComparator.filterStoragePropertiesList(this.getStoragePropertiesFilterList());
        }
    }
}

