/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.StringComparator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Glossary {
    private String name;
    private String id;
    private String description;
    private String fileName = "";
    private File file;
    private boolean dirty = false;
    private boolean newID = false;
    private boolean loaded = false;
    private int loadError = 0;
    private List words = new ArrayList();
    private static final Logger LOGGER;
    private String indent = "   ";
    private static final Comparator COMPARATOR;
    public static String GLOSSARY_TAG;
    public static String VERSION;
    public static String GLOSSARY_WORD;
    public static String WORD_NAME;
    public static String PLURAL;
    public static String ABBREVIATION;
    public static String ALT_ABBREVIATION;
    public static String SHORT_DESCRIPTION;
    public static String WORD_TYPE;
    public static String WORD_ID;
    public static String IMPORT_ID;
    public static String GL_CLASS_WORD;
    public static String GL_PRIMARY_WORD;
    public static String GL_MODIFIER;
    public static String GL_QUALIFIER;
    static String TRUE;
    private String FALSE = "false";
    public static String SPACE;
    public static String CHARACTER;
    public static String[] SEPARATOR_TYPES;
    static String MW_SEPARATOR;
    static String INCOMPLETE_MODIFIERS;
    static String CASE_SENSITIVE;
    static String SEPARATOR_TYPE;
    static String UNIQUE_ABBREVIATIONS;
    private Map wordsMap = new TreeMap();
    private Map wordsUpperCaseMap = new TreeMap();
    private char multiWordSeparator_def = (char)45;
    private boolean caseSensitive_def = false;
    private boolean incompleteModifiers_def = false;
    private String separatorType_def = CHARACTER;
    private boolean uniqueAbbreviations_def = false;
    private char multiWordSeparator = this.multiWordSeparator_def;
    private boolean caseSensitive = this.caseSensitive_def;
    private boolean incompleteModifiers = this.incompleteModifiers_def;
    private String separatorType = this.separatorType_def;
    private boolean uniqueAbbreviations = this.uniqueAbbreviations_def;
    private static File lastExpFolder;
    private static Glossary emptyGlossary;
    List nameSizeDescList = new ArrayList();
    List abbrSizeDescList = new ArrayList();
    List altAbbrSizeDescList = new ArrayList();
    Map abbreviationsMap = new TreeMap();
    Map altAbbreviationsMap = new TreeMap();
    Map pluralsMap = new TreeMap();
    String lastError = "";
    WordRule lastRule;
    String[] importOptions = new String[]{Messages.getString("Glossary.Update"), Messages.getString("Glossary.Skip")};
    String mess = Messages.getString("Glossary.wordsImportedBefore");

    public Glossary(File file) {
        this.file = file;
        this.id = new GUID().toString();
        this.newID = true;
        this.setDirty(true);
        if (file != null) {
            this.fileName = file.getPath();
            this.open(file);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.setDirty(true);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getShortFileName() {
        return this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(File file) {
        block20: {
            if (file != null && file.isFile()) {
                if (!file.exists()) {
                    this.clearGlossary();
                } else {
                    BufferedReader br = null;
                    try {
                        FileInputStream is = new FileInputStream(file);
                        br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        InputSource inputSource = new InputSource(br);
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = null;
                        try {
                            db = dbf.newDocumentBuilder();
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            // empty catch block
                        }
                        if (db == null) break block20;
                        try {
                            Document doc = db.parse(inputSource);
                            Element root = doc.getDocumentElement();
                            if (root == null) break block20;
                            String rootTag = root.getTagName();
                            if (GLOSSARY_TAG.equalsIgnoreCase(rootTag)) {
                                this.clearGlossary();
                                this.parseXMLDocument(root);
                                this.loaded = true;
                                this.dirty = this.newID;
                                break block20;
                            }
                            this.loaded = false;
                            this.loadError = -1;
                        }
                        catch (SAXException sAXException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public List getTerms(String name, char wordSeparator, boolean upperCaseAsSeparator) {
        ArrayList<NamePart> list = new ArrayList<NamePart>();
        String[] parts = this.getWords(name, wordSeparator, upperCaseAsSeparator, false, false, false);
        for (int i = 0; i < parts.length; ++i) {
            GlossaryWord word = null;
            parts[i] = parts[i].trim();
            word = this.isCaseSensitive() ? (GlossaryWord)this.wordsMap.get(parts[i]) : (GlossaryWord)this.wordsUpperCaseMap.get(parts[i].toUpperCase());
            NamePart part = new NamePart(parts[i]);
            part.word = word;
            part.existsInGlossary = word != null;
            list.add(part);
        }
        return list;
    }

    public List getTerms(String name, char wordSeparator, boolean upperCaseAsSeparator, boolean abbreviatedName, boolean upperCaseOnly, boolean abbreviatedOnly) {
        ArrayList<Object> list = new ArrayList<Object>();
        String[] parts = this.getWords(name, wordSeparator, upperCaseAsSeparator, abbreviatedName, upperCaseOnly, abbreviatedOnly);
        for (int i = 0; i < parts.length; ++i) {
            Object part;
            GlossaryWord word = null;
            if (!abbreviatedName || abbreviatedName && !abbreviatedOnly) {
                word = this.isCaseSensitive() ? (GlossaryWord)this.wordsMap.get(parts[i]) : (GlossaryWord)this.wordsUpperCaseMap.get(parts[i].toUpperCase());
            }
            if (word == null && abbreviatedName) {
                part = parts[i].toUpperCase();
                List coll = (List)this.abbreviationsMap.get(part);
                if (coll != null && coll.size() > 0) {
                    word = (GlossaryWord)coll.get(0);
                }
                if (word == null && (coll = (List)this.altAbbreviationsMap.get(part)) != null && coll.size() > 0) {
                    word = (GlossaryWord)coll.get(0);
                }
            }
            if (word == null && parts.length == 1) {
                word = this.getWordByPlural(name);
            }
            part = new NamePart(parts[i]);
            ((NamePart)part).word = word;
            ((NamePart)part).existsInGlossary = word != null;
            list.add(part);
        }
        return list;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int getLoadError() {
        return this.loadError;
    }

    public GlossaryWord createGlossaryWordWithID() {
        GlossaryWord word = this.createGlossaryWord(null);
        word.setId(new GUID().toString());
        return word;
    }

    public GlossaryWord createGlossaryWord(String id) {
        GlossaryWord word = new GlossaryWord(this);
        if (id != null) {
            word.setId(id);
        }
        this.words.add(word);
        return word;
    }

    public void clearGlossary() {
        this.words.clear();
        this.nameSizeDescList.clear();
        this.abbreviationsMap.clear();
        this.altAbbreviationsMap.clear();
        this.abbrSizeDescList.clear();
        this.altAbbrSizeDescList.clear();
        this.loaded = false;
        this.dirty = false;
    }

    private void parseXMLDocument(Element root) {
        String gloss_name = root.getAttribute(WORD_NAME);
        this.setName(StringUtilities.decodeAttributeValue(gloss_name));
        String gloss_descr = root.getAttribute(SHORT_DESCRIPTION);
        this.setDescription(StringUtilities.decodeAttributeValue(gloss_descr));
        String attr = root.getAttribute(UNIQUE_ABBREVIATIONS);
        if (attr != null && !"".equals(attr)) {
            this.uniqueAbbreviations = "true".equalsIgnoreCase(attr);
        }
        if ((attr = root.getAttribute(CASE_SENSITIVE)) != null && !"".equals(attr)) {
            this.caseSensitive = "true".equalsIgnoreCase(attr);
        }
        if ((attr = root.getAttribute(INCOMPLETE_MODIFIERS)) != null && !"".equals(attr)) {
            this.incompleteModifiers = "true".equalsIgnoreCase(attr);
        }
        if ((attr = root.getAttribute(SEPARATOR_TYPE)) != null && !"".equals(attr)) {
            this.separatorType = attr;
        }
        if ((attr = root.getAttribute(MW_SEPARATOR)) != null && attr.length() > 0) {
            this.multiWordSeparator = attr.charAt(0);
        }
        if ((attr = root.getAttribute(WORD_ID)) != null && !"".equals(attr)) {
            this.id = attr;
            this.newID = false;
        } else {
            if (this.id == null) {
                this.id = new GUID().toString();
            }
            this.setDirty(true);
            this.newID = true;
        }
        NodeList nodes = root.getElementsByTagName(GLOSSARY_WORD);
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            String desc;
            String type;
            String alt_abbr;
            String abbr;
            Element elem = (Element)nodes.item(i);
            String name = elem.getAttribute(WORD_NAME);
            if (name == null || "".equals(name)) continue;
            String id = elem.getAttribute(WORD_ID);
            if (id == null || "".equals(id)) {
                id = new GUID().toString();
            }
            GlossaryWord word = this.createGlossaryWord(id);
            String a_name = StringUtilities.decodeAttributeValue(name);
            word.setName(a_name);
            String plural = elem.getAttribute(PLURAL);
            if (plural != null) {
                word.setPlural(StringUtilities.decodeAttributeValue(plural));
            }
            if ((abbr = elem.getAttribute(ABBREVIATION)) != null) {
                word.setAbbreviation(StringUtilities.decodeAttributeValue(abbr));
            }
            if ((alt_abbr = elem.getAttribute(ALT_ABBREVIATION)) != null) {
                word.setAltAbbrevation(StringUtilities.decodeAttributeValue(alt_abbr));
            }
            if ((type = elem.getAttribute(GL_CLASS_WORD)) != null && TRUE.equalsIgnoreCase(type)) {
                word.setClassWord(true);
            }
            if ((type = elem.getAttribute(GL_PRIMARY_WORD)) != null && TRUE.equalsIgnoreCase(type)) {
                word.setPrimaryWord(true);
            }
            if ((type = elem.getAttribute(GL_MODIFIER)) != null && TRUE.equalsIgnoreCase(type)) {
                word.setModifier(true);
            }
            if ((type = elem.getAttribute(GL_QUALIFIER)) != null && TRUE.equalsIgnoreCase(type)) {
                word.setQualifier(true);
            }
            if ((desc = elem.getAttribute(SHORT_DESCRIPTION)) != null) {
                word.setShortDescription(StringUtilities.decodeAttributeValue(desc));
            }
            word.setDirty(false);
        }
    }

    String convertName(String name) {
        String[] parts;
        Object result = "";
        char sep = '\u0000';
        if (name.indexOf(45) > 0) {
            parts = name.split("-");
            sep = '-';
        } else if (name.indexOf(32) > 0) {
            parts = name.split(" ");
            sep = ' ';
        } else {
            parts = new String[]{name};
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = Character.toUpperCase(parts[i].charAt(0)) + parts[i].toLowerCase().substring(1, parts[i].length());
            result = i == 0 ? part : (sep != '\u0000' ? (String)result + sep + part : (String)result + part);
        }
        return result;
    }

    public void saveAs(ApplicationView appView) {
        File file;
        URLFilter glossaryFilter = new URLFilter(){

            public boolean accept(URL url) {
                File file = new File(url.getPath());
                return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("Glossary.CWDGlossaryFiles");
            }
        };
        URLFileChooser fileChooser = new URLFileChooser();
        fileChooser.clearChooseableURLFilters();
        fileChooser.setSelectionScope(0);
        fileChooser.setSelectionMode(0);
        fileChooser.setShowJarsAsDirs(false);
        fileChooser.setURLFilter(glossaryFilter);
        fileChooser.setPathContext("dataModeler_Glossary");
        if (lastExpFolder != null) {
            fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
        } else {
            String lastDir = appView.getSettings().getDefaultSavePath();
            if (lastDir != null && lastDir.length() > 0) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
            } else {
                URL url = appView.getUserHomeDirectory();
                if (url != null) {
                    fileChooser.setSelectedURL(url);
                }
            }
        }
        int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("Glossary.CWDSaveGlossaryFile"));
        if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
            lastExpFolder = file.getParentFile();
            this.saveOutput(file, appView, true);
        }
    }

    private void saveOutput(File infile, ApplicationView appView, boolean check) {
        try {
            int result;
            File selFile = infile;
            String fname = selFile.getName().toLowerCase();
            if (!fname.endsWith(".glossary") && !fname.endsWith(".glossary")) {
                selFile = new File(selFile.getPath() + ".glossary");
            }
            if (check && selFile.exists() && appView != null && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Glossary.FileExists"), selFile.getAbsolutePath()), Messages.getString("Glossary.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                return;
            }
            StringBuffer content = this.makeContent();
            selFile.getParentFile().mkdirs();
            selFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(selFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(content.toString());
            osw.close();
            this.file = selFile;
            this.fileName = this.file.getPath();
            MessageDialogs.showMessage(MessageFormat.format(Messages.getString("Glossary.GlossarySuccesfullySaved"), this.fileName));
        }
        catch (IOException ioe) {
            LOGGER.error("Error when saving Glossary.", ioe);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("Glossary.CanNotwriteToFile"), ioe.getMessage()}, Messages.getString("Glossary.WriteEror"), 0);
        }
        catch (Throwable t) {
            LOGGER.error("Error when saving Glossary.", t);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("Glossary.UnexpectedError"), t.getMessage()}, Messages.getString("Glossary.WriteError"), 0);
        }
    }

    public void save() {
        if (this.file != null) {
            this.saveOutput(this.file, null, false);
        } else {
            this.saveAs(ApplicationView.getInstance());
        }
    }

    private GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private StringBuffer makeContent() {
        StringBuffer content = new StringBuffer();
        content.append(MDConfiguration.getDefaultInstance().get("xml.documenttype")).append("\n");
        this.appendGlossaryBegin(content);
        this.appendWords(content);
        this.appendGlossaryEnd(content);
        return content;
    }

    private void appendGlossaryBegin(StringBuffer content) {
        content.append("\n");
        String name = StringUtilities.encodeAttributeValue(this.getName());
        String descr = StringUtilities.encodeAttributeValue(this.getDescription());
        Object params = "";
        params = (String)params + " " + WORD_ID + "=\"" + this.id + "\"";
        if (this.incompleteModifiers != this.incompleteModifiers_def) {
            params = (String)params + " " + INCOMPLETE_MODIFIERS + "=\"" + String.valueOf(this.incompleteModifiers) + "\"";
        }
        if (this.uniqueAbbreviations != this.uniqueAbbreviations_def) {
            params = (String)params + " " + UNIQUE_ABBREVIATIONS + "=\"" + String.valueOf(this.uniqueAbbreviations) + "\"";
        }
        if (this.caseSensitive != this.caseSensitive_def) {
            params = (String)params + " " + CASE_SENSITIVE + "=\"" + String.valueOf(this.caseSensitive) + "\"";
        }
        if (this.multiWordSeparator != this.multiWordSeparator_def || !this.separatorType.equalsIgnoreCase(this.separatorType_def)) {
            params = (String)params + " " + SEPARATOR_TYPE + "=\"" + String.valueOf(this.separatorType) + "\" " + MW_SEPARATOR + "=\"" + String.valueOf(this.multiWordSeparator) + "\"";
        }
        if ("".equalsIgnoreCase((String)params)) {
            content.append("<" + GLOSSARY_TAG + " name=\"" + name + "\" " + SHORT_DESCRIPTION + "=\"" + descr + "\" >\n");
        } else {
            content.append("<" + GLOSSARY_TAG + " name=\"" + name + "\" " + SHORT_DESCRIPTION + "=\"" + descr + "\"" + (String)params + " >\n");
        }
    }

    private void appendGlossaryEnd(StringBuffer content) {
        content.append("\n");
        content.append("</" + GLOSSARY_TAG + ">\n");
    }

    private void appendWords(StringBuffer content) {
        content.append("\n");
        for (GlossaryWord word : this.words) {
            String name = StringUtilities.encodeAttributeValue(word.getName());
            String plural = StringUtilities.encodeAttributeValue(word.getPlural());
            String abbr = StringUtilities.encodeAttributeValue(word.getAbbreviation());
            String alt_abbr = StringUtilities.encodeAttributeValue(word.getAltAbbrevation());
            String descr = StringUtilities.encodeAttributeValue(word.getShortDescription());
            Object type = "";
            if (word.isClassWord()) {
                type = (String)type + " " + GL_CLASS_WORD + "=\"true\"";
            }
            if (word.isPrimaryWord()) {
                type = (String)type + " " + GL_PRIMARY_WORD + "=\"true\"";
            }
            if (word.isModifier()) {
                type = (String)type + " " + GL_MODIFIER + "=\"true\"";
            }
            if (word.isQualifier()) {
                type = (String)type + " " + GL_QUALIFIER + "=\"true\"";
            }
            content.append(this.indent + "<" + GLOSSARY_WORD + " name=\"" + name + "\" " + PLURAL + "=\"" + plural + "\" " + ABBREVIATION + "=\"" + abbr + "\" " + ALT_ABBREVIATION + "=\"" + alt_abbr + "\"" + (String)type + " " + WORD_ID + "=\"" + word.getId() + "\" " + IMPORT_ID + "=\"" + word.getImportID() + "\" " + SHORT_DESCRIPTION + "=\"" + descr + "\" />\n");
        }
    }

    public List getWords() {
        return this.words;
    }

    public GlossaryWord getWordByName(String Name2) {
        for (GlossaryWord word : this.words) {
            if (!Name2.equals(word.getName())) continue;
            return word;
        }
        return null;
    }

    public GlossaryWord getDifferentWordByName(String name, GlossaryWord differentWord) {
        for (GlossaryWord word : this.words) {
            if (word == differentWord || !name.equals(word.getName())) continue;
            return word;
        }
        return null;
    }

    public boolean removeWord(GlossaryWord word) {
        return this.words.remove(word);
    }

    public void clearDirtyFlag() {
        for (GlossaryWord word : this.words) {
            word.setDirty(false);
        }
        this.setDirty(false);
    }

    private String[] getWords(String name, char wordSeparator, boolean upperCaseAsSeparator, boolean abbreviatedName, boolean upperCaseOnly, boolean abbreviatedOnly) {
        char mwordSeparator = this.getMW_SeparatorChar();
        if (!upperCaseAsSeparator) {
            if (mwordSeparator != wordSeparator && wordSeparator != '\u0000') {
                return name.split(String.valueOf(wordSeparator));
            }
            return this.getWordsWithReverseScan(name, wordSeparator, abbreviatedName, upperCaseOnly, abbreviatedOnly);
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char current = name.charAt(i);
            if (Character.isUpperCase(current)) {
                String str;
                boolean mword = false;
                if (i > 0 && name.charAt(i - 1) == mwordSeparator) {
                    mword = true;
                }
                if (!mword && !"".equals(str = sb.toString().trim())) {
                    list.add(str);
                    sb.setLength(0);
                }
                sb.append(current);
                continue;
            }
            sb.append(current);
        }
        String str = sb.toString().trim();
        if (!"".equals(str)) {
            list.add(str);
            sb.setLength(0);
        }
        return list.toArray(new String[0]);
    }

    public void prepareUtilityMaps() {
        WordNameSizeDescComparator comp = new WordNameSizeDescComparator();
        WordAbbrevSizeDescComparator abbr_comp = new WordAbbrevSizeDescComparator();
        WordAltAbbrevNameSizeDescComparator altAbbr_comp = new WordAltAbbrevNameSizeDescComparator();
        this.nameSizeDescList.clear();
        this.abbreviationsMap.clear();
        this.altAbbreviationsMap.clear();
        this.altAbbrSizeDescList.clear();
        this.altAbbrSizeDescList.clear();
        this.nameSizeDescList.addAll(this.words);
        Collections.sort(this.nameSizeDescList, comp);
        for (GlossaryWord word : this.words) {
            String pl;
            List<GlossaryWord> coll;
            String name;
            if (!"".equals(word.getAbbreviation().trim())) {
                name = word.getAbbreviation().toUpperCase();
                coll = (ArrayList<GlossaryWord>)this.abbreviationsMap.get(name);
                if (coll == null) {
                    coll = new ArrayList<GlossaryWord>();
                }
                coll.add(word);
                this.abbreviationsMap.put(name, coll);
                this.abbrSizeDescList.add(word);
            }
            if (!"".equals(word.getAltAbbrevation().trim())) {
                name = word.getAltAbbrevation().toUpperCase();
                coll = (List)this.altAbbreviationsMap.get(name);
                if (coll == null) {
                    coll = new ArrayList();
                }
                coll.add(word);
                this.altAbbreviationsMap.put(name, coll);
                this.altAbbrSizeDescList.add(word);
            }
            if ((pl = word.getPlural()) == null || "".equals(pl)) continue;
            this.pluralsMap.put(pl.toUpperCase(), word.getName());
        }
        Collections.sort(this.abbrSizeDescList, abbr_comp);
        Collections.sort(this.altAbbrSizeDescList, altAbbr_comp);
    }

    /*
     * WARNING - void declaration
     */
    private String[] getWordsWithReverseScan(String name, char wordSeparator, boolean abbreviatedName, boolean upperCaseOnly, boolean abbreviatedOnly) {
        String separator = "";
        if (wordSeparator != '\u0000') {
            separator = String.valueOf(wordSeparator);
        }
        LinkedList<Object> result = new LinkedList<Object>();
        String wname = name;
        if (!this.isCaseSensitive()) {
            wname = name.toUpperCase();
        }
        result.add(wname);
        if (!abbreviatedName) {
            ArrayList list_all = new ArrayList();
            if (!abbreviatedName || abbreviatedName && !abbreviatedOnly) {
                list_all.addAll(this.nameSizeDescList);
            }
            Iterator it = list_all.iterator();
            block0: while (it.hasNext() && this.hasString(result)) {
                GlossaryWord glossaryWord = (GlossaryWord)it.next();
                String sname = glossaryWord.getName();
                if (!this.isCaseSensitive()) {
                    sname = sname.toUpperCase();
                }
                Object[] nodes = result.toArray();
                for (int i = 0; i < nodes.length; ++i) {
                    String str;
                    int ind;
                    if (!(nodes[i] instanceof String) || (ind = (str = (String)nodes[i]).indexOf(sname)) <= -1 || ind > 0 && wordSeparator != '\u0000' && str.charAt(ind - 1) != wordSeparator) continue;
                    String left = str.substring(0, ind);
                    String right = "";
                    if (ind + sname.length() + 1 < str.length()) {
                        right = str.substring(ind + sname.length());
                    }
                    result.set(i, glossaryWord);
                    if (!"".equals(right)) {
                        result.add(i + 1, right);
                    }
                    if ("".equals(left) || separator.equalsIgnoreCase(left)) continue block0;
                    result.add(i, left);
                    continue block0;
                }
            }
        }
        if (abbreviatedName) {
            String right;
            Object[] nodes;
            GlossaryWord word;
            Iterator it = this.abbrSizeDescList.iterator();
            block2: while (it.hasNext() && this.hasString(result)) {
                word = (GlossaryWord)it.next();
                String string = word.getAbbreviation();
                if (!this.isCaseSensitive()) {
                    String string2 = string.toUpperCase();
                }
                nodes = result.toArray();
                for (int i = 0; i < nodes.length; ++i) {
                    void var11_15;
                    String str;
                    int ind;
                    if (!(nodes[i] instanceof String) || (ind = (str = (String)nodes[i]).indexOf((String)var11_15)) <= -1) continue;
                    String left = str.substring(0, ind);
                    right = "";
                    if (ind + var11_15.length() + 1 < str.length()) {
                        right = str.substring(ind + var11_15.length());
                    }
                    result.set(i, word);
                    if (!"".equals(right)) {
                        result.add(i + 1, right);
                    }
                    if ("".equals(left) || separator.equalsIgnoreCase(left)) continue block2;
                    result.add(i, left);
                    continue block2;
                }
            }
            it = this.altAbbrSizeDescList.iterator();
            block4: while (it.hasNext() && this.hasString(result)) {
                word = (GlossaryWord)it.next();
                String string = word.getAltAbbrevation();
                if (!this.isCaseSensitive()) {
                    String string3 = string.toUpperCase();
                }
                nodes = result.toArray();
                for (int i = 0; i < nodes.length; ++i) {
                    void var11_19;
                    String str;
                    int ind;
                    if (!(nodes[i] instanceof String) || (ind = (str = (String)nodes[i]).indexOf((String)var11_19)) <= -1) continue;
                    String left = str.substring(0, ind);
                    right = "";
                    if (ind + var11_19.length() + 1 < str.length()) {
                        right = str.substring(ind + var11_19.length());
                    }
                    result.set(i, word);
                    if (!"".equals(right)) {
                        result.add(i + 1, right);
                    }
                    if ("".equals(left) || separator.equalsIgnoreCase(left)) continue block4;
                    result.add(i, left);
                    continue block4;
                }
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object e : result) {
            if (e instanceof GlossaryWord) {
                list.add(((GlossaryWord)e).getName());
                continue;
            }
            if (!(e instanceof String)) continue;
            list.add((String)e);
        }
        return list.toArray(new String[0]);
    }

    private boolean hasString(List list) {
        for (Object obj : list) {
            if (!(obj instanceof String)) continue;
            return true;
        }
        return false;
    }

    private boolean isConfirmToRules(List nameParts, List nameRules, boolean abbreviatedName, boolean abbreviatedOnly) {
        if (nameParts.size() > nameRules.size()) {
            this.lastError = MessageFormat.format(Messages.getString("Glossary.NameHasNWords"), nameParts.size(), nameRules.size());
            return false;
        }
        Iterator it = nameParts.iterator();
        Object parts = "";
        int count = 0;
        boolean first = true;
        while (it.hasNext()) {
            NamePart np = (NamePart)it.next();
            if (np.word != null || this.isIncompleteModifiers()) continue;
            ++count;
            if (first) {
                parts = "'" + np.namePart + "'";
                first = false;
                continue;
            }
            parts = (String)parts + " , '" + np.namePart + "'";
        }
        if (!"".equals(parts)) {
            this.lastError = abbreviatedName && abbreviatedOnly ? (count > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedAsAbbreviations"), parts, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedAsAbbreviations"), parts, this.getName())) : (count > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedInGlossary"), parts, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedInGlossary"), parts, this.getName()));
            return false;
        }
        return this.confirmToRules(nameParts, 0, nameRules, 0);
    }

    private boolean isConfirmToGlossary(List nameParts, boolean abbreviatedName, boolean abbreviatedOnly) {
        Iterator it = nameParts.iterator();
        Object parts = "";
        int count = 0;
        boolean first = true;
        while (it.hasNext()) {
            NamePart np = (NamePart)it.next();
            if (np.word != null || this.isIncompleteModifiers()) continue;
            ++count;
            if (first) {
                parts = "'" + np.namePart + "'";
                first = false;
                continue;
            }
            parts = (String)parts + " , '" + np.namePart + "'";
        }
        if (!"".equals(parts)) {
            this.lastError = abbreviatedName && abbreviatedOnly ? (count > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedAsAbbreviations"), parts, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedAsAbbreviations"), parts, this.getName())) : (count > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedInGlossary"), parts, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedInGlossary"), parts, this.getName()));
            return false;
        }
        return true;
    }

    private boolean confirmToRules(List nameParts, int partsPos, List nameRules, int rulesPos) {
        int rdelta;
        NamePart np = (NamePart)nameParts.get(partsPos);
        int pdelta = nameParts.size() - 1 - partsPos;
        if (pdelta > (rdelta = nameRules.size() - 1 - rulesPos)) {
            this.lastError = Messages.getString("Glossary.NameDoesntMatch");
            return false;
        }
        for (int i = rulesPos; i < nameRules.size() - pdelta; ++i) {
            WordRule nameRule;
            this.lastRule = nameRule = (WordRule)nameRules.get(i);
            boolean match = this.areCompatible(np, nameRule);
            if (match) {
                if (pdelta == 0) {
                    if (rdelta == 0) {
                        return true;
                    }
                    WordRule rule = this.getFirstMandatoryRule(nameRules, i + 1);
                    if (rule != null) {
                        this.lastError = MessageFormat.format(Messages.getString("Glossary.MissingMandatory"), rule.getWordType());
                        return false;
                    }
                    return true;
                }
                if (rdelta == 0 || i == nameRules.size() - 1) {
                    this.lastError = Messages.getString("Glossary.NametooLong");
                    return false;
                }
                boolean test = this.confirmToRules(nameParts, partsPos + 1, nameRules, i + 1);
                if (test) {
                    return true;
                }
            }
            if (!nameRule.isMandatory()) continue;
            this.lastError = MessageFormat.format(Messages.getString("Glossary.MissingWordOfType"), this.lastError, this.lastRule.getWordType());
            return false;
        }
        this.lastError = Messages.getString("Glossary.166");
        return false;
    }

    private boolean areCompatible(NamePart namePart, WordRule rule) {
        if (namePart.word == null) {
            if (this.isIncompleteModifiers()) {
                return rule.getWordType().equals("Modifier") || rule.getWordType().equals("Qualifier");
            }
            return false;
        }
        if (rule.getWordType().equals("Modifier") && namePart.word.isModifier()) {
            return true;
        }
        if (rule.getWordType().equals("Prime Word") && namePart.word.isPrimaryWord()) {
            return true;
        }
        if (rule.getWordType().equals("Class Word") && namePart.word.isClassWord()) {
            return true;
        }
        return rule.getWordType().equals("Qualifier") && namePart.word.isQualifier();
    }

    private WordRule getFirstMandatoryRule(List rules, int startIndex) {
        for (int i = startIndex; i < rules.size(); ++i) {
            WordRule rule = (WordRule)rules.get(i);
            if (!rule.isMandatory()) continue;
            return rule;
        }
        return null;
    }

    public String checkValidName(String name, List nameRules, char wordSeparator, boolean upperCaseAsSeparator, boolean upperCaseOnly, boolean abbreviatedName, boolean abbreviatedOnly) {
        this.lastError = "";
        this.lastRule = null;
        List nameTerms = abbreviatedName ? this.getTerms(name, wordSeparator, upperCaseAsSeparator, abbreviatedName, upperCaseOnly, abbreviatedOnly) : this.getTerms(name, wordSeparator, upperCaseAsSeparator);
        boolean test = false;
        test = nameRules.size() > 0 ? this.isConfirmToRules(nameTerms, nameRules, abbreviatedName, abbreviatedOnly) : this.isConfirmToGlossary(nameTerms, abbreviatedName, abbreviatedOnly);
        if (test) {
            return null;
        }
        return this.lastError;
    }

    public void updateMaps(String oldName, String newName, GlossaryWord word) {
        if (oldName != null && !"".equalsIgnoreCase(oldName)) {
            GlossaryWord oldWord = (GlossaryWord)this.wordsMap.remove(oldName);
            if (oldWord != word) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("Glossary.InconsistencyInGlossaryNormalMap"), oldName, newName));
            }
            oldWord = (GlossaryWord)this.wordsUpperCaseMap.remove(oldName.toUpperCase());
            if (oldWord != word) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("Glossary.InconsistencyInGlossaryUpperCaseMap"), oldName, newName));
            }
            this.wordsMap.put(newName, word);
            this.wordsUpperCaseMap.put(newName.toUpperCase(), word);
        } else if (oldName != null && "".equalsIgnoreCase(oldName)) {
            this.wordsMap.put(newName, word);
            this.wordsUpperCaseMap.put(newName.toUpperCase(), word);
        }
    }

    public void sortWords() {
        Collections.sort(this.words, COMPARATOR);
    }

    public char getMultiWordSeparator() {
        return this.multiWordSeparator;
    }

    public void setMultiWordSeparator(char multiWordSeparator) {
        if (this.multiWordSeparator != multiWordSeparator) {
            this.multiWordSeparator = multiWordSeparator;
            this.setDirty(true);
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.caseSensitive != caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.setDirty(true);
        }
    }

    public void setIncompleteModifiers(boolean incompleteModifiers) {
        if (this.incompleteModifiers != incompleteModifiers) {
            this.incompleteModifiers = incompleteModifiers;
            this.setDirty(true);
        }
    }

    public boolean isIncompleteModifiers() {
        return this.incompleteModifiers;
    }

    public String getSeparatorType() {
        return this.separatorType;
    }

    public void setSeparatorType(String separatorType) {
        if (!this.separatorType.equalsIgnoreCase(separatorType)) {
            this.separatorType = separatorType;
            this.setDirty(true);
        }
    }

    public boolean isUniqueAbbreviations() {
        return this.uniqueAbbreviations;
    }

    public void setUniqueAbbreviations(boolean uniqueAbbreviations) {
        if (this.uniqueAbbreviations != uniqueAbbreviations) {
            this.uniqueAbbreviations = uniqueAbbreviations;
            this.setDirty(true);
        }
    }

    public char getMW_SeparatorChar() {
        if (this.separatorType.equalsIgnoreCase(SPACE)) {
            return ' ';
        }
        return this.multiWordSeparator;
    }

    public String validateMultiWordsForSpaces(char separator) {
        StringBuffer sb = new StringBuffer();
        if (' ' != separator) {
            boolean first = true;
            for (GlossaryWord word : this.words) {
                if (word.getName().trim().indexOf(32) <= 0) continue;
                if (first) {
                    first = false;
                    sb.append(MessageFormat.format(Messages.getString("Glossary.CurrentSeparatorSetTo"), Character.valueOf(separator)));
                    sb.append(Messages.getString("Glossary.ThereAreWordsWithSPACECharacter"));
                    sb.append("\n").append(word.getName());
                    continue;
                }
                sb.append("\n").append(word.getName());
            }
        }
        return sb.toString();
    }

    public void replaceSeparator(char oldSeparator, char newSeparator) {
        for (GlossaryWord word : this.words) {
            String[] parts;
            String name = word.getName().trim();
            if (name.indexOf(oldSeparator) <= -1 || (parts = name.split(String.valueOf(oldSeparator))).length <= 0) continue;
            String newName = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                newName = newName.concat(parts[i] + newSeparator);
            }
            newName = newName.concat(parts[parts.length - 1]);
            word.setName(newName);
        }
    }

    public List getWordsWithNoneUniqueAbbreviations() {
        ArrayList list = new ArrayList();
        ArrayList<GlossaryWord> emptyAbbr = new ArrayList<GlossaryWord>();
        TreeMap map = new TreeMap();
        for (GlossaryWord word : this.words) {
            if ("".equals(word.getAbbreviation().trim())) {
                emptyAbbr.add(word);
                continue;
            }
            String name = word.getAbbreviation().toUpperCase();
            List<GlossaryWord> coll = (ArrayList<GlossaryWord>)map.get(name);
            if (coll == null) {
                coll = new ArrayList<GlossaryWord>();
            }
            coll.add(word);
            map.put(name, coll);
            name = word.getAltAbbrevation();
            if ("".equalsIgnoreCase(name)) continue;
            coll = (List)map.get(name = name.toUpperCase());
            if (coll == null) {
                coll = new ArrayList();
            }
            coll.add(word);
            map.put(name, coll);
        }
        for (Object key : map.keySet()) {
            List coll = (List)map.get(key);
            if (coll.size() <= 1) continue;
            list.addAll(coll);
        }
        list.addAll(emptyAbbr);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importERwinGlossaryFile(File file) {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = null;
        try {
            String inputLine;
            boolean csv = file.getName().toUpperCase().endsWith(".CSV");
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), IdeUtil.getIdeEncoding());
            in = new BufferedReader(isr);
            int num = 0;
            ArrayList unclassWords = new ArrayList();
            while ((inputLine = in.readLine()) != null) {
                if (csv) {
                    if (num > 0) {
                        this.parseCSVLine(inputLine, sb, unclassWords);
                    }
                } else {
                    this.parseERwinLine(inputLine, sb, unclassWords);
                }
                ++num;
            }
            if (unclassWords.size() > 0) {
                if (sb.length() > 0) {
                    sb.append(Messages.getString("Glossary.UnclassifiedWordsS"));
                } else {
                    sb.append(Messages.getString("Glossary.UnclassifiedWords"));
                }
                for (int i = 0; i < unclassWords.size(); ++i) {
                    sb.append(unclassWords.get(i)).append("\n");
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    private void parseERwinLine(String line, StringBuffer errorSB, List unclassWords) {
        if (!"".equalsIgnoreCase(line)) {
            String[] parts;
            int last = line.length() - 1;
            String wline = line;
            if (line.charAt(last) == ',') {
                wline = line.substring(0, last);
            }
            if ((parts = wline.split(",")).length > 0) {
                GlossaryWord word = (GlossaryWord)this.wordsUpperCaseMap.get(parts[0].toUpperCase());
                if (word != null) {
                    errorSB.append(Messages.getString("Glossary.NameExists")).append(" - ").append(line).append("\n");
                } else {
                    word = this.createGlossaryWordWithID();
                    word.setName(parts[0]);
                    if (parts.length > 1 && !"".equalsIgnoreCase(parts[1])) {
                        word.setAbbreviation(parts[1]);
                    }
                    if (parts.length > 2 && !"".equalsIgnoreCase(parts[2])) {
                        word.setAltAbbrevation(parts[2]);
                    }
                    boolean classified = false;
                    if (parts.length > 3 && !"".equalsIgnoreCase(parts[3]) && "X".equalsIgnoreCase(parts[3])) {
                        word.setPrimaryWord(true);
                        classified = true;
                    }
                    if (parts.length > 4 && !"".equalsIgnoreCase(parts[4]) && "X".equalsIgnoreCase(parts[4])) {
                        word.setModifier(true);
                        classified = true;
                    }
                    if (parts.length > 5 && !"".equalsIgnoreCase(parts[5]) && "X".equalsIgnoreCase(parts[5])) {
                        word.setModifier(true);
                        classified = true;
                    }
                    if (parts.length > 6 && !"".equalsIgnoreCase(parts[6]) && "X".equalsIgnoreCase(parts[6])) {
                        word.setClassWord(true);
                        classified = true;
                    }
                    if (parts.length > 7 && !"".equalsIgnoreCase(parts[7])) {
                        Object desc = "";
                        for (int i = 7; i < parts.length; ++i) {
                            desc = i == 7 ? parts[i] : (String)desc + "," + parts[i];
                        }
                        word.setShortDescription((String)desc);
                    }
                    if (!classified) {
                        unclassWords.add(line);
                    }
                }
            } else {
                errorSB.append(line).append("\n");
            }
        }
    }

    private void parseCSVLine(String line, StringBuffer errorSB, List unclassWords) {
        if (!"".equalsIgnoreCase(line)) {
            String[] parts;
            int last = line.length() - 1;
            String wline = line;
            if (line.charAt(last) == ',') {
                wline = line.substring(0, last);
            }
            if ((parts = wline.split(",")).length > 0) {
                GlossaryWord word = (GlossaryWord)this.wordsUpperCaseMap.get(parts[0].toUpperCase());
                if (word != null) {
                    errorSB.append(Messages.getString("Glossary.NameExists")).append(" - ").append(line).append("\n");
                } else {
                    word = this.createGlossaryWordWithID();
                    word.setName(parts[0]);
                    if (parts.length > 1 && !"".equalsIgnoreCase(parts[1])) {
                        word.setPlural(parts[1]);
                    }
                    if (parts.length > 2 && !"".equalsIgnoreCase(parts[2])) {
                        word.setAbbreviation(parts[2]);
                    }
                    if (parts.length > 3 && !"".equalsIgnoreCase(parts[3])) {
                        word.setAltAbbrevation(parts[3]);
                    }
                    boolean classified = false;
                    if (parts.length > 4 && !"".equalsIgnoreCase(parts[4]) && "X".equalsIgnoreCase(parts[4])) {
                        word.setPrimaryWord(true);
                        classified = true;
                    }
                    if (parts.length > 5 && !"".equalsIgnoreCase(parts[5]) && "X".equalsIgnoreCase(parts[5])) {
                        word.setClassWord(true);
                        classified = true;
                    }
                    if (parts.length > 6 && !"".equalsIgnoreCase(parts[6]) && "X".equalsIgnoreCase(parts[6])) {
                        word.setModifier(true);
                        classified = true;
                    }
                    if (parts.length > 7 && !"".equalsIgnoreCase(parts[7]) && "X".equalsIgnoreCase(parts[7])) {
                        word.setQualifier(true);
                        classified = true;
                    }
                    if (parts.length > 8 && !"".equalsIgnoreCase(parts[8])) {
                        Object desc = "";
                        for (int i = 8; i < parts.length; ++i) {
                            desc = i == 8 ? parts[i] : (String)desc + "," + parts[i];
                        }
                        word.setShortDescription((String)desc);
                    }
                    if (!classified) {
                        unclassWords.add(line);
                    }
                }
            } else {
                errorSB.append(line).append("\n");
            }
        }
    }

    public String importGlossary(File file, ApplicationView appView) {
        JCheckBox applyForAll = new JCheckBox(Messages.getString("Glossary.ApplyForAll"));
        Object[] messArray = new Object[]{this.mess, Messages.getString("Glossary.OldL"), Messages.getString("Glossary.NewL"), applyForAll};
        StringBuffer sb = new StringBuffer();
        TreeMap<String, GlossaryWord> map = new TreeMap<String, GlossaryWord>();
        for (GlossaryWord word : this.words) {
            if ("".equalsIgnoreCase(word.getImportID())) continue;
            map.put(word.getImportID(), word);
        }
        int result = -1;
        Glossary gl = new Glossary(file);
        for (GlossaryWord word : gl.getWords()) {
            GlossaryWord tword = (GlossaryWord)map.get(word.getId());
            if (tword == null) {
                String name;
                if (this.isCaseSensitive()) {
                    name = word.getName().trim();
                    tword = (GlossaryWord)this.wordsMap.get(name);
                } else {
                    name = word.getName().trim().toUpperCase();
                    tword = (GlossaryWord)this.wordsMap.get(name);
                }
                if (tword != null) {
                    sb.append(Messages.getString("Glossary.NameExists")).append(tword.getName()).append("\n");
                    continue;
                }
                GlossaryWord nword = this.createGlossaryWordWithID();
                word.copyTo(nword);
                nword.setImportID(word.getId());
                continue;
            }
            if (!applyForAll.isSelected()) {
                messArray[1] = MessageFormat.format(Messages.getString("Glossary.Old"), tword.getName());
                messArray[2] = MessageFormat.format(Messages.getString("Glossary.New"), word.getName());
                result = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), messArray, Messages.getString("Glossary.WordsImport"), 0, 3, null, this.importOptions, this.importOptions[0]);
            }
            if (result != 0) continue;
            word.copyTo(tword);
        }
        return sb.toString();
    }

    public boolean exportAsCSVFile(File textFile, ApplicationView appView) throws IOException {
        int result;
        if (textFile.exists() && appView != null && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Glossary.FileExists"), textFile.getAbsolutePath()), Messages.getString("Glossary.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return false;
        }
        StringBuffer content = this.makeExportContent();
        textFile.getParentFile().mkdirs();
        textFile.createNewFile();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(textFile)), IdeUtil.getIdeEncoding());
        out.write(content.toString());
        out.flush();
        out.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportAsXLSFile(File file) throws IOException {
        int result;
        if (file.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Glossary.FileExists"), file.getAbsolutePath()), Messages.getString("Glossary.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return false;
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        try {
            String glossaryName = this.getFileName();
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet worksheet = workbook.createSheet(WorkbookUtil.createSafeSheetName((String)glossaryName));
            worksheet.setColumnWidth(0, 10000);
            worksheet.setColumnWidth(1, 10000);
            worksheet.setColumnWidth(2, 6000);
            worksheet.setColumnWidth(3, 6000);
            worksheet.setColumnWidth(4, 3000);
            worksheet.setColumnWidth(5, 3000);
            worksheet.setColumnWidth(6, 3000);
            worksheet.setColumnWidth(7, 3000);
            worksheet.setColumnWidth(8, 20000);
            HSSFDataValidationHelper dvHelper = new HSSFDataValidationHelper(worksheet);
            HSSFDataValidation validation = null;
            HSSFFont fontH = workbook.createFont();
            HSSFCellStyle cellStyleH = workbook.createCellStyle();
            cellStyleH.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleH.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleH.setAlignment(HorizontalAlignment.CENTER);
            cellStyleH.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex());
            cellStyleH.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSCellBorders(cellStyleH);
            fontH.setFontHeightInPoints((short)12);
            fontH.setFontName("Tahoma");
            fontH.setBold(true);
            cellStyleH.setFont(fontH);
            HSSFFont fontD = workbook.createFont();
            HSSFCellStyle cellStyleD = workbook.createCellStyle();
            cellStyleD.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleD.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleD.setAlignment(HorizontalAlignment.LEFT);
            cellStyleD.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex());
            cellStyleD.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSCellBorders(cellStyleD);
            fontD.setFontHeightInPoints((short)12);
            fontD.setFontName("Tahoma");
            fontD.setBold(true);
            cellStyleD.setFont(fontD);
            HSSFFont fontC = workbook.createFont();
            fontC.setFontName("Tahoma");
            fontC.setFontHeightInPoints((short)12);
            HSSFPalette palette = workbook.getCustomPalette();
            palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex(), (byte)Integer.parseInt("11011001", 2), (byte)Integer.parseInt("11110101", 2), (byte)Integer.parseInt("11111111", 2));
            HSSFRow titleRow = worksheet.createRow(1);
            titleRow.setHeight((short)((double)titleRow.getHeight() * 1.5));
            HSSFCell cell = titleRow.createCell(0);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont fontT = workbook.createFont();
            fontT.setFontName("Tahoma");
            fontT.setFontHeightInPoints((short)13);
            fontT.setBold(true);
            cellStyle.setFont(fontT);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(Messages.getString("Glossary.Glossary"));
            HSSFCellStyle cellStyleGeneral = workbook.createCellStyle();
            cellStyleGeneral.setLocked(false);
            cellStyleGeneral.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleGeneral.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleGeneral.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSCellBorders(cellStyleGeneral);
            cellStyleGeneral.setFont(fontC);
            cellStyleGeneral.setWrapText(true);
            HSSFCellStyle cellStyleText = workbook.createCellStyle();
            cellStyleText.setLocked(false);
            cellStyleText.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
            cellStyleText.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleText.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSCellBorders(cellStyleText);
            cellStyleText.setFont(fontC);
            cellStyleText.setWrapText(true);
            HSSFRow headerRow = worksheet.createRow(3);
            headerRow.setHeight((short)((double)headerRow.getHeight() * 1.2));
            HSSFCell headerCell = headerRow.createCell(0);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Name"));
            headerCell = headerRow.createCell(1);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Plural"));
            headerCell = headerRow.createCell(2);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Abbreviation"));
            headerCell = headerRow.createCell(3);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.AltAbbreviation"));
            headerCell = headerRow.createCell(4);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Prime"));
            headerCell = headerRow.createCell(5);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Class"));
            headerCell = headerRow.createCell(6);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Modifier"));
            headerCell = headerRow.createCell(7);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Qualifier"));
            headerCell = headerRow.createCell(8);
            headerCell.setCellStyle(cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.ShortDescription"));
            HSSFCreationHelper factory = workbook.getCreationHelper();
            HSSFPatriarch drawing = workbook.getSheetAt(0).createDrawingPatriarch();
            int rowCounter = 4;
            for (GlossaryWord word : this.getWords()) {
                String termID = word.getId();
                int newLines = 1;
                HSSFRow dataRow = worksheet.createRow(rowCounter);
                dataRow.setHeight((short)((double)dataRow.getHeight() * 1.2));
                cell = dataRow.createCell(0);
                cell.setCellStyle(cellStyleGeneral);
                cell.setCellValue(word.getName());
                ClientAnchor anchor = factory.createClientAnchor();
                anchor.setCol1(cell.getColumnIndex());
                anchor.setCol2(cell.getColumnIndex() + 2);
                anchor.setRow1(cell.getRowIndex());
                anchor.setRow2(cell.getRowIndex() + 2);
                Comment comment = drawing.createCellComment(anchor);
                RichTextString str = factory.createRichTextString("ObjectID:" + word.getId());
                comment.setString(str);
                cell.setCellComment(comment);
                cell = dataRow.createCell(1);
                cell.setCellStyle(cellStyleGeneral);
                cell.setCellValue(word.getPlural());
                cell = dataRow.createCell(2);
                cell.setCellStyle(cellStyleGeneral);
                cell.setCellValue(word.getAbbreviation());
                cell = dataRow.createCell(3);
                cell.setCellStyle(cellStyleGeneral);
                cell.setCellValue(word.getAltAbbrevation());
                DVConstraint dvConstraint = DVConstraint.createExplicitListConstraint((String[])new String[]{TRUE, this.FALSE});
                cell = dataRow.createCell(4);
                cell.setCellStyle(cellStyleText);
                CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 4, 4);
                validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isPrimaryWord() ? TRUE : this.FALSE);
                cell = dataRow.createCell(5);
                cell.setCellStyle(cellStyleText);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 5, 5);
                validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isClassWord() ? TRUE : this.FALSE);
                cell = dataRow.createCell(6);
                cell.setCellStyle(cellStyleText);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 6, 6);
                validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isModifier() ? TRUE : this.FALSE);
                cell = dataRow.createCell(7);
                cell.setCellStyle(cellStyleText);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 7, 7);
                validation = (HSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isQualifier() ? TRUE : this.FALSE);
                cell = dataRow.createCell(8);
                cell.setCellStyle(cellStyleGeneral);
                String sd = word.getShortDescription();
                cell.setCellValue(sd);
                int currentValueNewLines = 1;
                if (sd != null) {
                    Matcher m = Pattern.compile("\n|\r", 8).matcher(sd);
                    while (m.find()) {
                        ++currentValueNewLines;
                    }
                }
                if (newLines < currentValueNewLines) {
                    newLines = currentValueNewLines;
                }
                dataRow.setHeight((short)(dataRow.getHeight() * newLines));
                ++rowCounter;
            }
            worksheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 8));
            worksheet.protectSheet("");
            workbook.write((OutputStream)fileOut);
            fileOut.flush();
            fileOut.close();
        }
        catch (Exception e) {
            LOGGER.error("GlossaryExcelIO.exportToXLS()" + e);
        }
        finally {
            fileOut.flush();
            fileOut.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportAsXLSXFile(File file) throws IOException {
        int result;
        if (file.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Glossary.FileExists"), file.getAbsolutePath()), Messages.getString("Glossary.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return false;
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        try {
            String glossaryName = this.getFileName();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet worksheet = workbook.createSheet(WorkbookUtil.createSafeSheetName((String)glossaryName));
            worksheet.setColumnWidth(0, 10000);
            worksheet.setColumnWidth(1, 10000);
            worksheet.setColumnWidth(2, 6000);
            worksheet.setColumnWidth(3, 6000);
            worksheet.setColumnWidth(4, 3000);
            worksheet.setColumnWidth(5, 3000);
            worksheet.setColumnWidth(6, 3000);
            worksheet.setColumnWidth(7, 3000);
            worksheet.setColumnWidth(8, 20000);
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(worksheet);
            XSSFDataValidation validation = null;
            XSSFFont fontH = workbook.createFont();
            XSSFCellStyle cellStyleH = workbook.createCellStyle();
            cellStyleH.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleH.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleH.setAlignment(HorizontalAlignment.CENTER);
            cellStyleH.setFillForegroundColor(new XSSFColor(new Color(217, 245, 255)));
            cellStyleH.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSXCellBorders(cellStyleH);
            fontH.setFontHeightInPoints((short)12);
            fontH.setFontName("Tahoma");
            fontH.setBold(true);
            cellStyleH.setFont((Font)fontH);
            XSSFFont fontD = workbook.createFont();
            XSSFCellStyle cellStyleD = workbook.createCellStyle();
            cellStyleD.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleD.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyleD.setAlignment(HorizontalAlignment.LEFT);
            cellStyleD.setFillForegroundColor(new XSSFColor(new Color(217, 245, 255)));
            cellStyleD.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.setXLSXCellBorders(cellStyleD);
            fontD.setFontHeightInPoints((short)12);
            fontD.setFontName("Tahoma");
            fontD.setBold(true);
            cellStyleD.setFont((Font)fontD);
            XSSFFont fontC = workbook.createFont();
            fontC.setFontName("Tahoma");
            fontC.setFontHeightInPoints((short)12);
            XSSFRow titleRow = worksheet.createRow(1);
            titleRow.setHeight((short)((double)titleRow.getHeight() * 1.5));
            XSSFCell cell = titleRow.createCell(0);
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFFont fontT = workbook.createFont();
            fontT.setFontName("Tahoma");
            fontT.setFontHeightInPoints((short)13);
            fontT.setBold(true);
            cellStyle.setFont((Font)fontT);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue(Messages.getString("Glossary.Glossary"));
            XSSFCellStyle cellStyleGeneral = workbook.createCellStyle();
            cellStyleGeneral.setLocked(false);
            cellStyleGeneral.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"General"));
            cellStyleGeneral.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleGeneral.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSXCellBorders(cellStyleGeneral);
            cellStyleGeneral.setFont((Font)fontC);
            cellStyleGeneral.setWrapText(true);
            XSSFCellStyle cellStyleText = workbook.createCellStyle();
            cellStyleText.setLocked(false);
            cellStyleText.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
            cellStyleText.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyleText.setAlignment(HorizontalAlignment.LEFT);
            this.setXLSXCellBorders(cellStyleText);
            cellStyleText.setFont((Font)fontC);
            cellStyleText.setWrapText(true);
            XSSFRow headerRow = worksheet.createRow(3);
            headerRow.setHeight((short)((double)headerRow.getHeight() * 1.2));
            XSSFCell headerCell = headerRow.createCell(0);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Name"));
            headerCell = headerRow.createCell(1);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Plural"));
            headerCell = headerRow.createCell(2);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Abbreviation"));
            headerCell = headerRow.createCell(3);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.AltAbbreviation"));
            headerCell = headerRow.createCell(4);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Prime"));
            headerCell = headerRow.createCell(5);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Class"));
            headerCell = headerRow.createCell(6);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Modifier"));
            headerCell = headerRow.createCell(7);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.Qualifier"));
            headerCell = headerRow.createCell(8);
            headerCell.setCellStyle((CellStyle)cellStyleH);
            headerCell.setCellValue(Messages.getString("Glossary.ShortDescription"));
            XSSFCreationHelper factory = workbook.getCreationHelper();
            XSSFDrawing drawing = workbook.getSheetAt(0).createDrawingPatriarch();
            int rowCounter = 4;
            for (GlossaryWord word : this.getWords()) {
                String termID = word.getId();
                int newLines = 1;
                XSSFRow dataRow = worksheet.createRow(rowCounter);
                dataRow.setHeight((short)((double)dataRow.getHeight() * 1.2));
                cell = dataRow.createCell(0);
                cell.setCellStyle((CellStyle)cellStyleGeneral);
                cell.setCellValue(word.getName());
                ClientAnchor anchor = factory.createClientAnchor();
                anchor.setCol1(cell.getColumnIndex());
                anchor.setCol2(cell.getColumnIndex() + 2);
                anchor.setRow1(cell.getRowIndex());
                anchor.setRow2(cell.getRowIndex() + 2);
                Comment comment = drawing.createCellComment(anchor);
                RichTextString str = factory.createRichTextString("ObjectID:" + word.getId());
                comment.setString(str);
                cell.setCellComment(comment);
                cell = dataRow.createCell(1);
                cell.setCellStyle((CellStyle)cellStyleGeneral);
                cell.setCellValue(word.getPlural());
                cell = dataRow.createCell(2);
                cell.setCellStyle((CellStyle)cellStyleGeneral);
                cell.setCellValue(word.getAbbreviation());
                cell = dataRow.createCell(3);
                cell.setCellStyle((CellStyle)cellStyleGeneral);
                cell.setCellValue(word.getAltAbbrevation());
                XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(new String[]{TRUE, this.FALSE});
                cell = dataRow.createCell(4);
                cell.setCellStyle((CellStyle)cellStyleText);
                CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 4, 4);
                validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isPrimaryWord() ? TRUE : this.FALSE);
                cell = dataRow.createCell(5);
                cell.setCellStyle((CellStyle)cellStyleText);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 5, 5);
                validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isClassWord() ? TRUE : this.FALSE);
                cell = dataRow.createCell(6);
                cell.setCellStyle((CellStyle)cellStyleText);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 6, 6);
                validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isModifier() ? TRUE : this.FALSE);
                cell = dataRow.createCell(7);
                cell.setCellStyle((CellStyle)cellStyleText);
                addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), 7, 7);
                validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
                validation.setErrorStyle(0);
                validation.createErrorBox("Validation Error", "Entered value is not in valid list of values! \nChoose item from drop down list.");
                validation.setShowErrorBox(true);
                worksheet.addValidationData((DataValidation)validation);
                cell.setCellValue(word.isQualifier() ? TRUE : this.FALSE);
                cell = dataRow.createCell(8);
                cell.setCellStyle((CellStyle)cellStyleGeneral);
                String sd = word.getShortDescription();
                cell.setCellValue(sd);
                int currentValueNewLines = 1;
                if (sd != null) {
                    Matcher m = Pattern.compile("\n|\r", 8).matcher(sd);
                    while (m.find()) {
                        ++currentValueNewLines;
                    }
                }
                if (newLines < currentValueNewLines) {
                    newLines = currentValueNewLines;
                }
                dataRow.setHeight((short)(dataRow.getHeight() * newLines));
                ++rowCounter;
            }
            worksheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 8));
            worksheet.protectSheet("");
            workbook.write((OutputStream)fileOut);
            fileOut.flush();
            fileOut.close();
        }
        catch (Exception e) {
            LOGGER.error("Glossary.exportAsXLSXFile()" + e.getStackTrace());
        }
        finally {
            fileOut.flush();
            fileOut.close();
        }
        return true;
    }

    public String ImportExcelFile(File file) throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            TreeMap<String, GlossaryWord> map = new TreeMap<String, GlossaryWord>();
            for (GlossaryWord word : this.words) {
                if ("".equalsIgnoreCase(word.getImportID())) continue;
                map.put(word.getImportID(), word);
            }
            Glossary glossary = new Glossary(file);
            FileInputStream inp = new FileInputStream(file);
            Workbook wb = WorkbookFactory.create((InputStream)inp);
            Sheet sheet = wb.getSheetAt(0);
            boolean indata = false;
            Iterator rIt = sheet.rowIterator();
            block7: while (rIt.hasNext()) {
                Row row = (Row)rIt.next();
                GlossaryWord newWord = null;
                if (row == null) continue;
                Iterator cIt = row.cellIterator();
                while (cIt.hasNext()) {
                    Cell cell = (Cell)cIt.next();
                    if (cell == null) continue;
                    int columnIdx = cell.getColumnIndex();
                    if (columnIdx == 0) {
                        GlossaryWord tword;
                        String wordName = cell.getRichStringCellValue().getString();
                        Comment comment = cell.getCellComment();
                        String wordID = "";
                        if (comment != null) {
                            String str = comment.getString().getString();
                            String part1 = str.substring(0, str.indexOf(":") + 1);
                            String part2 = str.substring(str.indexOf(":") + 1, str.length());
                            if (!part1.equals("") && !part2.equals("") && part1.equals("ObjectID:")) {
                                wordID = part2;
                                indata = true;
                            }
                        } else if (!indata) continue block7;
                        if ((tword = (GlossaryWord)map.get(wordID)) != null) continue;
                        if (this.isCaseSensitive()) {
                            this.name = wordName.trim();
                            tword = (GlossaryWord)this.wordsMap.get(this.name);
                        } else {
                            this.name = wordName.trim().toUpperCase();
                            tword = (GlossaryWord)this.wordsMap.get(this.name);
                        }
                        if (tword != null) {
                            sb.append(Messages.getString("Glossary.NameExists")).append(tword.getName()).append("\n");
                            continue block7;
                        }
                        newWord = this.createGlossaryWord(wordID);
                        newWord.setName(wordName);
                        continue;
                    }
                    if (columnIdx == 1) {
                        if (newWord == null) continue;
                        newWord.setPlural(cell.getRichStringCellValue().getString());
                        continue;
                    }
                    if (columnIdx == 2) {
                        if (newWord == null) continue;
                        newWord.setAbbreviation(cell.getRichStringCellValue().getString());
                        continue;
                    }
                    if (columnIdx == 3) {
                        if (newWord == null) continue;
                        newWord.setAltAbbrevation(cell.getRichStringCellValue().getString());
                        continue;
                    }
                    if (columnIdx == 4) {
                        if (newWord == null) continue;
                        try {
                            newWord.setPrimaryWord(Boolean.parseBoolean(cell.getStringCellValue()));
                        }
                        catch (Exception e) {
                            try {
                                newWord.setPrimaryWord(cell.getBooleanCellValue());
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        continue;
                    }
                    if (columnIdx == 5) {
                        if (newWord == null) continue;
                        if (cell.getCellType() == CellType.STRING) {
                            newWord.setClassWord(Boolean.parseBoolean(cell.getStringCellValue()));
                            continue;
                        }
                        if (cell.getCellType() != CellType.BOOLEAN) continue;
                        newWord.setClassWord(cell.getBooleanCellValue());
                        continue;
                    }
                    if (columnIdx == 6) {
                        if (newWord == null) continue;
                        if (cell.getCellType() == CellType.STRING) {
                            newWord.setModifier(Boolean.parseBoolean(cell.getStringCellValue()));
                            continue;
                        }
                        if (cell.getCellType() != CellType.BOOLEAN) continue;
                        newWord.setModifier(cell.getBooleanCellValue());
                        continue;
                    }
                    if (columnIdx == 7) {
                        if (newWord == null) continue;
                        if (cell.getCellType() == CellType.STRING) {
                            newWord.setQualifier(Boolean.parseBoolean(cell.getStringCellValue()));
                            continue;
                        }
                        if (cell.getCellType() != CellType.BOOLEAN) continue;
                        newWord.setQualifier(cell.getBooleanCellValue());
                        continue;
                    }
                    if (columnIdx != 8 || newWord == null) continue;
                    newWord.setShortDescription(cell.getRichStringCellValue().getString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Glossary.importXLSFile()" + e.fillInStackTrace());
        }
        return sb.toString();
    }

    private StringBuffer makeExportContent() {
        StringBuffer content = new StringBuffer();
        this.appendFirstRow(content);
        this.appendRows(content);
        return content;
    }

    private void appendFirstRow(StringBuffer content) {
        content.append(MessageFormat.format(Messages.getString("Glossary.NamePluralAbbreviationAltAbbreviation"), "\n"));
    }

    private void appendRows(StringBuffer content) {
        for (GlossaryWord word : this.words) {
            String name = word.getName().trim();
            if ("".equals(name)) continue;
            content.append(name).append(",");
            String plur = word.getPlural().trim();
            if (!"".equals(plur)) {
                content.append(plur).append(",");
            } else {
                content.append(",");
            }
            String abbr = word.getAbbreviation().trim();
            if (!"".equals(abbr)) {
                content.append(abbr).append(",");
            } else {
                content.append(",");
            }
            abbr = word.getAltAbbrevation().trim();
            if (!"".equals(abbr)) {
                content.append(abbr).append(",");
            } else {
                content.append(",");
            }
            if (word.isPrimaryWord()) {
                content.append("X,");
            } else {
                content.append(",");
            }
            if (word.isClassWord()) {
                content.append("X,");
            } else {
                content.append(",");
            }
            if (word.isModifier()) {
                content.append("X,");
            } else {
                content.append(",");
            }
            if (word.isQualifier()) {
                content.append("X,");
            } else {
                content.append(",");
            }
            content.append(word.getShortDescription().replaceAll("\\n+", " "));
            content.append("\n");
        }
    }

    public GlossaryWord getWordByPlural(String name) {
        if (name != null && !"".equals(name)) {
            for (GlossaryWord word : this.words) {
                if (!(this.isCaseSensitive() ? name.equals(word.getPlural()) : name.equalsIgnoreCase(word.getPlural()))) continue;
                return word;
            }
        }
        return null;
    }

    public static Glossary getEmptyGlossary() {
        if (emptyGlossary == null) {
            emptyGlossary = new Glossary(null);
            emptyGlossary.setIncompleteModifiers(true);
        }
        return emptyGlossary;
    }

    public String getNameByPlural(String pluralInUpperCase) {
        if (pluralInUpperCase != null) {
            return (String)this.pluralsMap.get(pluralInUpperCase);
        }
        return null;
    }

    private void setXLSCellBorders(HSSFCellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
    }

    private void setXLSXCellBorders(XSSFCellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
    }

    static {
        COMPARATOR = new StringComparator();
        GLOSSARY_TAG = "cwd_glossary";
        VERSION = "version";
        GLOSSARY_WORD = "glossaryWord";
        WORD_NAME = "name";
        PLURAL = "plural";
        ABBREVIATION = "abbreviation";
        ALT_ABBREVIATION = "alt_abbreviation";
        SHORT_DESCRIPTION = "description";
        WORD_TYPE = "type";
        WORD_ID = "id";
        IMPORT_ID = "import_id";
        GL_CLASS_WORD = "class_word";
        GL_PRIMARY_WORD = "primary_word";
        GL_MODIFIER = "modifier";
        GL_QUALIFIER = "qualifier";
        TRUE = "true";
        SPACE = "Space";
        CHARACTER = "Character";
        SEPARATOR_TYPES = new String[]{CHARACTER, SPACE};
        MW_SEPARATOR = "mw_separator";
        INCOMPLETE_MODIFIERS = "incomplete_modifiers";
        CASE_SENSITIVE = "case_sensitive";
        SEPARATOR_TYPE = "separator_type";
        UNIQUE_ABBREVIATIONS = "unique_abbreviations";
        lastExpFolder = null;
        LOGGER = new Logger(Glossary.class);
    }

    public static class WordAltAbbrevNameSizeDescComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            int twosize;
            int onesize = ((GlossaryWord)one).getAltAbbrevation().length();
            if (onesize < (twosize = ((GlossaryWord)two).getAltAbbrevation().length())) {
                return 1;
            }
            if (onesize > twosize) {
                return -1;
            }
            return 0;
        }
    }

    public static class WordAbbrevSizeDescComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            int twosize;
            int onesize = ((GlossaryWord)one).getAbbreviation().length();
            if (onesize < (twosize = ((GlossaryWord)two).getAbbreviation().length())) {
                return 1;
            }
            if (onesize > twosize) {
                return -1;
            }
            return 0;
        }
    }

    public static class WordNameSizeDescComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            int twosize;
            int onesize = ((GlossaryWord)one).getName().length();
            if (onesize < (twosize = ((GlossaryWord)two).getName().length())) {
                return 1;
            }
            if (onesize > twosize) {
                return -1;
            }
            return 0;
        }
    }

    public class NamePart {
        public String namePart;
        boolean existsInGlossary = false;
        public GlossaryWord word;

        NamePart(String namePart) {
            this.namePart = namePart;
        }
    }
}

