/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_ColumnView
extends LongNameObjectSelection {
    private ColumnView columnView;

    public ImpA_ColumnView(ColumnView columnView, ModelIdObjectSelection parent, boolean load) {
        super(columnView);
        this.columnView = columnView;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addDependentColumnViews();
        this.loaded = true;
    }

    private void addDependentColumnViews() {
        ArrayList<ColumnView> list = new ArrayList<ColumnView>();
        Iterator it = ((RelationalDesign)this.columnView.getDesignPart()).getColumnViewSet().iterator();
        while (it.hasNext()) {
            ColumnView cView = (ColumnView)it.next();
            if (cView.getReferencedColumnView() == null || cView.getReferencedColumnView() != this.columnView) continue;
            list.add(cView);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_ColumnView.DependentViewColumns"));
            selection.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
            this.addChild(selection);
            for (ColumnView view : list) {
                if (!selection.hasAsParent(view)) {
                    selection.addChild(new ImpA_ColumnView(view, selection, false));
                    continue;
                }
                selection.addChild(new ModelIdObjectSelection(view));
            }
        }
    }
}

