/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class TableProxySet
extends ProxyDesignObjectSet {
    public TableProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getStorageDesign().getPhysicalDesign().getTableSet();
    }

    public TableProxy getByUserSchemaAndName(String schema, String name) {
        Iterator it = this.getElements().iterator();
        TableProxy proxy = null;
        while (it.hasNext()) {
            proxy = (TableProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName())) continue;
            StorageObject userSchema = proxy.getUserSchema();
            if (userSchema != null && userSchema.getName().equalsIgnoreCase(schema)) {
                return proxy;
            }
            Table table = (Table)proxy.getObject();
            if (!table.getSchema().equalsIgnoreCase(schema)) continue;
            return proxy;
        }
        return null;
    }

    public TableProxy getBySchemaImplAndName(String schema, String name) {
        Iterator it = this.getElements().iterator();
        TableProxy proxy = null;
        while (it.hasNext()) {
            ModelIDObject userSchema;
            proxy = (TableProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName()) || (userSchema = proxy.getSchemaImplementingObject()) == null || !userSchema.getName().equalsIgnoreCase(schema)) continue;
            return proxy;
        }
        return null;
    }

    public TableProxy getBySchemaRelAndName(String schema, String name) {
        Iterator it = this.getElements().iterator();
        TableProxy proxy = null;
        while (it.hasNext()) {
            proxy = (TableProxy)it.next();
            Table table = (Table)proxy.getObject();
            if (!name.equalsIgnoreCase(proxy.getName()) || !table.getSchema().equalsIgnoreCase(schema)) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16);
    }
}

