/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;

public abstract class Trigger
extends StorageObject {
    protected String body = "";
    protected String triggerTime;
    public static final String[] ACTION_TYPES = new String[]{"INSERT", "UPDATE", "DELETE"};
    private static List actionList = Arrays.asList(ACTION_TYPES);
    private String actions = "";
    private ArraySet actionSet = null;
    private boolean cWDGenerated = false;
    public static final String TYPE_NAME = "Trigger";

    public Trigger() {
    }

    public Trigger(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Trg";
    }

    public String getTriggerTime() {
        return this.triggerTime;
    }

    public void setTriggerTime(String triggerTime) {
        if (this.checkTriggerTime(triggerTime)) {
            this.triggerTime = triggerTime;
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    protected boolean checkActionType(String value) {
        return Arrays.asList(ACTION_TYPES).contains(value);
    }

    protected abstract boolean checkTriggerTime(String var1);

    private void addAction(String action) {
        if (this.checkActionType(action) && !this.getActionSet().contains(action) && actionList.contains(action)) {
            this.getActionSet().add(action);
        }
    }

    private void recreateActionSet(String actions) {
        this.getActionSet().clear();
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String action = st.nextToken().trim();
            if (!this.checkActionType(action)) continue;
            this.getActionSet().add(action.trim());
        }
    }

    public void setActions(String actions) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateActionSet(actions);
        } else {
            this.addAction(actions);
        }
        this.actions = this.getActionSet().toString();
        this.fireDataFieldChange();
    }

    public String getActions() {
        return this.actions;
    }

    public ArraySet getActionSet() {
        if (this.actionSet == null) {
            this.actionSet = new ArraySet();
        }
        return this.actionSet;
    }

    public void clearActions() {
        this.getActionSet().removeAllElements();
        this.actions = "";
    }

    public boolean isCWDGenerated() {
        return this.cWDGenerated;
    }

    public void setCWDGenerated(boolean generated) {
        this.cWDGenerated = generated;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if (id == null) {
            return null;
        }
        StorageObject result = this.getStorageDesign().getStorageObject(id);
        if (result == null) {
            ModelIDObject obj;
            String newID = null;
            Map map = this.getStorageDesign().getCorrespondenceMap();
            if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                newID = obj.getObjectID();
                result = this.getStorageDesign().getStorageObject(newID);
            }
        }
        if (result != null) {
            return result;
        }
        if (!"table".equals(propertyName) && !"view".equals(propertyName)) {
            return super.translateIdToObject(propertyName, id);
        }
        return null;
    }

    @Override
    public boolean isDataObject() {
        return false;
    }

    public abstract TableProxy getTableProxy();

    public class ArraySet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

