/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableViewPropertyDialogDB2;

public class TableViewProxyDB2
extends TableViewProxy
implements OwnedObject,
ModelObjectSetListener,
StorageObjectListener {
    private OwnedObjectImpl ownedObjectImpl = null;
    private String labelOn = "";
    public static final String CASCADED_CHECK_OPTIONS = "CASCADED";
    public static final String LOCAL_CHECK_OPTIONS = "LOCAL";
    public static String[] availableCheckOptionScopes = new String[]{"CASCADED", "LOCAL"};
    private String checkOptionScope = "CASCADED";
    private StorageObjectCollection synonyms;

    public TableViewProxyDB2(TableView view, StorageDesign storage) {
        super(view, storage);
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storage).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableViewProxyDB2.class);
        this.synonyms.setSetMethod("setView");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storage).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storage).getSynonymSet());
    }

    public TableViewProxyDB2(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableViewProxyDB2.class);
        this.synonyms.setSetMethod("setView");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof SynonymDB2) {
                SynonymDB2 syn = (SynonymDB2)event.getAffected();
                syn.addObjectListener(this);
                if (syn.getView() != null && syn.getView() == this) {
                    syn.setParent(this.synonyms);
                    this.synonyms.add(syn);
                } else {
                    this.synonyms.remove(syn);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof SynonymDB2) {
            SynonymDB2 syn = (SynonymDB2)event.getAffected();
            this.synonyms.remove(syn);
            syn.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof SynonymDB2) {
            SynonymDB2 syn = (SynonymDB2)event.getAffected();
            if (syn.getView() != null && syn.getView() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.synonyms.removeAll();
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.ownedObjectImpl == null) {
            this.ownedObjectImpl = new OwnedObjectImpl();
            this.ownedObjectImpl.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.ownedObjectImpl;
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !this.getOwner().isNullInstance() && !"".equalsIgnoreCase(this.getOwner().getName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            StorageObject user = ((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getBySchemaObject(so);
            if (user != null && !user.isNullInstance()) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public void setLabelOn(String labelOn) {
        if (labelOn.length() <= 30) {
            this.labelOn = labelOn;
            this.fireDataFieldChange();
        }
    }

    public String getLabelOn() {
        return this.labelOn;
    }

    public static String[] getAvailableCheckOptionScopes() {
        return availableCheckOptionScopes;
    }

    public void setCheckOptionScope(String checkOptionScope) {
        this.checkOptionScope = checkOptionScope;
        this.fireDataFieldChange();
    }

    public String getCheckOptionScope() {
        return this.checkOptionScope;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertyDialogDB2 dialog = new TableViewPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    protected void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymDB2 syn : set) {
            if (syn.getView() != null && syn.getView() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
                continue;
            }
            this.synonyms.remove(syn);
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.synonyms.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    public SynonymDB2 createSynonym() {
        SynonymDB2 syn = (SynonymDB2)this.synonyms.createElement(null);
        syn.setView(this);
        return syn;
    }
}

