/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.TriggerPropertyDialogDB2;

public class TriggerDB2
extends Trigger {
    protected TableProxyDB2 table;
    protected Owner owner;
    private String columns = "";
    private ColumnSet columnSet = null;
    protected String scope = SCOPE_TYPES[0];
    protected String ref_OLD_AS = "";
    protected String ref_NEW_AS = "";
    protected String OLD_TABLE_AS = "";
    protected String NEW_TABLE_AS = "";
    protected String condition = "";
    protected int order = 1;
    public static final String[] TRIGGER_TIMES = new String[]{"NO CASCADE BEFORE", "AFTER"};
    private static List triggerTimeList = Arrays.asList(TRIGGER_TIMES);
    private static Set triggerTimeSet = null;
    public static final String[] SCOPE_TYPES = new String[]{"FOR EACH ROW", "FOR EACH STATEMENT"};
    private static List scopeList = Arrays.asList(SCOPE_TYPES);
    private static Set scopeSet = null;

    public TriggerDB2(StorageDesign storageDesign) {
        super(storageDesign);
        this.setTriggerTime(TRIGGER_TIMES[0]);
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 table) {
        this.table = table;
        this.fireDataFieldChange();
    }

    public static String[] getTriggerTimes() {
        return TRIGGER_TIMES;
    }

    public static List getTriggerValues() {
        return triggerTimeList;
    }

    @Override
    protected boolean checkTriggerTime(String value) {
        if (triggerTimeSet == null) {
            triggerTimeSet = new HashSet();
            triggerTimeSet.addAll(Arrays.asList(TriggerDB2.getTriggerTimes()));
        }
        return triggerTimeSet.contains(value);
    }

    public static String[] getScopeTypes() {
        return SCOPE_TYPES;
    }

    public static List getScopeValues() {
        return scopeList;
    }

    protected boolean checkScope(String value) {
        if (scopeSet == null) {
            scopeSet = new HashSet();
            scopeSet.addAll(Arrays.asList(TriggerDB2.getScopeTypes()));
        }
        return scopeSet.contains(value);
    }

    private void addColumn(String column) {
        String columnName = column.substring(column.lastIndexOf(46) + 1, column.length());
        if (!this.getColumnSet().contains(columnName)) {
            this.getColumnSet().add(columnName);
        }
    }

    protected void recreateColumnSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void setColumns(String columns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(columns);
        } else {
            this.addColumn(columns);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
        this.fireDataFieldChange();
    }

    public String getNEW_TABLE_AS() {
        return this.NEW_TABLE_AS;
    }

    public void setNEW_TABLE_AS(String new_table_as) {
        this.NEW_TABLE_AS = new_table_as;
        this.fireDataFieldChange();
    }

    public String getOLD_TABLE_AS() {
        return this.OLD_TABLE_AS;
    }

    public void setOLD_TABLE_AS(String old_table_as) {
        this.OLD_TABLE_AS = old_table_as;
        this.fireDataFieldChange();
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getRef_NEW_AS() {
        return this.ref_NEW_AS;
    }

    public void setRef_NEW_AS(String ref_NEW_AS) {
        this.ref_NEW_AS = ref_NEW_AS;
        this.fireDataFieldChange();
    }

    public String getRef_OLD_AS() {
        return this.ref_OLD_AS;
    }

    public void setRef_OLD_AS(String ref_OLD_AS) {
        this.ref_OLD_AS = ref_OLD_AS;
        this.fireDataFieldChange();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.checkScope(scope)) {
            this.scope = scope;
            this.fireDataFieldChange();
        }
    }

    public boolean isScopeForEachRow() {
        return this.getScope().equalsIgnoreCase(SCOPE_TYPES[0]);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TriggerPropertyDialogDB2 dialog = new TriggerPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getTable().isDropEnabled() || this.getTable().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TRIGGER_ICON", 16);
    }

    @Override
    public TableProxy getTableProxy() {
        return this.getTable();
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

