/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v70;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class IndexProxyDB2v70
extends IndexProxyDB2 {
    public IndexProxyDB2v70(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyDB2v70(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)((StorageDesignDB2v70)targetDesign).getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxyDB2v70 indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignDB2v70)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxyDB2v70)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            for (int i = 0; i < this.getPartitions().length; ++i) {
                IndexPartitionDB2 partition = this.getPartitions()[i];
                IndexPartitionDB2 targetPartition = (IndexPartitionDB2)((StorageDesignDB2v70)targetDesign).getIndexPartitionSet().getByName(partition.getName());
                if (targetPartition == null) {
                    IndexPartitionDB2 newPartition = ((StorageDesignDB2v70)targetDesign).getIndexPartitionSet().createIndexPartition();
                    newPartition.setName(partition.getName());
                    newPartition.setRawObject(true);
                    newPartition.setIndex(indexProxy);
                    ((StorageDesignDB2v70)targetDesign).getIndexPartitionSet().add(newPartition);
                    continue;
                }
                targetPartition.setIndex(indexProxy);
                ((StorageDesignDB2v70)targetDesign).getIndexPartitionSet().add(targetPartition);
            }
            if (this.getOwner() != null) {
                Owner owner = (Owner)((StorageDesignDB2v70)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    Owner newOwner = (Owner)((StorageDesignDB2v70)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    indexProxy.setOwner(newOwner);
                } else {
                    indexProxy.setOwner(owner);
                }
            }
            indexProxy.setWhereNotNull(this.isWhereNotNull());
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 storageTempl = (StorageTemplateDB2)((StorageDesignDB2v70)targetDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (storageTempl == null) {
                    StorageTemplateDB2 newStTempl = ((StorageDesignDB2v70)targetDesign).getStorageTemplateSet().createStorageTemplate();
                    newStTempl.setName(this.getStorageTemplate().getName());
                    newStTempl.setRawObject(true);
                    indexProxy.setStorageTemplate(newStTempl);
                } else {
                    indexProxy.setStorageTemplate(storageTempl);
                }
            }
            indexProxy.setClusterType(this.getClusterType());
            indexProxy.setPieceSize(this.getPieceSize());
            if (this.getBufferPool() != null) {
                BufferPoolDB2 buffPool = (BufferPoolDB2)((StorageDesignDB2v70)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (buffPool == null) {
                    BufferPoolDB2 newBufferPool = (BufferPoolDB2)((StorageDesignDB2v70)targetDesign).getBufferPoolSet().createElement(null);
                    newBufferPool.setName(this.getBufferPool().getName());
                    newBufferPool.setRawObject(true);
                    indexProxy.setBufferPool(newBufferPool);
                } else {
                    indexProxy.setBufferPool(buffPool);
                }
            }
            indexProxy.setClose(this.isClose());
            indexProxy.setDefer(this.isDefer());
            indexProxy.setCopy(this.isCopy());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
        }
    }
}

