/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.HierarchyPropertyDialogOracle;

public class HierarchyOracle
extends AbstractStorageObjectOracle {
    private DimensionOracle dimension;
    private String levels = "";
    private InlineList levelSet = null;
    private String joins = "";
    private InlineList joinSet = null;
    public static final String TYPE_NAME = "Hierarchy";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            HierarchyPropertyDialogOracle dialog = new HierarchyPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "H";
    }

    public DimensionOracle getDimension() {
        return this.dimension;
    }

    public void setDimension(DimensionOracle dimension) {
        if (this.dimension != dimension) {
            this.dimension = dimension;
            this.setPAC_Element(dimension);
            this.fireDataFieldChange();
        }
    }

    private void addLevel(String levelID) {
        if (!this.getLevelSet().contains(levelID)) {
            this.getLevelSet().add(levelID);
        }
    }

    public void recreateLevelSet(String levels) {
        this.getLevelSet().clear();
        StringTokenizer st = new StringTokenizer(levels, ",");
        while (st.hasMoreTokens()) {
            this.getLevelSet().add(st.nextToken().trim());
        }
    }

    public void setLevels(String levels) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateLevelSet(levels);
        } else {
            this.addLevel(levels);
        }
        this.levels = this.getLevelSet().toString();
        this.fireDataFieldChange();
    }

    public String getLevels() {
        return this.levels;
    }

    public InlineList getLevelSet() {
        if (this.levelSet == null) {
            this.levelSet = new InlineList();
        }
        return this.levelSet;
    }

    public void clearLevels() {
        this.getLevelSet().removeAllElements();
        this.levels = "";
    }

    private void addJoin(String joins) {
        if (!this.getJoinSet().contains(joins)) {
            this.getJoinSet().add(joins);
        }
    }

    public void recreateJoinSet(String joins) {
        this.getJoinSet().clear();
        StringTokenizer st = new StringTokenizer(joins, ",");
        StringBuffer temp = new StringBuffer();
        while (st.hasMoreTokens()) {
            String join = st.nextToken();
            temp.append(join);
            if (join.toUpperCase().indexOf("REFERENCES") > 0) {
                this.getJoinSet().add(temp.toString().trim());
                temp.delete(0, temp.length());
                continue;
            }
            temp.append(",");
        }
    }

    public void setJoins(String joins) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateJoinSet(joins);
        } else {
            this.addJoin(joins);
        }
        this.joins = this.getJoinSet().toString();
        this.fireDataFieldChange();
    }

    public String getJoins() {
        return this.joins;
    }

    public InlineList getJoinSet() {
        if (this.joinSet == null) {
            this.joinSet = new InlineList();
        }
        return this.joinSet;
    }

    public void clearJoins() {
        this.getJoinSet().removeAllElements();
        this.joins = "";
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("HIERARCHY_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

